#
# Makefile for wlags49_xx_cs and wlags49_xxx
#

# 'all' builds Hermes-II and Hermes-II.5, CardServices and PCI

CUR_KERNEL_VER := $(shell uname -r)
DIR_LIB		    = /lib/modules/$(CUR_KERNEL_VER)/kernel/drivers/net

all:  .SILENT
.SILENT: wlags49_h2_cs wlags49_h25_cs wlags49_h2_pci wlags49_h25_pci

install: cs_install pci_install
	
clean:
	rm -f *.o
	rm -rf .depfiles

#
# PCMCIA builds
#

wlags49_h2_cs:
	$(MAKE) -C wireless -f wlags49_cs.mk $@.o

wlags49_h25_cs:
	$(MAKE) -C wireless -f wlags49_cs.mk $@.o

wlags49_ds_cs:
	$(MAKE) -C wireless -f wlags49_cs.mk $@.o

cs_install:
	if [ -f ./wireless/wlags49_h2_cs.o ] ; then $(MAKE) -C wireless install MODULES=wlags49_h2_cs.o ; fi
	if [ -f ./wireless/wlags49_h25_cs.o ] ; then $(MAKE) -C wireless install MODULES=wlags49_h25_cs.o ; fi
	if [ -f ./wireless/wlags49_ds_cs.o ] ; then $(MAKE) -C wireless install MODULES=wlags49_ds_cs.o ; fi
	/sbin/depmod -a -e
	$(MAKE) -C man install-man4 MAN4=wlags49.4
	$(MAKE) -C etc -f wlags49.mk install

#
# PCI Builds
#

wlags49_h2_pci:
	$(MAKE) -C wireless -f wlags49_pci.mk $@.o

wlags49_h25_pci:
	$(MAKE) -C wireless -f wlags49_pci.mk $@.o

wlags49_ds_pci:
	$(MAKE) -C wireless -f wlags49_pci.mk $@.o

pci_install:
#	$(MAKE) -C wireless -f wlags49_pci.mk install
	if [ -f wireless/wlags49_h2_pci.o ] ; then cp wireless/wlags49_h2_pci.o $(DIR_LIB); fi
	if [ -f wireless/wlags49_h25_pci.o ] ; then cp wireless/wlags49_h25_pci.o $(DIR_LIB); fi
	if [ -f wireless/wlags49_ds_pci.o ] ; then cp wireless/wlags49_ds_pci.o $(DIR_LIB); fi
	/sbin/depmod -a -e
#;? why different from cs_install	
	cp man/wlags49.4 $(DIR_MAN)/man4
#;? why not present in cs_install	
	rm -f *.d

