#
# Makefile for wlags49_h2 and wlags49_h25
#

KCC=gcc
LD=ld

KERNEL_VER := $(shell uname -r)
LINUX = /lib/modules/$(KERNEL_VER)/build
MANDIR = /usr/share/man

CDEFS_COMMON	= -D__KERNEL__ -DMODULE -DWVLAN_49 -DUSE_WPA

DIR_INCLUDE     = ../include
DIR_HCF         = ../hcf
DIR_CONFIG      = ../include/hcf
DIR_WIRELESS    = ../include/wireless
DIR_LINUX       = $(LINUX)/include
DIR_LIB		    = /lib/modules/$(KERNEL_VER)/kernel/drivers/net

SOURCES =   wl_profile.c \
            wl_wext.c \
            wl_priv.c \
            wl_main.c \
            wl_enc.c \
            wl_util.c \
            wl_netdev.c \
            wl_pci.c			\
			$(DIR_HCF)/hcf.c	\
			$(DIR_HCF)/dhf.c	\
			$(DIR_HCF)/mmd.c	
#			$(DIR_HCF)/sta_h25.c	
#			$(DIR_HCF)/ap_h25.c	
          
OBJS =      wl_profile.o \
            wl_wext.o \
            wl_priv.o \
            wl_main.o \
            wl_enc.o \
            wl_util.o \
            wl_netdev.o \
            wl_pci.o	\
			hcf.o		\
			dhf.o		\
			mmd.o		
#			sta_h25.o	
#			ap_h25.o		


CFLAGS = -O3 -Wall -Wstrict-prototypes -pipe
#CFLAGS = -O3  -w -Wstrict-prototypes -pipe
CPPFLAGS = $(PCDEBUG) -D__KERNEL__ -DMODULE -DBUS_PCI -DUSE_PROFILE -DDBG 
CPPFLAGS += -DWVLAN_49 -DUSE_WEXT -DUSE_UIL -DUSE_RTS -DUSE_WPA 

#CC = $(KCC) $(AFLAGS) $(KFLAGS) -I$(DIR_LINUX) -I$(DIR_INCLUDE) -I$(DIR_CONFIG) -I$(DIR_WIRELESS) -I$(DIR_HCF) 
CC = $(KCC) $(AFLAGS) $(KFLAGS) $(CDEFS_COMMON) -I$(DIR_WIRELESS) -I$(DIR_HCF)  -I$(DIR_INCLUDE) -I$(DIR_CONFIG) -I$(DIR_LINUX)


all: wlags49_h2_pci.o wlags49_h25_pci.o wlags49_ds_pci.o


wlags49_h2_pci.o: $(SOURCES) $(DIR_HCF)/fw_h2.c 
	echo get rid of USE_WDS ;
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) \
		-DHERMES2 -DUSE_WDS  -DMOD_NAME=$*\
		$(SOURCES) $(DIR_HCF)/fw_h2.c
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) fw_h2.o
	rm -f $(OBJS) fw_h2.o ;
	chmod -x $@ ;

wlags49_h25_pci.o: $(SOURCES) $(DIR_HCF)/fw_h25.c 
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) \
		-DHERMES25 -DWARP -DNO_ENABLE_DMA -DUSE_WDS  -DMOD_NAME=$*\
		$(SOURCES) $(DIR_HCF)/fw_h25.c
	mkdir -p .depfiles ;
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) fw_h25.o
	rm -f $(OBJS) fw_h25.o ;
	chmod -x $@ ;

wlags49_ds_pci.o: $(SOURCES)  $(DIR_HCF)/fw_h25.c
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) \
		-DHERMES25 -DUSE_WDS  -DMOD_NAME=$*\
		$(SOURCES) $(DIR_HCF)/fw_h25.c
	mkdir -p .depfiles ;
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) fw_h25.o
	rm -f $(OBJS) fw_h25.o ;
	chmod -x $@ ;
	
install:
	cp wlags49_h2.o $(DIR_LIB)
	/sbin/depmod -a -e
	cp ../man/wlags49.4 $(MANDIR)/man4
	rm -f *.d

