#
# Makefile for wlags49_cs_xxx
#

include ../config.mk

DIR_HCF         = ../hcf
DIR_CONFIG      = ../include/hcf
DIR_WIRELESS    = ../include/wireless

SOURCES =   wl_profile.c 		\
            wl_wext.c 			\
            wl_priv.c 			\
            wl_main.c 			\
            wl_enc.c 			\
            wl_util.c 			\
            wl_netdev.c 		\
            wl_cs.c				\
			$(DIR_HCF)/hcf.c	\
			$(DIR_HCF)/dhf.c	\
			$(DIR_HCF)/mmd.c	
          
OBJS =      wl_profile.o 		\
            wl_wext.o 			\
            wl_priv.o 			\
            wl_main.o 			\
            wl_enc.o 			\
            wl_util.o 			\
            wl_netdev.o 		\
            wl_cs.o				\
			hcf.o				\
			dhf.o				\
			mmd.o				


CFLAGS = -O3 -Wall -Wstrict-prototypes -pipe
#CFLAGS = -O3 -w -Wstrict-prototypes -pipe
CPPFLAGS += $(PCDEBUG) -D__KERNEL__ -DMODULE -DBUS_PCMCIA -DUSE_PROFILE -DDBG 
CPPFLAGS += -DWVLAN_49 -DUSE_UIL -DUSE_WPA 
CC = $(KCC) $(AFLAGS) $(KFLAGS) -I$(DIR_CONFIG) -I$(DIR_HCF) 

all: wlags49_h2_cs.o  wlags49_h25_cs.o wlags49_ds_cs.o

##OBJS= \
##	$(SOURCES:.c=.o)
## 
## .SUFFIXES:
## 
## .SUFFIXES:	.o .c .s .i .a .so
## 
## .c.o:
## 	echo got here at co suffix rule
## 	echo "$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DHERMES25 -DUSE_RTS -DUSE_WDS $<"
## 	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DHERMES25 -DUSE_RTS -DUSE_WDS $<	

wlags49_h2_cs.o: $(SOURCES)	$(DIR_HCF)/fw_h2.c	
#;?	get rid of USE_WDS ;
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) \
		-DHERMES2 -DUSE_RTS -DUSE_WDS  -DMOD_NAME=$*\
		$(SOURCES)	$(DIR_HCF)/fw_h2.c	
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) fw_h2.o
	rm -f $(OBJS) fw_h2.o ; 
	chmod -x $@ ;

wlags49_h25_cs.o: $(SOURCES) $(DIR_HCF)/fw_h25.c	
#;?	get rid of USE_WDS ;
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) \
		-DHERMES25 -DWARP -DUSE_RTS -DUSE_WDS -DMOD_NAME=$*\
		$(SOURCES)$(DIR_HCF)/fw_h25.c	
	mkdir -p .depfiles ;
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) fw_h25.o
	rm -f $(OBJS) fw_h25.o;
	chmod -x $@ ;

wlags49_ds_cs.o: $(SOURCES)	$(DIR_HCF)/fw_h25.c	
#;?	get rid of USE_WDS ;
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) \
		-DHERMES25 -DUSE_RTS -DUSE_WDS -DMOD_NAME=$*\
		$(SOURCES) $(DIR_HCF)/fw_h25.c
	mkdir -p .depfiles ;
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) fw_h25.o
	chmod -x $@ ;

