#ifndef CONFIG_H
#define CONFIG_H

#define WPA_CIPHER_NONE BIT(0)
#define WPA_CIPHER_WEP40 BIT(1)
#define WPA_CIPHER_WEP104 BIT(2)
#define WPA_CIPHER_TKIP BIT(3)
#define WPA_CIPHER_CCMP BIT(4)

#define WPA_KEY_MGMT_IEEE8021X BIT(0)
#define WPA_KEY_MGMT_PSK BIT(1)
#define WPA_KEY_MGMT_NONE BIT(2)

#define MAX_SSID_LEN 32
#define PMK_LEN 32

struct wpa_ssid {
	struct wpa_ssid *next;
	u8 ssid[MAX_SSID_LEN];
	size_t ssid_len;
	u8 bssid[ETH_ALEN];
	int bssid_set;
	u8 psk[PMK_LEN];
	int psk_set;
	char *passphrase;
	/* Bitfields of allowed Pairwise/Group Ciphers, WPA_CIPHER_* */
	int pairwise_cipher;
	int group_cipher;
	int key_mgmt;
	int scan_ssid; /* scan this SSID with Probe Requests */
};


struct wpa_ssid * wpa_config_read(const char *ssid_file);
void wpa_config_free(struct wpa_ssid *ssid);

#endif /* CONFIG_H */
