#ifndef HOSTAP_COMPAT_H
#define HOSTAP_COMPAT_H

#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,5,47))
#define NEW_MODULE_CODE
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,44))

#define HOSTAP_QUEUE struct tq_struct

#define PRISM2_SCHEDULE_TASK(q) \
MOD_INC_USE_COUNT; \
if (schedule_task((q)) == 0) \
	MOD_DEC_USE_COUNT;

static inline void flush_scheduled_work(void)
{
	flush_scheduled_tasks();
}

static inline void INIT_WORK(struct tq_struct *tq,
			     void (*routine)(void *), void *data)
{
	INIT_LIST_HEAD(&tq->list);
	tq->sync = 0;
	tq->routine = routine;
	tq->data = data;
}

#else /* kernel < 2.5.44 */

#define HOSTAP_QUEUE struct work_struct

#ifdef NEW_MODULE_CODE
#define PRISM2_SCHEDULE_TASK(q) schedule_work(q);
#else /* NEW_MODULE_CODE */
#define PRISM2_SCHEDULE_TASK(q) \
MOD_INC_USE_COUNT; \
if (schedule_work((q)) == 0) \
	MOD_DEC_USE_COUNT;
#endif /* NEW_MODULE_CODE */

#endif /* kernel < 2.5.44 */

#define HOSTAP_TASKLET struct tasklet_struct

#define HOSTAP_TASKLET_INIT(q, f, d) \
do { memset((q), 0, sizeof(*(q))); (q)->func = (f); (q)->data = (d); } \
while (0)


#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,19))
#define yield() schedule()
#endif


/* Interrupt handler backwards compatibility for Linux < 2.5.69 */
#ifndef IRQ_NONE
#define IRQ_NONE
#define IRQ_HANDLED
#define IRQ_RETVAL(x)
typedef void irqreturn_t;
#endif

#ifndef MODULE_LICENSE
#define MODULE_LICENSE(var)
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,23))
struct net_device;
static inline void free_netdev(struct net_device *dev)
{
	kfree(dev);
}
#endif


#ifdef __IN_PCMCIA_PACKAGE__
#define pcmcia_access_configuration_register(handle, reg) \
	CardServices(AccessConfigurationRegister, handle, reg)

#define pcmcia_register_client(handle, reg) \
	CardServices(RegisterClient, handle, reg)

#define pcmcia_deregister_client(handle) \
	CardServices(DeregisterClient, handle)

#define pcmcia_get_first_tuple(handle, tuple) \
	CardServices(GetFirstTuple, handle, tuple)

#define pcmcia_get_next_tuple(handle, tuple) \
	CardServices(GetNextTuple, handle, tuple)

#define pcmcia_get_tuple_data(handle, tuple) \
	CardServices(GetTupleData, handle, tuple)

#define pcmcia_parse_tuple(handle, tuple, parse) \
	CardServices(ParseTuple, handle, tuple, parse)

#define pcmcia_get_configuration_info(handle, config) \
	CardServices(GetConfigurationInfo, handle, config)

#define pcmcia_request_io(handle, req) \
	CardServices(RequestIO, handle, req)

#define pcmcia_request_irq(handle, req) \
	CardServices(RequestIRQ, handle, req)

#define pcmcia_request_configuration(handle, req) \
	CardServices(RequestConfiguration, handle, req)

#define pcmcia_release_configuration(handle) \
	CardServices(ReleaseConfiguration, handle)

#define pcmcia_release_io(handle, req) \
	CardServices(ReleaseIO, handle, req)

#define pcmcia_release_irq(handle, req) \
	CardServices(ReleaseIRQ, handle, req)

#define pcmcia_release_window(win) \
	CardServices(ReleaseWindow, win)

#define pcmcia_get_card_services_info(info) \
	CardServices(GetCardServicesInfo, info)

#define pcmcia_report_error(handle, err) \
	CardServices(ReportError, handle, err)
#endif /* __IN_PCMCIA_PACKAGE__ */

#endif /* HOSTAP_COMPAT_H */
