#
# Makefile for wlags49_xxx
#

#
# PCMCIA builds
#

# 'all' actually builds only the default targets, which are Hermes-I STAP and
# Hermes-II STAP.
all:
	$(MAKE) -C wireless -f wlags49_cs.mk all


h1_cs_sta:
	$(MAKE) -C wireless -f wlags49_cs.mk wlags49_h1_cs_sta.o

h1_cs_ap:
	$(MAKE) -C wireless -f wlags49_cs.mk wlags49_h1_cs_ap.o

h1_cs_stap:
	$(MAKE) -C wireless -f wlags49_cs.mk wlags49_h1_cs_stap.o

h2_cs_sta:
	$(MAKE) -C wireless -f wlags49_cs.mk wlags49_h2_cs_sta.o

h2_cs_ap:
	$(MAKE) -C wireless -f wlags49_cs.mk wlags49_h2_cs_ap.o

h2_cs_stap:
	$(MAKE) -C wireless -f wlags49_cs.mk wlags49_h2_cs_stap.o


# 'install' will install whatever Hermes-I and Hermes-II drivers
# have been built. Note that only one Hermes-I and one Hermes-II driver can
# be used at any given time.
install:
	if [ -f ./wireless/wlags49_h1_cs.o ] ; then $(MAKE) -C wireless install MODULES=wlags49_h1_cs.o ; fi
	if [ -f ./wireless/wlags49_h2_cs.o ] ; then $(MAKE) -C wireless install MODULES=wlags49_h2_cs.o ; fi
	/sbin/depmod -a -e
	$(MAKE) -C man install-man4 MAN4=wlags49.4
	$(MAKE) -C etc -f wlags49.mk $@


#
# PCI Builds - Note these are currently Hermes-II only
#

# 'pci' builds the default PCI target, Hermes-II STAP
pci:
	$(MAKE) -C wireless -f wlags49_pci.mk wlags49_h2_stap.o

h2_pci_sta:
	$(MAKE) -C wireless -f wlags49_pci.mk wlags49_h2_sta.o

h2_pci_ap:
	$(MAKE) -C wireless -f wlags49_pci.mk wlags49_h2_ap.o

h2_pci_stap:
	$(MAKE) -C wireless -f wlags49_pci.mk wlags49_h2_stap.o

h2_pci_clean:
	$(MAKE) -C wireless -f wlags49_pci.mk clean

pci_install:
	$(MAKE) -C wireless -f wlags49_pci.mk install

