#
# Makefile for wlags49_h2
#


KCC=gcc
LD=ld

LIB := ../lib

LIB_NAME_STA_H2  = sta-h2
LIB_NAME_AP_H2   = ap-h2
LIB_NAME_STAP_H2 = stap-h2

KERNEL_VER := $(shell uname -r)
KERNEL_MAJ_VER := $(shell uname -r | sed "s/\..*//")
KERNEL_MIN_VER := $(shell uname -r | sed "s/.\.//" | sed "s/\..*//")
KERNEL_PATCH_VER := $( shell uname -r | sed "s/.*\.//")
KERNEL_VER_SHORT := $(KERNEL_MAJ_VER).$(KERNEL_MIN_VER)

RED_HAT_DIST := $(shell cat /proc/version | grep 'Red Hat')

ifdef RED_HAT_DIST
LINUX = /usr/src/linux-$(KERNEL_VER_SHORT)
DIR_MAN	= /usr/share/man
else
LINUX	= /usr/src/linux
DIR_MAN	= /usr/share/man
endif

DIR_INCLUDE     = ../include
DIR_HCF         = ../hcf
DIR_DHF         = ../dhf
DIR_FW          = ../dhf
DIR_CONFIG      = ../include/hcf
DIR_WIRELESS    = ../include/wireless
DIR_LINUX       = $(LINUX)/include
DIR_LIB		= /lib/modules/$(KERNEL_VER)/kernel/drivers/net

CONFIG_HEADERS      = $(DIR_CONFIG)/debug.h $(DIR_CONFIG)/hcfcfg.h $(DIR_CONFIG)/dhfcfg.h
HCF_HEADERS         = $(DIR_HCF)/hcf.h $(DIR_HCF)/mdd.h $(DIR_HCF)/hcfdef.h
MMD_HEADERS         = $(MMD_DIR)/mmd.h
WIRELESS_HEADERS    = $(DIR_WIRELESS)/wl_enc.h $(DIR_WIRELESS)/wl_if.h $(DIR_WIRELESS)/wl_internal.h $(DIR_WIRELESS)/wl_version.h

SOURCES =   wl_profile.c \
            wl_wext.c \
            wl_priv.c \
            wl_main.c \
            wl_enc.c \
            wl_util.c \
            wl_netdev.c \
            wl_pci.c
          
OBJS =      wl_profile.o \
            wl_wext.o \
            wl_priv.o \
            wl_main.o \
            wl_enc.o \
            wl_util.o \
            wl_netdev.o \
            wl_pci.o


CFLAGS = -O3 -Wall -Wstrict-prototypes -pipe
CPPFLAGS = $(PCDEBUG) -D__KERNEL__ -DMODULE -DBUS_PCI -DUSE_WEXT -DUSE_PROFILE -DUSE_UIL -DDBG -DUSE_OLD_PARMS -DUSE_RTS
CC = $(KCC) $(AFLAGS) $(KFLAGS) -I$(DIR_LINUX) -I$(DIR_INCLUDE) -I$(DIR_CONFIG) -I$(DIR_WIRELESS) -I$(DIR_HCF) -I$(DIR_DHF)
CC = $(KCC) $(AFLAGS) $(KFLAGS) -I$(DIR_LINUX) -I$(DIR_INCLUDE) -I$(DIR_CONFIG) -I$(DIR_WIRELESS) -I$(DIR_HCF) -I$(DIR_DHF)


# H2-STAP is the default target
all: wlags49_h2_stap.o


$(LIB_NAME_STA_H2): $(CONFIG_HEADERS)
	make -C ../lib lib$@.a

$(LIB_NAME_AP_H2): $(CONFIG_HEADERS)
	make -C ../lib lib$@.a

$(LIB_NAME_STAP_H2): $(CONFIG_HEADERS)
	make -C ../lib lib$@.a


wlags49_h2_sta.o: $(SOURCES) $(LIB_NAME_STA_H2)
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DHERMES2 -DSTA_ONLY $(SOURCES)
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) -L$(LIB) -l$(LIB_NAME_STA_H2)
	rm -f $(OBJS) ; 
	chmod -x $@ ;
	mv $@ wlags49_h2.o ;

wlags49_h2_ap.o: $(SOURCES) $(LIB_NAME_AP_H2)
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DHERMES2 -DAP_ONLY -DUSE_WDS $(SOURCES)
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) -L$(LIB) -l$(LIB_NAME_AP_H2)
	rm -f $(OBJS) ; 
	chmod -x $@ ;
	mv $@ wlags49_h2.o ;

wlags49_h2_stap.o: $(SOURCES) $(LIB_NAME_STAP_H2)
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DHERMES2 -DUSE_WDS $(SOURCES)
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) -L$(LIB) -l$(LIB_NAME_STAP_H2)
	rm -f $(OBJS) ; 
	chmod -x $@ ;
	mv $@ wlags49_h2.o ;


install:
	cp wlags49_h2.o $(DIR_LIB)
	/sbin/depmod -a -e
	cp ../man/wlags49.4 $(DIR_MAN)/man4


clean:
	rm -f *.o

