#
# Makefile for wlags49_cs_xxx
#

include ../config.mk

LIB := ../lib

LIB_NAME_STA_H1  = sta-h1
LIB_NAME_STA_H2  = sta-h2
LIB_NAME_AP_H1   = ap-h1
LIB_NAME_AP_H2   = ap-h2
LIB_NAME_STAP_H1 = stap-h1
LIB_NAME_STAP_H2 = stap-h2

DIR_HCF         = ../hcf
DIR_DHF         = ../dhf
DIR_FW          = ../dhf
DIR_CONFIG      = ../include/hcf
DIR_WIRELESS    = ../include/wireless

CONFIG_HEADERS      = $(DIR_CONFIG)/debug.h $(DIR_CONFIG)/hcfcfg.h $(DIR_CONFIG)/dhfcfg.h
HCF_HEADERS         = $(DIR_HCF)/hcf.h $(DIR_HCF)/mdd.h $(DIR_HCF)/hcfdef.h
MMD_HEADERS         = $(MMD_DIR)/mmd.h
WIRELESS_HEADERS    = $(DIR_WIRELESS)/wl_enc.h $(DIR_WIRELESS)/wl_if.h $(DIR_WIRELESS)/wl_internal.h $(DIR_WIRELESS)/wl_version.h

SOURCES =   wl_profile.c \
            wl_wext.c \
            wl_priv.c \
            wl_main.c \
            wl_enc.c \
            wl_util.c \
            wl_netdev.c \
            wl_cs.c
          
OBJS =      wl_profile.o \
            wl_wext.o \
            wl_priv.o \
            wl_main.o \
            wl_enc.o \
            wl_util.o \
            wl_netdev.o \
            wl_cs.o


CFLAGS = -O3 -Wall -Wstrict-prototypes -pipe
CPPFLAGS += $(PCDEBUG) -D__KERNEL__ -DMODULE -DBUS_PCMCIA -DUSE_PROFILE -DUSE_UIL -DDBG -DUSE_OLD_PARMS 
CC = $(KCC) $(AFLAGS) $(KFLAGS) -I$(DIR_CONFIG) -I$(DIR_HCF) -I$(DIR_DHF)


# H1-STAP and H2-STAP are the default targets
all: wlags49_h1_cs_stap.o wlags49_h2_cs_stap.o


$(LIB_NAME_STA_H1): $(CONFIG_HEADERS)
	make -C ../lib lib$@.a

$(LIB_NAME_AP_H1): $(CONFIG_HEADERS)
	make -C ../lib lib$@.a

$(LIB_NAME_STAP_H1): $(CONFIG_HEADERS)
	make -C ../lib lib$@.a

$(LIB_NAME_STA_H2): $(CONFIG_HEADERS)
	make -C ../lib lib$@.a

$(LIB_NAME_AP_H2): $(CONFIG_HEADERS)
	make -C ../lib lib$@.a

$(LIB_NAME_STAP_H2): $(CONFIG_HEADERS)
	make -C ../lib lib$@.a


wlags49_h1_cs_sta.o: $(SOURCES) $(LIB_NAME_STA_H1)
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DSTA_ONLY $(SOURCES)
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) -L$(LIB) -l$(LIB_NAME_STA_H1)
	rm -f $(OBJS) ; 
	chmod -x $@ ;
	mv $@ wlags49_h1_cs.o ;

wlags49_h1_cs_ap.o: $(SOURCES) $(LIB_NAME_AP_H1)
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DAP_ONLY -DUSE_WDS $(SOURCES)
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) -L$(LIB) -l$(LIB_NAME_AP_H1)
	rm -f $(OBJS) ; 
	chmod -x $@ ;
	mv $@ wlags49_h1_cs.o ;

wlags49_h1_cs_stap.o: $(SOURCES) $(LIB_NAME_STAP_H1)
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DUSE_WDS $(SOURCES)
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) -L$(LIB) -l$(LIB_NAME_STAP_H1)
	rm -f $(OBJS) ; 
	mv $@ wlags49_h1_cs.o ;

wlags49_h2_cs_sta.o: $(SOURCES) $(LIB_NAME_STA_H2)
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DHERMES2 -DSTA_ONLY -DUSE_RTS $(SOURCES)
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) -L$(LIB) -l$(LIB_NAME_STA_H2)
	rm -f $(OBJS) ; 
	chmod -x $@ ;
	mv $@ wlags49_h2_cs.o ;

wlags49_h2_cs_ap.o: $(SOURCES) $(LIB_NAME_AP_H2)
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DHERMES2 -DAP_ONLY -DUSE_RTS -DUSE_WDS $(SOURCES)
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) -L$(LIB) -l$(LIB_NAME_AP_H2)
	rm -f $(OBJS) ; 
	chmod -x $@ ;
	mv $@ wlags49_h2_cs.o ;

wlags49_h2_cs_stap.o: $(SOURCES) $(LIB_NAME_STAP_H2)
	$(CC) -MD -c $(CFLAGS) $(CPPFLAGS) -DHERMES2 -DUSE_RTS -DUSE_WDS $(SOURCES)
	mkdir -p .depfiles ; 
	mv *.d .depfiles ;
	$(LD) -r -o $@ $(OBJS) -L$(LIB) -l$(LIB_NAME_STAP_H2)
	rm -f $(OBJS) ; 
	chmod -x $@ ;
	mv $@ wlags49_h2_cs.o ;
