/*******************************************************************************
 * Agere Systems Inc.
 * Wireless device driver for Linux (wlags49).
 *
 * Copyright (c) 1998-2003 Agere Systems Inc. 
 * All rights reserved.
 *   http://www.agere.com
 *
 * Initially developed by TriplePoint, Inc.
 *   http://www.triplepoint.com
 *
 *------------------------------------------------------------------------------
 *
 *   This header file contains version information for the code base, as well as
 *   special definitions and macros needed by certain versions of the code.
 *
 *------------------------------------------------------------------------------
 *
 * SOFTWARE LICENSE
 *
 * This software is provided subject to the following terms and conditions,
 * which you should read carefully before using the software.  Using this
 * software indicates your acceptance of these terms and conditions.  If you do
 * not agree with these terms and conditions, do not use the software.
 *
 * Copyright  2003 Agere Systems Inc.
 * All rights reserved.
 *
 * Redistribution and use in source or binary forms, with or without
 * modifications, are permitted provided that the following conditions are met:
 *
 * . Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following Disclaimer as comments in the code as
 *    well as in the documentation and/or other materials provided with the
 *    distribution.
 * 
 * . Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following Disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * . Neither the name of Agere Systems Inc. nor the names of the contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * Disclaimer
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, INFRINGEMENT AND THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  ANY
 * USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE IS SOLELY AT THE USERS OWN
 * RISK. IN NO EVENT SHALL AGERE SYSTEMS INC. OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, INCLUDING, BUT NOT LIMITED TO, CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 ******************************************************************************/




/*******************************************************************************
 * VERSION CONTROL INFORMATION
 *******************************************************************************
 *
 * $Author: vjs $
 * $Date: 2003/09/25 17:55:04 $
 * $Revision: 1.24 $
 * $Source: /cvsroot/wifi/wl_lkm/include/wireless/wl_version.h,v $
 *
 ******************************************************************************/




#ifndef __WL_VERSION_H__
#define __WL_VERSION_H__




/*******************************************************************************
 *  include files
 ******************************************************************************/
#include <linux/config.h>
#include <linux/version.h>

#ifdef CONFIG_MODVERSIONS
#include <linux/modversions.h>
#else
#define __NO_VERSION__
#endif  // CONFIG_MODVERSIONS




/*******************************************************************************
 *  constant definitions
 ******************************************************************************/
#ifndef WVLAN_49
#define WVLAN_49
#endif  // WVLAN_49

#define DRIVER_NAME         "wlags49"
#define DRV_IDENTITY        49


#define DRV_MAJOR_VERSION   7
#define DRV_MINOR_VERSION   14
#define DRV_VERSION_STR     "7.14"


#if defined BUS_PCMCIA
#define DRV_VARIANT         1
#define BUS_TYPE            "PCMCIA"
#elif defined BUS_PCI
#define DRV_VARIANT         2
#define BUS_TYPE            "PCI"
#else
#define DRV_VARIANT         0
#endif  // BUS_XXX


#define VENDOR_NAME         "Agere Systems, http://www.agere.com"

#ifdef BUS_PCMCIA
#ifdef HERMES2
#define MODULE_NAME         DRIVER_NAME "_h2_cs"
#define MODULE_NAME_EXT     DRIVER_NAME "_h2_cs.o"
#else
#define MODULE_NAME         DRIVER_NAME "_h1_cs"
#define MODULE_NAME_EXT     DRIVER_NAME "_h1_cs.o"
#endif  /* HERMES2 */
#elif defined BUS_PCI
#ifdef HERMES2
#define MODULE_NAME         DRIVER_NAME "_h2"
#define MODULE_NAME_EXT     DRIVER_NAME "_h2.o"
#else
#define MODULE_NAME         DRIVER_NAME "_h1"
#define MODULE_NAME_EXT     DRIVER_NAME "_h1.o"
#endif  /* HERMES2 */
#endif  /* BUS_XXX */



#define MODULE_DATE         "09/25/2003 1:59:00"
#define VERSION_INFO        MODULE_NAME " v" DRV_VERSION_STR " for " BUS_TYPE ", " MODULE_DATE " by " VENDOR_NAME

#define WIRELESS_SUPPORT    14  // The version of wireless extensions we support 




/*******************************************************************************
 *  bus architechture specific defines, includes, etc.
 ******************************************************************************/
/* If building for PCMCIA, it's configuration script will be used to determine
   the status of wireless extension support. Otherwise, including wireless
   extension support will be switched on/off by the USE_WEXT condition */
#if defined BUS_PCMCIA
#include <pcmcia/config.h>
#include <pcmcia/k_compat.h>
#elif defined BUS_PCI
#if USE_WEXT
#define HAS_WIRELESS_EXTENSIONS
#endif  // USE_WEXT


/* These are #defines you get "for free" with PCMCIA that I needed to add for 
   PCI to build */
#define NEW_MULTICAST
#define ALLOC_SKB(len)   dev_alloc_skb(len+2)
#define GET_PACKET(dev, skb, count)\
                        skb_reserve((skb), 2); \
                        BLOCK_INPUT(skb_put((skb), (count)), (count)); \
                        (skb)->protocol = eth_type_trans((skb), (dev))
#endif  // BUS_XXX




#endif  // __WL_VERSION_H__
