/*******************************************************************************
 * Agere Systems Inc.
 * Wireless device driver for Linux (wlags49).
 *
 * Copyright (c) 1998-2003 Agere Systems Inc. 
 * All rights reserved.
 *   http://www.agere.com
 *
 * Initially developed by TriplePoint, Inc.
 *   http://www.triplepoint.com
 *
 *------------------------------------------------------------------------------
 *
 *   This file contains HCF configuration info.
 *
 *------------------------------------------------------------------------------
 *
 * SOFTWARE LICENSE
 *
 * This software is provided subject to the following terms and conditions,
 * which you should read carefully before using the software.  Using this
 * software indicates your acceptance of these terms and conditions.  If you do
 * not agree with these terms and conditions, do not use the software.
 *
 * Copyright  2003 Agere Systems Inc.
 * All rights reserved.
 *
 * Redistribution and use in source or binary forms, with or without
 * modifications, are permitted provided that the following conditions are met:
 *
 * . Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following Disclaimer as comments in the code as
 *    well as in the documentation and/or other materials provided with the
 *    distribution.
 * 
 * . Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following Disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * . Neither the name of Agere Systems Inc. nor the names of the contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * Disclaimer
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, INFRINGEMENT AND THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  ANY
 * USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE IS SOLELY AT THE USERS OWN
 * RISK. IN NO EVENT SHALL AGERE SYSTEMS INC. OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, INCLUDING, BUT NOT LIMITED TO, CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 ******************************************************************************/




/*******************************************************************************
 * VERSION CONTROL INFORMATION
 *******************************************************************************
 *
 * $Author: vjs $
 * $Date: 2003/09/05 15:38:49 $
 * $Revision: 1.27 $
 * $Source: /cvsroot/wifi/wl_lkm/include/hcf/hcfcfg.h,v $
 *
 ******************************************************************************/




//   vim:tw=110:ts=4:
#ifndef HCFCFG_H
#define HCFCFG_H 1

/**************************************************************************************************************
*
* FILE	 : hcfcfg.tpl // hcfcfg.h **************************** 2.0 ********************************************
*
* DATE   : $Date: 2003/09/05 15:38:49 $   $Revision: 1.27 $
*
* AUTHOR : Nico Valster
*
* DESC   : HCF Customization Macros
*
***************************************************************************************************************
* COPYRIGHT (c) 1994 - 1995	by AT&T.	 			All Rights Reserved
* COPYRIGHT (c) 1996 - 2000 by Lucent Technologies.	All Rights Reserved
* COPYRIGHT (c) 2001 - 2003	by Agere Systems.		All Rights Reserved
***************************************************************************************************************
*
* hcfcfg.tpl list all #defines which must be specified to:
*    I:	adjust the HCF functions defined in HCF.CPP to the characteristics of a specific environment
* 		o maximum sizes for messages and notification frames, persistent configuration storage
* 		o Endianess
*
*	II:	Compiler specific macros
* 		o port I/O macros
* 		o type definitions
*
*  III:	Environment specific ASSERT macro
*
*   IV: Compiler specific
*
*    V: ;? specific
*
*
* By copying HCFCFG.TPL to HCFCFG.H and -if needed- modifying the #defines the WCI functionality can be
* tailored
*
* Supported environments:
WVLAN_41	Miniport                                NDIS 3.1
WVLAN_42	Packet                                	Microsoft Visual C 1.5
WVLAN_43	16 bits DOS ODI                      	Microsoft Visual C 1.5
WVLAN_44	32 bits ODI (__NETWARE_386__)			WATCOM
WVLAN_45	MAC_OS									MPW?, Symantec?
WVLAN_46	Windows CE (_WIN32_WCE)					Microsoft ?
WVLAN_47	LINUX  (__LINUX__)						GCC
WVLAN_48	Miniport                                NDIS 5
WVLAN_51	Miniport USB                            NDIS 5
WVLAN_52	Miniport 		                        NDIS 4
WVLAN_53	VxWorks END Station driver
WVLAN_54	VxWorks END Access Point driver
WVLAN_81	WavePoint								BORLAND C
WCITST		Inhouse test tool						Microsoft Visual C 1.5
WSU			WaveLAN Station Update					Microsoft Visual C ??
SCO UNIX	not yet actually used ?					?
__ppc		OEM supplied							?
_AM29K		OEM supplied							?
?			OEM supplied							Microtec Research 80X86 Compiler

* T O   D O :  A D D   A   R E C I P E   H O W  T O   M O D I F Y  HCFCFG.H
*
**************************************************************************************************************/


/****************************************************************************
*
* CHANGE HISTORY
*

  960702 - NV
	Original Entry - derived from HCF 2.12
*************************************************************************************************/



/*****************************    IN_PORT_STRING  S a m p l e s ***************************************************

		// C implementation which let the processor handle the word-at-byte-boundary problem
#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16 FAR*)dst = IN_PORT_WORD( prt ); dst += 2; }


		// C implementation which handles the word-at-byte-boundary problem 
#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { int i = IN_PORT_WORD( prt ); *dst++ = (char)i; *dst++ = (char)(i >> 8); }


		// Assembler implementation
#define IN_PORT_STRING( port, dest, len) __asm 		\
{													\
	__asm push di                               	\
	__asm push es                                 	\
	__asm mov cx,len                            	\
	__asm les di,dest                           	\
	__asm mov dx,port                           	\
	__asm rep insw                              	\
	__asm pop es	                            	\
	__asm pop di	                            	\
}

       
******************************************************************************************************************/


/*****************************   OUT_PORT_STRING  S a m p l e s ***************************************************
       
		// C implementation which let the processor handle the word-at-byte-boundary problem
#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16 FAR*)src ) ; src  += 2; }


		// C implementation which handles the word-at-byte-boundary problem 
#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *src | *(src+1)<<8  ) ; src  += 2; }
//;?  WHY hcf_16 FAR*)src and not unsigned char FAR*)src


												// Assembler implementation
#define OUT_PORT_STRING( port, src, len) __asm		\
{                                               	\
	__asm push si                                 	\
	__asm push ds                                 	\
	__asm mov cx,len                              	\
	__asm lds si,src                             	\
	__asm mov dx,port                             	\
	__asm rep outsw	                            	\
	__asm pop ds                                  	\
	__asm pop si                                  	\
}

******************************************************************************************************************/


/*  * * * * * * * * * * * * * * * * * * * * * *  I * * * * * * * * * * * * * * * * * * * * * * */

/*	Alignment
 *	Some platforms can access words on odd boundaries (with possibly an performance impact), at other
 *	platforms such an access may result in a memory access violation.
 *	It is assumed that everywhere where the HCF casts a char pointer into a word pointer, the
 *	alignment criteria are met. This put some restrictions on the MSF, which are assumed to be
 *	"automatically" fulfilled at the applicable platforms
 *	To assert this assumption, the macro HCF_ALIGN can be defined. The default value is 0, meaning no
 *	alignment, a value of 2 means word alignment, other values are invalid
 */

/*  * * * * * * * * * * * * * * * * * * * * * * II * * * * * * * * * * * * * * * * * * * * * * */



/************************************************************************************************/
/******************  C O M P I L E R   S P E C I F I C   M A C R O S  ***************************/
/************************************************************************************************/
/*************************************************************************************************
*
* The platforms supported by this version are:
*	- Microsoft Visual C 1.5 (16 bits platform)
*	- Microsoft Visual C 2.0 (32 bits platform)
*	- Watcom C/C++ 9.5
*	- SCO UNIX
*
* In this version of hcfiocfg.tpl all macros except the MSVC 1.5 versions are either dependent on
* compiler/environment supplied macros (e.g. _MSC_VER or "def-ed out"
*
* By selecting the appropriate Macro definitions by means of modifying the
* "#ifdef 0/1" lines, the HCF can be adjusted for the I/O characteristics of
* a specific compiler
*
* If needed the macros can be modified or replaced with definitions appropriate
* for your personal platform
* If you need to make such changes it is appreciated if you inform Lucent Technologies WCND Utrecht
* That way the changes can become part of the next release of the WCI
*
*
*	The prototypes and functional description of the macros are:
*
*	hcf_16	IN_PORT_WORD(  hcf_16 port)
*			Reads a word (16 bits) from the specified port
*
*	void	OUT_PORT_WORD( hcf_16 port, hcf_16 value)
*			Writes a word (16 bits) to the specified port
*
*	void	IN_PORT_STRING( port, dest, len)
*			Reads len number of words from the specified port to the (FAR) address dest in PC-RAM
*			Note that len specifies the number of words, NOT the number of bytes
*			!!!NOTE, although len specifies the number of words, dest MUST be a char pointer NOTE!!!
*			See also the common notes for IN_PORT_STRING and OUT_PORT_STRING
*
*	void	OUT_PORT_STRING( port, src, len)
*			Writes len number of words from the (FAR) address src in PC-RAM to the specified port
*			Note that len specifies the number of words, NOT the number of bytes.
*			!!!NOTE, although len specifies the number of words, src MUST be a char pointer NOTE!!!
*
*			The peculiar combination of word-length and char pointers for IN_PORT_STRING as well as
*			OUT_PORT_STRING is justified by the assumption that it offers a more optimal algorithm
*
*			Note to the HCF-implementor:
*			Due to the passing of the parameters to compiler specific blabla.........
*			do not use "expressions" as parameters, e.g. don't use "ifbp->IFB_IOBase + HREG_AUX_DATA" but
*			assign this to a temporary variable.
*
*
*  NOTE!!	For convenience of the MSF-programmer, all {IN|OUT}_PORT_{BYTE|WORD|STRING} macros are allowed to
*			modify their parameters (although some might argue that this would constitute bad coding
*			practice). This has its implications on the HCF, e.g. as a consequence these macros should not
*			be called with parameters which have side effects, e.g auto-increment.
*
*  NOTE!!	in the Microsoft implementation of inline assembly it is O.K. to corrupt all flags except
*			the direction flag and to corrupt all registers except the segment registers and EDI, ESI,
*			ESP and EBP (or their 16 bits equivalents).
*			Other environments may have other constraints
*
*  NOTE!!	in the Intel environment it is O.K to have a word (as a 16 bits quantity) at a byte boundary,
*			hence IN_/OUT_PORT_STRING can move words between PC-memory and NIC-memory with as only
*			constraint that the words are on a word boundary in NIC-memory. This does not hold true
*			for all conceivable environments, e.g. an Motorola 68xxx does not allow this, in other
*			words whenever there is a move from address in 2*n in one memory type to address 2*m+1 in the
*			other type, the current templates for IN_/OUT_PORT_STRING are unsuitable. Probably the
*			boundary conditions imposed by these type of platforms prevent this case from materializing
*
*************************************************************************************************/

// Note:
// Visual C++ 1.5 : _MSC_VER ==  800
// Visual C++ 4.0 : _MSC_VER == 1000
// Visual C++ 4.2 : _MSC_VER == 1020

typedef unsigned char				hcf_8;
typedef unsigned short				hcf_16;
typedef unsigned long				hcf_32;


/****************************** #define HCF_TYPE ******************************/
//#define HCF_TYPE_HI_PRE_SSN	0x0000	// Hermes-I F/W without SSN support
#define HCF_TYPE_SSN		0x0001	// SSN support
#define HCF_TYPE_USB		0x0002	// Host side for Internally developed USB Dongle driver support
#define HCF_TYPE_HII		0x0004	// Hermes-II
#define HCF_TYPE_AP 		0x0010	// Access Point
#define HCF_TYPE_STA		0x0020	// Station
#define HCF_TYPE_PRELOADED	0x0040	// (Hermes-II) pre-loaded F/W



/************************************************************************************************/
/******************************************  L I N U X  *****************************************/
/************************************************************************************************/

#if defined WVLAN_47 || defined WVLAN_49

#include <asm/io.h>
#include <linux/module.h>
#include <wireless/wl_version.h>

/* The following macro ensures that no symbols are exported, minimizing the chance of a symbol
   collision in the kernel */
EXPORT_NO_SYMBOLS;


/* The following sets the Hermes Type, as well as STA/AP functionality that will be included */

#if defined STA_ONLY && defined AP_ONLY
#error 	Cannot have STA_ONLY and AP_ONLY defined simultaneously!!!
#endif

#ifdef HERMES2

#if defined STA_ONLY
#define HCF_TYPE    (HCF_TYPE_STA|HCF_TYPE_HII)

#if defined USE_WDS
#error WDS is not supported in STA only builds!!!
#endif  /* USE_WDS */

#elif defined AP_ONLY
#define HCF_TYPE    (HCF_TYPE_AP|HCF_TYPE_HII)
#else
#define HCF_TYPE    (HCF_TYPE_STA|HCF_TYPE_AP|HCF_TYPE_HII)
#endif // STA-AP_ONLY

#else

#ifdef USE_RTS
#error RTS mode only supported for Hermes-II !!!
#endif  /* USE_RTS */

/* NOTE: For Hermes-I, HCF_TYPE_SSN must be defined */
#if defined STA_ONLY
#define HCF_TYPE    (HCF_TYPE_STA|HCF_TYPE_SSN)

#if defined USE_WDS
#error WDS is not supported in STA only builds!!!
#endif  /* USE_WDS */

#elif defined AP_ONLY
#define HCF_TYPE    (HCF_TYPE_AP|HCF_TYPE_SSN)
#else
#define HCF_TYPE    (HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_SSN)
#endif // STA-AP_ONLY

#endif // HERMES2

/* The following sets the component ID, as well as the versioning. See also wl_version.h */
#if defined WVLAN_47
#define	MSF_COMPONENT_ID	COMP_ID_LINUX_PD
#endif // WVLAN_47

#if defined WVLAN_49
#define	MSF_COMPONENT_ID	COMP_ID_LINUX_LIB
#endif // WVLAN_49

#define	MSF_COMPONENT_VAR			DRV_VARIANT
#define MSF_COMPONENT_MAJOR_VER     DRV_MAJOR_VERSION
#define MSF_COMPONENT_MINOR_VER     DRV_MINOR_VERSION


/* Define the following to turn on assertions in the HCF */
//#define HCF_ASSERT  0x8000

#ifdef USE_BIG_ENDIAN
#define HCF_BIG_ENDIAN
#endif  /* USE_BIG_ENDIAN */


/* Define the following if your system uses memory-mapped IO */
//#define HCF_MEM_IO


/* The following defines the standard macros required by the HCF to move data to/from the card */
#define IN_PORT_BYTE(port)			((hcf_8)inb( (hcf_io)(port) ))
#define IN_PORT_WORD(port)			((hcf_16)inw( (hcf_io)(port) ))
#define OUT_PORT_BYTE(port, value)	(outb( (hcf_8) (value), (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	(outw((hcf_16) (value), (hcf_io)(port) ))

#define IN_PORT_STRING(port, dst, n)	(insw((hcf_io)(port), dst, n))
#define OUT_PORT_STRING(port, src, n)	(outsw((hcf_io)(port), src, n))


#ifndef OUTPUTDEBUGMSG
#define OUTPUTDEBUGMSG(dprintf_exp)
#endif 


#ifndef ASSERTDEBUGMSG
#define ASSERTDEBUGMSG(cond, dprintf_exp)
#endif 

#ifndef CFG_SCAN_CHANNELS_2GHZ
#define CFG_SCAN_CHANNELS_2GHZ 0xFCC2
#endif /* CFG_SCAN_CHANNELS_2GHZ */

#endif	/* LINUX */


/*  * * * * * * * * * * * * * * * * * * * * * *  IV  * * * * * * * * * * * * * * * * * * * * * * */

/***************************************Compiler specific ****************************************/

#if !defined EXTERN_C
#ifdef __cplusplus
#define EXTERN_C extern "C"
#else
#define EXTERN_C
#endif //__cplusplus
#endif //EXTERN_C

/************************************************************************************************/
/************************ N D I S   S P E C I F I C   M A C R O S  ******************************/
/************************************************************************************************/

#if defined DEBUG || defined _DEBUG || (defined DBG && DBG != 0)
#ifdef _WIN32_WCE
#define DBGA2W(DBGSTR)	CeConvertAnsiToUnicodeLen(szDbgConvertBuffer, DBGSTR,  256)
#define OUTPUTDEBUGMSG(dprintf_exp)			        ce_debug_msg dprintf_exp // (void)(DEBUGMSG(ZONE_INIT, dprintf_exp)) //((void) (DbgPrint dprintf_exp))
#define ASSERTDEBUGMSG(cond, dprintf_exp)			cond ? 0:ce_debug_msg dprintf_exp 
#else
//#define OUTPUTDEBUGMSG(dprintf_exp)					((void) (DbgPrint dprintf_exp))
// the assertdebugmsg macro will print filename, line followed by a caller-defined text, when cond == 0
//#define ASSERTDEBUGMSG(cond, dprintf_exp)	((void)((cond) ? 0: (DbgPrint("%s:%d - ", __FILE__, __LINE__), DbgPrint dprintf_exp)))
#endif
#ifndef DBGA2W
#define DBGA2W
#endif
#else
#define OUTPUTDEBUGMSG(dprintf_exp)
#define ASSERTDEBUGMSG(cond, dprintf_exp)
#endif // DEBUG

/************************************************************************************************/
/********** M A C R O S derived of C O M P I L E R   S P E C I F I C   M A C R O S  *************/
/************************************************************************************************/

#if !defined FAR
#define FAR							// default to flat 32-bits code
#endif //!defined FAR

typedef hcf_8  FAR *wci_bufp;			 // segmented 16-bits or flat 32-bits pointer to 8 bits unit
typedef hcf_16 FAR *wci_recordp;		 // segmented 16-bits or flat 32-bits pointer to 16 bits unit

/*  * * * * * * * * * * * * * * * * * * * * * *  V  * * * * * * * * * * * * * * * * * * * * * * */


/*	I/O Address size
 *	Platforms which use port mapped I/O will (in general) have a 64k I/O space, conveniently expressed in
 *	a 16-bits quantity
 *	Platforms which use memory mapped I/O will (in general) have an I/O space much larger than 64k,
 *	and need a 32-bits quantity to express the I/O base
 *	To accommodate this the macro HCF_MEM_IO is available. If HCF_MEM_IO is not defined, the HCF uses an 
 *	hcf_16 to express I/O base and store in the IFB. If HCF_MEM_IO is defined, an hcf_32 is used.
 */
#if defined HCF_MEM_IO
typedef hcf_32 hcf_io;
#else
typedef hcf_16 hcf_io;
#endif //HCF_MEM_IO



/* MSF_COMPONENT_ID is used to define the CFG_IDENTITY_STRCT in HCF.C
 * CFG_IDENTITY_STRCT is defined in HCF.C purely based on convenience arguments
 * The HCF can not have the knowledge to determine the ComponentId field of the
 * Identity record (aka as Version Record), therefore the MSF part of the Drivers
 * must supply this value via the System Constant MSF_COMPONENT_ID
 * There is a set of values predefined in MDD.H (format COMP_ID_.....)
 *
 * Note that taking MSF_COMPONENT_ID as a default value for DUI_COMPAT_VAR is
 * purely an implementation convenience, the numerical values of these two
 * quantities have none functional relationship whatsoever.
 * Originally there was only a single DUI-variant with value 1. 
 * Then it was considered advantageous to have unique DUI-variant per driver and 
 * - as said before - out of convenience these variants where chosen to have 
 * the same numerical value as the component id of the driver.
 * Again later, it was decided that there would be two Miniport 3.1 drivers,
 * the old one continuing to have DUI-variant and component ID 41, the new 
 * one (the STAP or HomeLAN driver) having component ID 41 but DUI-variant 2 (since
 * 1 was already used in the past)
 */

#if defined	MSF_COMPONENT_ID
#if !defined DUI_COMPAT_VAR
#define	DUI_COMPAT_VAR				MSF_COMPONENT_ID
#endif //!defined DUI_COMPAT_VAR

#if ! defined DUI_COMPAT_BOT		//;?this way utilities can lower as well raise the bottom
#define	DUI_COMPAT_BOT              8
#endif // DUI_COMPAT_BOT

#if ! defined DUI_COMPAT_TOP		//;?this way utilities can lower as well raise the top
#define	DUI_COMPAT_TOP              8
#endif // DUI_COMPAT_TOP

#endif // MSF_COMPONENT_ID


#if (HCF_TYPE) & HCF_TYPE_HII
#if ! defined(HCF_HSI_VAR_4) 
#define HCF_HSI_VAR_4				//Hermes-II all types (for the time being!)
#endif // HCF_HSI_VAR_4
#else // !HCF_TYPE_HII
#if ! defined(HCF_HSI_VAR_0) && ! defined(HCF_HSI_VAR_1) && ! defined(HCF_HSI_VAR_2) && ! defined(HCF_HSI_VAR_3)
#define HCF_HSI_VAR_1				//PCCard
#define HCF_HSI_VAR_2				//MiniPCI
#endif // HCF_HSI_VAR_0/1/2/3
#endif // HCF_TYPE_HII


#if (HCF_TYPE) & HCF_TYPE_HII
#if ! defined(HCF_PRI_VAR_3)
#define HCF_PRI_VAR_3
#endif // HCF_PRI_VAR_3
#else // !HCF_TYPE_HII
#if ! defined(HCF_PRI_VAR_1) && ! defined(HCF_PRI_VAR_2)
#define HCF_PRI_VAR_1
#define HCF_PRI_VAR_2
#endif //HCF_PRI_VAR_1/2
#endif //HCF_TYPE_HII

#if (HCF_TYPE) & HCF_TYPE_HII
#if ! defined(HCF_APF_VAR_2)
#define HCF_APF_VAR_2
#endif // HCF_APF_VAR_2
#else // !HCF_TYPE_HII
#if ! defined(HCF_APF_VAR_1)
#define HCF_APF_VAR_1
#endif //HCF_APF_VAR_1
#endif //HCF_TYPE_HII

#if (HCF_TYPE) & HCF_TYPE_HII
#if ! defined(HCF_STA_VAR_2)
#define HCF_STA_VAR_2
#endif // HCF_STA_VAR_2
#else // !HCF_TYPE_HII
#if ! defined(HCF_STA_VAR_1)
#define HCF_STA_VAR_1
#endif //HCF_STA_VAR_1
#endif //HCF_TYPE_HII


/************************************************************************************************/
/******  M S F    S U P P O R T    F U N C T I O N S    P R O T O T Y P E S   *******************/
/************************************************************************************************/

//******************************************* A L I G N M E N T  **********************************************
#if !defined HCF_ALIGN
#define HCF_ALIGN 1			//default to no alignment
#endif // HCF_ALIGN

#define HCF_8P(p)						((hcf_8*)p)					
#define HCF_DEREF_WORDP(wp)			(hcf_16)( *HCF_8P(wp)  ) | (hcf_16) ((*(HCF_8P(wp)+1)) << 8)
#define HCF_DEREF_DWORDP(dwp)		(hcf_32)( *HCF_8P(dwp) ) | (hcf_32) ((*(HCF_8P(dwp)+1)) << 8)  | (hcf_32) ( (*(HCF_8P(dwp)+2)) << 16) | (hcf_32) ( (*(HCF_8P(dwp)+3)) << 24)


#if HCF_ALIGN != 1 && HCF_ALIGN != 2 && HCF_ALIGN != 4 && HCF_ALIGN != 8
	error;
#endif // HCF_ALIGN != 0 && HCF_ALIGN != 2 etc


#if !defined HCF_MAX_GROUP
#define HCF_MAX_GROUP		16		/* historical determined number of Multicast Addresses
									 * up to Station Supplier 4, Hermes supported a maximum of 16 addresses
									 * to prevent side effects on existing MSFs and to prevent the need
									 * for (messy) adaptation code, the HCF default is 16, making the
									 * HCF default compatible with all station vesions (as far as the
									 * Multicast aspect is concerned. It is suggested that MSFs which
									 * want 32 addresses, limit the Station Actor range to a bottom of
									 * at least 5														*/
#elif HCF_MAX_GROUP > 32
error;								// Hermes supports up to 32 Multicast Addresses
#endif

#if !defined HCF_MAX_CONFIG
#define HCF_MAX_CONFIG		256		/* maximum accumulated size in hcf_16 of LTV records used in hcf_put_info
									 * use of this feature is not recomanded and may be abondaned in the future
									 */
#endif

#if !defined HCF_MAX_MSG
#define HCF_MAX_MSG			1514	// WaveLAN Packet Size in bytes
#endif

#if !defined HCF_MAX_LTV
#define HCF_MAX_LTV			0x1001	// ;? requires some thought, this copes with "default" DownLoadBufferLenght
#endif

#if !defined HCF_PROT_TIME
#define HCF_PROT_TIME		256		// number of 10K microseconds protection timer against H/W malfunction
#elif HCF_PROT_TIME < 19 || HCF_PROT_TIME >	256
error;								// below the minimum .5 second required by Hermes or above the hcf_32 capacity
#endif


/*	Endianess
 *	Little Endian (a.k.a. Intel), least significant byte first
 *	Big Endian (a.k.a. Motorola), most significant byte first
 *
 * The following macros are supplied
 *  o CNV_LITTLE_TO_INT(w)			interprets the 16-bits input value as Little Endian, returns an hcf_16
 * 	o CNV_BIG_TO_INT(w)				interprets the 16-bits input value as Big Endian, returns an hcf_16
 *
 * At a number of places in the HCF code, the CNV_INT_TO_BIG_NP macro is used. While it does have the desired
 * effect on all platforms, it's naming is misleading, so revisit all places where these CNV macros are used
 * to assure the right name is used at the right place.
 *
 */

/* To increase portability, use unsigned char and unsigned char * when accessing parts of larger
 * types to convert their Endianess
 */

#define CNV_END(w)    ( ((hcf_16)(w) & 0x00FF) << 8 | ((hcf_16)(w) & 0xFF00) >> 8 )
#if defined HCF_BIG_ENDIAN
//******************************************** B I G   E N D I A N *******************************************
#define EOC						1			// endianess offset compenation
#define BE_PAR(x)				,x
#define CNV_LITTLE_TO_INT(w)    CNV_END(w)	//    endianess conversion needed
#define CNV_BIG_TO_INT(w)		(w)			// no endianess conversion needed
#else
//****************************************** L I T T L E   E N D I A N ****************************************
#define EOC						0			// endianess offset compenation
#define BE_PAR(x)
#define CNV_LITTLE_TO_INT(w) 	(w)			// no endianess conversion needed
#define CNV_BIG_TO_INT(w)       CNV_END(w)	//    endianess conversion needed
#endif // HCF_BIG_ENDIAN

// conversion macros which can be expressed in other macros
#define CNV_INT_TO_LITTLE(w)	CNV_LITTLE_TO_INT(w)
#define CNV_INT_TO_BIG(w)		CNV_BIG_TO_INT(w)



/*************************************************************************************************************/
/******************************************** . . . . . . . . .  *********************************************/
/*************************************************************************************************************/


/* The BASED customization macro is used to resolves the SS!=DS conflict for the Interrupt Service
 * logic in DOS Drivers. Due to the cumbersomeness of mixing C and assembler local BASED variables
 * still end up in the wrong segment. The workaround is that the HCF uses only global BASED
 * variables or IFB-based variables
 * The "BASED" construction (supposedly) only amounts to something in the small memory model.
 *
 * Note that the whole BASED rigmarole is needlessly complicated because both the Microsoft Compiler and
 * Linker are unnecessary restrictive in what far pointer manipulation they allow
 */

#if !defined BASED
#define BASED
#endif

#if !defined NULL
#define NULL ((void *) 0)
#endif

///*conflicts with ULTSDEMO
#if !defined TEXT
#define TEXT(x) x
#endif

#if !defined _TCHAR_DEFINED
#define TCHAR char
#endif
//conflicts with ULTSDEMO*/

/*************************************************************************************************************/
/************************************ M I G R A T I O N   A S P E C T S **************************************/
/*************************************************************************************************************/
#if !defined HCF_TALLIES
#define HCF_TALLIES 0x0001
#endif // HCF_TALLIES

#if !defined HCF_ENCAPSULATION
#define HCF_ENCAPSULATION 1
#endif // HCF_ENCAPSULATION

#if !defined HCF_MB_OFF
#define HCF_MB_ON
#endif // HCF_MB_OFF

#ifdef _WIN32_WCE
#if !defined HCF_TX_ERR_NOTIFY
#define HCF_TX_ERR_NOTIFY		0
#endif
#if HCF_TX_ERR_NOTIFY 
#undef HCF_MB_ON
#define HCF_MB_ON
#endif // HCF_TX_ERR_NOTIFY
#else // _WIN32_WCE
#ifdef HCF_TX_ERR_NOTIFY 
#undef HCF_MB_ON
#define HCF_MB_ON
#endif // HCF_TX_ERR_NOTIFY
#endif // _WIN32_WCE

//#if (HCF_TYPE) & HCF_TYPE_HII
//#define HCF_DLV 
//#define HCF_DLNV
//#endif //HCF_TYPE_HII

#if !defined HCF_DOWNLOAD_OFF
#define HCF_DOWNLOAD
#define HCF_DLV 
#endif

#if !defined HCF_INT_OFF
#define HCF_INT_ON
#endif // HCF_INT_OFF

//#if !defined HCF_CARD_CHECK_OFF		/*obsolete under new WCI definition */
//#define	HCF_CARD_CHECK_ON
//#define	HCF_CARD_CHECK if ( ifbp->IFB_CardStat & CARD_STAT_PRESENT ) 
//#else
//#define HCF_CARD_CHECK
//#endif // HCF_CARD_CHECK_OFF

#define IFB_PIFRscInd		IFB_RscInd
#define IFB_DUIFRscInd		IFB_RscInd		
#define IFB_NotifyRscInd	IFB_RscInd		  
/*************************************************************************************************************/
/*********************** C O N F L I C T   D E T E C T I O N  &  R E S O L U T I O N *************************/
/*************************************************************************************************************/
#if defined _WVLAN_USB
#undef HCF_INT_ON
#if defined HCF_TYPE
#if ! ( (HCF_TYPE) & HCF_TYPE_USB ) 
there seems to be a conflict between HCF_TYPE and other macro definitions;
#endif // HCF_TYPE & HCF_TYPE_USB
#else
#define HCF_TYPE HCF_TYPE_USB		//default to: no SSN
#endif // HCF_TYPE
#endif // _WVLAN_USB

#if !defined HCF_TYPE
#define HCF_TYPE HCF_TYPE_HII		//default to Hermes-II
#endif 

#if (HCF_TYPE) & HCF_TYPE_HII
#undef HCF_IFB_SECURE
#undef HCF_MAX_CONFIG
#undef HCF_MAX_GROUP
#endif // HCF_TYPE

#if !( (HCF_TYPE) & HCF_TYPE_STA ) && !( (HCF_TYPE) & HCF_TYPE_AP )
you must define at least HCF_TYPE_STA or HCF_TYPE_AP;
//;?make sure this logic works on all relevant compilers;
/*#define HCF_TYPE__HCF_TYPE HCF_TYPE		//note that HCF_TYPE is garuanteed to be defined due to preceeding test
 *#undef HCF_TYPE
 *#define HCF_TYPE ( (HCF_TYPE__HCF_TYPE) | HCF_TYPE_STA )
 */
#endif

#if (HCF_TYPE) & (HCF_TYPE_STA|HCF_TYPE_AP) == 0
too bad, above logic does not seem to work;
#endif

#if defined HCF_ASSERT
#if HCF_ASSERT & 0x0002 && (HCF_TYPE) & HCF_TYPE_USB
err: conflict in assert which performs direct I/O in this case
#endif // HCF_ASSERT / HCF_TYPE_USB

#if HCF_ASSERT & 0x0004
//resolve potential conflict
#undef HCF_MB_OFF
#if !defined HCF_MB_ON
#define HCF_MB_ON
#endif // HCF_MB_ON
#endif // HCF_ASSERT
#endif // HCF_ASSERT

#if defined HCF_DEBUG && (HCF_TYPE) & HCF_TYPE_USB 
err: conflict in hcf_debug_trigger;
#endif // HCF_DEBUG / HCF_TYPE_USB
#endif //HCFCFG_H
