
//   vim:tw=110:ts=4:
/************************************************************************************************************
*
* FILE	  : mmd.c
*
* DATE    : $Date: 2003/05/30 11:34:03 $   $Revision: 1.1.1.1 $
*
* AUTHOR  : Nico Valster
*
* DESC   : Common routines for HCF, MSF, UIL as well as USF sources
*
***************************************************************************************************************
* COPYRIGHT (c) 2001 - 2003	by Agere Systems.		All Rights Reserved
*
* SOFTWARE LICENSE
*
* This software is provided subject to the following terms and conditions,
* which you should read carefully before using the software.  Using this
* software indicates your acceptance of these terms and conditions.  If you do
* not agree with these terms and conditions, do not use the software.
*
* Copyright  2003 Agere Systems Inc.
* All rights reserved.
*
* Redistribution and use in source or binary forms, with or without
* modifications, are permitted provided that the following conditions are met:
*
* . Redistributions of source code must retain the above copyright notice, this
*    list of conditions and the following Disclaimer as comments in the code as
*    well as in the documentation and/or other materials provided with the
*    distribution.
* 
* . Redistributions in binary form must reproduce the above copyright notice,
*    this list of conditions and the following Disclaimer in the documentation
*    and/or other materials provided with the distribution.
* 
* . Neither the name of Agere Systems Inc. nor the names of the contributors
*    may be used to endorse or promote products derived from this software
*    without specific prior written permission.
*
* Disclaimer
*
* THIS SOFTWARE IS PROVIDED AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, INFRINGEMENT AND THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  ANY
* USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE IS SOLELY AT THE USERS OWN
* RISK. IN NO EVENT SHALL AGERE SYSTEMS INC. OR CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, INCLUDING, BUT NOT LIMITED TO, CONTRACT, STRICT 
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
* OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
**************************************************************************************************************/

#include "hcf.h"				// Needed as long as we do not really sort out the mess
#include "hcfdef.h"				// get HCFASSERT
#include "mmd.h"				// MoreModularDriver common include file

 
/*FF***************************************************************************************************************
FUNCT: mmd_check_comp                                                                                2000/02/04 14:15
USERS: hcf_initialize                                   
CALLS: hcf_get_info                                     CNV_LITTLE_TO_INT                                
GLOBL: HCF_SUCCESS                                      p->variant.bottom                                
       p->variant.number                                p->variant.top                                   
PARAM: ifbp                                             p                                                
       p->len                                           type                                             
LOCAL: cnt                                              i                                                
       x                                                x.len                                            
       x.typ                                            x.variant.bottom                                 
       x.variant.number                                 x.variant.top                                    
******************************************************************************************************************/
/******************************************************************************************************************

.MODULE			mmd_check_comp
.DESCRIPTION	Checks compatibility between an actor and a supplier

.ARGUMENTS
  CFG_RANGE_SPEC_STRCT* mmd_check_comp( CFG_RANGES_STRCT *actp, CFG_RANGES_STRCT *supp )
	
.RETURNS
  NULL		incompatible
  <>NULL	pointer to matching CFG_RANGES_STRCT substructure in actor-structure matching the supplier

.NARRATIVE

 Parameters:
  actp	address of the actor specification
  supp	address of the supplier specification

 Description: mmd_check_comp is a support routine to check the compatibility between an actor and a supplier.
 mmd_check_comp is independent of the endianess of the actp and supp structures. This is achieved by checking
 the "bottom" or "role" fields of these structures. Since these fields are restricted to a limited range,
 comparing the contents to a value with a known endian-ess gives a clue to their actual endianess.

.DIAGRAM
 1: The role-field of the actor structure has a known non-zero, not "byte symmetric"  value (namely 
 	COMP_ROLE_ACT or 0x0001), so when the contents of this field matches COMP_ROLE_ACT in Little Endian format,
	the actor structure is Little Endian. Note that the selected macro CNV_LITTLE_TO_INT is a misnomer 
	(especially on a Big Endian platform) but has the intended effect (of doing nothing on a LE platform
	and swapping bytes on a BE platform). By setting i_act appropriately the byte with the "lower" or "higher" 
	address in the number, bottom and top sub-fileds of the CFG_RANGE_SPEC_STRCT field(s) in the actor 
	structure can be selected. Since each of these values is in the range of 1 through 99 inclusive, a byte
	check suffices.
 2:	Since the role-field of the supplier structure is 0x0000, the test as used for the actor does not work.
 	Analoguos to the reasoning why we need only check (either the lower or higher addressed) single byte in
	number, bottom and top, we can conclude that the lower addressed byte of the bottom in a LE can not be 0x00
	and in a BE structure must be 0x00.
 6:	Each of the actor variants is checked against the (single) supplier bottom-top range till either an
 	acceptable match is found or all actor variants are tried. As explained above, due to the limited ranges
	of these values, checking a byte is acceptable and suitable.
 8: depending on whether a match was found or not, the NULL pointer or a pointer to the matching 
 	Number/Top/Bottom record of the Actor structure is returned
 
Note: the CFG_RANGE_SPEC_STRCT and its deravitives use number as a field name where variant might be considered
	more appropriate. For the time being the repurcussions of correcting this are considered to outweigh the
	benefits.
NOTE: The Endian Detection Algorithm places limitations on future extensions of the fields, i.e. they should 
	stay within the currently defined boundaries of 1 through 99 (although 1 through 255) would work as well
	and there should never be a valid bottom 0 variant of a supplier (this would break the i_sup determination)
NOTE: strategy as used in #2 (i.e. supplier index) can NOT be used for #1 (i.e actor index), because there are 
	actors which contain - in addition to meaningfull CFG_RANGE_SPEC_STRCT structures - zero filled 
	CFG_RANGE_SPEC_STRCT as padding. An actor may have a top of zero (see Assert related note below),
	another reason why the top field of an actor can not be used to determine Endianess			
NOTE: the L and T can not be used for the Endian Detection Algorithm, because L and T are always
	Native Endian.
NOTE: the number field of the supplier structure can not be used for the Endian Detection Algorithm, because 
	a variant 0x0000 has been used as Controlled Deployment indication in the past.
Note: relative to Asserts, the following can be observed:
 1:	Supplier variant 0x0000 has been used for Controlled Deployment
 2: An actor may have one or more variant specifications with a top of zero and a  non-zero bottom to override
 	the HCF default support of a particular variant by the MSF programmer via hcfcfg.h
 3:	An actor range can be specified as all zeros, e.g. as padding in the automatically generated fw.c files
	
.ENDOC				END DOCUMENTATION
-----------------------------------------------------------------------------------------------------------*/
CFG_RANGE_SPEC_STRCT* mmd_check_comp( CFG_RANGES_STRCT *actp, CFG_RANGES_STRCT *supp )
{

CFG_RANGE_SPEC_BYTE_STRCT  *actq = (CFG_RANGE_SPEC_BYTE_STRCT*)actp->variant;
CFG_RANGE_SPEC_BYTE_STRCT  *supq = (CFG_RANGE_SPEC_BYTE_STRCT*)supp->variant;
hcf_16	i;
int		i_act = actp->role == CNV_LITTLE_TO_INT(COMP_ROLE_ACT)  ? 0 : 1;	//actor index				/* 1 */
int		i_sup = supq->bottom[0] == 0 ? 1 : 0;								//supplier index			/* 2 */

	//HCFASSERT( supp->len == 6, supp->len )
	//HCFASSERT( actp->len >= 6 && actp->len%3 == 0, actp->len )
	//HCFASSERT( supp->role == COMP_ROLE_SUPL || supp->role == CNV_END(COMP_ROLE_SUPL), supp->role )
	//HCFASSERT( actp->role == COMP_ROLE_ACT  || actp->role == CNV_END(COMP_ROLE_ACT), actp->role )
	//HCFASSERT(/*1 <= supq->number[i_sup] && */ supq->number[i_sup] <=99,  supp->variant[0].number )
	//HCFASSERT(  1 <= supq->bottom[i_sup] &&    supq->bottom[i_sup] <=99,  supp->variant[0].bottom )
	//HCFASSERT(  1 <= supq->top[i_sup]    &&    supq->top[i_sup]    <=99,  supp->variant[0].top    )
	//HCFASSERT(       supq->bottom[i_sup] <=    supq->top[i_sup]        ,  supp->variant[0].number )
#ifdef HCFASSERT
//	for ( i = 3; i < actp->len ; actq++, i += 3 ) {
		//HCFASSERT( ( actq->number[i_act^1] | actq->top[i_act^1] | actq->bottom[i_act^1] ) == 0, i )
		//HCFASSERT( actq->number[i_act] <= 99 && actq->top[i_act] <= 99 && actq->bottom[i_act] <= 99 , i )
		//HCFASSERT( actq->top[i_act] == 0 || ( actq->bottom[i_act] <= actq->top[i_act] ), i )
		//HCFASSERT( ( actq->number[i_act] == 0 && actq->bottom[i_act] == 0 ) ||
		//         ( actq->number[i_act]      && actq->bottom[i_act] ),
		//		   i
		//		 )
//	}
//	actq = (CFG_RANGE_SPEC_BYTE_STRCT*)actp->variant;
#endif // //HCFASSERT
	for ( i = actp->len ; i > 3; actq++, i -= 3 ) {														/* 6 */
		if ( actq->number[i_act] == supq->number[i_sup] &&
			 actq->bottom[i_act] <= supq->top[i_sup] &&
			 actq->top[i_act]    >= supq->bottom[i_sup]    
		   ) break;
	}
	return i > 3 ? (CFG_RANGE_SPEC_STRCT*)actq : NULL;
}/* mmd_check_comp */


