
//   vim:tw=110:ts=4:
#ifndef HCFDEFC_H
#define HCFDEFC_H 1


/*************************************************************************************************
*
* FILE	 : HCFDEFC.H
*
* DATE   : $Date: 2003/06/27 09:54:57 $   $Revision: 1.2 $
*
* AUTHOR : Nico Valster
*
* DESC   : Definitions and Prototypes for HCF only
*
**************************************************************************************************
* COPYRIGHT (c) 1994 - 1995	by AT&T.	 			All Rights Reserved
* COPYRIGHT (c) 1996 - 2000 by Lucent Technologies.	All Rights Reserved
* COPYRIGHT (c) 2001 - 2003	by Agere Systems.		All Rights Reserved
*
* SOFTWARE LICENSE
*
* This software is provided subject to the following terms and conditions,
* which you should read carefully before using the software.  Using this
* software indicates your acceptance of these terms and conditions.  If you do
* not agree with these terms and conditions, do not use the software.
*
* Copyright  2003 Agere Systems Inc.
* All rights reserved.
*
* Redistribution and use in source or binary forms, with or without
* modifications, are permitted provided that the following conditions are met:
*
* . Redistributions of source code must retain the above copyright notice, this
*    list of conditions and the following Disclaimer as comments in the code as
*    well as in the documentation and/or other materials provided with the
*    distribution.
* 
* . Redistributions in binary form must reproduce the above copyright notice,
*    this list of conditions and the following Disclaimer in the documentation
*    and/or other materials provided with the distribution.
* 
* . Neither the name of Agere Systems Inc. nor the names of the contributors
*    may be used to endorse or promote products derived from this software
*    without specific prior written permission.
*
* Disclaimer
*
* THIS SOFTWARE IS PROVIDED AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, INFRINGEMENT AND THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  ANY
* USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE IS SOLELY AT THE USERS OWN
* RISK. IN NO EVENT SHALL AGERE SYSTEMS INC. OR CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, INCLUDING, BUT NOT LIMITED TO, CONTRACT, STRICT 
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
* OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*************************************************************************************************/


/****************************************************************************
*
* CHANGE HISTORY
*
  961018 - NV
	Original Entry

**************************************************************************************************/

/************************************************************************************************/
/*********************************  P R E F I X E S  ********************************************/
/************************************************************************************************/
//IFB_		Interface Block
//HCMD_		Hermes Command
//HFS_		Hermes (Transmit/Receive) Frame Structure
//HREG_		Hermes Register

/*************************************************************************************************/


/************************************************************************************************/
/********************************* GENERAL EQUATES **********************************************/
/************************************************************************************************/

#if ! defined STATIC	//;? change to HCF_STATIC some day
#if defined _DEBUG || defined OOL
#define STATIC
#else
#define STATIC		//;? conflicts with USB Dongle side static
#endif //_DEBUG
#endif // STATIC


#define AUX_MAGIC_0				0xFE01
#define AUX_MAGIC_1				0xDC23
#define AUX_MAGIC_2				0xBA45
#define HCF_MAGIC				0x7D37	// "}7" Handle validation
#define DIAG_MAGIC				0x5A5A

#if HCF_TYPE & HCF_TYPE_HII
#define	PLUG_DATA_OFFSET        0x00000800L
#else
#define	PLUG_DATA_OFFSET        0x00390000L
#endif

#define ONE_SECOND				977		// 977 times a Hermes Timer Tick of 1K microseconds ~ 1 second
#define INI_TICK_INI			0x00040000L

#define IO_IN					0		//hcfio_in_string
#define IO_OUT					1		//hcfio_out_string

#define INI_COMPLETE			obsolete	// 0
#define INI_PARTIAL				obsolete	// 1
//#define INI_PRIM				2

#define CARD_STAT_ENA_PRES		obsolete (CARD_STAT_ENABLED|CARD_STAT_PRESENT)
#define CARD_STAT_PRI_PRES		obsolete (CARD_STAT_PRESENT|CARD_STAT_INCOMP_PRI)
#define CARD_STAT_PRI_STA_PRES	obsolete (CARD_STAT_PRI_PRES|CARD_STAT_INCOMP_STA)

#define DO_ASSERT				( ifbp->IFB_Magic != HCF_MAGIC && ifbp->IFB_Magic == HCF_MAGIC )	//FALSE without the nasty compiler warning

// trace codes used to 
// 1: profile execution times via HCF_TRACE and HCF_TRACE_VALUE
// 2: hierarchical flow information in HCF_ASSERT and hcf_debug_trigger via IFB_AssertTrace 

enum {
//	HCF_TRACE_CONNECT,			useless
//	HCF_TRACE_DISCONNECT,		useless
	HCF_TRACE_ACTION,			//0x0000  0x0001
 	HCF_TRACE_DISABLE,			//0x0001  0x0002	
	HCF_TRACE_ENABLE,			//0x0002  0x0004	
	HCF_TRACE_RCV_MSG,			//0x0003  0x0008	
	HCF_TRACE_GET_INFO,			//0x0004  0x0010	
	HCF_TRACE_INITIALIZE,		//0x0005  0x0020
	HCF_TRACE_PUT_DATA,			//0x0006  0x0040
	HCF_TRACE_PUT_INFO,			//0x0007  0x0080
	HCF_TRACE_CMD_EXE,			//0x0008  0x0100	
	HCF_TRACE_SEND_MSG,			//0x0009  0x0200
	HCF_TRACE_SERVICE_NIC,		//0x000A  0x0400
//                          	//0x000B  0x0800
//                              //0x000C  0x1000
//                              //0x000E  0x4000
//

	HCF_TRACE_STRIO				= 0x0020,
	HCF_TRACE_ALLOC,            //0X0021
	HCF_TRACE_DL,		      	//0X0023
	HCF_TRACE_ISR_INFO,        	//0X0024
	HCF_TRACE_CALIBRATE,		//0x0026
	
	HCF_TRACE_PHASE1			= 0x1000,
	HCF_TRACE_PHASE2			= 0x2000,
	HCF_TRACE_PHASE3			= 0x3000,
#if defined USB
	HCF_TRACE_EXIT 			  	= 0x8000	// Keil C warns "long constant truncated to int"
#else
	HCF_TRACE_EXIT 			  	= -32768	// 0x8000 yield warning like: truncation of constant value
#endif
};

#define	CFG_CONFIG_RID_MASK		0xFC00		//CONFIGURATION RECORDS

#define BAP_0					HREG_DATA_0		//Tx-related register set for WMAC buffer access
#define BAP_1					0x38	//	HREG_DATA_1		//non Tx-related register set for WMAC buffer access
/************************************************************************************************/
/***************************** STRUCTURES *******************************************************/
/************************************************************************************************/


//************************* Hermes Receive/Transmit Frame Structures
//HFS_STAT
//see MMD.H for HFS_STAT_ERR
#define 	HFS_STAT_MSG_TYPE	0xE000	//Hermes reported Message Type
#define 	HFS_STAT_MIC_KEY_ID	0x1800	//MIC key used (if any)
#define 	HFS_STAT_1042		0x2000	//RFC1042 Encoded
#define 	HFS_STAT_TUNNEL		0x4000	//Bridge-Tunnel Encoded
#define 	HFS_STAT_WMP_MSG	0x6000	//WaveLAN-II Management Protocol Frame
#if (HCF_TYPE) & HCF_TYPE_SSN 
#define 	HFS_STAT_MIC		0x0010	//Frame contains MIC  //;? re-instate when F/W ready 
#else
#define 	HFS_STAT_MIC		0x0000	//Frame contains MIC
#endif

#if HFS_TX_CNTL_TYPE_TKIP != HFS_STAT_MIC
Layout of Status field of RxFS and Control field of TxFS should match ****
#endif 

#define 	HFS_TX_CNTL_MASK	(HFS_TX_CNTL_PRIO | HFS_TX_CNTL_SPECTRALINK | HFS_TX_CNTL_PORT | \
								 HFS_TX_CNTL_TX_OK | HFS_TX_CNTL_TX_EX)
			/* ;? mask tx_cntl depending on Hermes capabilities
			 * ;? i.e. change HFS_TX_CNTL_MASK into a dynamic value determined by the F/W supplier range
			 * ;? or mask out priority subfield on STA
			 */
#define 	HFS_TX_CNTL_BITS	(HFS_TX_CNTL_MASK | HFS_TX_CNTL_NO_DCWA | HFS_TX_CNTL_TX_DELAY )

//************************* Hermes Register Offsets and Command bits
#define HREG_IO_RANGE			0x40		//I/O Range used by Hermes


//************************* Command/Status
#define HREG_CMD				0x00		//
#define 	HCMD_CMD_CODE			0x3F
#define HREG_PARAM_0			0x02		//
#define HREG_PARAM_1			0x04		//
#define HREG_PARAM_2			0x06		//
#define HREG_STAT				0x08		//
#define 	HREG_STAT_CMD_CODE		0x003F	//
#define		HREG_STAT_DIAG_ERR		0x0100
#define		HREG_STAT_INQUIRE_ERR	0x0500
#define 	HREG_STAT_CMD_RESULT	0x7F00	//
#define HREG_RESP_0				0x0A		//
#define HREG_RESP_1				0x0C		//
#define HREG_RESP_2				0x0E		//


//************************* FID Management
#define HREG_INFO_FID			0x10		//
#define HREG_RX_FID				0x20		//
#define HREG_ALLOC_FID  		0x22		//
#define HREG_TX_COMPL_FID  		0x24		//


//************************* BAP
#define HREG_SELECT_0			0x18		//
#define HREG_OFFSET_0			0x1C		//
//#define 	HREG_OFFSET_BUSY		0x8000	// use HCMD_BUSY
#define 	HREG_OFFSET_ERR			0x4000	//
//rsrvd #define 	HREG_OFFSET_DATA_OFFSET	0x0FFF	//

#define HREG_DATA_0				0x36		//
//#define HREG_SELECT_1	0x1A		//
//#define HREG_OFFSET_1			0x1E		//

//#define HREG_DATA_1				0x38		//


//************************* Event
#define HREG_EV_STAT			0x30		//
#define HREG_INT_EN				0x32		//
#define HREG_EV_ACK				0x34		//


//************************* Host Software
#define HREG_SW_0				0x28		//
#define HREG_SW_1				0x2A		//
#define HREG_SW_2				0x2C		//
//rsrvd #define HREG_SW_3		0x2E		//
//************************* Control and Auxiliary Port

#define HREG_IO					0x12
#define HREG_CNTL				0x14		//
#define		HREG_CNTL_AUX_ENA_STAT	0xC000
#define		HREG_CNTL_AUX_DIS_STAT	0x0000
#define		HREG_CNTL_AUX_ENA_CNTL	0x8000
#define		HREG_CNTL_AUX_DIS_CNTL	0x4000
#define		HREG_CNTL_AUX_DSD		0x2000
#define		HREG_CNTL_AUX_ENA		(HREG_CNTL_AUX_ENA_CNTL | HREG_CNTL_AUX_DIS_CNTL )
#define HREG_SPARE				0x16		//
#define HREG_AUX_PAGE			0x3A		//
#define HREG_AUX_OFFSET			0x3C		//
#define HREG_AUX_DATA			0x3E		//


/************************************************************************************************/
/***************************** END OF STRUCTURES ***********************************************/
/************************************************************************************************/


/************************************************************************************************/
/**********************************  EQUATES  ***************************************************/
/************************************************************************************************/


// SNAP header for E-II Encapsulation

// Hermes Command Codes and Qualifier bits
#define 	HCMD_BUSY			0x8000	// Busy bit, applicable for all commands
#define HCMD_INI				0x0000	//
#define 	HCMD_INI_0x0100		0x0100	//
#define HCMD_ENABLE				0x0001	//
#define HCMD_DISABLE			0x0002	//
#define HCMD_DIAG				0x0003	//
#define HCMD_EXECUTE			0x0004	//
#define HCMD_ALLOC				0x000A	//
#define HCMD_TX					0x000B	//
#define 	HCMD_RECL			0x0100	// Reclaim bit, applicable for Tx and Inquire
#if HCF_TYPE & HCF_TYPE_HII
#define 	HCMD_DCP			0x0000	// No DataCorruptionPattern for H_II
#else
//;? re-instate when F/W ready #define 	HCMD_DCP			0x0200	// DataCorruptionPattern bit
#define 	HCMD_DCP			0x0000	// No DataCorruptionPattern for H_II
#endif // HCF_TYPE
#define HCMD_NOTIFY				0x0010	//
#define HCMD_INQUIRE			0x0011	//
//#define 	HCMD_RECL			0x0100	// Reclaim bit, applicable for Tx and Inquire
#define HCMD_ACCESS				0x0021	//
#define 	HCMD_ACCESS_WRITE		0x0100	//
#define HCMD_PROGRAM			0x0022	//
#define 	HCMD_PROGRAM_DISABLE				0x0000	//
#define 	HCMD_PROGRAM_ENABLE_VOLATILE	 	0x0100	//
#define 	HCMD_PROGRAM_ENABLE_NON_VOLATILE	0x0200	//
#define 	HCMD_PROGRAM_NON_VOLATILE			0x0300	//
#define HCMD_READ_MIF			0x0030
#define HCMD_WRITE_MIF			0x0031
#define HCMD_THESEUS			0x0038


//Configuration Management
//
#define CFG_DRV_ACT_RANGES_PRI_1_BOTTOM	1	// Default Bottom Compatibility for Primary Firmware - driver I/F
#define CFG_DRV_ACT_RANGES_PRI_1_TOP	2	// Default Top    Compatibility for Primary Firmware - driver I/F
										   	// Hermes needs 2 as top, if top == 1, Shark only

#define CFG_DRV_ACT_RANGES_PRI_2_BOTTOM	1	// Default Bottom Compatibility for Primary Firmware - driver I/F
#define CFG_DRV_ACT_RANGES_PRI_2_TOP	1	// Default Top    Compatibility for Primary Firmware - driver I/F

#define CFG_DRV_ACT_RANGES_PRI_3_BOTTOM	1	// Default Bottom Compatibility for Primary Firmware - driver I/F
#define CFG_DRV_ACT_RANGES_PRI_3_TOP	1	// Default Top    Compatibility for Primary Firmware - driver I/F

#define CFG_DRV_ACT_RANGES_HSI_0_BOTTOM	1	// Default Bottom Compatibility for H/W - driver I/F
#define CFG_DRV_ACT_RANGES_HSI_0_TOP	1	// Default Top    Compatibility for H/W - driver I/F

#define CFG_DRV_ACT_RANGES_HSI_1_BOTTOM	1	// Default Bottom Compatibility for H/W - driver I/F
#define CFG_DRV_ACT_RANGES_HSI_1_TOP	2	// Default Top    Compatibility for H/W - driver I/F

#define CFG_DRV_ACT_RANGES_HSI_2_BOTTOM	1	// Default Bottom Compatibility for H/W - driver I/F
#define CFG_DRV_ACT_RANGES_HSI_2_TOP	1	// Default Top    Compatibility for H/W - driver I/F

#define CFG_DRV_ACT_RANGES_HSI_3_BOTTOM	1	// Default Bottom Compatibility for H/W - driver I/F
#define CFG_DRV_ACT_RANGES_HSI_3_TOP	1	// Default Top    Compatibility for H/W - driver I/F

#define CFG_DRV_ACT_RANGES_HSI_4_BOTTOM	1	// Default Bottom Compatibility for H/W - driver I/F
#define CFG_DRV_ACT_RANGES_HSI_4_TOP	1	// Default Top    Compatibility for H/W - driver I/F

#define CFG_DRV_ACT_RANGES_APF_1_BOTTOM	1	// Default Bottom Compatibility for AP Firmware - driver I/F
#define CFG_DRV_ACT_RANGES_APF_1_TOP    1	// Default Top    Compatibility for AP Firmware - driver I/F

#define CFG_DRV_ACT_RANGES_APF_2_BOTTOM	1	// Default Bottom Compatibility for AP Firmware - driver I/F
#define CFG_DRV_ACT_RANGES_APF_2_TOP    1	// Default Top    Compatibility for AP Firmware - driver I/F

#if HCF_TYPE & HCF_TYPE_SSN
#define CFG_DRV_ACT_RANGES_STA_1_BOTTOM	16	// Default Bottom Compatibility for Station Firmware - driver I/F
#define CFG_DRV_ACT_RANGES_STA_1_TOP   16	// Default Top    Compatibility for Station Firmware - driver I/F
#else
#define CFG_DRV_ACT_RANGES_STA_1_BOTTOM	 6	// Default Bottom Compatibility for Station Firmware - driver I/F
#define CFG_DRV_ACT_RANGES_STA_1_TOP    15	// Default Top    Compatibility for Station Firmware - driver I/F
#endif // HCF_TYPE_SSN


#define CFG_DRV_ACT_RANGES_STA_2_BOTTOM	1	// Default Bottom Compatibility for Station Firmware - driver I/F
#define CFG_DRV_ACT_RANGES_STA_2_TOP    1	// Default Top    Compatibility for Station Firmware - driver I/F

#define CFG_DRV_ACT_RANGES_UBI_1_BOTTOM	1	// Default Bottom Compatibility for USB Converter board - driver I/F
#define CFG_DRV_ACT_RANGES_UBI_1_TOP	1	// Default Top    Compatibility for USB Converter board - driver I/F

											// variant 2
#define CFG_DRV_ACT_RANGES_UBI_2_BOTTOM	1	// Default Bottom Compatibility for USB Converter board - driver I/F
#define CFG_DRV_ACT_RANGES_UBI_2_TOP	1	// Default Top    Compatibility for USB Converter board - driver I/F

#define CFG_DRV_ACT_RANGES_UDI_1_BOTTOM	1	// Default Bottom Compatibility for USB Bootloader  - driver I/F
#define CFG_DRV_ACT_RANGES_UDI_1_TOP	1	// Default Top    Compatibility for USB Bootloader  - driver I/F

//---------------------------------------------------------------------------------------------------------------------
#ifdef HCF_CFG_PRI_1_TOP									// Top Compatibility for Primary Firmware - driver I/F
#if HCF_CFG_PRI_1_TOP == 0  || \
	CFG_DRV_ACT_RANGES_PRI_1_BOTTOM <= HCF_CFG_PRI_1_TOP && HCF_CFG_PRI_1_TOP <= CFG_DRV_ACT_RANGES_PRI_1_TOP
#undef CFG_DRV_ACT_RANGES_PRI_1_TOP
#define CFG_DRV_ACT_RANGES_PRI_1_TOP	HCF_CFG_PRI_1_TOP
#else
error;
#endif
#endif // HCF_CFG_PRI_1_TOP

#ifdef HCF_CFG_PRI_1_BOTTOM                       			// Bottom Compatibility for Primary Firmware - driver I/F
#if CFG_DRV_ACT_RANGES_PRI_1_BOTTOM <= HCF_CFG_PRI_1_BOTTOM && HCF_CFG_PRI_1_BOTTOM <= CFG_DRV_ACT_RANGES_PRI_1_TOP
#undef CFG_DRV_ACT_RANGES_PRI_1_BOTTOM	
#define CFG_DRV_ACT_RANGES_PRI_1_BOTTOM	HCF_CFG_PRI_1_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_PRI_1_BOTTOM


#ifdef HCF_CFG_PRI_2_TOP									// Top Compatibility for Primary Firmware - driver I/F
#if HCF_CFG_PRI_2_TOP == 0 || \
	CFG_DRV_ACT_RANGES_PRI_2_BOTTOM <= HCF_CFG_PRI_2_TOP && HCF_CFG_PRI_2_TOP <= CFG_DRV_ACT_RANGES_PRI_2_TOP
#undef CFG_DRV_ACT_RANGES_PRI_2_TOP
#define CFG_DRV_ACT_RANGES_PRI_2_TOP	HCF_CFG_PRI_2_TOP
#else
error;
#endif
#endif // HCF_CFG_PRI_2_TOP

#ifdef HCF_CFG_PRI_2_BOTTOM                       			// Bottom Compatibility for Primary Firmware - driver I/F
#if CFG_DRV_ACT_RANGES_PRI_2_BOTTOM <= HCF_CFG_PRI_2_BOTTOM && HCF_CFG_PRI_2_BOTTOM <= CFG_DRV_ACT_RANGES_PRI_2_TOP
#undef CFG_DRV_ACT_RANGES_PRI_2_BOTTOM	
#define CFG_DRV_ACT_RANGES_PRI_2_BOTTOM	HCF_CFG_PRI_2_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_PRI_2_BOTTOM


#ifdef HCF_CFG_PRI_3_TOP									// Top Compatibility for Primary Firmware - driver I/F
#if HCF_CFG_PRI_3_TOP == 0 || \
	CFG_DRV_ACT_RANGES_PRI_3_BOTTOM <= HCF_CFG_PRI_3_TOP && HCF_CFG_PRI_3_TOP <= CFG_DRV_ACT_RANGES_PRI_3_TOP
#undef CFG_DRV_ACT_RANGES_PRI_3_TOP
#define CFG_DRV_ACT_RANGES_PRI_3_TOP	HCF_CFG_PRI_3_TOP
#else
error;
#endif
#endif // HCF_CFG_PRI_3_TOP

#ifdef HCF_CFG_PRI_3_BOTTOM                       			// Bottom Compatibility for Primary Firmware - driver I/F
#if CFG_DRV_ACT_RANGES_PRI_3_BOTTOM <= HCF_CFG_PRI_3_BOTTOM && HCF_CFG_PRI_3_BOTTOM <= CFG_DRV_ACT_RANGES_PRI_3_TOP
#undef CFG_DRV_ACT_RANGES_PRI_3_BOTTOM	
#define CFG_DRV_ACT_RANGES_PRI_3_BOTTOM	HCF_CFG_PRI_3_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_PRI_3_BOTTOM


//---------------------------------------------------------------------------------------------------------------------
#ifdef HCF_CFG_HSI_0_TOP 									// Top Compatibility for HSI I/F
#if HCF_CFG_HSI_0_TOP == 0 || \
	CFG_DRV_ACT_RANGES_HSI_0_BOTTOM <= CF_CFG_HSI_0_TOP && HCF_CFG_HSI_0_TOP <= CFG_DRV_ACT_RANGES_HSI_0_TOP
#undef CFG_DRV_ACT_RANGES_HSI_0_TOP	
#define CFG_DRV_ACT_RANGES_HSI_0_TOP	HCF_CFG_HSI_0_TOP
#else
error;
#endif
#endif // HCF_CFG_HSI_0_TOP

#ifdef HCF_CFG_HSI_0_BOTTOM								// Bottom Compatibility for HSI I/F
#if CFG_DRV_ACT_RANGES_HSI_0_BOTTOM <= HCF_CFG_HSI_0_BOTTOM && HCF_CFG_HSI_0_BOTTOM <= CFG_DRV_ACT_RANGES_HSI_0_TOP
#undef CFG_DRV_ACT_RANGES_HSI_0_BOTTOM	
#define CFG_DRV_ACT_RANGES_HSI_0_BOTTOM	HCF_CFG_HSI_0_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_HSI_0_BOTTOM


#ifdef HCF_CFG_HSI_1_TOP 									// Top Compatibility for HSI I/F
#if HCF_CFG_HSI_1_TOP == 0 || \
	CFG_DRV_ACT_RANGES_HSI_1_BOTTOM <= CF_CFG_HSI_1_TOP && HCF_CFG_HSI_1_TOP <= CFG_DRV_ACT_RANGES_HSI_1_TOP
#undef CFG_DRV_ACT_RANGES_HSI_1_TOP	
#define CFG_DRV_ACT_RANGES_HSI_1_TOP	HCF_CFG_HSI_1_TOP
#else
error;
#endif
#endif // HCF_CFG_HSI_1_TOP

#ifdef HCF_CFG_HSI_1_BOTTOM								// Bottom Compatibility for HSI I/F
#if CFG_DRV_ACT_RANGES_HSI_1_BOTTOM <= HCF_CFG_HSI_1_BOTTOM && HCF_CFG_HSI_1_BOTTOM <= CFG_DRV_ACT_RANGES_HSI_1_TOP
#undef CFG_DRV_ACT_RANGES_HSI_1_BOTTOM	
#define CFG_DRV_ACT_RANGES_HSI_1_BOTTOM	HCF_CFG_HSI_1_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_HSI_1_BOTTOM


#ifdef HCF_CFG_HSI_2_TOP 									// Top Compatibility for HSI I/F
#if HCF_CFG_HSI_2_TOP == 0 || \
	CFG_DRV_ACT_RANGES_HSI_2_BOTTOM <= CF_CFG_HSI_2_TOP && HCF_CFG_HSI_2_TOP <= CFG_DRV_ACT_RANGES_HSI_2_TOP
#undef CFG_DRV_ACT_RANGES_HSI_2_TOP	
#define CFG_DRV_ACT_RANGES_HSI_2_TOP	HCF_CFG_HSI_2_TOP
#else
error;
#endif
#endif // HCF_CFG_HSI_2_TOP

#ifdef HCF_CFG_HSI_2_BOTTOM								// Bottom Compatibility for HSI I/F
#if CFG_DRV_ACT_RANGES_HSI_2_BOTTOM <= HCF_CFG_HSI_2_BOTTOM && HCF_CFG_HSI_2_BOTTOM <= CFG_DRV_ACT_RANGES_HSI_2_TOP
#undef CFG_DRV_ACT_RANGES_HSI_2_BOTTOM	
#define CFG_DRV_ACT_RANGES_HSI_2_BOTTOM	HCF_CFG_HSI_2_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_HSI_2_BOTTOM


#ifdef HCF_CFG_HSI_3_TOP 									// Top Compatibility for HSI I/F
#if HCF_CFG_HSI_3_TOP == 0 || \
	CFG_DRV_ACT_RANGES_HSI_3_BOTTOM <= CF_CFG_HSI_3_TOP && HCF_CFG_HSI_3_TOP <= CFG_DRV_ACT_RANGES_HSI_3_TOP
#undef CFG_DRV_ACT_RANGES_HSI_3_TOP	
#define CFG_DRV_ACT_RANGES_HSI_3_TOP	HCF_CFG_HSI_3_TOP
#else
error;
#endif
#endif // HCF_CFG_HSI_3_TOP

#ifdef HCF_CFG_HSI_3_BOTTOM								// Bottom Compatibility for HSI I/F
#if CFG_DRV_ACT_RANGES_HSI_3_BOTTOM <= HCF_CFG_HSI_3_BOTTOM && HCF_CFG_HSI_3_BOTTOM <= CFG_DRV_ACT_RANGES_HSI_3_TOP
#undef CFG_DRV_ACT_RANGES_HSI_3_BOTTOM	
#define CFG_DRV_ACT_RANGES_HSI_3_BOTTOM	HCF_CFG_HSI_3_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_HSI_3_BOTTOM

#ifdef HCF_CFG_HSI_4_TOP 									// Top Compatibility for HSI I/F
#if HCF_CFG_HSI_4_TOP == 0 || \
	CFG_DRV_ACT_RANGES_HSI_4_BOTTOM <= CF_CFG_HSI_4_TOP && HCF_CFG_HSI_4_TOP <= CFG_DRV_ACT_RANGES_HSI_4_TOP
#undef CFG_DRV_ACT_RANGES_HSI_4_TOP	
#define CFG_DRV_ACT_RANGES_HSI_4_TOP	HCF_CFG_HSI_4_TOP
#else
error;
#endif
#endif // HCF_CFG_HSI_4_TOP

#ifdef HCF_CFG_HSI_4_BOTTOM								// Bottom Compatibility for HSI I/F
#if CFG_DRV_ACT_RANGES_HSI_4_BOTTOM <= HCF_CFG_HSI_4_BOTTOM && HCF_CFG_HSI_4_BOTTOM <= CFG_DRV_ACT_RANGES_HSI_4_TOP
#undef CFG_DRV_ACT_RANGES_HSI_4_BOTTOM	
#define CFG_DRV_ACT_RANGES_HSI_4_BOTTOM	HCF_CFG_HSI_4_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_HSI_4_BOTTOM

//---------------------------------------------------------------------------------------------------------------------


#ifdef HCF_CFG_UBI_1_TOP									// Top Compatibility for USB Converter board - driver I/F 
#if HCF_CFG_UBI_1_TOP == 0 || \
	CFG_DRV_ACT_RANGES_UBI_1_BOTTOM <= HCF_CFG_UBI_1_TOP && HCF_CFG_UBI_1_TOP <= CFG_DRV_ACT_RANGES_UBI_1_TOP
#undef CFG_DRV_ACT_RANGES_UBI_1_TOP
#define CFG_DRV_ACT_RANGES_UBI_1_TOP	HCF_CFG_UBI_1_TOP
#else
error;
#endif
#endif // HCF_CFG_UBI_1_TOP

#ifdef HCF_CFG_UBI_1_BOTTOM                       			// Bottom Compatibility for USB Converter board - driver I/F 
#if CFG_DRV_ACT_RANGES_UBI_1_BOTTOM <= HCF_CFG_UBI_1_BOTTOM && HCF_CFG_UBI_1_BOTTOM <= CFG_DRV_ACT_RANGES_UBI_1_TOP
#undef CFG_DRV_ACT_RANGES_UBI_1_BOTTOM	
#define CFG_DRV_ACT_RANGES_UBI_1_BOTTOM	HCF_CFG_UBI_1_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_UBI_1_BOTTOM


#ifdef HCF_CFG_UDI_1_TOP									// Top Compatibility for USB Bootloader  - driver I/F
#if HCF_CFG_UDI_1_TOP == 0 || \
	CFG_DRV_ACT_RANGES_UDI_1_BOTTOM <= HCF_CFG_UDI_1_TOP && HCF_CFG_UDI_1_TOP <= CFG_DRV_ACT_RANGES_UDI_1_TOP
#undef CFG_DRV_ACT_RANGES_UDI_1_TOP
#define CFG_DRV_ACT_RANGES_UDI_1_TOP	HCF_CFG_UDI_1_TOP
#else
error;
#endif
#endif // HCF_CFG_UDI_1_TOP

#ifdef HCF_CFG_UDI_1_BOTTOM                       			// Bottom Compatibility for USB Bootloader  - driver I/F
#if CFG_DRV_ACT_RANGES_UDI_1_BOTTOM <= HCF_CFG_UDI_1_BOTTOM && HCF_CFG_UDI_1_BOTTOM <= CFG_DRV_ACT_RANGES_UDI_1_TOP
#undef CFG_DRV_ACT_RANGES_UDI_1_BOTTOM	
#define CFG_DRV_ACT_RANGES_UDI_1_BOTTOM	HCF_CFG_UDI_1_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_UDI_1_BOTTOM

//---------------------------------------------------------------------------------------------------------------------
#ifdef HCF_CFG_APF_1_TOP                  					// Top Compatibility for AP Firmware - driver I/F
#if HCF_CFG_APF_1_TOP == 0 || \
	CFG_DRV_ACT_RANGES_APF_1_BOTTOM <= HCF_CFG_APF_1_TOP && HCF_CFG_APF_1_TOP <= CFG_DRV_ACT_RANGES_APF_1_TOP
#undef CFG_DRV_ACT_RANGES_APF_1_TOP	
#define CFG_DRV_ACT_RANGES_APF_1_TOP	HCF_CFG_APF_1_TOP
#else
error;
#endif
#endif // HCF_CFG_APF_TOP

#ifdef HCF_CFG_APF_1_BOTTOM                       			// Bottom Compatibility for AP Firmware - driver I/F
#if CFG_DRV_ACT_RANGES_APF_1_BOTTOM <= HCF_CFG_APF_1_BOTTOM && HCF_CFG_APF_1_BOTTOM <= CFG_DRV_ACT_RANGES_APF_1_TOP
#undef CFG_DRV_ACT_RANGES_APF_1_BOTTOM	
#define CFG_DRV_ACT_RANGES_APF_1_BOTTOM	HCF_CFG_APF_1_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_APF_BOTTOM

#ifdef HCF_CFG_APF_2_TOP                  					// Top Compatibility for AP Firmware - driver I/F
#if HCF_CFG_APF_2_TOP == 0 || \
	CFG_DRV_ACT_RANGES_APF_2_BOTTOM <= HCF_CFG_APF_2_TOP && HCF_CFG_APF_2_TOP <= CFG_DRV_ACT_RANGES_APF_2_TOP
#undef CFG_DRV_ACT_RANGES_APF_2_TOP	
#define CFG_DRV_ACT_RANGES_APF_2_TOP	HCF_CFG_APF_2_TOP
#else
error;
#endif
#endif // HCF_CFG_APF_TOP

#ifdef HCF_CFG_APF_2_BOTTOM                       			// Bottom Compatibility for AP Firmware - driver I/F
#if CFG_DRV_ACT_RANGES_APF_2_BOTTOM <= HCF_CFG_APF_2_BOTTOM && HCF_CFG_APF_2_BOTTOM <= CFG_DRV_ACT_RANGES_APF_2_TOP
#undef CFG_DRV_ACT_RANGES_APF_2_BOTTOM	
#define CFG_DRV_ACT_RANGES_APF_2_BOTTOM	HCF_CFG_APF_2_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_APF_BOTTOM

#ifdef HCF_CFG_STA_1_TOP                  					// Top Compatibility for Station Firmware - driver I/F
#if HCF_CFG_STA_1_TOP == 0 || \
	CFG_DRV_ACT_RANGES_STA_1_BOTTOM <= HCF_CFG_STA_1_TOP && HCF_CFG_STA_1_TOP <= CFG_DRV_ACT_RANGES_STA_1_TOP
#undef CFG_DRV_ACT_RANGES_STA_1_TOP	
#define CFG_DRV_ACT_RANGES_STA_1_TOP	HCF_CFG_STA_1_TOP
#else
error;
#endif
#endif // HCF_CFG_STA_TOP

#ifdef HCF_CFG_STA_1_BOTTOM                       			// Bottom Compatibility for Station Firmware - driver I/F
#if CFG_DRV_ACT_RANGES_STA_1_BOTTOM <= HCF_CFG_STA_1_BOTTOM && HCF_CFG_STA_1_BOTTOM <= CFG_DRV_ACT_RANGES_STA_1_TOP
#undef CFG_DRV_ACT_RANGES_STA_1_BOTTOM	
#define CFG_DRV_ACT_RANGES_STA_1_BOTTOM	HCF_CFG_STA_1_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_STA_BOTTOM


#ifdef HCF_CFG_STA_2_TOP                  					// Top Compatibility for Station Firmware - driver I/F
#if HCF_CFG_STA_2_TOP == 0 || \
	CFG_DRV_ACT_RANGES_STA_2_BOTTOM <= HCF_CFG_STA_2_TOP && HCF_CFG_STA_2_TOP <= CFG_DRV_ACT_RANGES_STA_2_TOP
#undef CFG_DRV_ACT_RANGES_STA_2_TOP	
#define CFG_DRV_ACT_RANGES_STA_2_TOP	HCF_CFG_STA_2_TOP
#else
error;
#endif
#endif // HCF_CFG_STA_TOP

#ifdef HCF_CFG_STA_2_BOTTOM                       			// Bottom Compatibility for Station Firmware - driver I/F
#if CFG_DRV_ACT_RANGES_STA_2_BOTTOM <= HCF_CFG_STA_2_BOTTOM && HCF_CFG_STA_2_BOTTOM <= CFG_DRV_ACT_RANGES_STA_2_TOP
#undef CFG_DRV_ACT_RANGES_STA_2_BOTTOM	
#define CFG_DRV_ACT_RANGES_STA_2_BOTTOM	HCF_CFG_STA_2_BOTTOM
#else
error;
#endif
#endif // HCF_CFG_STA_BOTTOM


/************************************************************************************************/
/**********************************  END OF EQUATES  ********************************************/
/************************************************************************************************/


/************************************************************************************************/
/**************************************  MACROS  ************************************************/
/************************************************************************************************/


#define MUL_BY_2( x )	( (x) << 1 )	//used to multiply by 2
#define DIV_BY_2( x )	( (x) >> 1 )	//used to divide by 2

#if (HCF_TYPE) & HCF_TYPE_HII // lets forget all those workarounds, it is unworkable over different HCF versions 
#if 1 //;?insecure
#define S_DAWA_ACK( ifbp, mask) ack_the_bastard( ifbp, mask )
#else
#define S_DAWA_ACK( ifbp, mask) DAWA_ACK( ifbp, mask)  
#endif // 1
#define DAWA_ACK( ifbp, mask) {OPW( HREG_EV_ACK, mask|HREG_EV_REPAIR_ACK );OPW( HREG_EV_ACK, mask|HREG_EV_REPAIR_ACK );}
#define HI_AUX_CNTL(ifbp, cmd) 
#else // HCF_TYPE_HII
#define S_DAWA_ACK( ifbp, mask) OPW( HREG_EV_ACK, mask );
#define DAWA_ACK( ifbp, mask)   OPW( HREG_EV_ACK, mask );
#define HI_AUX_CNTL(ifbp, cmd) aux_cntl( ifbp, cmd );
#endif // HCF_TYPE_HII

#if (HCF_TYPE) & HCF_TYPE_SSN
//after testing to prove its correctness: #define MIC_RX_RTN( mic, dw ) update_mic( mic, dw )
#define MIC_RX_RTN( mic, dw ) ifbp->IFB_MICRxRtn( mic, dw );
#define MIC_TX_RTN( mic, dw ) ifbp->IFB_MICTxRtn( mic, dw );
#define IF_SSN(x)  x
#define IF_NOT_SSN(x)
#else
#define MIC_RX_RTN( mic, dw )
#define MIC_TX_RTN( mic, dw )
#define IF_SSN(x)
#define IF_NOT_SSN(x) x
#endif // HCF_TYPE_SSN



//!-
#if (HCF_TYPE) & HCF_TYPE_USB	// ********************** USB  **********************
#define IF_USB(x)  x
#define IF_NOT_USB(x)
#define HCF_WAIT_WHILE( x )	
#define IPW(x) *usb_simp++	
#define OPW(x, y) { \
	hcf_16 z = y; \
/*;? this is needed when "simulating" USB as a test with the DOS ODI	OUT_PORT_WORD( ifbp->IFB_IOBase + (x), z );*/\
	HCFASSERT( x == HREG_DATA_0, x )\
	if ( x == HREG_DATA_0 ) *usb_simp++ = z;\
/*	usb_tx_len += 2; ;?not very runtime efficient*/ \
}
#else 						 	// ******************** No USB  ********************
#define IF_USB(x)
#define IF_NOT_USB(x) x
#define IPW(x) IN_PORT_WORD( ifbp->IFB_IOBase + (x) ) 
#define OPW(x, y) OUT_PORT_WORD( ifbp->IFB_IOBase + (x), y ) 
	/* make sure the implementation of HCF_WAIT_WHILE is such that there may be multiple HCF_WAIT_WHILE calls
	 * in a row and that when one fails all subsequent fail immediately without reinitialization of prot_cnt
	 */
#if defined HCF_YIELD 
#define HCF_WAIT_WHILE( x ) while ( prot_cnt && (x) && (HCF_YIELD) ) prot_cnt--;
#else
#define HCF_WAIT_WHILE( x ) while ( prot_cnt && (x) ) prot_cnt--;
#endif // HCF_YIELD
#endif // HCF_TYPE_USB

#if defined HCF_EX_INT
#if HCF_EX_INT & ~( HCF_EX_INT_TX_EX | HCF_EX_INT_TX_OK | HCF_EX_INT_TICK )
error, you used an invalid bitmask;
#endif // HCF_EX_INT validation
#else
#define HCF_EX_INT 0x000
#endif // HCF_EX_INT

#if HCF_EX_INT_TICK	!= HREG_EV_TICK
error, someone redefined these macros while the implemenation assumes they are equal;
#endif 
#if HCF_EX_INT_TX_OK != HFS_TX_CNTL_TX_OK || HFS_TX_CNTL_TX_OK != HREG_EV_TX_OK 
error, someone redefined these macros while the implemenation assumes they are equal;
#endif 
#if HCF_EX_INT_TX_EX != HFS_TX_CNTL_TX_EX || HFS_TX_CNTL_TX_EX != HREG_EV_TX_EX 
error, someone redefined these macros while the implemenation assumes they are equal;
#endif 


#if ! defined HCF_MB_ON && HCF_EX_INT & (HCF_EX_INT_TX_OK | HCF_EX_INT_TX_EX)
#define HCF_MB_ON			//if HCF_MB_OFF is also defined this will catch a couple of lines down
#endif // HCF_MB_ON / HCF_EX_INT

#if defined HCF_MB_OFF && defined HCF_MB_ON
error: at most 1 of these macros should be defined;
#elif !defined HCF_MB_OFF && !defined HCF_MB_ON
#define HCF_MB_ON
#endif //HCF_MB_OFF

/* The assert in HCFLOGENTRY checks against re-entrancy. Re-entrancy could be caused by a MSF logic at 
 * task-level calling hcf_functions without shielding with HCF_ACT_ON/_OFF. When an interrupt occurs, 
 * the ISR could (either directly or indirectly) cause re-entering of the interrupted HCF-routine.
 *
 * The "(ifbp->IFB_AssertWhere = where)" test in HCFLOGENTRY services ALSO as a statement to get around:
 * #pragma warning: conditional expression is constant
 * on the if-statement
 */
#if HCF_ASSERT
#define HCFASSERT(x,q) if (!(x)) {assert( ifbp, __LINE__, q );}

#define HCFLOGENTRY( where, what ) 														\
{if ( (ifbp->IFB_AssertWhere = where) <= 15 ) {															\
	HCFASSERT( (ifbp->IFB_AssertTrace & 1<<(where)) == 0, ifbp->IFB_AssertTrace );		\
	ifbp->IFB_AssertTrace |= 1<<(where);												\
	}																					\
HCFTRACE(ifbp, where )																	\
HCFTRACEVALUE(ifbp, what )																\
}

#define HCFLOGEXIT( where ) 															\
{if ( (ifbp->IFB_AssertWhere = where) <= 15 )ifbp->IFB_AssertTrace &= ~(1<<(where));}						 \
HCFTRACE(ifbp, (where)|HCF_TRACE_EXIT )

#else // HCF_ASSERT
#define HCFASSERT( x, q )
#define HCFLOGENTRY( where, what ) 	
#define HCFLOGEXIT( where ) 		
#endif // HCF_ASSERT

#if defined HCF_INT_ON
#define HCFASSERT_INT HCFASSERT( ifbp->IFB_IntOffCnt != 0xFFFF, 0 )
#else
#define HCFASSERT_INT
#endif // HCF_INT_ON


#ifdef HCF_TRACE 
#ifndef _WIN32_WCE	//;? these MACROS should not be here in the first place !!!!!!!!!!!!!!!!!!
// were these not defined in hcfcfg.h?
#define IN_PORT_WORD(port)			((hcf_16)_inpw( (hcf_io)(port) ))		//;?kludge to get wcitst to run
#define OUT_PORT_WORD(port, value)	((void)_outpw( (hcf_io)(port), value ))
#endif
//#define HCFTRACE(ifbp, where ) {OPW( HREG_SW_1, where );}
#define HCFTRACE(ifbp, where )	   {hcf_debug_trigger( ifbp, HREG_SW_1, where );}
#define HCFTRACEVALUE(ifbp, what ) {hcf_debug_trigger( ifbp, HREG_SW_2, what  );}
#else
#define HCFTRACE(ifbp, where )
#define HCFTRACEVALUE(ifbp, what )
#endif // HCF_TRACE



/************************************************************************************************/
/**************************************  END OF MACROS  *****************************************/
/************************************************************************************************/

/************************************************************************************************/
/***************************************  PROTOTYPES  *******************************************/
/************************************************************************************************/


#endif	//HCFDEFC_H
