
option expr32
option casemap:none

; Begin of file c:/HCF/hcf.h
;    vim:tw=110:ts=4:
HCF_H		EQU		1t
; ************************************************************************************************************
; *
; * FILE	 : hcf.h *************** 2.0 *************************************************************************
; *
; * DATE   : $Date: 2003/05/30 11:34:03 $   $Revision: 1.1.1.1 $
; *
; * AUTHOR : Nico Valster
; *
; * DESC   : Definitions and Prototypes for MSF as well as HCF sources
; *
; *			Customizable via HCFCFG.H
; *
; *
; **************************************************************************************************************
; Instructions to convert HCF.H to HCF.INC by means of H2INC
; 
; Use a command line which defines the specific macros and command line options
; needed to build the C-part, e.g. for the DOS ODI driver
; 		`h2inc /C /Ni /Zp /Zn hcf	 hcf.h`
; 
; 
; **************************************************************************************************************
; * COPYRIGHT (c) 1994 - 1995	by AT&T.	 			All Rights Reserved
; * COPYRIGHT (c) 1996 - 2000 by Lucent Technologies.	All Rights Reserved
; * COPYRIGHT (c) 2001 - 2003	by Agere Systems.		All Rights Reserved
; *************************************************************************************************************
;  System Constants to be defined by the MSF-programmer to tailor the HCF
; Begin of file c:/HCF/hcfcfg.h
;    vim:tw=110:ts=4:
HCFCFG_H		EQU		1t
; *************************************************************************************************************
; *
; * FILE	 : hcfcfg.tpl // hcfcfg.h **************************** 2.0 ********************************************
; *
; * DATE   : $Date: 2003/05/30 11:34:03 $   $Revision: 1.1.1.1 $
; *
; * AUTHOR : Nico Valster
; *
; * DESC   : HCF Customization Macros
; *
; ***************************************************************************************************************
; * COPYRIGHT (c) 1994 - 1995	by AT&T.	 			All Rights Reserved
; * COPYRIGHT (c) 1996 - 2000 by Lucent Technologies.	All Rights Reserved
; * COPYRIGHT (c) 2001 - 2003	by Agere Systems.		All Rights Reserved
; ***************************************************************************************************************
; *
; * hcfcfg.tpl list all #defines which must be specified to:
; *    I:	adjust the HCF functions defined in HCF.CPP to the characteristics of a specific environment
; * 		o maximum sizes for messages and notification frames, persistent configuration storage
; * 		o Endianess
; *
; *	II:	Compiler specific macros
; * 		o port I/O macros
; * 		o type definitions
; *
; *  III:	Environment specific ASSERT macro
; *
; *   IV: Compiler specific
; *
; *    V: ;? specific
; *
; *
; * By copying HCFCFG.TPL to HCFCFG.H and -if needed- modifying the #defines the WCI functionality can be
; * tailored
; *
; * Supported environments:
; WVLAN_41	Miniport                                NDIS 3.1
; WVLAN_42	Packet                                	Microsoft Visual C 1.5
; WVLAN_43	16 bits DOS ODI                      	Microsoft Visual C 1.5
; WVLAN_44	32 bits ODI (__NETWARE_386__)			WATCOM
; WVLAN_45	MAC_OS									MPW?, Symantec?
; WVLAN_46	Windows CE (_WIN32_WCE)					Microsoft ?
; WVLAN_47	LINUX  (__LINUX__)						GCC
; WVLAN_48	Miniport                                NDIS 5
; WVLAN_51	Miniport USB                            NDIS 5
; WVLAN_52	Miniport 		                        NDIS 4
; WVLAN_53	VxWorks END Station driver
; WVLAN_54	VxWorks END Access Point driver
; WVLAN_81	WavePoint								BORLAND C
; WCITST		Inhouse test tool						Microsoft Visual C 1.5
; WSU			WaveLAN Station Update					Microsoft Visual C ??
; SCO UNIX	not yet actually used ?					?
; __ppc		OEM supplied							?
; _AM29K		OEM supplied							?
; ?			OEM supplied							Microtec Research 80X86 Compiler
; 
; * T O   D O :  A D D   A   R E C I P E   H O W  T O   M O D I F Y  HCFCFG.H
; *
; *************************************************************************************************************
; ***************************************************************************
; *
; * CHANGE HISTORY
; *
; 
;   960702 - NV
; 	Original Entry - derived from HCF 2.12
; ************************************************************************************************
; ****************************    IN_PORT_STRING  S a m p l e s ***************************************************
; 
; 		// C implementation which let the processor handle the word-at-byte-boundary problem
; #define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16 FAR*)dst = IN_PORT_WORD( prt ); dst += 2; }
; 
; 
; 		// C implementation which handles the word-at-byte-boundary problem 
; #define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { int i = IN_PORT_WORD( prt ); *dst++ = (char)i; *dst++ = (char)(i >> 8); }
; 
; 
; 		// Assembler implementation
; #define IN_PORT_STRING( port, dest, len) __asm 		{														__asm push di                               		__asm push es                                 		__asm mov cx,len                            		__asm les di,dest                           		__asm mov dx,port                           		__asm rep insw                              		__asm pop es	                            		__asm pop di	                            	}
; 
;        
; *****************************************************************************************************************
; ****************************   OUT_PORT_STRING  S a m p l e s ***************************************************
;        
; 		// C implementation which let the processor handle the word-at-byte-boundary problem
; #define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16 FAR*)src ) ; src  += 2; }
; 
; 
; 		// C implementation which handles the word-at-byte-boundary problem 
; #define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *src | *(src+1)<<8  ) ; src  += 2; }
; //;?  WHY hcf_16 FAR*)src and not unsigned char FAR*)src
; 
; 
; 												// Assembler implementation
; #define OUT_PORT_STRING( port, src, len) __asm		{                                               		__asm push si                                 		__asm push ds                                 		__asm mov cx,len                              		__asm lds si,src                             		__asm mov dx,port                             		__asm rep outsw	                            		__asm pop ds                                  		__asm pop si                                  	}
; 
; *****************************************************************************************************************
;   * * * * * * * * * * * * * * * * * * * * * *  I * * * * * * * * * * * * * * * * * * * * * * 
; 	Alignment
;  *	Some platforms can access words on odd boundaries (with possibly an performance impact), at other
;  *	platforms such an access may result in a memory access violation.
;  *	It is assumed that everywhere where the HCF casts a char pointer into a word pointer, the
;  *	alignment criteria are met. This put some restrictions on the MSF, which are assumed to be
;  *	"automatically" fulfilled at the applicable platforms
;  *	To assert this assumption, the macro HCF_ALIGN can be defined. The default value is 0, meaning no
;  *	alignment, a value of 2 means word alignment, other values are invalid
;  
;   * * * * * * * * * * * * * * * * * * * * * * II * * * * * * * * * * * * * * * * * * * * * * 
; **********************************************************************************************
; *****************  C O M P I L E R   S P E C I F I C   M A C R O S  **************************
; **********************************************************************************************
; ************************************************************************************************
; *
; * The platforms supported by this version are:
; *	- Microsoft Visual C 1.5 (16 bits platform)
; *	- Microsoft Visual C 2.0 (32 bits platform)
; *	- Watcom C/C++ 9.5
; *	- SCO UNIX
; *
; * In this version of hcfiocfg.tpl all macros except the MSVC 1.5 versions are either dependent on
; * compiler/environment supplied macros (e.g. _MSC_VER or "def-ed out"
; *
; * By selecting the appropriate Macro definitions by means of modifying the
; * "#ifdef 0/1" lines, the HCF can be adjusted for the I/O characteristics of
; * a specific compiler
; *
; * If needed the macros can be modified or replaced with definitions appropriate
; * for your personal platform
; * If you need to make such changes it is appreciated if you inform Lucent Technologies WCND Utrecht
; * That way the changes can become part of the next release of the WCI
; *
; *
; *	The prototypes and functional description of the macros are:
; *
; *	hcf_16	IN_PORT_WORD(  hcf_16 port)
; *			Reads a word (16 bits) from the specified port
; *
; *	void	OUT_PORT_WORD( hcf_16 port, hcf_16 value)
; *			Writes a word (16 bits) to the specified port
; *
; *	void	IN_PORT_STRING( port, dest, len)
; *			Reads len number of words from the specified port to the (FAR) address dest in PC-RAM
; *			Note that len specifies the number of words, NOT the number of bytes
; *			!!!NOTE, although len specifies the number of words, dest MUST be a char pointer NOTE!!!
; *			See also the common notes for IN_PORT_STRING and OUT_PORT_STRING
; *
; *	void	OUT_PORT_STRING( port, src, len)
; *			Writes len number of words from the (FAR) address src in PC-RAM to the specified port
; *			Note that len specifies the number of words, NOT the number of bytes.
; *			!!!NOTE, although len specifies the number of words, src MUST be a char pointer NOTE!!!
; *
; *			The peculiar combination of word-length and char pointers for IN_PORT_STRING as well as
; *			OUT_PORT_STRING is justified by the assumption that it offers a more optimal algorithm
; *
; *			Note to the HCF-implementor:
; *			Due to the passing of the parameters to compiler specific blabla.........
; *			do not use "expressions" as parameters, e.g. don't use "ifbp->IFB_IOBase + HREG_AUX_DATA" but
; *			assign this to a temporary variable.
; *
; *
; *  NOTE!!	For convenience of the MSF-programmer, all {IN|OUT}_PORT_{BYTE|WORD|STRING} macros are allowed to
; *			modify their parameters (although some might argue that this would constitute bad coding
; *			practice). This has its implications on the HCF, e.g. as a consequence these macros should not
; *			be called with parameters which have side effects, e.g auto-increment.
; *
; *  NOTE!!	in the Microsoft implementation of inline assembly it is O.K. to corrupt all flags except
; *			the direction flag and to corrupt all registers except the segment registers and EDI, ESI,
; *			ESP and EBP (or their 16 bits equivalents).
; *			Other environments may have other constraints
; *
; *  NOTE!!	in the Intel environment it is O.K to have a word (as a 16 bits quantity) at a byte boundary,
; *			hence IN_/OUT_PORT_STRING can move words between PC-memory and NIC-memory with as only
; *			constraint that the words are on a word boundary in NIC-memory. This does not hold true
; *			for all conceivable environments, e.g. an Motorola 68xxx does not allow this, in other
; *			words whenever there is a move from address in 2*n in one memory type to address 2*m+1 in the
; *			other type, the current templates for IN_/OUT_PORT_STRING are unsuitable. Probably the
; *			boundary conditions imposed by these type of platforms prevent this case from materializing
; *
; ************************************************************************************************
;  Note:
;  Visual C++ 1.5 : _MSC_VER ==  800
;  Visual C++ 4.0 : _MSC_VER == 1000
;  Visual C++ 4.2 : _MSC_VER == 1020
hcf_8		TYPEDEF		BYTE

hcf_16		TYPEDEF		WORD

hcf_32		TYPEDEF		DWORD

; ***************************** #define HCF_TYPE *****************************
; #define HCF_TYPE_HI_PRE_SSN	0x0000	// Hermes-I F/W without SSN support
;  SSN support
HCF_TYPE_SSN		EQU		000000001h
;  Host side for Internally developed USB Dongle driver support
HCF_TYPE_USB		EQU		000000002h
;  Hermes-II
HCF_TYPE_HII		EQU		000000004h
;  Access Point
HCF_TYPE_AP		EQU		000000010h
;  Station
HCF_TYPE_STA		EQU		000000020h
;  (Hermes-II) pre-loaded F/W
HCF_TYPE_PRELOADED		EQU		000000040h
; **********************************************************************************************
; *****************************  M I N I P O R T    N D I S  3.1  ******************************
; **********************************************************************************************
; **********************************************************************************************
; ***************************  P A C K E T   D R I V E R  **************************************
; *********************************  D O S   O D I  ********************************************
; **********************************************************************************************
; #undef  HCF_ASSERT	//;?temporarily while chasing the double definition
; #define HCF_ASSERT    0x0002			//assert (also) via S/W Supp Register
; #define HCF_ASSERT    0x0004			//assert (also) in Mailbox
; #define HCF_ASSERT	0x8000			//link msf_assert routine statically
; #define HCF_ENCAPSULATION 0
; #define HCF_MB_OFF
; #define HCF_INT_OFF
; out-of-date #define HCF_CARD_CHECK_OFF
; log transmissions in Mailbox
; //just to investigate the Intermec observations
; #define HCF_ALIGN 2			
; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ To ease testing the different options ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
MSF_COMPONENT_VAR		EQU		1t
MSF_COMPONENT_MAJOR_VER		EQU		6t
MSF_COMPONENT_MINOR_VER		EQU		10t
;  number of Multicast Addresses supported by ODI/Packet
HCF_MAX_GROUP		EQU		16t
;  segmented 16 bits mode
; Begin of file /MSVC/INCLUDE\stdio.h
; **
; *stdio.h - definitions/declarations for standard I/O routines
; *
; *   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
; *
; *Purpose:
; *   This file defines the structures, values, macros, and functions
; *   used by the level 2 I/O ("standard I/O") routines.
; *   [ANSI/System V]
; *
; ***
size_t		TYPEDEF		WORD

va_list		TYPEDEF		PTR SBYTE

;  buffered I/O macros 
BUFSIZ		EQU		512t
_NFILE		EQU		20t
EOF		EQU		0ffffffffh
@t_hcf0		TYPEDEF		PTR SBYTE
@t_hcf1		TYPEDEF		PTR SBYTE
_iobuf		STRUCT 2t
_ptr		@t_hcf0		?
_cnt		SWORD		?
_base		@t_hcf1		?
_flag		SBYTE		?
_file		SBYTE		?
_iobuf		ENDS

FILE		TYPEDEF		_iobuf

;  _P_tmpnam: Directory where temporary files may be created.
;  * L_tmpnam size =  size of _P_tmpdir
;  *  + 1 (in case _P_tmpdir does not end in "")
;  *  + 6 (for the temp number string)
;  *  + 1 (for the null terminator)
;  
;  fseek constants 
SEEK_CUR		EQU		1t
SEEK_END		EQU		2t
SEEK_SET		EQU		0t
;  minimum guaranteed filename length, open file count, and unique
;  * tmpnam filenames.
;  
FILENAME_MAX		EQU		128t
FOPEN_MAX		EQU		18t
TMP_MAX		EQU		32767t
_SYS_OPEN		EQU		20t
;  define NULL pointer value 
;  declare _iob[] array 
EXTERNDEF		C _iob:FILE

;  define file position type 
fpos_t		TYPEDEF		SDWORD

;  standard file pointers 
_IOREAD		EQU		000000001h
_IOWRT		EQU		000000002h
_IOFBF		EQU		000000000h
_IOLBF		EQU		000000040h
_IONBF		EQU		000000004h
_IOMYBUF		EQU		000000008h
_IOEOF		EQU		000000010h
_IOERR		EQU		000000020h
_IOSTRG		EQU		000000040h
_IORW		EQU		000000080h
;  function prototypes 
@proto_hcf0		TYPEDEF		PROTO C :PTR FILE
_filbuf		PROTO		@proto_hcf0

@proto_hcf1		TYPEDEF		PROTO C :SWORD, :PTR FILE
_flsbuf		PROTO		@proto_hcf1

@proto_hcf2		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :SWORD
_fsopen		PROTO		@proto_hcf2

@proto_hcf3		TYPEDEF		PROTO C :PTR FILE
clearerr		PROTO		@proto_hcf3

@proto_hcf4		TYPEDEF		PROTO C :PTR FILE
fclose		PROTO		@proto_hcf4

@proto_hcf5		TYPEDEF		PROTO C 
_fcloseall		PROTO		@proto_hcf5

@proto_hcf6		TYPEDEF		PROTO C :SWORD, :PTR SBYTE
_fdopen		PROTO		@proto_hcf6

@proto_hcf7		TYPEDEF		PROTO C :PTR FILE
feof		PROTO		@proto_hcf7

@proto_hcf8		TYPEDEF		PROTO C :PTR FILE
ferror		PROTO		@proto_hcf8

@proto_hcf9		TYPEDEF		PROTO C :PTR FILE
fflush		PROTO		@proto_hcf9

@proto_hcf10		TYPEDEF		PROTO C :PTR FILE
fgetc		PROTO		@proto_hcf10

@proto_hcf11		TYPEDEF		PROTO C 
_fgetchar		PROTO		@proto_hcf11

@proto_hcf12		TYPEDEF		PROTO C :PTR FILE, :PTR fpos_t
fgetpos		PROTO		@proto_hcf12

@proto_hcf13		TYPEDEF		PROTO C :PTR SBYTE, :SWORD, :PTR FILE
fgets		PROTO		@proto_hcf13

@proto_hcf14		TYPEDEF		PROTO C :PTR FILE
_fileno		PROTO		@proto_hcf14

@proto_hcf15		TYPEDEF		PROTO C 
_flushall		PROTO		@proto_hcf15

@proto_hcf16		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE
fopen		PROTO		@proto_hcf16

@proto_hcf17		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE, :VARARG
fprintf		PROTO		@proto_hcf17

@proto_hcf18		TYPEDEF		PROTO C :SWORD, :PTR FILE
fputc		PROTO		@proto_hcf18

@proto_hcf19		TYPEDEF		PROTO C :SWORD
_fputchar		PROTO		@proto_hcf19

@proto_hcf20		TYPEDEF		PROTO C :PTR SBYTE, :PTR FILE
fputs		PROTO		@proto_hcf20

@proto_hcf21		TYPEDEF		PROTO C :PTR , :size_t, :size_t, :PTR FILE
fread		PROTO		@proto_hcf21

@proto_hcf22		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :PTR FILE
freopen		PROTO		@proto_hcf22

@proto_hcf23		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE, :VARARG
fscanf		PROTO		@proto_hcf23

@proto_hcf24		TYPEDEF		PROTO C :PTR FILE, :PTR SDWORD
fsetpos		PROTO		@proto_hcf24

@proto_hcf25		TYPEDEF		PROTO C :PTR FILE, :SDWORD, :SWORD
fseek		PROTO		@proto_hcf25

@proto_hcf26		TYPEDEF		PROTO C :PTR FILE
ftell		PROTO		@proto_hcf26

@proto_hcf27		TYPEDEF		PROTO C :PTR , :size_t, :size_t, :PTR FILE
fwrite		PROTO		@proto_hcf27

@proto_hcf28		TYPEDEF		PROTO C :PTR FILE
getc		PROTO		@proto_hcf28

@proto_hcf29		TYPEDEF		PROTO C 
getchar		PROTO		@proto_hcf29

@proto_hcf30		TYPEDEF		PROTO C :PTR SBYTE
gets		PROTO		@proto_hcf30

@proto_hcf31		TYPEDEF		PROTO C :PTR FILE
_getw		PROTO		@proto_hcf31

@proto_hcf32		TYPEDEF		PROTO C :PTR SBYTE
perror		PROTO		@proto_hcf32

@proto_hcf33		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
printf		PROTO		@proto_hcf33

@proto_hcf34		TYPEDEF		PROTO C :SWORD, :PTR FILE
putc		PROTO		@proto_hcf34

@proto_hcf35		TYPEDEF		PROTO C :SWORD
putchar		PROTO		@proto_hcf35

@proto_hcf36		TYPEDEF		PROTO C :PTR SBYTE
puts		PROTO		@proto_hcf36

@proto_hcf37		TYPEDEF		PROTO C :SWORD, :PTR FILE
_putw		PROTO		@proto_hcf37

@proto_hcf38		TYPEDEF		PROTO C :PTR SBYTE
remove		PROTO		@proto_hcf38

@proto_hcf39		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE
rename		PROTO		@proto_hcf39

@proto_hcf40		TYPEDEF		PROTO C :PTR FILE
rewind		PROTO		@proto_hcf40

@proto_hcf41		TYPEDEF		PROTO C 
_rmtmp		PROTO		@proto_hcf41

@proto_hcf42		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
scanf		PROTO		@proto_hcf42

@proto_hcf43		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE
setbuf		PROTO		@proto_hcf43

@proto_hcf44		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE, :SWORD, :size_t
setvbuf		PROTO		@proto_hcf44

@proto_hcf45		TYPEDEF		PROTO C :PTR SBYTE, :size_t, :PTR SBYTE, :VARARG
_snprintf		PROTO		@proto_hcf45

@proto_hcf46		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :VARARG
sprintf		PROTO		@proto_hcf46

@proto_hcf47		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :VARARG
sscanf		PROTO		@proto_hcf47

@proto_hcf48		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE
_tempnam		PROTO		@proto_hcf48

@proto_hcf49		TYPEDEF		PROTO C 
tmpfile		PROTO		@proto_hcf49

@proto_hcf50		TYPEDEF		PROTO C :PTR SBYTE
tmpnam		PROTO		@proto_hcf50

@proto_hcf51		TYPEDEF		PROTO C :SWORD, :PTR FILE
ungetc		PROTO		@proto_hcf51

@proto_hcf52		TYPEDEF		PROTO C :PTR SBYTE
_unlink		PROTO		@proto_hcf52

@proto_hcf53		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE, :va_list
vfprintf		PROTO		@proto_hcf53

@proto_hcf54		TYPEDEF		PROTO C :PTR SBYTE, :va_list
vprintf		PROTO		@proto_hcf54

@proto_hcf55		TYPEDEF		PROTO C :PTR SBYTE, :size_t, :PTR SBYTE, :va_list
_vsnprintf		PROTO		@proto_hcf55

@proto_hcf56		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :va_list
vsprintf		PROTO		@proto_hcf56

;  macro definitions 
;  Non-ANSI names for compatibility 
SYS_OPEN		EQU		000000014h
@proto_hcf57		TYPEDEF		PROTO C 
fcloseall		PROTO		@proto_hcf57

@proto_hcf58		TYPEDEF		PROTO C :SWORD, :PTR SBYTE
fdopen		PROTO		@proto_hcf58

@proto_hcf59		TYPEDEF		PROTO C 
fgetchar		PROTO		@proto_hcf59

@proto_hcf60		TYPEDEF		PROTO C :PTR FILE
fileno		PROTO		@proto_hcf60

@proto_hcf61		TYPEDEF		PROTO C 
flushall		PROTO		@proto_hcf61

@proto_hcf62		TYPEDEF		PROTO C :SWORD
fputchar		PROTO		@proto_hcf62

@proto_hcf63		TYPEDEF		PROTO C :PTR FILE
getw		PROTO		@proto_hcf63

@proto_hcf64		TYPEDEF		PROTO C :SWORD, :PTR FILE
putw		PROTO		@proto_hcf64

@proto_hcf65		TYPEDEF		PROTO C 
rmtmp		PROTO		@proto_hcf65

@proto_hcf66		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE
tempnam		PROTO		@proto_hcf66

@proto_hcf67		TYPEDEF		PROTO C :PTR SBYTE
unlink		PROTO		@proto_hcf67

; End of file /MSVC/INCLUDE\stdio.h
; Begin of file /MSVC/INCLUDE\conio.h
; **
; *conio.h - console and port I/O declarations
; *
; *   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
; *
; *Purpose:
; *   This include file contains the function declarations for
; *   the MS C V2.03 compatible console and port I/O routines.
; *
; ***
;  function prototypes 
@proto_hcf68		TYPEDEF		PROTO C :PTR SBYTE
_cgets		PROTO		@proto_hcf68

@proto_hcf69		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
_cprintf		PROTO		@proto_hcf69

@proto_hcf70		TYPEDEF		PROTO C :PTR SBYTE
_cputs		PROTO		@proto_hcf70

@proto_hcf71		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
_cscanf		PROTO		@proto_hcf71

@proto_hcf72		TYPEDEF		PROTO C 
_getch		PROTO		@proto_hcf72

@proto_hcf73		TYPEDEF		PROTO C 
_getche		PROTO		@proto_hcf73

@proto_hcf74		TYPEDEF		PROTO C :WORD
_inp		PROTO		@proto_hcf74

@proto_hcf75		TYPEDEF		PROTO C :WORD
_inpw		PROTO		@proto_hcf75

@proto_hcf76		TYPEDEF		PROTO C 
_kbhit		PROTO		@proto_hcf76

@proto_hcf77		TYPEDEF		PROTO C :WORD, :SWORD
_outp		PROTO		@proto_hcf77

@proto_hcf78		TYPEDEF		PROTO C :WORD, :WORD
_outpw		PROTO		@proto_hcf78

@proto_hcf79		TYPEDEF		PROTO C :SWORD
_putch		PROTO		@proto_hcf79

@proto_hcf80		TYPEDEF		PROTO C :SWORD
_ungetch		PROTO		@proto_hcf80

;  Non-ANSI names for compatibility 
@proto_hcf81		TYPEDEF		PROTO C :PTR SBYTE
cgets		PROTO		@proto_hcf81

@proto_hcf82		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
cprintf		PROTO		@proto_hcf82

@proto_hcf83		TYPEDEF		PROTO C :PTR SBYTE
cputs		PROTO		@proto_hcf83

@proto_hcf84		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
cscanf		PROTO		@proto_hcf84

@proto_hcf85		TYPEDEF		PROTO C 
getch		PROTO		@proto_hcf85

@proto_hcf86		TYPEDEF		PROTO C 
getche		PROTO		@proto_hcf86

@proto_hcf87		TYPEDEF		PROTO C :WORD
inp		PROTO		@proto_hcf87

@proto_hcf88		TYPEDEF		PROTO C :WORD
inpw		PROTO		@proto_hcf88

@proto_hcf89		TYPEDEF		PROTO C 
kbhit		PROTO		@proto_hcf89

@proto_hcf90		TYPEDEF		PROTO C :WORD, :SWORD
outp		PROTO		@proto_hcf90

@proto_hcf91		TYPEDEF		PROTO C :WORD, :WORD
outpw		PROTO		@proto_hcf91

@proto_hcf92		TYPEDEF		PROTO C :SWORD
putch		PROTO		@proto_hcf92

@proto_hcf93		TYPEDEF		PROTO C :SWORD
ungetch		PROTO		@proto_hcf93

; End of file /MSVC/INCLUDE\conio.h
; #ifndef _DEBUG
; #endif // _DEBUG
;  C implementation which let the processor handle the word-at-byte-boundary problem
;  Asm or C implementation
;  H_2_INC 
;  WVLAN_43, WVLAN_42 (DOS ODI, Packet Driver) 
; **********************************************************************************************
; ***************************  D O S  H - II  L O A D E R  *************************************
; **********************************************************************************************
; **********************************************************************************************
; ***************************  N E T W A R E   3 8 6  ******************************************
; **********************************************************************************************
; **********************************************************************************************
; **********************************  M A C  O S   *********************************************
; **********************************************************************************************
; ********
; **********************************************************************************************
; **********************************  W I N C E ************************************************
; **********************************************************************************************
; *****************
;  WVLAN_46, WINCE 
; **********************************************************************************************
; *****************************************  L I N U X  ****************************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************  M I N I P O R T    N D I S  5.0 / 5.1 *************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************  M I N I P O R T    N D I S  4    ******************************
; **********************************************************************************************
; **********************************************************************************************
; ********************************************  Q N X  *****************************************
; **********************************************************************************************
; **********************************************************************************************
; ********************************************  B E O S  ***************************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************  M I N I P O R T  U S B   N D I S  5    ************************
; **********************************************************************************************
; **********************************************************************************************
; *******************************  U S B   D O N G L E  ****************************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************************  FreeBSD  ******************************************
; **********************************************************************************************
; **********************************************************************************************
; ********************************  W A V E P O I N T  *****************************************
; **********************************************************************************************
; **********************************************************************************************
; *******************************  W A V E L A U N C H  ****************************************
; **********************************************************************************************
; **********************************************************************************************
; ************************************  W C I T S T ********************************************
; **********************************************************************************************
; **********************************************************************************************
; ********************************* S C O   U N I X  *******************************************
; **********************************************************************************************
; **********************************************************************************************
; ******************************  Motorola Power PC 800 family  ********************************
; **********************************************************************************************
;  known users: LH@I
;  
; **********************************************************************************************
; *********************************   Diab or High C 29K   *************************************
; **********************************************************************************************
;  known users: GK@C
;  
; **********************************************************************************************
; ****************************************  MPC860 *********************************************
; **********************************************************************************************
;  known users: RR
;  
; ;? JohanB #if 0
; ;? JohanB #endif //0
; **********************************************************************************************
; ***************************  Microtec Research 80X86 Compiler ********************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************  W A V E L A N  E C  *******************************************
; **********************************************************************************************
;  known users: KM
;  
; *******
;  LC302 
;  Vinay.B : Added for NGAP : Jan 12th, 2000 
; **********************************************************************************************
; ********************************  NGAP   **************************************
; **********************************************************************************************
;   * * * * * * * * * * * * * * * * * * * * * *  IV  * * * * * * * * * * * * * * * * * * * * * * 
; **************************************Compiler specific ***************************************
; __cplusplus
; EXTERN_C
; **********************************************************************************************
; *********************** N D I S   S P E C I F I C   M A C R O S  *****************************
; **********************************************************************************************
; #define OUTPUTDEBUGMSG(dprintf_exp)					((void) (DbgPrint dprintf_exp))
;  the assertdebugmsg macro will print filename, line followed by a caller-defined text, when cond == 0
; #define ASSERTDEBUGMSG(cond, dprintf_exp)	((void)((cond) ? 0: (DbgPrint("%s:%d - ", __FILE__, __LINE__), DbgPrint dprintf_exp)))
; **********************************************************************************************
; ********* M A C R O S derived of C O M P I L E R   S P E C I F I C   M A C R O S  ************
; **********************************************************************************************
wci_bufp		TYPEDEF		FAR PTR hcf_8

;  segmented 16-bits or flat 32-bits pointer to 8 bits unit
wci_recordp		TYPEDEF		FAR PTR hcf_16

;  segmented 16-bits or flat 32-bits pointer to 16 bits unit
;   * * * * * * * * * * * * * * * * * * * * * *  V  * * * * * * * * * * * * * * * * * * * * * * 
; 	I/O Address size
;  *	Platforms which use port mapped I/O will (in general) have a 64k I/O space, conveniently expressed in
;  *	a 16-bits quantity
;  *	Platforms which use memory mapped I/O will (in general) have an I/O space much larger than 64k,
;  *	and need a 32-bits quantity to express the I/O base
;  *	To accommodate this the macro HCF_MEM_IO is available. If HCF_MEM_IO is not defined, the HCF uses an 
;  *	hcf_16 to express I/O base and store in the IFB. If HCF_MEM_IO is defined, an hcf_32 is used.
;  
hcf_io		TYPEDEF		hcf_16

; HCF_MEM_IO
;  MSF_COMPONENT_ID is used to define the CFG_IDENTITY_STRCT in HCF.C
;  * CFG_IDENTITY_STRCT is defined in HCF.C purely based on convenience arguments
;  * The HCF can not have the knowledge to determine the ComponentId field of the
;  * Identity record (aka as Version Record), therefore the MSF part of the Drivers
;  * must supply this value via the System Constant MSF_COMPONENT_ID
;  * There is a set of values predefined in MDD.H (format COMP_ID_.....)
;  *
;  * Note that taking MSF_COMPONENT_ID as a default value for DUI_COMPAT_VAR is
;  * purely an implementation convenience, the numerical values of these two
;  * quantities have none functional relationship whatsoever.
;  * Originally there was only a single DUI-variant with value 1. 
;  * Then it was considered advantageous to have unique DUI-variant per driver and 
;  * - as said before - out of convenience these variants where chosen to have 
;  * the same numerical value as the component id of the driver.
;  * Again later, it was decided that there would be two Miniport 3.1 drivers,
;  * the old one continuing to have DUI-variant and component ID 41, the new 
;  * one (the STAP or HomeLAN driver) having component ID 41 but DUI-variant 2 (since
;  * 1 was already used in the past)
;  
; !defined DUI_COMPAT_VAR
; ;?this way utilities can lower as well raise the bottom
DUI_COMPAT_BOT		EQU		8t
;  DUI_COMPAT_BOT
; ;?this way utilities can lower as well raise the top
DUI_COMPAT_TOP		EQU		8t
;  DUI_COMPAT_TOP
;  MSF_COMPONENT_ID
; PCCard
; MiniPCI
;  HCF_HSI_VAR_0/1/2/3
;  HCF_TYPE_HII
; HCF_PRI_VAR_1/2
; HCF_TYPE_HII
; HCF_APF_VAR_1
; HCF_TYPE_HII
; HCF_STA_VAR_1
; HCF_TYPE_HII
; **********************************************************************************************
; *****  M S F    S U P P O R T    F U N C T I O N S    P R O T O T Y P E S   ******************
; **********************************************************************************************
; ******************************************* A L I G N M E N T  **********************************************
; default to no alignment
HCF_ALIGN		EQU		1t
;  HCF_ALIGN
;  maximum accumulated size in hcf_16 of LTV records used in hcf_put_info
; 									 * use of this feature is not recomanded and may be abondaned in the future
; 									 
HCF_MAX_CONFIG		EQU		256t
;  WaveLAN Packet Size in bytes
HCF_MAX_MSG		EQU		1514t
;  ;? requires some thought, this copes with "default" DownLoadBufferLenght
HCF_MAX_LTV		EQU		000001001h
;  number of 10K microseconds protection timer against H/W malfunction
HCF_PROT_TIME		EQU		256t
; 	Endianess
;  *	Little Endian (a.k.a. Intel), least significant byte first
;  *	Big Endian (a.k.a. Motorola), most significant byte first
;  *
;  * The following macros are supplied
;  *  o CNV_LITTLE_TO_INT(w)			interprets the 16-bits input value as Little Endian, returns an hcf_16
;  * 	o CNV_BIG_TO_INT(w)				interprets the 16-bits input value as Big Endian, returns an hcf_16
;  *
;  * At a number of places in the HCF code, the CNV_INT_TO_BIG_NP macro is used. While it does have the desired
;  * effect on all platforms, it's naming is misleading, so revisit all places where these CNV macros are used
;  * to assure the right name is used at the right place.
;  *
;  
;  To increase portability, use unsigned char and unsigned char * when accessing parts of larger
;  * types to convert their Endianess
;  
; ****************************************** L I T T L E   E N D I A N ****************************************
;  endianess offset compenation
EOC		EQU		0t
;  no endianess conversion needed
;     endianess conversion needed
;  HCF_BIG_ENDIAN
;  conversion macros which can be expressed in other macros
; ***********************************************************************************************************
; ******************************************* . . . . . . . . .  ********************************************
; ***********************************************************************************************************
;  The BASED customization macro is used to resolves the SS!=DS conflict for the Interrupt Service
;  * logic in DOS Drivers. Due to the cumbersomeness of mixing C and assembler local BASED variables
;  * still end up in the wrong segment. The workaround is that the HCF uses only global BASED
;  * variables or IFB-based variables
;  * The "BASED" construction (supposedly) only amounts to something in the small memory model.
;  *
;  * Note that the whole BASED rigmarole is needlessly complicated because both the Microsoft Compiler and
;  * Linker are unnecessary restrictive in what far pointer manipulation they allow
;  
; /*conflicts with ULTSDEMO
; conflicts with ULTSDEMO*/
; ***********************************************************************************************************
; *********************************** M I G R A T I O N   A S P E C T S *************************************
; ***********************************************************************************************************
HCF_TALLIES		EQU		000000001h
;  HCF_TALLIES
HCF_ENCAPSULATION		EQU		1t
;  HCF_ENCAPSULATION
;  HCF_MB_OFF
;  _WIN32_WCE
;  HCF_INT_OFF
; #if !defined HCF_CARD_CHECK_OFF		/*obsolete under new WCI definition */
; #define	HCF_CARD_CHECK_ON
; #define	HCF_CARD_CHECK if ( ifbp->IFB_CardStat & CARD_STAT_PRESENT ) 
; #else
; #define HCF_CARD_CHECK
; #endif // HCF_CARD_CHECK_OFF
; ***********************************************************************************************************
; ********************** C O N F L I C T   D E T E C T I O N  &  R E S O L U T I O N ************************
; ***********************************************************************************************************
; HCFCFG_H
; End of file c:/HCF/hcfcfg.h
;  Include file common for HCF, MSF, UIL, USF
; Begin of file c:/HCF/mdd.h
;    vim:tw=110:ts=4:
CFG_PROG_STOP		EQU		000000000h
CFG_PROG_VOLATILE		EQU		000000100h
CFG_PROG_FLASH		EQU		000000300h
CFG_PROG_SEEPROM		EQU		000001300h
CFG_PROG_SEEPROM_READBACK		EQU		000000400h
MDD_H		EQU		1t
; ************************************************************************************************************
; *
; * FILE	  : mdd.h
; *
; * DATE    : $Date: 2003/05/30 11:34:03 $   $Revision: 1.1.1.1 $
; *
; * AUTHOR  : Nico Valster
; *
; * DESC   : Definitions and Prototypes for HCF, MSF, UIL as well as USF sources
; *
; ***************************************************************************************************************
; * COPYRIGHT (c) 1994 - 1995	by AT&T.	 			All Rights Reserved
; * COPYRIGHT (c) 1996 - 2000 by Lucent Technologies.	All Rights Reserved
; * COPYRIGHT (c) 2001 - 2003	by Agere Systems.		All Rights Reserved
; *************************************************************************************************************
; *************************************************************************************************************
; *
; * Implementation Notes
; *
;  -	Typ rather than type is used as field names in structures like CFG_CIS_STRCT because type leads to
;  	conflicts with MASM when the H-file is converted to an INC-file
; *
; ***************************************************************************************************************
; Instructions to convert MDD.H to MDD.INC by means of H2INC
; 
; Use a command line which defines the specific macros and command line options
; needed to build the C-part, e.g. for the DOS ODI driver
; 		`h2inc /C  /DH_2_INC /Ni /Zp /Zn mdd	 mdd.h`
; 
; 
; 
; *
; * ToDo
; *
; 
; *************************************************************************************************************
; *************************************************************************************************************
; *
; * The macros Xn(...) and XXn(...) are used to define the LTV's (short for Length Type Value[ ]) ,
; * aka RIDs, processed by the Hermes.
; * The n in Xn and XXn reflects the number of "Value" fields in these RIDs.
; *
; * Xn(...) : Macros used for RIDs which use only type hcf_16 for the "V" fields of the LTV.
; * Xn takes as parameters a RID name and "n" name(s), one for each of the "V" fields of the LTV.
; *
; * XXn(...) : Macros used for RIDs which use at least one other type then hcf_16 for a "V" field
; * of the LTV.
; * XXn(..) takes as parameters a RID name and "n" pair(s) of type and name, one for each "V" field
; * of the LTV
; 
;  ******************************************  e x a m p l e s  **************************************************
; 
; * X1(RID_NAME, parameters...) : expands to :
; *    typedef struct RID_NAME_STRCT {
; *         hcf_16  len;
; *         hcf_16  typ;
; *         hcf_16  par1;
; *    } RID_NAME_STRCT;
; 
; * X2(RID_NAME, parameters...) : expands to :
; *    typedef struct RID_NAME_STRCT {
; *         hcf_16  len;
; *         hcf_16  typ;
; *         hcf_16  par1;
; *         hcf_16  par2;
; *    } RID_NAME_STRCT;
; 
; 
; * XX1(RID_NAME, par1type, par1name, ...) : expands to :
; *    typedef struct RID_NAME_STRCT {
; *       hcf_16    len;
; *       hcf_16    typ;
; *       par1type  par1name;
; *    } RID_NAME_STRCT;
; 
; **************************************************************************************************************
; ****************************** General define **************************************************************
MAC_ADDR_SIZE		EQU		6t
GROUP_ADDR_SIZE		EQU		0000000c0h
; channelset structure used in the CFG_CNF_COUNTRY LTV
CHANNEL_SET		STRUCT 1t
first_channel		hcf_16		?
number_of_channels		hcf_16		?
max_tx_output_level		hcf_16		?
CHANNEL_SET		ENDS

;  key structure used in the CFG_DEFAULT_KEYS LTV
; length of key
; encryption key
KEY_STRCT		STRUCT 1t
len		hcf_16		?
key		hcf_8		14t DUP (?)
KEY_STRCT		ENDS

;  Scan Result structure used in the CFG_SCAN LTV
SCAN_RS_STRCT		STRUCT 1t
channel_id		hcf_16		?
noise_level		hcf_16		?
signal_level		hcf_16		?
bssid		hcf_8		6t DUP (?)
beacon_interval_time		hcf_16		?
capability		hcf_16		?
ssid_len		hcf_16		?
ssid_val		hcf_8		32t DUP (?)
SCAN_RS_STRCT		ENDS

;  range specification structure used in CFG_RANGES, CFG_RANGE1 etc
CFG_RANGE_SPEC_STRCT		STRUCT 1t
number		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_RANGE_SPEC_STRCT		ENDS

;  byte oriented range specification structure used in CFG_RANGE_B LTV
CFG_RANGE_SPEC_BYTE_STRCT		STRUCT 1t
number		hcf_8		2t DUP (?)
bottom		hcf_8		2t DUP (?)
top		hcf_8		2t DUP (?)
CFG_RANGE_SPEC_BYTE_STRCT		ENDS

; used to set up "T" functionality for Info frames, i.e. log info frames in MSF supplied buffer and MailBox
; hcf16
@t_hcf2		TYPEDEF		FAR PTR WORD
RID_LOG_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
bufp		@t_hcf2		?
RID_LOG_STRCT		ENDS

RID_LOGP		TYPEDEF		FAR PTR RID_LOG_STRCT

CFG_RID_LOG_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
recordp		RID_LOGP		?
CFG_RID_LOG_STRCT		ENDS

;  CFG_DLNV_START (0x0850) Setup for Download to non-volatile RAM
;  CFG_DLV_START (0x0852) Setup for Download to volatile RAM			*/
; low_addr: Low order part of 32-bits non-volatile NIC RAM address
; high_addr: High order part of 32-bits non-volatile NIC RAM address
CFG_DL_START_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
low_addr		hcf_16		?
high_addr		hcf_16		?
CFG_DL_START_STRCT		ENDS

; CFG_REG_ASSERT_RTNP (0x0832)	(de-)register MSF Callback routines
; lvl: Assert level filtering (not yet implemented)
; rtnp: address of MSF_ASSERT_RTN (native Endian format)
@proto_hcf94		TYPEDEF		PROTO C :FAR PTR hcf_8, :WORD, :hcf_16, :SWORD
MSF_ASSERT_RTN		TYPEDEF		@proto_hcf94

@proto_hcf95		TYPEDEF		PROTO FAR C :FAR PTR hcf_8, :WORD, :hcf_16, :SWORD
MSF_ASSERT_RTNP		TYPEDEF		FAR PTR @proto_hcf95

CFG_REG_ASSERT_RTNP_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
lvl		hcf_16		?
rtnp		MSF_ASSERT_RTNP		?
CFG_REG_ASSERT_RTNP_STRCT		ENDS

;  CFG_CMD_NIC (0x0860)		Hermes Engineering command
; default length of RID
; RID identification as defined by Hermes
; Command code (0x003F) and control bits (0xFFC0)
; parameters for Hermes Param0 register
; parameters for Hermes Param1 register
; parameters for Hermes Param2 register
; result code from Hermes Status register
; responses from Hermes Resp0 register
; responses from Hermes Resp1 register
; responses from Hermes Resp2 register
; result code from cmd_exe routine
; IFB_ErrCmd
; IFB_ErrQualifier
CFG_CMD_NIC_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
cmd		hcf_16		?
parm0		hcf_16		?
parm1		hcf_16		?
parm2		hcf_16		?
stat		hcf_16		?
resp0		hcf_16		?
resp1		hcf_16		?
resp2		hcf_16		?
hcf_stat		hcf_16		?
ifb_err_cmd		hcf_16		?
ifb_err_qualifier		hcf_16		?
CFG_CMD_NIC_STRCT		ENDS

LTV_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
val		hcf_16		1t DUP (?)
LTV_STRCT		ENDS

; minimum LTV proto typ	
LTV_MAX_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
val		hcf_16		4097t DUP (?)
LTV_MAX_STRCT		ENDS

; maximum LTV proto typ	
@t_hcf3		TYPEDEF		FAR PTR 
;  Pointer to IFB
; 						 *	returned from MSF to USF by uil_connect
; 				 		 *	passed from USF to MSF as a "magic cookie" by all other UIL function calls
; 				 		 
;  status returned from MSF to USF
;  command code from USF to MSF
;  LTV structure
; 			 			 *** during uil_put_info:
; 			 			 *	  the L, T and V-fields carry information from USF to MSF
; 			 			 *** during uil_get_info:
; 						 *	  the L and T fields carry information from USF to MSF
; 						 *	  the L and V-fields carry information from MSF to USF
; 			 			 
DUI_STRCT		STRUCT 1t
ifbp		@t_hcf3		?
stat		hcf_16		?
fun		hcf_16		?
ltv		LTV_STRCT		<>
DUI_STRCT		ENDS

DUIP		TYPEDEF		FAR PTR DUI_STRCT

CFG_MB_ASSERT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
trace		hcf_16		?
qualifier		hcf_16		?
line		hcf_16		?
file_name		hcf_8		10t DUP (?)
CFG_MB_ASSERT_STRCT		ENDS

; MBInfoBlock for asserts
CFG_HCF_OPT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
val		hcf_16		20t DUP (?)
CFG_HCF_OPT_STRCT		ENDS

; HCF (Compile time) option	
CFG_CMD_HCF_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
cmd		hcf_16		?
mode		hcf_16		?
add_info		hcf_16		?
CFG_CMD_HCF_STRCT		ENDS

; Program LTV	
CFG_PROG_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mode		hcf_16		?
low_addr		hcf_16		?
high_addr		hcf_16		?
dl_data		hcf_16		1t DUP (?)
CFG_PROG_STRCT		ENDS

; Program LTV	
CFG_RANGES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		1t DUP (<>)
CFG_RANGES_STRCT		ENDS

; Actor/Supplier range (1 variant)
CFG_RANGE1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		1t DUP (<>)
CFG_RANGE1_STRCT		ENDS

; Actor/Supplier range (1 variant)
CFG_RANGE2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		2t DUP (<>)
CFG_RANGE2_STRCT		ENDS

; Actor range ( 2 variants)		
CFG_RANGE3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		3t DUP (<>)
CFG_RANGE3_STRCT		ENDS

; Actor range ( 3 variants)		
CFG_RANGE4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		4t DUP (<>)
CFG_RANGE4_STRCT		ENDS

; Actor range ( 4 variants)		
CFG_RANGE5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		5t DUP (<>)
CFG_RANGE5_STRCT		ENDS

; Actor range ( 5 variants)		
CFG_RANGE6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		6t DUP (<>)
CFG_RANGE6_STRCT		ENDS

; Actor range ( 6 variants)		
CFG_RANGE7_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		7t DUP (<>)
CFG_RANGE7_STRCT		ENDS

; Actor range ( 7 variants)		
CFG_RANGE20_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		20t DUP (<>)
CFG_RANGE20_STRCT		ENDS

; Actor range (20 variants)		
CFG_RANGE_B_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_BYTE_STRCT		20t DUP (<>)
CFG_RANGE_B_STRCT		ENDS

;  UNCLEAR !!!!	
; Static Configurations 
CFG_CNF_PORT_TYPE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
port_type		hcf_16		?
CFG_CNF_PORT_TYPE_STRCT		ENDS

; [STA] Connection control characteristics
CFG_MAC_ADDR_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_MAC_ADDR_STRCT		ENDS

; general: 0xFC01, FC08, FC11, FC12, FC13, FC14, FC15, FC16 
CFG_CNF_OWN_MAC_ADDR_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_OWN_MAC_ADDR_STRCT		ENDS

CFG_ID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_ID_STRCT		ENDS

; 0xFC02, 0xFC04, 0xFC0E 
; 	X1( CFG_DESIRED_SSID,			ssid[17]			 )	see Dynamic Configurations 
CFG_CNF_OWN_CHANNEL_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
channel		hcf_16		?
CFG_CNF_OWN_CHANNEL_STRCT		ENDS

; Communication channel for BSS creation
CFG_CNF_OWN_SSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_CNF_OWN_SSID_STRCT		ENDS

CFG_CNF_OWN_ATIM_WINDOW_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
atim_window		hcf_16		?
CFG_CNF_OWN_ATIM_WINDOW_STRCT		ENDS

CFG_CNF_SYSTEM_SCALE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
system_scale		hcf_16		?
CFG_CNF_SYSTEM_SCALE_STRCT		ENDS

CFG_CNF_MAX_DATA_LEN_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
max_data_len		hcf_16		?
CFG_CNF_MAX_DATA_LEN_STRCT		ENDS

CFG_CNF_WDS_ADDR_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR_STRCT		ENDS

; [STA] MAC Address of corresponding WDS Link node
CFG_CNF_PM_ENABLED_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
pm_enabled		hcf_16		?
CFG_CNF_PM_ENABLED_STRCT		ENDS

; [STA] Switch for ESS Power Management (PM) On/Off
CFG_CNF_PM_EPS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
pm_eps		hcf_16		?
CFG_CNF_PM_EPS_STRCT		ENDS

; [STA] Switch for ESS PM EPS/PS Mode
CFG_CNF_MCAST_RX_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mcast_rx		hcf_16		?
CFG_CNF_MCAST_RX_STRCT		ENDS

; [STA] Switch for ESS PM Multicast reception On/Off
CFG_CNF_MAX_SLEEP_DURATION_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
duration		hcf_16		?
CFG_CNF_MAX_SLEEP_DURATION_STRCT		ENDS

; [STA] Maximum sleep time for ESS PM
CFG_CNF_PM_HOLDOVER_DURATION_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
duration		hcf_16		?
CFG_CNF_PM_HOLDOVER_DURATION_STRCT		ENDS

; [STA] Holdover time for ESS PM
CFG_CNF_OWN_NAME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_CNF_OWN_NAME_STRCT		ENDS

; Identification text for diagnostic purposes
CFG_CNF_OWN_DTIM_PERIOD_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
period		hcf_16		?
CFG_CNF_OWN_DTIM_PERIOD_STRCT		ENDS

; [AP] Beacon intervals between successive DTIMs
CFG_CNF_WDS_ADDR1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR1_STRCT		ENDS

; [AP] Port 1 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR2_STRCT		ENDS

; [AP] Port 2 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR3_STRCT		ENDS

; [AP] Port 3 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR4_STRCT		ENDS

; [AP] Port 4 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR5_STRCT		ENDS

; [AP] Port 5 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR6_STRCT		ENDS

; [AP] Port 6 MAC Adrs of corresponding WDS Link node
CFG_CNF_MCAST_PM_BUF_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mcast_pm_buf		hcf_16		?
CFG_CNF_MCAST_PM_BUF_STRCT		ENDS

; [AP] Switch for PM buffereing of Multicast Messages
CFG_CNF_REJECT_ANY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
reject_any		hcf_16		?
CFG_CNF_REJECT_ANY_STRCT		ENDS

; [AP] Switch for PM buffereing of Multicast Messages
CFG_CNF_ENCRYPTION_ENABLED_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
encryption		hcf_16		?
CFG_CNF_ENCRYPTION_ENABLED_STRCT		ENDS

; specify encryption type of Tx/Rx messages
CFG_CNF_AUTHENTICATION_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
authentication		hcf_16		?
CFG_CNF_AUTHENTICATION_STRCT		ENDS

; selects Authentication algorithm
CFG_CNF_EXCL_UNENCRYPTED_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
exclude_unencrypted		hcf_16		?
CFG_CNF_EXCL_UNENCRYPTED_STRCT		ENDS

; [AP] Switch for 'clear-text' rx message acceptance
CFG_CNF_MCAST_RATE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mcast_rate		hcf_16		?
CFG_CNF_MCAST_RATE_STRCT		ENDS

; Transmit Data rate for Multicast frames
CFG_CNF_INTRA_BSS_RELAY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
intra_bss_relay		hcf_16		?
CFG_CNF_INTRA_BSS_RELAY_STRCT		ENDS

; [AP] Switch for IntraBBS relay
CFG_CNF_MICRO_WAVE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
micro_wave		hcf_16		?
CFG_CNF_MICRO_WAVE_STRCT		ENDS

; MicroWave (Robustness)
CFG_CNF_LOAD_BALANCING_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
load_balancing		hcf_16		?
CFG_CNF_LOAD_BALANCING_STRCT		ENDS

; Load Balancing	  (Boolean, 0=OFF, 1=ON, default=1)
CFG_CNF_MEDIUM_DISTRIBUTION_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
medium_distribution		hcf_16		?
CFG_CNF_MEDIUM_DISTRIBUTION_STRCT		ENDS

; Medium Distribution (Boolean, 0=OFF, 1=ON, default=1)
CFG_CNF_GROUP_ADDRESS_FILTER_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
group_addr_filter		hcf_16		?
CFG_CNF_GROUP_ADDRESS_FILTER_STRCT		ENDS

; Group Address Filter								   
CFG_CNF_COUNTRY_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
n_channel_sets		hcf_16		?
country_code		hcf_16		2t DUP (?)
environment		hcf_16		?
channel_set		CHANNEL_SET		1t DUP (<>)
CFG_CNF_COUNTRY_INFO_STRCT		ENDS

; Current Country Info  
CFG_CNF_COUNTRY_INFO_MAX_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
n_channel_sets		hcf_16		?
country_code		hcf_16		2t DUP (?)
environment		hcf_16		?
channel_set		CHANNEL_SET		14t DUP (<>)
CFG_CNF_COUNTRY_INFO_MAX_STRCT		ENDS

; Current Country Info  
; Dynamic Configurations 
CFG_DESIRED_SSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_DESIRED_SSID_STRCT		ENDS

; [STA] Service Set identification for connection
CFG_GROUP_ADDR_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		96t DUP (?)
CFG_GROUP_ADDR_STRCT		ENDS

; [STA] Multicast MAC Addresses for Rx-message
CFG_CREATE_IBSS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
create_ibss		hcf_16		?
CFG_CREATE_IBSS_STRCT		ENDS

; [STA] Switch for IBSS creation On/Off
CFG_RTS_THRH_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH_STRCT		ENDS

; [STA] Frame length used for RTS/CTS handshake
CFG_TX_RATE_CNTL_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tx_rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL_STRCT		ENDS

; [STA] Data rate control for message transmission
CFG_PROMISCUOUS_MODE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
promiscuous_mode		hcf_16		?
CFG_PROMISCUOUS_MODE_STRCT		ENDS

; [STA] Switch for Promiscuous mode reception On/Off
CFG_WAKE_ON_LAN_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
wake_on_lan		hcf_16		?
CFG_WAKE_ON_LAN_STRCT		ENDS

; [STA] Switch for Wake-On-LAN mode
CFG_RTS_THRH0_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH0_STRCT		ENDS

; [AP] Port 0 frame length for RTS/CTS handshake
CFG_RTS_THRH1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH1_STRCT		ENDS

; [AP] Port 1 frame length for RTS/CTS handshake
CFG_RTS_THRH2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH2_STRCT		ENDS

; [AP] Port 2 frame length for RTS/CTS handshake
CFG_RTS_THRH3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH3_STRCT		ENDS

; [AP] Port 3 frame length for RTS/CTS handshake
CFG_RTS_THRH4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH4_STRCT		ENDS

; [AP] Port 4 frame length for RTS/CTS handshake
CFG_RTS_THRH5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH5_STRCT		ENDS

; [AP] Port 5 frame length for RTS/CTS handshake
CFG_RTS_THRH6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH6_STRCT		ENDS

; [AP] Port 6 frame length for RTS/CTS handshake
CFG_TX_RATE_CNTL0_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL0_STRCT		ENDS

; [AP] Port 0 data rate control for transmission
CFG_TX_RATE_CNTL1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL1_STRCT		ENDS

; [AP] Port 1 data rate control for transmission
CFG_TX_RATE_CNTL2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL2_STRCT		ENDS

; [AP] Port 2 data rate control for transmission
CFG_TX_RATE_CNTL3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL3_STRCT		ENDS

; [AP] Port 3 data rate control for transmission
CFG_TX_RATE_CNTL4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL4_STRCT		ENDS

; [AP] Port 4 data rate control for transmission
CFG_TX_RATE_CNTL5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL5_STRCT		ENDS

; [AP] Port 5 data rate control for transmission
CFG_TX_RATE_CNTL6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL6_STRCT		ENDS

; [AP] Port 6 data rate control for transmission
CFG_DEFAULT_KEYS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
key		KEY_STRCT		4t DUP (<>)
CFG_DEFAULT_KEYS_STRCT		ENDS

; defines set of encryption keys
CFG_TX_KEY_ID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tx_key_id		hcf_16		?
CFG_TX_KEY_ID_STRCT		ENDS

; select key for encryption of Tx messages
CFG_SCAN_SSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_SCAN_SSID_STRCT		ENDS

;                   identification for connection
CFG_ADD_TKIP_DEFAULT_KEY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tkip_key_id_info		hcf_16		?
tkip_key_iv_info		hcf_16		4t DUP (?)
tkip_key		hcf_16		8t DUP (?)
tx_mic_key		hcf_16		4t DUP (?)
rx_mic_key		hcf_16		4t DUP (?)
CFG_ADD_TKIP_DEFAULT_KEY_STRCT		ENDS

;        
CFG_SET_SSN_AUTHENTICATION_SUITE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssn_authentication_suite		hcf_16		?
CFG_SET_SSN_AUTHENTICATION_SUITE_STRCT		ENDS

;    
CFG_REMOVE_TKIP_DEFAULT_KEY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tkip_key_id		hcf_16		?
CFG_REMOVE_TKIP_DEFAULT_KEY_STRCT		ENDS

;    
CFG_TICK_TIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tick_time		hcf_16		?
CFG_TICK_TIME_STRCT		ENDS

; [PRI] Auxiliary Timer tick interval
; apparently not needed ;?XX4( CFG_CNF_COUNTRY,			hcf_16, num_sets, hcf_32, country_code, hcf_16, enviroment, CHANNEL_SET, channel_set[1] ) /*   */
;  NIC Information 
CFG_IDENTITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
comp_id		hcf_16		?
variant		hcf_16		?
version_major		hcf_16		?
version_minor		hcf_16		?
CFG_IDENTITY_STRCT		ENDS

; identification Prototype
CFG_RID_INF_MIN_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
y		hcf_16		?
CFG_RID_INF_MIN_STRCT		ENDS

; lowest value representing an Information RID
CFG_MAX_LOAD_TIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
max_load_time		hcf_16		?
CFG_MAX_LOAD_TIME_STRCT		ENDS

; [PRI] Max response time of the Download command
CFG_DL_BUF_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
buf_page		hcf_16		?
buf_offset		hcf_16		?
buf_len		hcf_16		?
CFG_DL_BUF_STRCT		ENDS

; [PRI] Download buffer location and size
CFG_PRI_IDENTITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
comp_id		hcf_16		?
variant		hcf_16		?
version_major		hcf_16		?
version_minor		hcf_16		?
CFG_PRI_IDENTITY_STRCT		ENDS

; [PRI] Primary F/W identification
CFG_PRI_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_PRI_SUP_RANGE_STRCT		ENDS

; [PRI] Primary Supplier compatibility range
CFG_CFI_ACT_RANGES_PRI_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_CFI_ACT_RANGES_PRI_STRCT		ENDS

; [PRI] Controller Actor compatibility ranges
CFG_NIC_HSI_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_NIC_HSI_SUP_RANGE_STRCT		ENDS

; H/W - S/W I/F supplier range
CFG_NIC_SERIAL_NUMBER_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
serial_number		hcf_16		17t DUP (?)
CFG_NIC_SERIAL_NUMBER_STRCT		ENDS

; [PRI] Network I/F Card serial number
CFG_NIC_IDENTITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
comp_id		hcf_16		?
variant		hcf_16		?
version_major		hcf_16		?
version_minor		hcf_16		?
CFG_NIC_IDENTITY_STRCT		ENDS

; [PRI] Network I/F Card identification
CFG_NIC_MFI_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_NIC_MFI_SUP_RANGE_STRCT		ENDS

; [PRI] Modem I/F Supplier compatibility range
CFG_NIC_CFI_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_NIC_CFI_SUP_RANGE_STRCT		ENDS

; [PRI] Controller I/F Supplier compatibility range
CFG_CHANNEL_LIST_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
channel_list		hcf_16		?
CFG_CHANNEL_LIST_STRCT		ENDS

; Allowed communication channels
CFG_REG_DOMAINS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
num_domain		hcf_16		?
reg_domains		hcf_8		10t DUP (?)
CFG_REG_DOMAINS_STRCT		ENDS

; List of intended regulatory domains
CFG_NIC_TEMP_TYPE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
temp_type		hcf_16		?
CFG_NIC_TEMP_TYPE_STRCT		ENDS

; Hardware temperature range code
CFG_CIS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
cis		hcf_16		240t DUP (?)
CFG_CIS_STRCT		ENDS

; PC Card Standard Card Information Structure
CFG_NIC_PROFILE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
profile_code		hcf_16		?
capability_options		hcf_16		?
allowed_data_rates		hcf_16		?
val4		hcf_16		?
val5		hcf_16		?
CFG_NIC_PROFILE_STRCT		ENDS

; Card Profile
CFG_FW_IDENTITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
comp_id		hcf_16		?
variant		hcf_16		?
version_major		hcf_16		?
version_minor		hcf_16		?
CFG_FW_IDENTITY_STRCT		ENDS

; [STA] Station F/W identification
CFG_FW_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_FW_SUP_RANGE_STRCT		ENDS

; [STA] Station I/F Supplier compatibility range
CFG_MFI_ACT_RANGES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_MFI_ACT_RANGES_STRCT		ENDS

; [STA] Modem I/F Actor compatibility ranges
CFG_CFI_ACT_RANGES_STA_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_CFI_ACT_RANGES_STA_STRCT		ENDS

; [STA] Controller I/F Actor compatibility ranges
CFG_NIC_BUS_TYPE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
nic_bus_type		hcf_16		?
CFG_NIC_BUS_TYPE_STRCT		ENDS

; NIC bustype derived from BUSSEL host I/F signals 
; 	MAC INFORMATION	
CFG_PORT_STAT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
port_stat		hcf_16		?
CFG_PORT_STAT_STRCT		ENDS

; [STA] Actual MAC Port connection control status
CFG_CURRENT_SSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_CURRENT_SSID_STRCT		ENDS

; [STA] Identification of the actually connected SS
CFG_CURRENT_BSSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CURRENT_BSSID_STRCT		ENDS

; [STA] Identification of the actually connected BSS
CFG_COMMS_QUALITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
coms_qual		hcf_16		?
signal_lvl		hcf_16		?
noise_lvl		hcf_16		?
CFG_COMMS_QUALITY_STRCT		ENDS

; [STA] Quality of the Basic Service Set connection
CFG_CURRENT_TX_RATE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE_STRCT		ENDS

; [STA] Actual transmit data rate
CFG_CUR_BEACON_INTERVAL_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
interval		hcf_16		?
CFG_CUR_BEACON_INTERVAL_STRCT		ENDS

; Beacon transmit interval time for BSS creation
CFG_CUR_SCALE_THRH_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
energy_detect_thrh		hcf_16		?
carrier_detect_thrh		hcf_16		?
defer_thrh		hcf_16		?
cell_search_thrh		hcf_16		?
out_of_range_thrh		hcf_16		?
delta_snr		hcf_16		?
CFG_CUR_SCALE_THRH_STRCT		ENDS

; Actual System Scale thresholds settings
CFG_PROTOCOL_RSP_TIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
time		hcf_16		?
CFG_PROTOCOL_RSP_TIME_STRCT		ENDS

; Max time to await a response to a request message
CFG_CUR_SHORT_RETRY_LIMIT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
limit		hcf_16		?
CFG_CUR_SHORT_RETRY_LIMIT_STRCT		ENDS

; Max number of transmit attempts for short frames
CFG_CUR_LONG_RETRY_LIMIT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
limit		hcf_16		?
CFG_CUR_LONG_RETRY_LIMIT_STRCT		ENDS

; Max number of transmit attempts for long frames
CFG_MAX_TX_LIFETIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
time		hcf_16		?
CFG_MAX_TX_LIFETIME_STRCT		ENDS

; Max transmit frame handling duration
CFG_MAX_RX_LIFETIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
time		hcf_16		?
CFG_MAX_RX_LIFETIME_STRCT		ENDS

; Max received frame handling duration
CFG_CF_POLLABLE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
cf_pollable		hcf_16		?
CFG_CF_POLLABLE_STRCT		ENDS

; [STA] Contention Free pollable capability indication
CFG_AUTHENTICATION_ALGORITHMS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
authentication_type		hcf_16		?
type_enabled		hcf_16		?
CFG_AUTHENTICATION_ALGORITHMS_STRCT		ENDS

; Authentication Algorithm
CFG_PRIVACY_OPT_IMPLEMENTED_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
privacy_opt_implemented		hcf_16		?
CFG_PRIVACY_OPT_IMPLEMENTED_STRCT		ENDS

; WEP Option availability indication
CFG_CURRENT_REMOTE_RATES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rates		hcf_16		?
CFG_CURRENT_REMOTE_RATES_STRCT		ENDS

; CurrentRemoteRates
CFG_CURRENT_USED_RATES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rates		hcf_16		?
CFG_CURRENT_USED_RATES_STRCT		ENDS

; CurrentUsedRates
CFG_CURRENT_SYSTEM_SCALE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
current_system_scale		hcf_16		?
CFG_CURRENT_SYSTEM_SCALE_STRCT		ENDS

; CurrentUsedRates
CFG_CURRENT_TX_RATE1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE1_STRCT		ENDS

; [AP] Actual Port 1 transmit data rate
CFG_CURRENT_TX_RATE2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE2_STRCT		ENDS

; [AP] Actual Port 2 transmit data rate
CFG_CURRENT_TX_RATE3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE3_STRCT		ENDS

; [AP] Actual Port 3 transmit data rate
CFG_CURRENT_TX_RATE4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE4_STRCT		ENDS

; [AP] Actual Port 4 transmit data rate
CFG_CURRENT_TX_RATE5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE5_STRCT		ENDS

; [AP] Actual Port 5 transmit data rate
CFG_CURRENT_TX_RATE6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE6_STRCT		ENDS

; [AP] Actual Port 6 transmit data rate
CFG_OWN_MACADDRESS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_OWN_MACADDRESS_STRCT		ENDS

; [AP] Unique local node MAC Address
CFG_PCF_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
medium_occupancy_limit		hcf_16		?
cfp_period		hcf_16		?
cfp_max_duration		hcf_16		?
CFG_PCF_INFO_STRCT		ENDS

; [AP] Point Coordination Function capability info
; #@ ;? define CFG_CURRENT_COUNTRY_INFO		0xFD88		//
CFG_CURRENT_SSN_INFO_ELEMENT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssn_info_element		hcf_16		1t DUP (?)
CFG_CURRENT_SSN_INFO_ELEMENT_STRCT		ENDS

;     
CFG_CURRENT_TKIP_IV_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tkip_seq_cnt0		hcf_16		4t DUP (?)
tkip_seq_cnt1		hcf_16		4t DUP (?)
tkip_seq_cnt2		hcf_16		4t DUP (?)
tkip_seq_cnt3		hcf_16		4t DUP (?)
CFG_CURRENT_TKIP_IV_INFO_STRCT		ENDS

;     
CFG_CURRENT_ASSOC_REQ_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
frame_type		hcf_16		?
frame_body		hcf_16		1t DUP (?)
CFG_CURRENT_ASSOC_REQ_INFO_STRCT		ENDS

; 	0xFD8C	
CFG_CURRENT_ASSOC_RESP_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
frame_type		hcf_16		?
frame_body		hcf_16		1t DUP (?)
CFG_CURRENT_ASSOC_RESP_INFO_STRCT		ENDS

; 	0xFD8D	
; 	Modem INFORMATION	
CFG_PHY_TYPE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
phy_type		hcf_16		?
CFG_PHY_TYPE_STRCT		ENDS

; 	Physical layer type indication
CFG_CURRENT_CHANNEL_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
current_channel		hcf_16		?
CFG_CURRENT_CHANNEL_STRCT		ENDS

; Actual frequency channel used for transmission
CFG_CURRENT_POWER_STATE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
current_power_state		hcf_16		?
CFG_CURRENT_POWER_STATE_STRCT		ENDS

; Actual power consumption status
CFG_CCAMODE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
cca_mode		hcf_16		?
CFG_CCAMODE_STRCT		ENDS

; Clear channel assessment mode indication
CFG_SUPPORTED_DATA_RATES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rates		hcf_16		5t DUP (?)
CFG_SUPPORTED_DATA_RATES_STRCT		ENDS

; Data rates capability information
;  FRAMES 
CFG_SCAN_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
scan_result		SCAN_RS_STRCT		32t DUP (<>)
CFG_SCAN_STRCT		ENDS

; Scan results
; -------------------------------------------------------------------------------------- 
;  UIL management function to be passed to WaveLAN/IEEE Drivers in DUI_STRCT field fun
; --------------------------------------------------------------------------------------
UIL_FUN_CONNECT		EQU		0t
;  Perform connect command
UIL_FUN_DISCONNECT		EQU		1t
;  Perform disconnect command
UIL_FUN_ACTION		EQU		2t
;  Perform UIL Action command.
UIL_FUN_SEND_DIAG_MSG		EQU		3t
;  Send a diagnostic message.
UIL_FUN_GET_INFO		EQU		4t
;  Retrieve information from NIC.
;  Put information on NIC.
UIL_FUN_PUT_INFO		EQU		5t

uil_fun		TYPEDEF		SWORD

; 	UIL_ACT_TALLIES		 0x05		 * this should not be exported to the USF
; 									 * it is solely intended as a strategic choice for the MSF to either
; 									 * - use HCF_ACT_TALLIES and direct IFB access
; 									 * - use CFG_TALLIES
; 									 
UIL_ACT_SCAN		EQU		000000006h
;  only supported by AP F/W
UIL_ACT_ACS_SCAN		EQU		000000007h
UIL_ACT_BLOCK		EQU		00000000bh
UIL_ACT_UNBLOCK		EQU		00000000ch
UIL_ACT_RESET		EQU		000000080h
UIL_ACT_REBIND		EQU		000000081h
UIL_ACT_APPLY		EQU		000000082h
;  Note that UIL_ACT-codes must match HCF_ACT-codes accross a run-time bound I/F
;  * The initial matching is achieved by "#define HCF_ACT_xxx HCF_UIL_ACT_xxx" where appropriate  
;  * In other words, these codes should never, ever change to minimize migration problems between
;  * combinations of old drivers and new utilities nad vice versa
;  
;  ! UIL_ACT_TALLIES does not exist ! Hermes Inquire Tallies (F100) cmnd
HCF_ACT_TALLIES		EQU		000000005h
;  06 Hermes Inquire Scan (F101) command
HCF_ACT_SCAN		EQU		000000006h
;  07 Hermes ACS Scan (F102) command
HCF_ACT_ACS_SCAN		EQU		000000007h
;  USB look-a-like for hcf_initialize(xxxx) on the Dongle side
HCF_ACT_INI		EQU		00000000ah
; 0B USB look-a-like for HCF_ACT_BLOCK on the Dongle side
HCF_ACT_DISABLE		EQU		00000000bh
; 0C USB look-a-like for HCF_ACT_UNBLOCK on the Dongle side
HCF_ACT_ENABLE		EQU		00000000ch
; 0D Disable Interrupt generation
HCF_ACT_INT_OFF		EQU		00000000dh
; 0E Enable Interrupt generation
HCF_ACT_INT_ON		EQU		00000000eh
; 0F Enforce Enable Interrupt generation
HCF_ACT_INT_FORCE_ON		EQU		00000000fh
; 10 HCF_CARD_CHECK_ON : MSF reported Card insertion
; 										 *   HCF_CARD_CHECK_OFF: Card initialization				
HCF_ACT_CARD_IN		EQU		000000010h
; 11 HCF_CARD_CHECK_ON : MSF reported Card removal
; 										 *   HCF_CARD_CHECK_OFF: place holder						
HCF_ACT_CARD_OUT		EQU		000000011h
; 17 Receiever ACK (optimization)
HCF_ACT_RX_ACK		EQU		000000015h
; 18 disables polling mechanism for USB if allowed
HCF_ACT_USB_POLLING_OFF		EQU		000000018h
; 19 enables polling mechanism for USB 
HCF_ACT_USB_POLLING_ON		EQU		000000019h
; 	HCF_ACT_MAX							// xxxx: start value for UIL-range, NOT to be passed to HCF
;  *										Too bad, there was originally no spare room created to use
;  *										HCF_ACT_MAX as an equivalent of HCF_ERR_MAX. Since creating
;  *										this room in retrospect would create a backward incompatibilty
;  *										we will just have to live with the haphazard sequence of
;  *										UIL- and HCF specific codes. Theoretically this could be
;  *										corrected when and if there will ever be an overall
;  *										incompatibilty introduced for another reason
;  
; ============================================================= CONFIGURATION RECORDS	=====================
; ============================================================= mask 0xFCxx				=====================
; 	NETWORK PARAMETERS, STATIC CONFIGURATION ENTITIES
; FC05, FC0B, FC0C, FC0D: SEE W2DN149
; lowest value representing a Configuration RID
CFG_RID_CFG_MIN		EQU		00000fc00h
; [STA] Connection control characteristics
CFG_CNF_PORT_TYPE		EQU		00000fc00h
; [STA] MAC Address of this node
CFG_CNF_OWN_MAC_ADDR		EQU		00000fc01h
; [STA] Service Set identification for connection
; 													 *originally known as static entity with name 
; 													 *	CFG_CNF_DESIRED_SSID
; 													 *when type changed to dynamic, name incorrectly changed to 
; 													 *	CNF_DESIRED_SSID
; 													 *finally name changed to (the "correct")
; 													 *	CFG_DESIRED_SSID
; 													 *CNF_DESIRED_SSID will be discarded some time in the future
; 													 
CNF_DESIRED_SSID		EQU		00000fc02h
; #define CFG_DESIRED_SSID	  CNF_DESIRED_SSID			
; Communication channel for BSS creation
CFG_CNF_OWN_CHANNEL		EQU		00000fc03h
; IBSS creation (STA) or ESS (AP) Service Set Ident
CFG_CNF_OWN_SSID		EQU		00000fc04h
; [STA] ATIM Window time for IBSS creation
CFG_CNF_OWN_ATIM_WINDOW		EQU		00000fc05h
; System Scale that specifies the AP density
CFG_CNF_SYSTEM_SCALE		EQU		00000fc06h
; Maximum length of MAC Frame Body data
CFG_CNF_MAX_DATA_LEN		EQU		00000fc07h
; [STA] MAC Address of corresponding WDS Link node
CFG_CNF_WDS_ADDR		EQU		00000fc08h
;  HCF_TYPE_HII
; [STA] Switch for ESS PM Multicast reception On/Off
CFG_CNF_MCAST_RX		EQU		00000fc0bh
; [STA] Maximum sleep time for ESS PM
CFG_CNF_MAX_SLEEP_DURATION		EQU		00000fc0ch
; [STA] Holdover time for ESS PM
CFG_CNF_HOLDOVER_DURATION		EQU		00000fc0dh
; Identification text for diagnostic purposes
CFG_CNF_OWN_NAME		EQU		00000fc0eh
; [AP] Beacon intervals between successive DTIMs
CFG_CNF_OWN_DTIM_PERIOD		EQU		00000fc10h
; [AP] Port 1 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR1		EQU		00000fc11h
; [AP] Port 2 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR2		EQU		00000fc12h
; [AP] Port 3 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR3		EQU		00000fc13h
; [AP] Port 4 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR4		EQU		00000fc14h
; [AP] Port 5 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR5		EQU		00000fc15h
; [AP] Port 6 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR6		EQU		00000fc16h
; [AP] Switch for PM buffereing of Multicast Messages
CFG_CNF_PM_MCAST_BUF		EQU		00000fc17h
; name does not match H-II spec
CFG_CNF_MCAST_PM_BUF		EQU		00000fc17h
; [AP] Switch for PM buffereing of Multicast Messages	
CFG_CNF_REJECT_ANY		EQU		00000fc18h
; select en/de-cryption of Tx/Rx messages
CFG_CNF_ENCRYPTION		EQU		00000fc20h
; selects Authentication algorithm						
CFG_CNF_AUTHENTICATION		EQU		00000fc21h
; [AP] Switch for 'clear-text' rx message acceptance	
CFG_CNF_EXCL_UNENCRYPTED		EQU		00000fc22h
; Transmit Data rate for Multicast frames				
CFG_CNF_MCAST_RATE		EQU		00000fc23h
; [AP] Switch for IntraBBS relay						
CFG_CNF_INTRA_BSS_RELAY		EQU		00000fc24h
; MicroWave (Robustness)
CFG_CNF_MICRO_WAVE		EQU		00000fc25h
; Load Balancing		 (Boolean, 0=OFF, 1=ON, default=1)
CFG_CNF_LOAD_BALANCING		EQU		00000fc26h
; Medium Distribution	 (Boolean, 0=OFF, 1=ON, default=1)
CFG_CNF_MEDIUM_DISTRIBUTION		EQU		00000fc27h
; Group Address Filter
CFG_CNF_RX_ALL_GROUP_ADDRESS		EQU		00000fc28h
; Country Info
CFG_CNF_COUNTRY_INFO		EQU		00000fc29h
; 	NETWORK PARAMETERS, DYNAMIC CONFIGURATION ENTITIES
; [STA] Service Set identification for connection
CFG_DESIRED_SSID		EQU		00000fc02h
; [STA] Multicast MAC Addresses for Rx-message
CFG_GROUP_ADDR		EQU		00000fc80h
; [STA] Switch for IBSS creation On/Off
CFG_CREATE_IBSS		EQU		00000fc81h
; [STA] Frame length used for RTS/CTS handshake
CFG_RTS_THRH		EQU		00000fc83h
; [STA] Data rate control for message transmission
CFG_TX_RATE_CNTL		EQU		00000fc84h
; [STA] Switch for Promiscuous mode reception On/Off
CFG_PROMISCUOUS_MODE		EQU		00000fc85h
; [STA] Switch for Wake-On-LAN mode
CFG_WAKE_ON_LAN		EQU		00000fc86h
; * delete some macros to stay below the Microsoft H2INC limit
; [AP] Port 0 frame length for RTS/CTS handshake
CFG_RTS_THRH0		EQU		00000fc97h
; [AP] Port 1 frame length for RTS/CTS handshake
CFG_RTS_THRH1		EQU		00000fc98h
; [AP] Port 2 frame length for RTS/CTS handshake
CFG_RTS_THRH2		EQU		00000fc99h
; [AP] Port 3 frame length for RTS/CTS handshake
CFG_RTS_THRH3		EQU		00000fc9ah
; [AP] Port 4 frame length for RTS/CTS handshake
CFG_RTS_THRH4		EQU		00000fc9bh
; [AP] Port 5 frame length for RTS/CTS handshake
CFG_RTS_THRH5		EQU		00000fc9ch
; [AP] Port 6 frame length for RTS/CTS handshake
CFG_RTS_THRH6		EQU		00000fc9dh
; [AP] Port 0 data rate control for transmission
CFG_TX_RATE_CNTL0		EQU		00000fc9eh
; [AP] Port 1 data rate control for transmission
CFG_TX_RATE_CNTL1		EQU		00000fc9fh
; [AP] Port 2 data rate control for transmission
CFG_TX_RATE_CNTL2		EQU		00000fca0h
; [AP] Port 3 data rate control for transmission
CFG_TX_RATE_CNTL3		EQU		00000fca1h
; [AP] Port 4 data rate control for transmission
CFG_TX_RATE_CNTL4		EQU		00000fca2h
; [AP] Port 5 data rate control for transmission
CFG_TX_RATE_CNTL5		EQU		00000fca3h
; [AP] Port 6 data rate control for transmission	
CFG_TX_RATE_CNTL6		EQU		00000fca4h
; delete some macros to stay below the Microsoft H2INC limit */
; defines set of encryption keys
CFG_DEFAULT_KEYS		EQU		00000fcb0h
; select key for encryption of Tx messages
CFG_TX_KEY_ID		EQU		00000fcb1h
; Scan SSID
CFG_SCAN_SSID		EQU		00000fcb2h
; 
CFG_ADD_TKIP_DEFAULT_KEY		EQU		00000fcb4h
; KeyID mask for tkip_key_id_info field
KEY_ID		EQU		000000003h
; Default Tx Key flag of tkip_key_id_info field
TX_KEY		EQU		000008000h
; 
CFG_SET_SSN_AUTHENTICATION_SUITE		EQU		00000fcb5h
; 
CFG_REMOVE_TKIP_DEFAULT_KEY		EQU		00000fcb6h
; 	BEHAVIOR PARAMETERS	
; [PRI] Auxiliary Timer tick interval
CFG_TICK_TIME		EQU		00000fce0h
; highest value representing an Configuration RID
CFG_RID_CFG_MAX		EQU		00000fcffh
; ============================================================= INFORMATION RECORDS 	=====================
; ============================================================= mask 0xFDxx				=====================
; 	NIC INFORMATION	
; lowest value representing an Information RID
CFG_RID_INF_MIN		EQU		00000fd00h
; [PRI] Maximum response time of the Download command.
CFG_MAX_LOAD_TIME		EQU		00000fd00h
; [PRI] Download buffer location and size.
CFG_DL_BUF		EQU		00000fd01h
; too many uses in NDIS H-II !((HCF_TYPE) & HCF_TYPE_HII )
; [PRI] Primary Functions firmware identification.
CFG_PRI_IDENTITY		EQU		00000fd02h
;  HCF_TYPE_HII
; [PRI] Primary Functions I/F Supplier compatibility range.
CFG_PRI_SUP_RANGE		EQU		00000fd03h
; [PRI] Controller I/F Actor compatibility ranges.
CFG_CFI_ACT_RANGES_PRI		EQU		00000fd04h
; H/W - S/W I/F supplier range
CFG_NIC_HSI_SUP_RANGE		EQU		00000fd09h
; [PRI] Network Interface Card serial number.
CFG_NIC_SERIAL_NUMBER		EQU		00000fd0ah
; [PRI] Network Interface Card identification.
CFG_NIC_IDENTITY		EQU		00000fd0bh
; [PRI] Modem I/F Supplier compatibility range.
CFG_NIC_MFI_SUP_RANGE		EQU		00000fd0ch
; [PRI] Controller I/F Supplier compatibility range.
CFG_NIC_CFI_SUP_RANGE		EQU		00000fd0dh
; Allowed communication channels.
CFG_CHANNEL_LIST		EQU		00000fd10h
; List of intended regulatory domains.
CFG_REG_DOMAINS		EQU		00000fd11h
;  HCF_TYPE_HII
; Hardware temperature range code.
CFG_NIC_TEMP_TYPE		EQU		00000fd12h
; PC Card Standard Card Information Structure
CFG_CIS		EQU		00000fd13h
; Card Profile
CFG_NIC_PROFILE		EQU		00000fd14h
; firmware identification.
CFG_FW_IDENTITY		EQU		00000fd20h
; firmware Supplier compatibility range.
CFG_FW_SUP_RANGE		EQU		00000fd21h
; [STA] Modem I/F Actor compatibility ranges.
CFG_MFI_ACT_RANGES_STA		EQU		00000fd22h
; [STA] Controller I/F Actor compatibility ranges.
CFG_CFI_ACT_RANGES_STA		EQU		00000fd23h
; 
; 	MAC INFORMATION
; [STA] Actual MAC Port connection control status
CFG_PORT_STAT		EQU		00000fd40h
; [STA] Identification of the actually connected SS
CFG_CURRENT_SSID		EQU		00000fd41h
; [STA] Identification of the actually connected BSS
CFG_CURRENT_BSSID		EQU		00000fd42h
; [STA] Quality of the Basic Service Set connection
CFG_COMMS_QUALITY		EQU		00000fd43h
; [STA] Actual transmit data rate
CFG_CURRENT_TX_RATE		EQU		00000fd44h
; Beacon transmit interval time for BSS creation
CFG_CUR_BEACON_INTERVAL		EQU		00000fd45h
; Actual System Scale thresholds settings
CFG_CUR_SCALE_THRH		EQU		00000fd46h
; Max time to await a response to a request message
CFG_PROTOCOL_RSP_TIME		EQU		00000fd47h
; Max number of transmit attempts for short frames
CFG_CUR_SHORT_RETRY_LIMIT		EQU		00000fd48h
; Max number of transmit attempts for long frames
CFG_CUR_LONG_RETRY_LIMIT		EQU		00000fd49h
; Max transmit frame handling duration
CFG_MAX_TX_LIFETIME		EQU		00000fd4ah
; Max received frame handling duration
CFG_MAX_RX_LIFETIME		EQU		00000fd4bh
; [STA] Contention Free pollable capability indication
CFG_CF_POLLABLE		EQU		00000fd4ch
; Available Authentication Algorithms indication
CFG_AUTHENTICATION_ALGORITHMS		EQU		00000fd4dh
; WEP Option availability indication
CFG_PRIVACY_OPT_IMPLEMENTED		EQU		00000fd4fh
; CurrentRemoteRates
CFG_CURRENT_REMOTE_RATES		EQU		00000fd50h
; CurrentUsedRates
CFG_CURRENT_USED_RATES		EQU		00000fd51h
; CurrentSystemScale
CFG_CURRENT_SYSTEM_SCALE		EQU		00000fd52h
; AP] Actual Port 1 transmit data rate
CFG_CURRENT_TX_RATE1		EQU		00000fd80h
; [AP] Actual Port 2 transmit data rate
CFG_CURRENT_TX_RATE2		EQU		00000fd81h
; [AP] Actual Port 3 transmit data rate
CFG_CURRENT_TX_RATE3		EQU		00000fd82h
; [AP] Actual Port 4 transmit data rate
CFG_CURRENT_TX_RATE4		EQU		00000fd83h
; [AP] Actual Port 5 transmit data rate
CFG_CURRENT_TX_RATE5		EQU		00000fd84h
; [AP] Actual Port 6 transmit data rate
CFG_CURRENT_TX_RATE6		EQU		00000fd85h
; [AP] Unique local node MAC Address
CFG_NIC_MAC_ADDR		EQU		00000fd86h
; [AP] Point Coordination Function capability info
CFG_PCF_INFO		EQU		00000fd87h
; 
CFG_CURRENT_COUNTRY_INFO		EQU		00000fd89h
; 
CFG_CURRENT_SSN_INFO_ELEMENT		EQU		00000fd8ah
; 
CFG_CURRENT_TKIP_IV_INFO		EQU		00000fd8bh
; 
CFG_CURRENT_ASSOC_REQ_INFO		EQU		00000fd8ch
; 
CFG_CURRENT_ASSOC_RESP_INFO		EQU		00000fd8dh
; 	MODEM INFORMATION	
; Physical layer type indication
CFG_PHY_TYPE		EQU		00000fdc0h
; Actual frequency channel used for transmission
CFG_CURRENT_CHANNEL		EQU		00000fdc1h
; Actual power consumption status
CFG_CURRENT_POWER_STATE		EQU		00000fdc2h
; Clear channel assessment mode indication
CFG_CCAMODE		EQU		00000fdc3h
; Data rates capability information
CFG_SUPPORTED_DATA_RATES		EQU		00000fdc6h
; highest value representing an Information RID
CFG_RID_INF_MAX		EQU		00000fdffh
; #define CNF_DESIRED_SSID	CFG_DESIRED_SSID		/ * what a mess changing 0xFC02 from static to dynamic
; 													 * and trying to keep naming consistent
; 													 * as the X macros show, this was not a success
; 													 * to minimize the annoyance of the MSF programmers
; 													 * couple the "bad" historical name with the "right" name
; 													 */
; ***********************************************************************************************************
; *****************************      M A C R O S     *******************************************************
;  min and max macros 
; ***********************************************************************************************************
; ***************************** General define **************************************************************
; IFB field related
; 		IFB_CardStat
;  hcf_disable did not detect compatible primary functions
CARD_STAT_INCOMP_PRI		EQU		000002000h
;  hcf_disable did not detect compatible station functions
CARD_STAT_INCOMP_STA		EQU		000001000h
;  No (functional) STA F/W in NV-RAM (allows download and AP mode)
CARD_STAT_STA_ABSENT		EQU		000000400h
;  Hermaphrodite in AP mode
CARD_STAT_AP		EQU		000000200h
;  HCF is in Defunct mode
CARD_STAT_DEFUNCT		EQU		000000100h
; 		IFB_RxStat
; Priority subfield
RX_STAT_PRIO		EQU		0000000e0h
; Error mask
RX_STAT_ERR		EQU		000000003h
; Non-decryptable encrypted message
RX_STAT_UNDECR		EQU		000000002h
; FCS error
RX_STAT_FCS_ERR		EQU		000000001h
;  SNAP header for E-II Encapsulation
ENC_NONE		EQU		0000000ffh
ENC_1042		EQU		000000000h
ENC_TUNNEL		EQU		0000000f8h
; ***************************** Xxxxxxxx ********************************************************************
; hcf_stat
HCF_SUCCESS		EQU		0t
;  0x00: OK
HCF_ERR_TIME_OUT		EQU		4t
;  0x04: Expected Hermes event did not occure in expected time
HCF_ERR_NO_NIC		EQU		5t
;  0x05: card not found (usually yanked away during hcfio_in_string
; 											 Also: card is either absent or disabled while it should be neither		
HCF_ERR_LEN		EQU		8t
;  0x08: buffer size insufficient
; 		  -	IFB_ConfigTable too small									
; 		  -	hcf_get_info buffer has a size of 0 or 1 or less than needed
; 			to accomodate all data
; 		  -	hcf_put_info: CFG_DLNV_DATA exceeds intermediate buffer size
HCF_ERR_INCOMP_PRI		EQU		9t
;  0x09: primary functions are not compatible
HCF_ERR_INCOMP_FW		EQU		10t
;  0x0A: primary functions are compatible, station functions are not
HCF_ERR_MIC		EQU		11t
;  0x0D: MIC check fails
HCF_ERR_MAX		EQU		63t
;  end of HCF range, see UIL_ERR_MIN/MAX
; 									   *** ** *** *****  *** ***************  
HCF_ERR_DEFUNCT		EQU		128t
;  BIT, reflecting that the HCF is in defunct mode (bits 0x7F reflect cause)
HCF_ERR_DEFUNCT_AUX		EQU		129t
;  0x082 Timeout on acknowledgement on en/disabling AUX registers
HCF_ERR_DEFUNCT_TIMER		EQU		130t
;  0x083 Timeout on timer calibration during initialization process
HCF_ERR_DEFUNCT_TIME_OUT		EQU		131t
;  0x084 Timeout on Busy bit drop during BAP setup
HCF_ERR_DEFUNCT_CMD_SEQ		EQU		132t
;  0x086 Hermes and HCF are out of sync in issuing/processing commands
; enum /*uil_stat*/ {
UIL_FAILURE		EQU		255t
;  HCF_FAILURE,         //JMES/24022000: activated
; 												 * 20010705 nv this relick should be eridicated ot the UIL as well
; 												 
UIL_SUCCESS		EQU		0t
UIL_ERR_TIME_OUT		EQU		4t
UIL_ERR_NO_NIC		EQU		5t
UIL_ERR_LEN		EQU		8t
UIL_ERR_MIN		EQU		63t
; 0x3F,	end of HCF errors which are passed through to UIL
; 									   		  ****  *** ** *** ****** ***** *** ****** ******* ** ***  
UIL_ERR_PIF_CONFLICT		EQU		64t
; lower boundary UIL errors without HCF-pendant (kept for historical reason)
UIL_ERR_INCOMP_DRV		EQU		65t
UIL_ERR_NO_DRV		EQU		66t
UIL_ERR_DOS_CALL		EQU		67t
UIL_ERR_IN_USE		EQU		68t
UIL_ERR_NSTL		EQU		69t
UIL_ERR_WRONG_IFB		EQU		70t
; upper boundary of UIL errors without HCF-pendant
; 											  ***** ******** ** *** ****** ******* *** *******  
; } /* uil_stat */
UIL_ERR_MAX		EQU		127t

;  (ODI initiated) return status of hcf_act( HCF_ACT_INT_OFF )
HCF_INT_PENDING		EQU		1t
HCF_PORT_DISABLE		EQU		000000002h
HCF_PORT_ENABLE		EQU		000000001h
;  Station supports only single MAC Port
HCF_PORT_0		EQU		000000000h
; HFS_TX_CNTL
; ??????????????????????????????????????????????#define 	HFS_TX_CNTL_SPECTRALINK	0x0002 of is het 1
; ???????????????????????????in the past it has been 2
HFS_TX_CNTL_SPECTRALINK		EQU		000000001h
HFS_TX_CNTL_TX_OK		EQU		000000002h
HFS_TX_CNTL_TX_EX		EQU		000000004h
; type subfield
HFS_TX_CNTL_TYPE		EQU		000000018h
HFS_TX_CNTL_TYPE_TKIP		EQU		000000000h
; MIC Key ID subfield
HFS_TX_CNTL_MIC_KEY_ID		EQU		000000000h
;  HCF_TYPE_SSN
; TxPriority subfield of TxControl field of Transmit Frame Structure
HFS_TX_CNTL_PRIO		EQU		0000000e0h
HCF_TX_PRIO_HIGH		EQU		000000020h
HFS_TX_CNTL_NO_DCWA		EQU		000001000h
; decouple "put data" and send
HFS_TX_CNTL_TX_DELAY		EQU		000002000h
; Station and HCF-light supports only a single MAC Port
HFS_TX_CNTL_PORT		EQU		000000000h
;  HCF_TYPE_AP
HCF_EX_INT_TX_OK		EQU		000000002h
HCF_EX_INT_TX_EX		EQU		000000004h
HCF_EX_INT_TICK		EQU		000008000h
; ============================================================= HCF Defined RECORDS	=========================
; USB designator for Tx Frame
CFG_TX_FRAME		EQU		000000700h
; USB designator for Rx Frame
CFG_RX_FRAME		EQU		000000701h
; USB designator for "dummy response"
CFG_RESPONSE		EQU		000000710h
; Plug Data
CFG_PROD_DATA		EQU		000000800h
;  HCF_TYPE_HII
; 	80x reserved for "similar" actions
; Up/Download I2PROM for USB
CFG_DL_EEPROM		EQU		000000806h
; Download PDA
CFG_PDA		EQU		000000002h
; Up/Download EEPROM
CFG_MEM_I2PROM		EQU		000000004h
CFG_MEM_READ		EQU		000000000h
CFG_MEM_WRITE		EQU		000000001h
; Empty Mail Box Info Block
CFG_NULL		EQU		000000820h
; Mail Box Info Block
CFG_MB_INFO		EQU		000000820h
; WaveLAN Management Protocol
CFG_WMP		EQU		000000822h
; byte wise copy of IFB
CFG_IFB		EQU		000000824h
; Driver Information structure (see CFG_DRV_INFO_STRCT for details)
CFG_DRV_INFO		EQU		000000825h
; driver identity (see CFG_DRV_IDENTITY_STRCT for details)
CFG_DRV_IDENTITY		EQU		000000826h
; Supplier range of driver - utility I/F
CFG_DRV_SUP_RANGE		EQU		000000827h
; (Acceptable) Actor range for Primary Firmware - driver I/F
CFG_DRV_ACT_RANGES_PRI		EQU		000000828h
; (Acceptable) Actor range for Station Firmware - driver I/F
CFG_DRV_ACT_RANGES_STA		EQU		000000829h
; (Acceptable) Actor range for H/W - driver I/F
CFG_DRV_ACT_RANGES_HSI		EQU		00000082ah
; (Acceptable) Actor range for AP Firmware - driver I/F
CFG_DRV_ACT_RANGES_APF		EQU		00000082bh
; HCF (Compile time) options
CFG_HCF_OPT		EQU		00000082ch
; Register Mail Box
CFG_REG_MB		EQU		000000830h
; Assert information
CFG_MB_ASSERT		EQU		000000831h
; (de-)register MSF Assert Callback routine
CFG_REG_ASSERT_RTNP		EQU		000000832h
; (de-)register MSF Log Callback routine
CFG_REG_LOG_RTNP		EQU		000000837h
; (de-)register Info frames to Log
CFG_REG_INFO_LOG		EQU		000000839h
; TxFrame copied to MB based on HCF_EX_INT_TX_EX/HCF_EX_INT_TX_OK
CFG_EX_INT_TX		EQU		000000840h
; Setup for Download to non-volatile RAM
CFG_DLNV_START		EQU		000000850h
; Download data
CFG_DLNV_DATA		EQU		000000851h
; Setup for Download to volatile RAM
CFG_DLV_START		EQU		000000852h
; Download RAM Addressing information
CFG_DLV_ADDR		EQU		000000853h
; Download RAM Data
CFG_DLV_DATA		EQU		000000854h
; Cleanup Download, non-volatile as well as volatile
CFG_DL_STOP		EQU		000000855h
; Program NIC memory
CFG_PROG		EQU		000000857h
; Hermes Engineering command
CFG_CMD_NIC		EQU		000000860h
; HCF Engineering command
CFG_CMD_HCF		EQU		000000863h
; 0x088x											USB System Identification Range							
; USB Converter board Identity
CFG_UHW_IDENTITY		EQU		000000880h
; USB Converter board Supplier Range
CFG_UBI_SUP_RANGE		EQU		000000881h
; USB Bootloader Identity
CFG_UBL_IDENTITY		EQU		000000882h
; USB Bootloader Supplier Range	//;?Why twice
CFG_UDI_SUP_RANGE		EQU		000000883h
; USB Bootloader Supplier Range	//;?Why twice
CFG_UBL_SUP_RANGE		EQU		000000883h
; Actor Hardware - USB Bootloader I/F
CFG_HW_ACT_RANGES_UDI		EQU		000000884h
; Actor Driver - USB Bootloader I/F
CFG_DRV_ACT_RANGES_UDI		EQU		000000885h
; Actor Driver - USB Converter board
CFG_DRV_ACT_RANGES_UBI		EQU		000000886h
; 0x089x											PCI System Identification Range							
; ============================================================= MSF Defined RECORDS	=========================
; transfer encryption info from CPL to MSF 
CFG_ENCRYPT_STRING		EQU		000000900h
; control mode of STAP driver from CPL
CFG_AP_MODE		EQU		000000901h
; extend&export En-/Disable facility to Utility
CFG_DRIVER_ENABLE		EQU		000000902h
; PCI adapter (Ooievaar) structure
CFG_PCI_COMMAND		EQU		000000903h
; extend&export En-/Disable WOLAS facility to Utility
CFG_WOLAS_ENABLE		EQU		000000904h
; transfer CountryInfo info from CPL to MSF 
CFG_COUNTRY_STRING		EQU		000000905h
; ============================================================= INFORMATION FRRAMES		=====================
; lowest value representing an Informatio Frame
CFG_INFO_FRAME_MIN		EQU		00000f000h
; Handover Address						
CFG_NOTIFY		EQU		00000f000h
;  HCF_TYPE_HII
; Communications Tallies
CFG_TALLIES		EQU		00000f100h
; Scan results
CFG_SCAN		EQU		00000f101h
; ACS Scan results
CFG_ACS_SCAN		EQU		00000f102h
; Link Status
CFG_LINK_STAT		EQU		00000f200h
; Association Status		
CFG_ASSOC_STAT		EQU		00000f201h
; Security Status					
CFG_SECURITY_STAT		EQU		00000f202h
; ============================================================= CONFIGURATION RECORDS	=====================
; ***********************************************************************************************************
; ***************************** S T R U C T U R E   D E F I N I T I O N S ***********************************
; Quick&Dirty to get download for DOS ODI Hermes-II running typedef LTV_STRCT FAR *	LTVP;
; CFG_DRV_INFO (0x0825) driver information
; default length of RID
; RID identification as defined by Hermes
; Driver name, 8 bytes, right zero padded
; BCD 2 digit major and 2 digit minor driver version
; BCD 2 digit major and 2 digit minor HCF version
; 
; IOAddress used by NIC
; IORange used by NIC
; Interrupt used by NIC
; NIC status
; 									@*	0x8000	Card present
; 									@*	0x4000	Card Enabled
; 									@*	0x2000	Driver incompatible with NIC Primary Functions
; 									@*	0x1000	Driver incompatible with NIC Station Functions
; 									@*	0x007F	HCF Internal Flags (i.e. pseudo Asynchronous command code)  
; Frame type
; 									@*	0x000	802.3
; 									@*	0x008	802.11														
; driver specific info
; 									 * CE: virtual I/O base													
CFG_DRV_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
driver_name		hcf_8		8t DUP (?)
driver_version		hcf_16		?
HCF_version		hcf_16		?
driver_stat		hcf_16		?
IO_address		hcf_16		?
IO_range		hcf_16		?
IRQ_number		hcf_16		?
card_stat		hcf_16		?
frame_type		hcf_16		?
drv_info		hcf_32		?
CFG_DRV_INFO_STRCT		ENDS

; Primary Functions Firmware
COMP_ID_FW_PRI		EQU		21t
; Intermediate Functions Firmware
COMP_ID_FW_INTERMEDIATE		EQU		22t
; Station Functions Firmware
COMP_ID_FW_STA		EQU		31t
; AP Functions Firmware 
COMP_ID_FW_AP		EQU		32t
; Windows 9x/NT Miniport NDIS 3.1
COMP_ID_MINIPORT_NDIS_31		EQU		41t
; Packet
COMP_ID_PACKET		EQU		42t
; DOS ODI
COMP_ID_ODI_16		EQU		43t
; 32-bits ODI
COMP_ID_ODI_32		EQU		44t
; Macintosh OS
COMP_ID_MAC_OS		EQU		45t
; Windows CE Miniport
COMP_ID_WIN_CE		EQU		46t
; Linux, full source code in Public Domain, HCF-light based
; 													 *thanks to Andreas Neuhaus								
COMP_ID_LINUX_PD		EQU		47t
; Windows 9x/NT Miniport NDIS 5.0
COMP_ID_MINIPORT_NDIS_50		EQU		48t
; Linux, HCF-library based
COMP_ID_LINUX_LIB		EQU		49t
; QNX
COMP_ID_QNX		EQU		50t
; Windows 9x/NT Miniport NDIS 4.0
COMP_ID_MINIPORT_NDIS_50_USB		EQU		51t
; Windows 9x/NT Miniport NDIS 4.0
COMP_ID_MINIPORT_NDIS_40		EQU		52t
;  VxWorks END Station driver. 
COMP_ID_VX_WORKS_ENDSTA		EQU		53t
;  VxWorks END Access Point driver. 
COMP_ID_VX_WORKS_ENDAP		EQU		54t
; ;?#define COMP_ID_MAC_OS_????			55		//;?check with HM
;  VxWorks END Station/Access Point driver. 
COMP_ID_VX_WORKS_END		EQU		56t
; WaveLAN/IEEE AP
COMP_ID_AP1		EQU		81t
; WaveLAN/IEEE Ethernet Converter
COMP_ID_EC		EQU		83t
; USB Boot Loader
COMP_ID_UBL		EQU		87t
; supplier
COMP_ROLE_SUPL		EQU		000000000h
; actor
COMP_ROLE_ACT		EQU		000000001h
; Supplier			  - actor
; Modem		 		  - Firmware	I/F
COMP_ID_MFI		EQU		000000001h
; Controller		  - Firmware	I/F
COMP_ID_CFI		EQU		000000002h
; Primary Firmware	  - Driver		I/F
COMP_ID_PRI		EQU		000000003h
; Station Firmware	  - Driver		I/F
COMP_ID_STA		EQU		000000004h
; Driver			  - Utility		I/F
COMP_ID_DUI		EQU		000000005h
; H/W                 - Driver		I/F
COMP_ID_HSI		EQU		000000006h
; API                 - Driver		I/F
COMP_ID_DAI		EQU		000000007h
; H/W                 - Driver		I/F
COMP_ID_APF		EQU		000000008h
; USB Converter board - Host Driver	I/F
COMP_ID_UBI		EQU		000000019h
; 						USB Bootloader
; USB Bootloader	  - Host Driver	I/F
COMP_ID_UDI		EQU		00000001ah
; ****************************** Obsolete/Legacy *************************************************************
; Obsolete H-I legacy 
CFG_CARD_PROFILE		EQU		00000fd14h
; legacy	
CFG_STA_IDENTITY		EQU		00000fd20h
; legacy
CFG_STA_SUP_RANGE		EQU		00000fd21h
; ?????????#define CFG_AUTHENTICATION				0xFD4D					//??????????????????????????????????????????
; ?????????#define CFG_AUTHENTICATION_TYPE			0xFD4E		//Available Authentication Types indication
; 0x0080	//replaces HCF_PUT_DATA_RESET
; ??
; 0x0702		//USB designator for Action Command Frame
; 0x0821		//Diagnose result
; Aux Data (still used by usb_u.c)
CFG_AUX_DATA		EQU		000000801h
; 0x0807		//range of the AUX_DATA family
; 0x0823		//accumulated set of restraint bits detected by driver (HCF + MSF)
; 0x082F		//Unknown, used a.o. in "flows which should not occure"
; 0x0833		//Read and Clear Communications Tallies
; 0x0834		//set/reset bits in MSF-controlled field of CFG_RESTRAINT_INFO
; 0x0835		//control emergency escape IFB_MSFType		
; 0x0836		//control Engineering Flag settings			
; 0x083A		//filter for use in TRACE/TRACE_VALUE macros set
; 0x0842		//driver HCF activity log
; 0x0856		//Download result
; obsolete	//USB Engineering command
CFG_CMD_DONGLE		EQU		000000861h
; #define CFG_THESEUS_CMD					0x0862		//Theseus Test command
; Hermes Engineering command
; legacy, to be deleted some time in the future
CFG_CNF_PM_ENABLED		EQU		00000fc09h
; 0xFC28	//Group Address Filter
; 0xFDC5	//MAC processing delay time
; 0x0A	// USB look-a-like for hcf_initialize(xxxx) on the Dongle side
; 0x0B	//0B USB look-a-like for HCF_ACT_BLOCK on the Dongle side
; 0x0C	//0C USB look-a-like for HCF_ACT_UNBLOCK on the Dongle side
; 12 freeze the F/W execution
; 13 disable TimerTick interrupt
; 14 enable TimerTick interrupt
; 0x16	
; 0x17
; usb_u.c uses it obsolete	// 0x06: hcf_send_diag_msg called while PIF_RscInd == 0
HCF_ERR_BUSY		EQU		000000006h
;  0x07: other cmd than the expected completed, probably HCF-bug
HCF_ERR_SEQ_BUG		EQU		000000007h
UIL_ERR_SEQ_BUG		EQU		000000007h
;  0x0100,	//"insignificant" error (see W2DN264)
;  0x0C DCWA (Data Corruption Work Around) catched
;  0x0003U	/* HCF noticed an error after succesful diagnose command
;  0x088 freeze the F/W execution (intentionally via HCF_ACT_FREEZE)
;  0x081 Timeout on Busy bit drop before writing Hermes Initialize command
;  0x085 Allocation failed during initialization process
;  0x087 DCWA during download did not succeed within retry limit
;  0x10,	// 0x10: any incompatibilty (recall)
;  0x0B: Incompatible feature (prevents enable)
;  0x0511,	// Inquiry failed due to lack of Hermes Buffer space
UIL_ERR_BUSY		EQU		000000006h
;  0x0A: primary functions are compatible, station functions are not
CFG_HSI_SUP_RANGE		EQU		00000fd09h
CFG_MFI_SUP_RANGE		EQU		00000fd0ch
CFG_CFI_SUP_RANGE		EQU		00000fd0dh
; #define CFG_NIC_HSI_SUP_RANGE_STRCT	CFG_HSI_SUP_RANGE_STRCT
; ~~#define CFG_CNF_PM_EPS					0xFC0A		//[STA] Switch for ESS PM EPS/PS Mode
;  Debug Only !!
; 												 * MSF defines card as being present
; 												 * controls whether hcf-function is allowed to do I/O		
CARD_STAT_PRESENT		EQU		000008000h
;  Incompatible feature (prevents enable)
; 												 * !! NOTE !! this bit is only cleared as side effect of 
; 												   !! HCF_ACT_CARD_IN. Dynamically clearing it if a non-
; 												   !! violating feature is set, will not work properly if
; 												   !! - some time in the future -, a 2nd feature with this
; 												   !! characteristics is created. Since Utilities protect
; 												   !! "intelligent" against this problem and Driver Config
; 												   !! files can not change dynamically, this is not a serious
; 												   !! limitation
;                                                  
;  MDD_H
; End of file c:/HCF/mdd.h
; **********************************************************************************************************
; *****************                                                  ***************************************
; **********************************************************************************************************
;  offsets Transmit/Receive Frame Structure
HFS_STAT		EQU		000000000h
; SW Support
HFS_SWSUP		EQU		000000006h
; Signal/Silence level
HFS_Q_INFO		EQU		000000006h
; RxFlow/Rate
HFS_RATE		EQU		000000008h
; link "natural" HCF name to "natural" MSF name
HFS_STAT_ERR		EQU		000000003h
HFS_ADDR_DEST		EQU		00000002eh
HFS_TX_CNTL		EQU		00000000ch
;  HCF_TYPE_SSN
;  HCF_TYPE										//	H-I		H-II
;  0x002C  0x0038
HFS_DAT_LEN		EQU		00000002ch
; 		HFS_ADDR_DEST									   0x002E  0x003A	
;  0x0034  0x0040
HFS_ADDR_SRC		EQU		000000034h
;  0x003A  0x0046
HFS_LEN		EQU		00000003ah
;  0x003C  0x0048
HFS_DAT		EQU		00000003ch
;  0x0042  0x004E
HFS_TYPE		EQU		000000042h
; ***********************************************************************************************************
; ***************   H C F  F U N C T I O N   R E T U R N   C O D E S   **************************************
; ***********************************************************************************************************
; Debug Purposes only				!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; Hermes Event Register bit definitions
; Auxiliary Timer Tick
HREG_EV_TICK		EQU		000008000h
; H/W error (Wait Time-out)
HREG_EV_RES		EQU		000004000h
; WMAC did not have sufficient RAM to build Unsollicited Frame
HREG_EV_INFO_DROP		EQU		000002000h
HREG_EV_REPAIR_ACK		EQU		000000000h
; Asynchronous Information Frame
HREG_EV_INFO		EQU		000000080h
; Command completed, Status and Response available
HREG_EV_CMD		EQU		000000010h
; Asynchronous part of Allocation/Reclaim completed
HREG_EV_ALLOC		EQU		000000008h
; "Orthogonal" name for HREG_EV_TX_EXC (matches control field of TxFS)
HREG_EV_TX_EX		EQU		000000004h
; #define HREG_EV_TX_EXC	0x0004	//"Correct but discouraged": Asynchronous Transmission unsuccessful completed
; "Orthogonal" name for HREG_EV_TX (matches control field of TxFS)
HREG_EV_TX_OK		EQU		000000002h
; #define HREG_EV_TX		0x0002	//"Correct but discouraged": Asynchronous Transmission successful completed
; Asynchronous Receive Frame
HREG_EV_RX		EQU		000000001h
; =========================================  T A L L I E S  ===================================================
; Hermes Tallies (IFB substructure)
CFG_HERMES_TALLIES_STRCT		STRUCT 1t
TxUnicastFrames		hcf_32		?
TxMulticastFrames		hcf_32		?
TxFragments		hcf_32		?
TxUnicastOctets		hcf_32		?
TxMulticastOctets		hcf_32		?
TxDeferredTransmissions		hcf_32		?
TxSingleRetryFrames		hcf_32		?
TxMultipleRetryFrames		hcf_32		?
TxRetryLimitExceeded		hcf_32		?
TxDiscards		hcf_32		?
RxUnicastFrames		hcf_32		?
RxMulticastFrames		hcf_32		?
RxFragments		hcf_32		?
RxUnicastOctets		hcf_32		?
RxMulticastOctets		hcf_32		?
RxFCSErrors		hcf_32		?
RxDiscards_NoBuffer		hcf_32		?
TxDiscardsWrongSA		hcf_32		?
RxWEPUndecryptable		hcf_32		?
RxMsgInMsgFragments		hcf_32		?
RxMsgInBadMsgFragments		hcf_32		?
RxDiscards_WEPICVError		hcf_32		?
RxDiscards_WEPExcluded		hcf_32		?
CFG_HERMES_TALLIES_STRCT		ENDS

; HCF Tallies (IFB substructure)
; No buffer available reported by Inquiry command
; No buffer available for unsolicited Notify frame
; No space available in MailBox
; Miscellaneous errors
;   										@* time out on BAP Initialization
;   										@* time out on Tx Frame Allocation
;   										@* time out on AUX port En-/Disabling
;   										@* time out on completion synchronous part Hermes Command
;   										@* synchronously completed Hermes Command doesn't match original command
;   										@* Request to put zero-length MailBox Info block
;   										@* IFBTickIni based protection counter expired
;   										 
; Engineering Count
;   										@* Data Corruption Workaround catched
;   										 
; *Engineering Count
; *Engineering Count
; *Engineering Count
; *Engineering Count
; *Engineering Count
CFG_HCF_TALLIES_STRCT		STRUCT 1t
not_used_NoBufInq		hcf_32		?
NoBufInfo		hcf_32		?
NoBufMB		hcf_32		?
MiscErr		hcf_32		?
EngCnt		hcf_32		?
EngCnt0		hcf_32		?
EngCnt1		hcf_32		?
EngCnt2		hcf_32		?
EngCnt3		hcf_32		?
EngCnt4		hcf_32		?
CFG_HCF_TALLIES_STRCT		ENDS

; Note this way to define CFG_TALLIES_STRCT_SIZE implies that all tallies must keep the same (hcf_32) size
; **********************************************************************************************************
; **********   W C I    F U N C T I O N S    P R O T O T Y P E S   *****************************************
; **********************************************************************************************************
;  initially 0, to be incremented by every IFB layout change		
IFB_VERSION		EQU		00000000ah
;  identifier IFB_STRCT on typedef line needed to get the individual fields in the MS Browser DataBase		
; I/F Block
; **********************************************************************************************************
;  part I (survives init)  ***********************************************************************
; **********************************************************************************************************
;   hcf_16		len;					/* using LTV form means displacing IFB_IOBase from offset 0 	*/
;   hcf_16		typ;					/* this carries a penalty of 56 bytes in code size for DOS ODI	*/
;   hcf_io		IFB_IOBase;				/* I/O address of Hermes chip as passed by MSF at hcf_connect call	*/
;  I/O address of Hermes chip as passed by MSF at hcf_connect call	
;   hcf_16		IFB_IOBase_pad;			// Optional field, makes IFB-layout independent of IFB_IOBase size
; HCF_PORT_IO
;  I/O Range used by Hermes chip
;  initially 0, incremented by every SIGNIFICANT IFB layout change	
;  align/slack space, minimizes impact of:
; 										 *  - IFB definition changes over time
; 										 *  - fields which depend on compile time options 
; to make Microsoft H2INC conversion programming happy 
; Hermes tallies
; HCF tallies
;  HINC 
;                 													
;  bit flags representing individual enabled ports
;  filter for use in TRACE/TRACE_VALUE macros set
@t_hcf4		TYPEDEF		FAR PTR hcf_16
;                 													
;                 												 	
;                 													
;                 													
;                 													
;  Download Mode state
;                 													
;  initialization of S/W counter based protection loop
;   										 * Note that via IFB_DefunctStat time outs in cmd_wait and in
;   										 * hcfio_string block all Hermes access till the next init
;   										 * so functions which call a mix of cmd_wait and hcfio_string only
;   										 * need to check the return status of the last call					
;                 													
; HCF_ASSERT
;  pointer to RID_LOG structure
@t_hcf5		TYPEDEF		FAR PTR 
;  pointer for arbitrary use by the MSF
;  Monitor capture length											
; 																	
;  HCF_TYPE_USB
;  cmd in progress, to be ack-ed etc before next cmd can be issued	
;                 													
;  pass appropriate FID to hcf_put_mb_info							
; HCF_TYPE_USB
;  fid storage during "delayed" send								
;                 													
;  the fields after this text must stay concatenated because of their (mis-)use as LTV record				
;  32-bits (don't confuse with FAR) Pointer to NV-RAM download target
; HCF_DLNV
; hcf_8			IFB_StaVersion[2];		/* [0]: MinorVersion [1]: MajorVersion								*/
;  the fields above this text must stay concatenated because of their (mis-)use as LTV record				
;                 													
;  BAP initialization or Cmd Completion failed once
;   										 * see remark at IFB_TickIni definition								
;  contents Status reg when error bits and/or mismatch in cmd_wait
;  contents Resp0  reg when error bits and/or mismatch in cmd_wait
; hcf_16		IFB_EngFlg;				/* Engineering Flags
;   										 *	0x0001	WMP filtering on PDU type								*/
;  LookAhead Length												
;  LookAhead Buffer pointer											
;  Link Status
; 										 * 1 Connected, 2 Disconnected,
; 										 * 3 AP change, 4 AP out of range, 5 AP in range					
; ;? remove the obsolete *Cfg fields 
; hcf_16		IFB_PRICfg;				// Primary		Top/Bottom Supplier Range
; hcf_16		IFB_HSICfg;				// H/W-S/W I/F	Top/Bottom Supplier Range
;  Station		Top/Bottom Supplier Range
;  USB Converter Board	Top/Bottom Supplier Range
;  USB Bootloader		Top/Bottom Supplier Range
;  (HCF_TYPE) == HCF_TYPE_STA 
;  HCF_TYPE_STA
;  HCF_TYPE_SSN  
@proto_hcf96		TYPEDEF		PROTO C :PTR hcf_32, :hcf_32
@t_hcf6		TYPEDEF		PTR @proto_hcf96
; dummy routine or Rx MIC calculation engine
@proto_hcf97		TYPEDEF		PROTO C :PTR hcf_32, :hcf_32
@t_hcf7		TYPEDEF		PTR @proto_hcf97
; dummy routine or Tx MIC calculation engine
; temp length, carries over from one Rx fragment to another
; temp length, carries over from one Tx fragment to another
; temp byte accumulator, carry over from one fragment to next
; temp byte accumulator, carry over from one fragment to next
IFB_STRCT		STRUCT 1t
IFB_IOBase		hcf_32		?
IFB_IORange		hcf_16		?
IFB_Version		hcf_8		?
IFB_Slack_2		hcf_8		3t DUP (?)
IFB_NIC_Tallies		CFG_HERMES_TALLIES_STRCT		<>
IFB_HCF_Tallies		CFG_HCF_TALLIES_STRCT		<>
IFB_CardStat		hcf_16		?
IFB_PortStat		hcf_16		?
IFB_TraceLvl		hcf_16		?
IFB_MBp		@t_hcf4		?
IFB_MBSize		hcf_16		?
IFB_MBWp		hcf_16		?
IFB_MBRp		hcf_16		?
IFB_MBInfoLen		hcf_16		?
IFB_DLMode		hcf_16		?
IFB_IntOffCnt		hcf_16		?
IFB_TickIni		hcf_32		?
IFB_Magic		hcf_16		?
IFB_Slack_5		hcf_16		5t DUP (?)
IFB_RIDLogp		RID_LOGP		?
IFB_MSFSup		@t_hcf5		?
IFB_Monitor		hcf_16		?
IFB_RscInd		hcf_16		?
IFB_Slack_10		hcf_16		2t DUP (?)
IFB_Cmd		hcf_16		?
IFB_RxFID		hcf_16		?
IFB_MB_FID		hcf_16		?
IFB_TxFid		hcf_16		?
IFB_RxLen		hcf_16		?
IFB_Slack_16		hcf_16		8t DUP (?)
IFB_DLTarget		hcf_16		2t DUP (?)
IFB_Slack_18		hcf_16		3t DUP (?)
IFB_IntEnMask		hcf_16		?
IFB_DefunctStat		hcf_16		?
IFB_ErrCmd		hcf_16		?
IFB_ErrQualifier		hcf_16		?
IFB_Slack_26		hcf_16		2t DUP (?)
IFB_lal		hcf_16		?
IFB_lap		wci_bufp		?
IFB_LinkStat		hcf_16		?
IFB_HSISup		CFG_NIC_HSI_SUP_RANGE_STRCT		<>
IFB_PRIIdentity		CFG_PRI_IDENTITY_STRCT		<>
IFB_PRISup		CFG_PRI_SUP_RANGE_STRCT		<>
IFB_FWIdentity		CFG_FW_IDENTITY_STRCT		<>
IFB_FWSup		CFG_FW_SUP_RANGE_STRCT		<>
IFB_STACfg		hcf_16		?
IFB_UBICfg		hcf_16		?
IFB_UDICfg		hcf_16		?
IFB_Slack_28		hcf_16		2t DUP (?)
IFB_Slack_40		hcf_16		?
IFB_Slack_41		hcf_16		32t DUP (?)
IFB_Slack_42		hcf_8		8t DUP (?)
IFB_Slack_43		hcf_8		8t DUP (?)
IFB_MICRxRtn		@t_hcf6		?
IFB_MICTxRtn		@t_hcf7		?
IFB_rx_tlen		hcf_16		?
IFB_tx_tlen		hcf_16		?
IFB_rx_32		hcf_8		4t DUP (?)
IFB_tx_32		hcf_8		4t DUP (?)
IFB_STRCT		ENDS

; #define offsetof(s,m)   (size_t)&(((s *)0)->m)
; #define IFB_CARDSTAT_OFFSET offsetof( IFB_STRCT, IFB_CardStat )	//Debug convenience: 1st field after Tallies
; length of assert_strct
; trace log copy from IFB
; qualifier from entry parameter
; line number from entry parameter
ASSERT_STRCT		STRUCT 1t
len		hcf_16		?
trace		hcf_16		?
qualifier		hcf_16		?
line_number		hcf_16		?
val		SBYTE		1t DUP (?)
ASSERT_STRCT		ENDS

;  0: cnt, 1: size
@tag_hcf2		UNION
cntl_stat		hcf_32		?
buf_dim		hcf_16		2t DUP (?)
@tag_hcf2		ENDS

@t_hcf8		TYPEDEF		FAR PTR DESC_STRCT
@t_hcf9		TYPEDEF		FAR PTR hcf_8
DESC_STRCT		STRUCT 1t
buf_cntl		@tag_hcf2		<>
buf_phys_addr		hcf_32		?
next_desc_phys_addr		hcf_32		?
next_desc_addr		@t_hcf8		?
buf_addr		@t_hcf9		?
DESC_STRCT		ENDS

IFBP		TYPEDEF		PTR IFB_STRCT

@proto_hcf98		TYPEDEF		PROTO C :IFBP, :hcf_16
hcf_action		PROTO		@proto_hcf98

@proto_hcf99		TYPEDEF		PROTO C :IFBP, :hcf_io
hcf_connect		PROTO		@proto_hcf99

; EXTERN_C void	hcf_disconnect		(IFBP ifbp );
@proto_hcf100		TYPEDEF		PROTO C :IFBP, :FAR PTR LTV_STRCT
hcf_get_info		PROTO		@proto_hcf100

@proto_hcf101		TYPEDEF		PROTO C :IFBP, :wci_bufp, :WORD
hcf_service_nic		PROTO		@proto_hcf101

@proto_hcf102		TYPEDEF		PROTO C :IFBP, :hcf_16
hcf_cntl_port		PROTO		@proto_hcf102

@proto_hcf103		TYPEDEF		PROTO C :IFBP, :FAR PTR LTV_STRCT
hcf_put_info		PROTO		@proto_hcf103

@proto_hcf104		TYPEDEF		PROTO C :IFBP, :PTR DESC_STRCT, :WORD
hcf_rcv_msg		PROTO		@proto_hcf104

@proto_hcf105		TYPEDEF		PROTO C :IFBP, :PTR DESC_STRCT, :hcf_16
hcf_send_msg		PROTO		@proto_hcf105

; || defined DBG //;?DBG just to get NDIS going till we figure out what is really right
;  HCF_H 
; End of file c:/HCF/hcf.h
