
//   vim:tw=110:ts=4:
#ifndef HCF_H
#define HCF_H 1

/*************************************************************************************************************
*
* FILE	 : hcf.h *************** 2.0 *************************************************************************
*
* DATE   : $Date: 2003/05/30 11:34:03 $   $Revision: 1.1.1.1 $
*
* AUTHOR : Nico Valster
*
* DESC   : Definitions and Prototypes for MSF as well as HCF sources
*
*			Customizable via HCFCFG.H
*
*
**************************************************************************************************************
Instructions to convert HCF.H to HCF.INC by means of H2INC

Use a command line which defines the specific macros and command line options
needed to build the C-part, e.g. for the DOS ODI driver
		`h2inc /C /Ni /Zp /Zn hcf	 hcf.h`


**************************************************************************************************************
* COPYRIGHT (c) 1994 - 1995	by AT&T.	 			All Rights Reserved
* COPYRIGHT (c) 1996 - 2000 by Lucent Technologies.	All Rights Reserved
* COPYRIGHT (c) 2001 - 2003	by Agere Systems.		All Rights Reserved
*
* SOFTWARE LICENSE
*
* This software is provided subject to the following terms and conditions,
* which you should read carefully before using the software.  Using this
* software indicates your acceptance of these terms and conditions.  If you do
* not agree with these terms and conditions, do not use the software.
*
* Copyright  2003 Agere Systems Inc.
* All rights reserved.
*
* Redistribution and use in source or binary forms, with or without
* modifications, are permitted provided that the following conditions are met:
*
* . Redistributions of source code must retain the above copyright notice, this
*    list of conditions and the following Disclaimer as comments in the code as
*    well as in the documentation and/or other materials provided with the
*    distribution.
* 
* . Redistributions in binary form must reproduce the above copyright notice,
*    this list of conditions and the following Disclaimer in the documentation
*    and/or other materials provided with the distribution.
* 
* . Neither the name of Agere Systems Inc. nor the names of the contributors
*    may be used to endorse or promote products derived from this software
*    without specific prior written permission.
*
* Disclaimer
*
* THIS SOFTWARE IS PROVIDED AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, INFRINGEMENT AND THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  ANY
* USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE IS SOLELY AT THE USERS OWN
* RISK. IN NO EVENT SHALL AGERE SYSTEMS INC. OR CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, INCLUDING, BUT NOT LIMITED TO, CONTRACT, STRICT 
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
* OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
**************************************************************************************************************/


#include "hcfcfg.h"	// System Constants to be defined by the MSF-programmer to tailor the HCF
#include "mdd.h"	// Include file common for HCF, MSF, UIL, USF

/************************************************************************************************************/
/******************                                                  ****************************************/
/************************************************************************************************************/

// offsets Transmit/Receive Frame Structure
#define HFS_STAT				0x0000
#define HFS_SWSUP				0x0006		//SW Support
#define HFS_Q_INFO				0x0006		//Signal/Silence level
#define HFS_RATE				0x0008		//RxFlow/Rate
#define 	HFS_STAT_ERR		RX_STAT_ERR	//link "natural" HCF name to "natural" MSF name
#if HCF_TYPE & HCF_TYPE_HII
#define HFS_TX_CNTL				0x0036
#define HFS_ADDR_DEST			0x003A
#else
#define HFS_ADDR_DEST			0x002E
#if HCF_TYPE & HCF_TYPE_SSN
#define HFS_TX_CNTL				(HFS_ADDR_DEST - 2)
#else
#define HFS_TX_CNTL				0x000C
#endif // HCF_TYPE_SSN
#endif // HCF_TYPE										//	H-I		H-II
#define HFS_DAT_LEN				(HFS_ADDR_DEST - 2)		// 0x002C  0x0038
//		HFS_ADDR_DEST									   0x002E  0x003A	
#define HFS_ADDR_SRC			(HFS_ADDR_DEST + 6)		// 0x0034  0x0040
#define HFS_LEN					(HFS_ADDR_SRC  + 6)		// 0x003A  0x0046
#define HFS_DAT					(HFS_LEN       + 2)		// 0x003C  0x0048
#define HFS_TYPE				(HFS_DAT       + 6)		// 0x0042  0x004E

/*************************************************************************************************************/
/****************   H C F  F U N C T I O N   R E T U R N   C O D E S   ***************************************/
/*************************************************************************************************************/

//Debug Purposes only				!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//Hermes Event Register bit definitions
#define HREG_EV_TICK		0x8000	//Auxiliary Timer Tick
#define HREG_EV_RES			0x4000	//H/W error (Wait Time-out)
#define HREG_EV_INFO_DROP	0x2000	//WMAC did not have sufficient RAM to build Unsollicited Frame
#if (HCF_TYPE) & HCF_TYPE_HII
#define HREG_EV_REPAIR_ACK	0x1000	//Workaround Kludge bit for H-II (not H-II.5)
#else
#define HREG_EV_REPAIR_ACK	0x0000
#endif
#define HREG_EV_INFO		0x0080	//Asynchronous Information Frame
#define HREG_EV_CMD			0x0010	//Command completed, Status and Response available
#define HREG_EV_ALLOC		0x0008	//Asynchronous part of Allocation/Reclaim completed
#define HREG_EV_TX_EX		0x0004	//"Orthogonal" name for HREG_EV_TX_EXC (matches control field of TxFS)
//#define HREG_EV_TX_EXC	0x0004	//"Correct but discouraged": Asynchronous Transmission unsuccessful completed
#define HREG_EV_TX_OK		0x0002	//"Orthogonal" name for HREG_EV_TX (matches control field of TxFS)
//#define HREG_EV_TX		0x0002	//"Correct but discouraged": Asynchronous Transmission successful completed
#define HREG_EV_RX			0x0001	//Asynchronous Receive Frame

//=========================================  T A L L I E S  ===================================================

typedef struct CFG_HERMES_TALLIES_STRCT {  //Hermes Tallies (IFB substructure)
  hcf_32	TxUnicastFrames;
  hcf_32	TxMulticastFrames;
  hcf_32	TxFragments;
  hcf_32	TxUnicastOctets;
  hcf_32	TxMulticastOctets;
  hcf_32	TxDeferredTransmissions;
  hcf_32	TxSingleRetryFrames;
  hcf_32	TxMultipleRetryFrames;
  hcf_32	TxRetryLimitExceeded;
  hcf_32	TxDiscards;
  hcf_32	RxUnicastFrames;
  hcf_32	RxMulticastFrames;
  hcf_32	RxFragments;
  hcf_32	RxUnicastOctets;
  hcf_32	RxMulticastOctets;
  hcf_32	RxFCSErrors;
  hcf_32	RxDiscards_NoBuffer;
  hcf_32	TxDiscardsWrongSA;
  hcf_32	RxWEPUndecryptable;
  hcf_32	RxMsgInMsgFragments;
  hcf_32	RxMsgInBadMsgFragments;
  hcf_32	RxDiscards_WEPICVError;
  hcf_32	RxDiscards_WEPExcluded;
}CFG_HERMES_TALLIES_STRCT;

typedef struct CFG_HCF_TALLIES_STRCT {  //HCF Tallies (IFB substructure)
  hcf_32	not_used_NoBufInq;					//No buffer available reported by Inquiry command
  hcf_32	NoBufInfo;  				//No buffer available for unsolicited Notify frame
  hcf_32	NoBufMB;					//No space available in MailBox
  hcf_32	MiscErr;					/*Miscellaneous errors
  										@* time out on BAP Initialization
  										@* time out on Tx Frame Allocation
  										@* time out on AUX port En-/Disabling
  										@* time out on completion synchronous part Hermes Command
  										@* synchronously completed Hermes Command doesn't match original command
  										@* Request to put zero-length MailBox Info block
  										@* IFBTickIni based protection counter expired
  										 */
  hcf_32	EngCnt;						/*Engineering Count
  										@* Data Corruption Workaround catched
  										 */
  hcf_32	EngCnt0;						//*Engineering Count
  hcf_32	EngCnt1;						//*Engineering Count
  hcf_32	EngCnt2;						//*Engineering Count
  hcf_32	EngCnt3;						//*Engineering Count
  hcf_32	EngCnt4;						//*Engineering Count
}CFG_HCF_TALLIES_STRCT;


//Note this way to define CFG_TALLIES_STRCT_SIZE implies that all tallies must keep the same (hcf_32) size
#define		HCF_NIC_TAL_CNT	(sizeof(CFG_HERMES_TALLIES_STRCT)/ sizeof(hcf_32))
#define		HCF_HCF_TAL_CNT	(sizeof(CFG_HCF_TALLIES_STRCT)   / sizeof(hcf_32))
#define		HCF_TOT_TAL_CNT	(HCF_NIC_TAL_CNT + HCF_HCF_TAL_CNT)

/************************************************************************************************************/
/***********   W C I    F U N C T I O N S    P R O T O T Y P E S   ******************************************/
/************************************************************************************************************/

#define IFB_VERSION 0x0A	 			/* initially 0, to be incremented by every IFB layout change		*/


/* identifier IFB_STRCT on typedef line needed to get the individual fields in the MS Browser DataBase		*/
typedef struct IFB_STRCT{               //I/F Block
/************************************************************************************************************/
/* part I (survives init)  ************************************************************************/
/************************************************************************************************************/
//  hcf_16		len;					/* using LTV form means displacing IFB_IOBase from offset 0 	*/
//  hcf_16		typ;					/* this carries a penalty of 56 bytes in code size for DOS ODI	*/
//  hcf_io		IFB_IOBase;				/* I/O address of Hermes chip as passed by MSF at hcf_connect call	*/
  hcf_32		IFB_IOBase;				/* I/O address of Hermes chip as passed by MSF at hcf_connect call	*/
#if ! defined HCF_MEM_IO
//  hcf_16		IFB_IOBase_pad;			// Optional field, makes IFB-layout independent of IFB_IOBase size
#endif //HCF_PORT_IO
  hcf_16		IFB_IORange;			// I/O Range used by Hermes chip
  hcf_8			IFB_Version;			/* initially 0, incremented by every SIGNIFICANT IFB layout change	*/
  hcf_8			IFB_Slack_2[3];			/* align/slack space, minimizes impact of:
										 *  - IFB definition changes over time
										 *  - fields which depend on compile time options */
#if defined HINC						//to make Microsoft H2INC conversion programming happy 
  hcf_32		IFB_NIC_Tallies[HCF_NIC_TAL_CNT];	//Hermes tallies
  hcf_32		IFB_HCF_Tallies[HCF_HCF_TAL_CNT];	//HCF tallies
#else
  CFG_HERMES_TALLIES_STRCT	IFB_NIC_Tallies;		//Hermes tallies
  CFG_HCF_TALLIES_STRCT		IFB_HCF_Tallies;		//HCF tallies
#endif // HINC 
  hcf_16		IFB_CardStat;			/*                													*/
  hcf_16 		IFB_PortStat;			// bit flags representing individual enabled ports
  hcf_16		IFB_TraceLvl;			// filter for use in TRACE/TRACE_VALUE macros set
  hcf_16 FAR   *IFB_MBp;				/*                													*/
  hcf_16		IFB_MBSize;				/*                												 	*/
  hcf_16		IFB_MBWp;				/*                													*/
  hcf_16		IFB_MBRp;				/*                													*/
  hcf_16		IFB_MBInfoLen;			/*                													*/
  hcf_16		IFB_DLMode;				// Download Mode state
#if defined HCF_INT_ON
  hcf_16		IFB_IntOffCnt;			/*                													*/
#else
  hcf_16		IFB_Slack_4;
#endif // HCF_INT_ON
  hcf_32	 	IFB_TickIni;			/* initialization of S/W counter based protection loop
  										 * Note that via IFB_DefunctStat time outs in cmd_wait and in
  										 * hcfio_string block all Hermes access till the next init
  										 * so functions which call a mix of cmd_wait and hcfio_string only
  										 * need to check the return status of the last call					*/
  hcf_16		IFB_Magic;				/*                													*/
#if HCF_ASSERT
  MSF_ASSERT_RTNP	IFB_AssertRtn;		// MSF Assert Call back routine (inspired by GEF, DrDobbs Nov 1998 )
  hcf_16		IFB_AssertLvl;			// Assert Filtering, Not yet implemented
  hcf_16		IFB_AssertWhere;		/* Where parameter of the Assert macro								*/
  hcf_16		IFB_AssertTrace;		/* bit based trace off all hcf_.... invocations						*/
#else
  hcf_16		IFB_Slack_5[5];
#endif //HCF_ASSERT
#if (( ( HCF_TYPE ) & HCF_TYPE_HII ) && (( HCF_TYPE ) & HCF_TYPE_USB ) )
  USB_IO_PTR	IFB_USBIOp;				// USB base pointer for device I/O structure 
#endif
  RID_LOGP		IFB_RIDLogp;			// pointer to RID_LOG structure
  void FAR	   *IFB_MSFSup;				// pointer for arbitrary use by the MSF
  hcf_16		IFB_Monitor;			/* Monitor capture length											*/
#if (HCF_TYPE) &HCF_TYPE_USB
  hcf_16		IFB_Slack_8;
#else
  hcf_16  		IFB_RscInd;				/*																	*/
#endif // HCF_TYPE_USB
  hcf_16		IFB_Slack_10[2];
  hcf_16		IFB_Cmd;				/* cmd in progress, to be ack-ed etc before next cmd can be issued	*/
  hcf_16		IFB_RxFID;				/*                													*/
#if (HCF_TYPE) & HCF_TYPE_USB
  hcf_16		IFB_Slack_12;
#else
  hcf_16		IFB_MB_FID;				/* pass appropriate FID to hcf_put_mb_info							*/
#endif //HCF_TYPE_USB
  hcf_16		IFB_TxFid;				/* fid storage during "delayed" send								*/
  hcf_16		IFB_RxLen;				/*                													*/
  hcf_16		IFB_Slack_16[8];
  /* the fields after this text must stay concatenated because of their (mis-)use as LTV record				*/
  hcf_16		IFB_DLTarget[2];		// 32-bits (don't confuse with FAR) Pointer to NV-RAM download target
#if defined HCF_DLNV			
  hcf_16		IFB_DLPage;				/* Download Buffer Page, must be concatenated with IFB_DLTarget		*/
  hcf_16		IFB_DLOffset;			/* Download Buffer Offset, must be concatenated with IFB_DLPage		*/
  hcf_16		IFB_DLLen;				/* Download Buffer Length, must be concatenated with IFB_DLOffset	*/
#else
  hcf_16		IFB_Slack_18[3];
#endif //HCF_DLNV
  /* the fields above this text must stay concatenated because of their (mis-)use as LTV record				*/
#if defined HCF_INT_ON
  hcf_16		IFB_IntEnMask;			/*                													*/
#else
  hcf_16		IFB_Slack_24;
#endif // HCF_INT_ON
  hcf_16		IFB_DefunctStat;		/* BAP initialization or Cmd Completion failed once
  										 * see remark at IFB_TickIni definition								*/
  hcf_16		IFB_ErrCmd;				// contents Status reg when error bits and/or mismatch in cmd_wait
  hcf_16		IFB_ErrQualifier;		// contents Resp0  reg when error bits and/or mismatch in cmd_wait
//hcf_16		IFB_EngFlg;				/* Engineering Flags
//  										 *	0x0001	WMP filtering on PDU type								*/
  hcf_16		IFB_Slack_26[2];
  hcf_16		IFB_lal;				/* LookAhead Length												*/
  wci_bufp		IFB_lap;				/* LookAhead Buffer pointer											*/
  hcf_16		IFB_LinkStat;			/* Link Status
										 * 1 Connected, 2 Disconnected,
										 * 3 AP change, 4 AP out of range, 5 AP in range					*/
  CFG_NIC_HSI_SUP_RANGE_STRCT	IFB_HSISup;
  CFG_PRI_IDENTITY_STRCT	IFB_PRIIdentity;
  CFG_PRI_SUP_RANGE_STRCT	IFB_PRISup;
  CFG_FW_IDENTITY_STRCT		IFB_FWIdentity;
  CFG_FW_SUP_RANGE_STRCT	IFB_FWSup;
  //;? remove the obsolete *Cfg fields 
//hcf_16		IFB_PRICfg;				// Primary		Top/Bottom Supplier Range
//hcf_16		IFB_HSICfg;				// H/W-S/W I/F	Top/Bottom Supplier Range
  hcf_16		IFB_STACfg;				// Station		Top/Bottom Supplier Range
  hcf_16		IFB_UBICfg;				// USB Converter Board	Top/Bottom Supplier Range
  hcf_16		IFB_UDICfg;				// USB Bootloader		Top/Bottom Supplier Range
#if 0 // (HCF_TYPE) == HCF_TYPE_STA 
  hcf_16		IFB_WarningInfo[2];		/* [0] HCF controlled warning bits
  										 *	0 - 0x0001 : Power management
  										 *  0 - 0x0002 : unused
  										 :
  										 *  0 - 0x8000 : unused
  										 * [1] MSF controlled warning bits
  										 */
#else
  hcf_16		IFB_Slack_28[2];
#endif // HCF_TYPE_STA
#if HCF_TYPE & HCF_TYPE_SSN  
  hcf_16		IFB_MICKey[1+4*(4+4)];	/* index of default key in MICKey array 
  										 * 4 times 1 calculating and 1 checking MIC key */
  hcf_8			IFB_MICRx[8]; 	 		//Rx MIC calculation Engine state 
  hcf_8			IFB_MICTx[8];   	  	//Tx MIC calculation Engine state 
#else
  hcf_16		IFB_Slack_40;
  hcf_16		IFB_Slack_41[4*(4+4)];
  hcf_8			IFB_Slack_42[8];
  hcf_8			IFB_Slack_43[8];
#endif // HCF_TYPE_SSN  
  void (*IFB_MICRxRtn)( hcf_32*, hcf_32 );		//dummy routine or Rx MIC calculation engine
  void (*IFB_MICTxRtn)( hcf_32*, hcf_32 );		//dummy routine or Tx MIC calculation engine
  hcf_16		IFB_rx_tlen;			//temp length, carries over from one Rx fragment to another
  hcf_16		IFB_tx_tlen;			//temp length, carries over from one Tx fragment to another
  hcf_8			IFB_rx_32[4];			//temp byte accumulator, carry over from one fragment to next
  hcf_8			IFB_tx_32[4];			//temp byte accumulator, carry over from one fragment to next
}IFB_STRCT;


//#define offsetof(s,m)   (size_t)&(((s *)0)->m)
//#define IFB_CARDSTAT_OFFSET offsetof( IFB_STRCT, IFB_CardStat )	//Debug convenience: 1st field after Tallies



typedef struct ASSERT_STRCT {
	hcf_16	len;					//length of assert_strct
	hcf_16	trace;					//trace log copy from IFB
	hcf_16	qualifier;				//qualifier from entry parameter
	hcf_16	line_number;			//line number from entry parameter
	char val[1];
} ASSERT_STRCT;

typedef struct DESC_STRCT{
	union {
		hcf_32				cntl_stat;
		hcf_16				buf_dim[2];				// 0: cnt, 1: size
	} buf_cntl;
	hcf_32					buf_phys_addr;
	hcf_32					next_desc_phys_addr;
	struct DESC_STRCT FAR	*next_desc_addr;
	hcf_8	FAR				*buf_addr;
} DESC_STRCT;


typedef IFB_STRCT*	IFBP;


EXTERN_C int	hcf_action			(IFBP ifbp, hcf_16 cmd );
#if (( ( HCF_TYPE ) & HCF_TYPE_HII ) && (( HCF_TYPE ) & HCF_TYPE_USB ) )
EXTERN_C int	hcf_connect			(IFBP ifbp, USB_HANDLE usb_handle  );
#else
EXTERN_C int	hcf_connect			(IFBP ifbp, hcf_io io_base );
#endif
//EXTERN_C void	hcf_disconnect		(IFBP ifbp );
#define hcf_disconnect( ifbp ) hcf_connect( ifbp, 0 )
#if HCF_ENCAPSULATION == 0x0002
EXTERN_C hcf_8 	hcf_encap			(wci_bufp type );
#endif // HCF_ENCAPSULATION
EXTERN_C int	hcf_get_info		(IFBP ifbp, LTVP ltvp );
EXTERN_C int	hcf_service_nic		(IFBP ifbp, wci_bufp bufp, unsigned int len );
EXTERN_C int	hcf_cntl_port		(IFBP ifbp, hcf_16 port );
EXTERN_C int	hcf_put_info		(IFBP ifbp, LTVP ltvp );
EXTERN_C int 	hcf_rcv_msg			(IFBP ifbp, DESC_STRCT *descp, unsigned int offset );
EXTERN_C int 	hcf_send_msg       	(IFBP ifbp, DESC_STRCT *dp, hcf_16 tx_cntl );
#if HCF_ASSERT //|| defined DBG //;?DBG just to get NDIS going till we figure out what is really right
EXTERN_C void	msf_assert 			(wci_bufp file_namep, unsigned int line_number, hcf_16 trace, int qual );
#endif //HCF_ASSERT


#endif  /* HCF_H */

