
//   vim:tw=110:ts=4:
#ifndef HCFCFG_H
#define HCFCFG_H 1

/**************************************************************************************************************
*
* FILE	 : hcfcfg.tpl // hcfcfg.h **************************** 2.0 ********************************************
*
* DATE   : $Date: 2003/05/30 11:34:03 $   $Revision: 1.1.1.1 $
*
* AUTHOR : Nico Valster
*
* DESC   : HCF Customization Macros
*
***************************************************************************************************************
* COPYRIGHT (c) 1994 - 1995	by AT&T.	 			All Rights Reserved
* COPYRIGHT (c) 1996 - 2000 by Lucent Technologies.	All Rights Reserved
* COPYRIGHT (c) 2001 - 2003	by Agere Systems.		All Rights Reserved
***************************************************************************************************************
*
* hcfcfg.tpl list all #defines which must be specified to:
*    I:	adjust the HCF functions defined in HCF.CPP to the characteristics of a specific environment
* 		o maximum sizes for messages and notification frames, persistent configuration storage
* 		o Endianess
*
*	II:	Compiler specific macros
* 		o port I/O macros
* 		o type definitions
*
*  III:	Environment specific ASSERT macro
*
*   IV: Compiler specific
*
*    V: ;? specific
*
*
* By copying HCFCFG.TPL to HCFCFG.H and -if needed- modifying the #defines the WCI functionality can be
* tailored
*
* Supported environments:
WVLAN_41	Miniport                                NDIS 3.1
WVLAN_42	Packet                                	Microsoft Visual C 1.5
WVLAN_43	16 bits DOS ODI                      	Microsoft Visual C 1.5
WVLAN_44	32 bits ODI (__NETWARE_386__)			WATCOM
WVLAN_45	MAC_OS									MPW?, Symantec?
WVLAN_46	Windows CE (_WIN32_WCE)					Microsoft ?
WVLAN_47	LINUX  (__LINUX__)						GCC
WVLAN_48	Miniport                                NDIS 5
WVLAN_51	Miniport USB                            NDIS 5
WVLAN_52	Miniport 		                        NDIS 4
WVLAN_53	VxWorks END Station driver
WVLAN_54	VxWorks END Access Point driver
WVLAN_81	WavePoint								BORLAND C
WCITST		Inhouse test tool						Microsoft Visual C 1.5
WSU			WaveLAN Station Update					Microsoft Visual C ??
SCO UNIX	not yet actually used ?					?
__ppc		OEM supplied							?
_AM29K		OEM supplied							?
?			OEM supplied							Microtec Research 80X86 Compiler

* T O   D O :  A D D   A   R E C I P E   H O W  T O   M O D I F Y  HCFCFG.H
*
**************************************************************************************************************/


/****************************************************************************
*
* CHANGE HISTORY
*

  960702 - NV
	Original Entry - derived from HCF 2.12
*************************************************************************************************/



/*****************************    IN_PORT_STRING  S a m p l e s ***************************************************

		// C implementation which let the processor handle the word-at-byte-boundary problem
#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16 FAR*)dst = IN_PORT_WORD( prt ); dst += 2; }


		// C implementation which handles the word-at-byte-boundary problem 
#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { int i = IN_PORT_WORD( prt ); *dst++ = (char)i; *dst++ = (char)(i >> 8); }


		// Assembler implementation
#define IN_PORT_STRING( port, dest, len) __asm 		\
{													\
	__asm push di                               	\
	__asm push es                                 	\
	__asm mov cx,len                            	\
	__asm les di,dest                           	\
	__asm mov dx,port                           	\
	__asm rep insw                              	\
	__asm pop es	                            	\
	__asm pop di	                            	\
}

       
******************************************************************************************************************/


/*****************************   OUT_PORT_STRING  S a m p l e s ***************************************************
       
		// C implementation which let the processor handle the word-at-byte-boundary problem
#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16 FAR*)src ) ; src  += 2; }


		// C implementation which handles the word-at-byte-boundary problem 
#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *src | *(src+1)<<8  ) ; src  += 2; }
//;?  WHY hcf_16 FAR*)src and not unsigned char FAR*)src


												// Assembler implementation
#define OUT_PORT_STRING( port, src, len) __asm		\
{                                               	\
	__asm push si                                 	\
	__asm push ds                                 	\
	__asm mov cx,len                              	\
	__asm lds si,src                             	\
	__asm mov dx,port                             	\
	__asm rep outsw	                            	\
	__asm pop ds                                  	\
	__asm pop si                                  	\
}

******************************************************************************************************************/


/*  * * * * * * * * * * * * * * * * * * * * * *  I * * * * * * * * * * * * * * * * * * * * * * */

/*	Alignment
 *	Some platforms can access words on odd boundaries (with possibly an performance impact), at other
 *	platforms such an access may result in a memory access violation.
 *	It is assumed that everywhere where the HCF casts a char pointer into a word pointer, the
 *	alignment criteria are met. This put some restrictions on the MSF, which are assumed to be
 *	"automatically" fulfilled at the applicable platforms
 *	To assert this assumption, the macro HCF_ALIGN can be defined. The default value is 0, meaning no
 *	alignment, a value of 2 means word alignment, other values are invalid
 */

/*  * * * * * * * * * * * * * * * * * * * * * * II * * * * * * * * * * * * * * * * * * * * * * */



/************************************************************************************************/
/******************  C O M P I L E R   S P E C I F I C   M A C R O S  ***************************/
/************************************************************************************************/
/*************************************************************************************************
*
* The platforms supported by this version are:
*	- Microsoft Visual C 1.5 (16 bits platform)
*	- Microsoft Visual C 2.0 (32 bits platform)
*	- Watcom C/C++ 9.5
*	- SCO UNIX
*
* In this version of hcfiocfg.tpl all macros except the MSVC 1.5 versions are either dependent on
* compiler/environment supplied macros (e.g. _MSC_VER or "def-ed out"
*
* By selecting the appropriate Macro definitions by means of modifying the
* "#ifdef 0/1" lines, the HCF can be adjusted for the I/O characteristics of
* a specific compiler
*
* If needed the macros can be modified or replaced with definitions appropriate
* for your personal platform
* If you need to make such changes it is appreciated if you inform Lucent Technologies WCND Utrecht
* That way the changes can become part of the next release of the WCI
*
*
*	The prototypes and functional description of the macros are:
*
*	hcf_16	IN_PORT_WORD(  hcf_16 port)
*			Reads a word (16 bits) from the specified port
*
*	void	OUT_PORT_WORD( hcf_16 port, hcf_16 value)
*			Writes a word (16 bits) to the specified port
*
*	void	IN_PORT_STRING( port, dest, len)
*			Reads len number of words from the specified port to the (FAR) address dest in PC-RAM
*			Note that len specifies the number of words, NOT the number of bytes
*			!!!NOTE, although len specifies the number of words, dest MUST be a char pointer NOTE!!!
*			See also the common notes for IN_PORT_STRING and OUT_PORT_STRING
*
*	void	OUT_PORT_STRING( port, src, len)
*			Writes len number of words from the (FAR) address src in PC-RAM to the specified port
*			Note that len specifies the number of words, NOT the number of bytes.
*			!!!NOTE, although len specifies the number of words, src MUST be a char pointer NOTE!!!
*
*			The peculiar combination of word-length and char pointers for IN_PORT_STRING as well as
*			OUT_PORT_STRING is justified by the assumption that it offers a more optimal algorithm
*
*			Note to the HCF-implementor:
*			Due to the passing of the parameters to compiler specific blabla.........
*			do not use "expressions" as parameters, e.g. don't use "ifbp->IFB_IOBase + HREG_AUX_DATA" but
*			assign this to a temporary variable.
*
*
*  NOTE!!	For convenience of the MSF-programmer, all {IN|OUT}_PORT_{BYTE|WORD|STRING} macros are allowed to
*			modify their parameters (although some might argue that this would constitute bad coding
*			practice). This has its implications on the HCF, e.g. as a consequence these macros should not
*			be called with parameters which have side effects, e.g auto-increment.
*
*  NOTE!!	in the Microsoft implementation of inline assembly it is O.K. to corrupt all flags except
*			the direction flag and to corrupt all registers except the segment registers and EDI, ESI,
*			ESP and EBP (or their 16 bits equivalents).
*			Other environments may have other constraints
*
*  NOTE!!	in the Intel environment it is O.K to have a word (as a 16 bits quantity) at a byte boundary,
*			hence IN_/OUT_PORT_STRING can move words between PC-memory and NIC-memory with as only
*			constraint that the words are on a word boundary in NIC-memory. This does not hold true
*			for all conceivable environments, e.g. an Motorola 68xxx does not allow this, in other
*			words whenever there is a move from address in 2*n in one memory type to address 2*m+1 in the
*			other type, the current templates for IN_/OUT_PORT_STRING are unsuitable. Probably the
*			boundary conditions imposed by these type of platforms prevent this case from materializing
*
*************************************************************************************************/

// Note:
// Visual C++ 1.5 : _MSC_VER ==  800
// Visual C++ 4.0 : _MSC_VER == 1000
// Visual C++ 4.2 : _MSC_VER == 1020

typedef unsigned char				hcf_8;
typedef unsigned short				hcf_16;
typedef unsigned long				hcf_32;


/****************************** #define HCF_TYPE ******************************/
//#define HCF_TYPE_HI_PRE_SSN	0x0000	// Hermes-I F/W without SSN support
#define HCF_TYPE_SSN		0x0001	// SSN support
#define HCF_TYPE_USB		0x0002	// Host side for Internally developed USB Dongle driver support
#define HCF_TYPE_HII		0x0004	// Hermes-II
#define HCF_TYPE_AP 		0x0010	// Access Point
#define HCF_TYPE_STA		0x0020	// Station
#define HCF_TYPE_PRELOADED	0x0040	// (Hermes-II) pre-loaded F/W

/************************************************************************************************/
/******************************  M I N I P O R T    N D I S  3.1  *******************************/
/************************************************************************************************/

#if defined WVLAN_41

#define HCF_DLV 

#define	MSF_COMPONENT_ID			COMP_ID_MINIPORT_NDIS_31
#ifndef _APIDLL
#include <ndis.h>
#endif
#include <version.h>

#ifdef HERMES2
#define	MSF_COMPONENT_VAR			3
#define	HCF_TYPE (HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_HII)
#else
#define	MSF_COMPONENT_VAR			1
#ifdef _WPA
#define	HCF_TYPE (HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_SSN)
#define HCF_CFG_STA_1_BOTTOM        16
#else // _WPA
#define	HCF_TYPE (HCF_TYPE_AP|HCF_TYPE_STA)
#define HCF_CFG_STA_1_BOTTOM        12
#endif // _WPA
#endif // HERMES2
#define	MSF_COMPONENT_MAJOR_VER		TPI_MAJOR_VERSION
#define	MSF_COMPONENT_MINOR_VER		TPI_MINOR_VERSION

#ifndef _APIDLL
__inline UCHAR NDIS_IN_BYTE( ULONG port )
{
    UCHAR value;
    NdisRawReadPortUchar(port , &value);
    return (value);
}

__inline USHORT NDIS_IN_WORD( ULONG port )
{
    USHORT value;
    NdisRawReadPortUshort(port , &value);
    return (value);
}

#define IN_PORT_WORD(port)			NDIS_IN_WORD( (ULONG) (port) )
#define OUT_PORT_WORD(port, value)	NdisRawWritePortUshort((ULONG) (port) , (USHORT) (value))

#define IN_PORT_STRING(port, addr, len)		NdisRawReadPortBufferUshort(port, addr, (len));
#define OUT_PORT_STRING(port, addr, len)	NdisRawWritePortBufferUshort(port, addr, (len));

#endif //_APIDLL

#if defined _DEBUG || (defined DBG && DBG != 0)
#define HCF_ASSERT                  1
#endif // _DEBUG || DBG

#endif	/* WVLAN_41 MINIPORT 3.1 */

/************************************************************************************************/
/****************************  P A C K E T   D R I V E R  ***************************************/
/**********************************  D O S   O D I  *********************************************/
/************************************************************************************************/

#if defined WVLAN_42 || defined WVLAN_43 
#if defined WVLAN_42 

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ To ease testing the different options ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define HCF_TYPE (HCF_TYPE_STA | HCF_TYPE_SSN )		// Hermes-I F/W with SSN support
//#define HCF_TYPE (HCF_TYPE_STA | HCF_TYPE_USB	)		// Host side for Internally developed USB Dongle driver support
//#define HCF_TYPE (HCF_TYPE_STA | HCF_TYPE_HII | HCF_TYPE_PRELOADED )		// Hermes-II
//#define HCF_TYPE HCF_TYPE_STA							// Hermes-I F/W without SSN support
#endif //WVLAN_42

//#undef  HCF_ASSERT	//;?temporarily while chasing the double definition
//#define HCF_ASSERT    0x0002			//assert (also) via S/W Supp Register
//#define HCF_ASSERT    0x0004			//assert (also) in Mailbox
//#define HCF_ASSERT	0x8000			//link msf_assert routine statically

//#define HCF_ENCAPSULATION 0
//#define HCF_MB_OFF
//#define HCF_INT_OFF
//out-of-date #define HCF_CARD_CHECK_OFF
#define HCF_EX_INT (HCF_EX_INT_TX_EX|HCF_EX_INT_TX_OK)	//log transmissions in Mailbox
#define HCF_TX_NOTIFY			HCF_EX_INT	////just to investigate the Intermec observations
//#define HCF_ALIGN 2			
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ To ease testing the different options ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#pragma warning ( disable: 4001 )
										
#if defined WVLAN_43
#define	MSF_COMPONENT_ID			COMP_ID_ODI_16
#define	MSF_COMPONENT_VAR			1
#define	MSF_COMPONENT_MAJOR_VER		6
#define	MSF_COMPONENT_MINOR_VER		10

#elif defined WVLAN_42
#define	MSF_COMPONENT_ID			COMP_ID_PACKET
#define	MSF_COMPONENT_VAR			1
#define	MSF_COMPONENT_MAJOR_VER		6
#define	MSF_COMPONENT_MINOR_VER		12
#endif //WVLAN_xx

#define HCF_MAX_GROUP		16		// number of Multicast Addresses supported by ODI/Packet
										
#define FAR  __far					// segmented 16 bits mode
#define BASED __based(__segname("_CODE"))

#ifndef H_2_INC 
#include <stdio.h>
#include <conio.h>
//#ifndef _DEBUG
#pragma intrinsic( _inp, _inpw, _outp, _outpw )
//#endif // _DEBUG

#define IN_PORT_WORD(port)			((hcf_16)_inpw( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	((void)_outpw( (hcf_io)(port), value ))

#if 0		// C implementation which let the processor handle the word-at-byte-boundary problem
#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16 FAR*)dst = IN_PORT_WORD( prt ); dst += 2; }
#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16 FAR*)src ) ; src  += 2; }
//#elif 0		// C implementation which handles the word-at-byte-boundary problem 
//#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { int i = IN_PORT_WORD( prt ); *dst++ = (char)i; *dst++ = (char)(i >> 8); }
//#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *src | *(src+1)<<8  ) ; src  += 2; }
////;?  WHY hcf_16 FAR*)src and not unsigned char FAR*)src
#else												// Assembler implementation
#define IN_PORT_STRING( port, dest, len) __asm 		\
{													\
	__asm push di                               	\
	__asm push es                                 	\
	__asm mov cx,len                            	\
	__asm les di,dest                           	\
	__asm mov dx,port                           	\
	__asm rep insw                              	\
	__asm pop es	                            	\
	__asm pop di	                            	\
}

#define OUT_PORT_STRING( port, src, len) __asm		\
{                                               	\
	__asm push si                                 	\
	__asm push ds                                 	\
	__asm mov cx,len                              	\
	__asm lds si,src                             	\
	__asm mov dx,port                             	\
	__asm rep outsw	                            	\
	__asm pop ds                                  	\
	__asm pop si                                  	\
}

#endif	// Asm or C implementation
#endif // H_2_INC 

#endif	/* WVLAN_43, WVLAN_42 (DOS ODI, Packet Driver) */



/************************************************************************************************/
/****************************  D O S  H - II  L O A D E R  **************************************/
/************************************************************************************************/

#if defined H2_LDR || defined H1_LDR

#if defined H2_LDR 
#define HCF_TYPE (HCF_TYPE_STA | HCF_TYPE_HII )		// Hermes-II
#else
#define HCF_TYPE (HCF_TYPE_STA )					// Hermes-I
#endif 

#define HCF_ASSERT    0x0004			//assert (also) in Mailbox

#define HCF_ENCAPSULATION 0
#define HCF_MB_OFF
#define HCF_INT_OFF
//out-of-date #define HCF_CARD_CHECK_OFF

#define	MSF_COMPONENT_ID			COMP_ID_ODI_16 //;?By lack of any better
#define	MSF_COMPONENT_VAR			1
#define	MSF_COMPONENT_MAJOR_VER		0
#define	MSF_COMPONENT_MINOR_VER		0

#define FAR 
#define BASED

#include <stdio.h>
#include <conio.h>
#pragma intrinsic( _inp, _inpw, _outp, _outpw )

#define IN_PORT_WORD(port)			((hcf_16)_inpw( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	((void)_outpw( (hcf_io)(port), value ))

#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16 FAR*)dst = IN_PORT_WORD( prt ); dst += 2; }
#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16 FAR*)src ) ; src  += 2; }

#endif	// H2_LDR //H1_LDR


/************************************************************************************************/
/****************************  N E T W A R E   3 8 6  *******************************************/
/************************************************************************************************/

#if defined  __NETWARE_386__	/* WVLAN_44, WATCOM */

#define	MSF_COMPONENT_ID			COMP_ID_ODI_32

#include <conio.h>

//#define CNV_LITTLE_TO_INT(x) (x)			// No endianess conversion needed

#define IN_PORT_WORD(port)			(inpw( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	(outpw( (hcf_io)(port), value ))

//#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16*)dst = IN_PORT_WORD( prt ); dst += 2; }
//#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16*)src ) ; src  += 2; }

#endif	// WVLAN_44, __NETWARE_386__


/************************************************************************************************/
/***********************************  M A C  O S   **********************************************/
/************************************************************************************************/

            	    	/**********/
#if defined WVLAN_45    /* MAC_OS */
                		/**********/
#include "Version.h"

#define MSF_COMPONENT_ID            COMP_ID_MAC_OS
#define MSF_COMPONENT_VAR           VARIANT
#define MSF_COMPONENT_MAJOR_VER     VERSION_MAJOR
#define MSF_COMPONENT_MINOR_VER     VERSION_MINOR

#define MAC_OS                      1

#define HCF_BIG_ENDIAN              // selects Big Endian (a.k.a. Motorola), most significant byte first

#if defined(DEBUG)
#define HCF_ASSERT                  1
#endif // DEBUG

#ifdef  __cplusplus
extern "C" {
#endif
extern volatile unsigned char *MacIOaddr;
extern hcf_16 IN_PORT_WORD(hcf_16 port);
extern void   OUT_PORT_WORD(hcf_16 port, hcf_16 value);
extern void   IN_PORT_STRING(hcf_16 port, void *dest, hcf_16 len);
extern void   OUT_PORT_STRING(hcf_16 port, void *src, hcf_16 len);

#define SwapBytes(t)    (((t) >> 8) + (((t) & 0xff) << 8))

#ifdef  __cplusplus
}
#endif

#endif  /* WVLAN_45, MAC_OS */

/************************************************************************************************/
/***********************************  W I N C E *************************************************/
/************************************************************************************************/

                  /*******************/
#ifdef _WIN32_WCE /* WVLAN_46, WINCE */
                  /*******************/
#define HCF_INTERFACE_CONNECT(ifbp)		//InitializeCriticalSection(&(ifbp->IFB_CritSec));
#define HCF_INTERFACE_DISCONNECT(ifbp)		//DeleteCriticalSection(&(ifbp->IFB_CritSec));
#define HCF_ENTER_INTERFACE_FUNCT(ibfb)		//EnterCriticalSection(&(ifbp->IFB_CritSec));
#define HCF_LEAVE_INTERFACE_FUNCT(ifbp)		//LeaveCriticalSection(&(ifbp->IFB_CritSec));

#define HCF_DLV
#define HCF_INT_ON

#define HCF_ALIGN 2	
#define HCF_MEM_IO					// overrule standard Port I/O with Memory mapped I/O

#define	MSF_COMPONENT_ID			COMP_ID_WIN_CE
#define HCF_STA						//station characteristics
#define HCF_AP

#include "..\wl_ndis\version.h"
#include <windows.h>
#include <winnt.h>



#ifdef NDIS51_MINIPORT
#ifdef HERMES2
#define	MSF_COMPONENT_VAR			4
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_HII)
#else // HERMES2
#define	MSF_COMPONENT_VAR			2
#ifdef _WPA
#define	HCF_TYPE                    (HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_SSN)
#define HCF_CFG_STA_1_BOTTOM        16
#else // _WPA
#define HCF_CFG_STA_1_BOTTOM        12
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA)
#endif // _WPA
#endif // HERMES2
#else // NDIS51_MINIPORT
#ifdef HERMES2
#define	MSF_COMPONENT_VAR			3
#define	HCF_TYPE (HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_HII)
#else // HERMES2
#define	MSF_COMPONENT_VAR			1
#ifdef _WPA
#define	HCF_TYPE                    (HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_SSN)
#define HCF_CFG_STA_1_BOTTOM        16
#else // _WPA
#define HCF_CFG_STA_1_BOTTOM        12
#define	HCF_TYPE (HCF_TYPE_AP|HCF_TYPE_STA)
#endif // _WPA
#endif // HERMES2
#endif // NDIS51_MINIPORT



#define	MSF_COMPONENT_MAJOR_VER		TPI_MAJOR_VERSION
#define	MSF_COMPONENT_MINOR_VER		TPI_MINOR_VERSION


#define HCF_CFG_STA_1_BOTTOM        12


#if defined(DEBUG) || defined(_DEBUG) || defined(DBG)
#define HCF_ASSERT                  1
#endif // DEBUG || _DEBUG || DBG

//
extern hcf_8  IN_PORT_BYTE(hcf_32 port);
extern void   OUT_PORT_BYTE(hcf_32 port, hcf_8 value);
extern hcf_16 IN_PORT_WORD(hcf_32 port);
extern void   OUT_PORT_WORD(hcf_32 port, hcf_16 value);
extern void   IN_PORT_STRING(hcf_32 port, void *dest, hcf_16 len);
extern void   OUT_PORT_STRING(hcf_32 port, void *src, hcf_16 len);

#endif	/* WVLAN_46, _WIN32_WCE */


/************************************************************************************************/
/******************************************  L I N U X  *****************************************/
/************************************************************************************************/

#if defined WVLAN_47 || defined WVLAN_49

#if defined WVLAN_47
#define	MSF_COMPONENT_ID	COMP_ID_LINUX_PD
#endif // WVLAN_47
#if defined WVLAN_49
#define	MSF_COMPONENT_ID	COMP_ID_LINUX_LIB
#endif // WVLAN_49

#define	MSF_COMPONENT_VAR			1

#define __NO_VERSION__				//define kernel version only in MSF47 / MSF
#include <linux/module.h>
#include <asm/io.h>
#include <linux/types.h>

#define IN_PORT_WORD(port)			((hcf_16)inw( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	(outw( (hcf_16) (value), (hcf_io)(port) ))
#define IN_PORT_STRING(port, dst, n)	(insw((hcf_io)(port), dst, n))
#define OUT_PORT_STRING(port, src, n)	(outsw((hcf_io)(port), src, n))

#endif	/* LINUX */


/************************************************************************************************/
/******************************  M I N I P O R T    N D I S  5.0 / 5.1 **************************/
/************************************************************************************************/

#if defined WVLAN_48 && !defined(_WIN32_WCE)

#define HCF_DLV 


#define	MSF_COMPONENT_ID			COMP_ID_MINIPORT_NDIS_50

#ifndef _APIDLL
#include <ndis.h>
#endif
#include <version.h>


#ifdef NDIS51_MINIPORT
#ifdef HERMES2
#define	MSF_COMPONENT_VAR			4
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_HII)
#else // HERMES2
#define	MSF_COMPONENT_VAR			2
#ifdef _WPA
#define	HCF_TYPE                    (HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_SSN)
#define HCF_CFG_STA_1_BOTTOM        16
#else // _WPA
#define HCF_CFG_STA_1_BOTTOM        12
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA)
#endif // _WPA
#endif // HERMES2
#else // NDIS51_MINIPORT
#ifdef HERMES2
#define	MSF_COMPONENT_VAR			3
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_HII)
#else // HERMES2
#define	MSF_COMPONENT_VAR			1
#ifdef _WPA
#define	HCF_TYPE                    (HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_SSN)
#define HCF_CFG_STA_1_BOTTOM        16
#else // _WPA
#define HCF_CFG_STA_1_BOTTOM        12
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA)
#endif // _WPA
#endif // HERMES2
#endif // NDIS51_MINIPORT

#define	MSF_COMPONENT_MAJOR_VER		TPI_MAJOR_VERSION
#define	MSF_COMPONENT_MINOR_VER		TPI_MINOR_VERSION

#ifndef _APIDLL

__inline UCHAR NDIS_IN_BYTE( ULONG port )
{
    UCHAR value;
    NdisRawReadPortUchar(port , &value);
    return (value);
}

__inline USHORT NDIS_IN_WORD( ULONG port )
{
    USHORT value;
    NdisRawReadPortUshort(port , &value);
    return (value);
}

#define IN_PORT_WORD(port)			NDIS_IN_WORD( (ULONG) (port) )
#define OUT_PORT_WORD(port, value)	NdisRawWritePortUshort((ULONG) (port) , (USHORT) (value))

#ifdef BUSMASTER
validate this section;
extern void ooiInPortString(IN PULONG Port, OUT PUSHORT  Buffer, IN ULONG  Length);
extern void ooiOutPortString(IN PULONG Port, OUT PUSHORT  Buffer, IN ULONG  Length);

#define IN_PORT_STRING(port, addr, len) \
{                                                                    \
	if (len < 100 || (port != TpiMac.Hw->PortOffset + HREG_DATA_0 && \
					  port != TpiMac.Hw->PortOffset + HREG_DATA_1)){ \
		NdisRawReadPortBufferUshort(port, addr, (len));              \
	}                                                                \
	else {		                                                     \
        ooiInPortString(port, (PUSHORT)addr, len);					 \
    }                                                                \
}

#define OUT_PORT_STRING(port, addr, len) \
{                                                                    \
	if (len < 100 || (port != TpiMac.Hw->PortOffset + HREG_DATA_0 && \
					  port != TpiMac.Hw->PortOffset + HREG_DATA_1)){ \
		NdisRawWritePortBufferUshort(port, addr, (len));             \
	}                                                                \
	else {		                                                     \
        ooiOutPortString(port, (PUSHORT)addr, len);					 \
    }                                                                \
}

#else // !BUSMASTER

#define IN_PORT_STRING(port, addr, len)		NdisRawReadPortBufferUshort(port, addr, (len));
#define OUT_PORT_STRING(port, addr, len)	NdisRawWritePortBufferUshort(port, addr, (len));

#endif // _APIDLL

#endif //BUSMASTER
#if defined _DEBUG || (defined DBG && DBG != 0)
#define HCF_ASSERT                  1
#endif // _DEBUG || DBG

#endif	/* WVLAN_48 MINIPORT 5.0 */

/************************************************************************************************/
/******************************  M I N I P O R T    N D I S  4    *******************************/
/************************************************************************************************/

#if defined WVLAN_52 && !defined(_WIN32_WCE)

#define HCF_DLV 


#define	MSF_COMPONENT_ID			COMP_ID_MINIPORT_NDIS_40

#ifndef _APIDLL
#include <ndis.h>
#endif
#include <version.h>

#ifdef SOFTEX
#ifdef HERMES2
#define	MSF_COMPONENT_VAR			4
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_HII)
#else  // HERMES2
#define HCF_CFG_STA_1_BOTTOM        12
#define	MSF_COMPONENT_VAR			2
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA)
#endif // HERMES2
#else  // SOFTEX
#ifdef HERMES2
#define	MSF_COMPONENT_VAR			3
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA|HCF_TYPE_HII)
#else  // HERMES2
#define HCF_CFG_STA_1_BOTTOM        12
#define	MSF_COMPONENT_VAR			1
#define	HCF_TYPE 					(HCF_TYPE_AP|HCF_TYPE_STA)
#endif // HERMES2
#endif // SOFTEX

#define	MSF_COMPONENT_MAJOR_VER		TPI_MAJOR_VERSION
#define	MSF_COMPONENT_MINOR_VER		TPI_MINOR_VERSION

#ifndef _APIDLL

__inline UCHAR NDIS_IN_BYTE( ULONG port )
{
    UCHAR value;
    NdisRawReadPortUchar(port , &value);
    return (value);
}

__inline USHORT NDIS_IN_WORD( ULONG port )
{
    USHORT value;
    NdisRawReadPortUshort(port , &value);
    return (value);
}

#define IN_PORT_WORD(port)			NDIS_IN_WORD( (ULONG) (port) )
#define OUT_PORT_WORD(port, value)	NdisRawWritePortUshort((ULONG) (port) , (USHORT) (value))

#define IN_PORT_STRING(port, addr, len)		NdisRawReadPortBufferUshort(port, addr, (len));
#define OUT_PORT_STRING(port, addr, len)	NdisRawWritePortBufferUshort(port, addr, (len));

#endif // !_APIDLL

#if defined _DEBUG || (defined DBG && DBG != 0)
#define HCF_ASSERT                  1
#endif // _DEBUG || DBG

#endif	/* WVLAN_52 MINIPORT 4 */


/************************************************************************************************/
/*********************************************  Q N X  ******************************************/
/************************************************************************************************/

#if defined  __QNX__ || defined WVLAN_50

#define MSF_COMPONENT_ID		0   //Although there is no DUI support, we need this to get ...
#define MSF_COMPONENT_VAR		0	//...compatibilty check to function
#define MSF_COMPONENT_MAJOR_VER	0	//...;?this is worth looking into to make this a more
#define MSF_COMPONENT_MINOR_VER	0	//..."defined" I/F so OEMers can figure out what to do

#include <conio.h>

#define IN_PORT_WORD(port)			((hcf_16)inpw( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	(outpw( (hcf_io)(port), (hcf_16) (value) ))
//#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16*)dst = IN_PORT_WORD( prt ); dst += 2; }
//#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16*)src ) ; src  += 2; }

#endif	/* QNX || WVLAN_50 */


/************************************************************************************************/
/*********************************************  B E O S  ****************************************/
/************************************************************************************************/

#if defined  __BEOS__ 

#define MSF_COMPONENT_ID		0   //Although there is no DUI support, we need this to get ...
#define MSF_COMPONENT_VAR		0	//...compatibilty check to function
#define MSF_COMPONENT_MAJOR_VER	0	//...;?this is worth looking into to make this a more
#define MSF_COMPONENT_MINOR_VER	0	//..."defined" I/F so OEMers can figure out what to do

#include <drivers/Drivers.h>
#include <drivers/KernelExport.h>

uint8 read_io_8 (int);
void write_io_8 (int, uint8);
uint16 read_io_16 (int);
void write_io_16 (int, uint16);

#define IN_PORT_WORD(port)			((hcf_16)read_io_16( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	(write_io_16( (hcf_io)(port), (hcf_16) (value) ))
//#define OUT_PORT_WORD(port, value)	dprintf( "OPW %04x %04x", port, value)//(write_io_16( (hcf_io)(port), (hcf_16) (value) ))
//#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16*)dst = IN_PORT_WORD( prt ); dst += 2; }
//#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16*)src ) ; src  += 2; }

#endif	/* BEOS */



/************************************************************************************************/
/******************************  M I N I P O R T  U S B   N D I S  5    *************************/
/************************************************************************************************/

#if defined WVLAN_51

#define HCF_DLV 


#define	MSF_COMPONENT_ID			COMP_ID_MINIPORT_NDIS_50_USB

#if !defined SOFTRONICS_CODE && !defined _APIDLL 
#include <ndis.h>
#endif
#include <version.h>

#ifdef NDIS51_MINIPORT
#ifdef HERMES2
#define	MSF_COMPONENT_VAR			4
#define	HCF_TYPE 					(HCF_TYPE_USB|HCF_TYPE_STA|HCF_TYPE_HII)
#else // HERMES2
#define	MSF_COMPONENT_VAR			2
#ifdef _WPA
#define	HCF_TYPE                    (HCF_TYPE_USB|HCF_TYPE_STA|HCF_TYPE_SSN)
#define HCF_CFG_STA_1_BOTTOM        16
#else // _WPA
#define	HCF_TYPE 					(HCF_TYPE_USB|HCF_TYPE_STA)
#define HCF_CFG_STA_1_BOTTOM        12
#endif // _WPA
#endif // HERMES2

#else //NDIS51_MINIPORT

#ifdef HERMES2
#define	MSF_COMPONENT_VAR			3
#define	HCF_TYPE 					(HCF_TYPE_USB|HCF_TYPE_STA|HCF_TYPE_HII)
#else // HERMES2
#define	MSF_COMPONENT_VAR			1
#ifdef _WPA
#define	HCF_TYPE                    (HCF_TYPE_USB|HCF_TYPE_STA|HCF_TYPE_SSN)
#define HCF_CFG_STA_1_BOTTOM        16
#else // _WPA
#define	HCF_TYPE 					(HCF_TYPE_USB|HCF_TYPE_STA)
#define HCF_CFG_STA_1_BOTTOM        12
#endif // _WPA
#endif // HERMES2
#endif // NDIS51_MINIPORT

#define	MSF_COMPONENT_MAJOR_VER		TPI_MAJOR_VERSION
#define	MSF_COMPONENT_MINOR_VER		TPI_MINOR_VERSION

// Added for building a USB driver in the HCF
#define _WVLAN_USB
#ifdef	OSTYPE_LINUX
#include	"../linux/lnxextra.h"
#endif	//OSTYPE_LINUX

#if defined _DEBUG || (defined DBG && DBG != 0)
#define HCF_ASSERT                  1
#endif // _DEBUG || DBG

#endif	/* WVLAN_51 USB MINIPORT 5 */


/************************************************************************************************/
/********************************  U S B   D O N G L E  *****************************************/
/************************************************************************************************/

#if defined USB
#include "gpif.h"

#define	MSF_COMPONENT_MAJOR_VER		0
#define	MSF_COMPONENT_MINOR_VER		1

#define IN_PORT_WORD(port)			(Hermes_IO_Read( (hcf_8)(port)))
#define OUT_PORT_WORD(port, value)	(Hermes_IO_Write( (hcf_8)port, /*(hcf_16)*/(value) ) )
/* !!!! NOTE USB supports only 16-bits I/O and no 8-bits I/O
 * as a consequence the IN_/OUT_PORT_STRING macros use hcf_16* rather than hcf_8 pointers
 * to get more optimal code
 * therefore the pointers are incremented by 1 (which means two "bytes") rather than by 2
 */
#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *dst++ = IN_PORT_WORD( prt ); }
#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *src++ ); }

#define	HCF_TYPE 					HCF_TYPE_STA

#endif	/* USB */


/************************************************************************************************/
/******************************************  FreeBSD  *******************************************/
/************************************************************************************************/

#if defined __FREE_BSD__

#define	MSF_COMPONENT_ID	        COMP_ID_FreeBSD
#define	MSF_COMPONENT_VAR			1
#define	MSF_COMPONENT_MAJOR_VER		1
#define	MSF_COMPONENT_MINOR_VER		0

#define HCF_MAX_MSG					2048			// overrule standard WaveLAN Packet Size of 1514 with 2048
#define HCF_MEM_IO									// overrule standard Port I/O with Memory mapped I/O

#include <machine/cpufunc.h>

#define IN_PORT_WORD(port)			((hcf_16)inw( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	(outw((hcf_io)(port), (hcf_16)(value)))

//#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16*)dst = IN_PORT_WORD( prt ); dst += 2; }
//#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16*)src ) ; src  += 2; }

#endif	/* FreeBSD */


/************************************************************************************************/
/*********************************  W A V E P O I N T  ******************************************/
/************************************************************************************************/

#if defined WVLAN_81	/* BORLANDC */

#define EXTERN_C  extern	// needed because DHF uses this instead of 'extern' 

#define HCF_IFB_SECURE				1	//IFB is secure in WavePOINT, HCF can restore WEP keys
#define	MSF_COMPONENT_ID	COMP_ID_AP1
#define	MSF_COMPONENT_VAR			1
#define	MSF_COMPONENT_MAJOR_VER		4
#define	MSF_COMPONENT_MINOR_VER		0

#define HCF_PROT_TIME				49	//49*10240 microseconds H/W failure protection timer				

#include <dos.h>

//#define HCF_ASSERT					0  /* debug build only */

#if !defined FAR
#define FAR  far						// segmented 16 bits mode
#endif //!defined FAR

#define IN_PORT_WORD(port)					(inport( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)      	(outport( (hcf_io)(port), value ))

#define IN_PORT_STRING(port, addr, len) 	\
	asm { push di; push es; mov cx,len; les di,addr; mov dx,port; rep insw; pop es; pop di }

#define OUT_PORT_STRING(port, addr, len)	\
	asm { push si; push ds; mov cx,len; lds si,addr; mov dx,port; rep outsw; pop ds; pop si }

#endif /* WVLAN_81 WavePoint */


/************************************************************************************************/
/********************************  W A V E L A U N C H  *****************************************/
/************************************************************************************************/

#if defined WVLAUNCH

#include "DriverX.h"
extern HWDEVICE*	g_pDevice;

//#define	MSF_COMPONENT_ID			0  //;? to get around browser problem

#define IN_PORT_WORD(port)	HwInpw( g_pDevice, port )
#define OUT_PORT_WORD(port, value)	HwOutpw( g_pDevice, port, value )


// C implementation which let the processor handle the word-at-byte-boundary problem
//#define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16 FAR*)dst = IN_PORT_WORD( prt ); dst += 2; }
//#define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16 FAR*)src ) ; src  += 2; }

#endif //WVLAUNCH

/************************************************************************************************/
/*************************************  W C I T S T *********************************************/
/************************************************************************************************/

#if defined WCITST
#define MSF_COMPONENT_ID		0   //Although there is no DUI support, we need this to get ...
#define MSF_COMPONENT_VAR		0	//...compatibilty check to function
#define MSF_COMPONENT_MAJOR_VER	0	//...;?this is worth looking into to make this a more
#define MSF_COMPONENT_MINOR_VER	0	//..."defined" I/F so OEMers can figure out what to do

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ To ease testing the different options ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//#define	HCF_TYPE HCF_TYPE_AP
//#define	HCF_TYPE HCF_TYPE_STA
#define HCF_TYPE (HCF_TYPE_STA | HCF_TYPE_SSN )		// Hermes-I F/W with SSN support
#define LLB	//!!!!MIC Debug Only
#if defined LLB && !((HCF_TYPE) & HCF_TYPE_SSN)
error, no LLB unless SSN;
#endif
//#define HCF_ALIGN 2			
#define HCF_EX_INT (HCF_EX_INT_TX_EX|HCF_EX_INT_TX_OK)	//log transmissions in Mailbox
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ To ease testing the different options ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#pragma warning ( disable: 4001 )
										

//#define HCF_ASSERT                  2	//assert (also) via S/W Supp Register
#define HCF_ASSERT                  4	//assert (also) in Mailbox

//#define HCF_MB_OFF

#if !defined _CONSOLE
#define FAR  __far					// segmented 16 bits mode
#if defined _M_I86TM
#define BASED __based(__segname("_CODE"))
#endif // _M_I86TM
#endif  //_CONSOLE

#include <stdio.h>
#include <conio.h>
#ifndef _DEBUG
#pragma intrinsic( _inp, _inpw, _outp, _outpw )
#endif // _DEBUG

#ifdef LOG
extern FILE* utm_logfile;
hcf_16	ipw( hcf_16 port );
hcf_8	ipb( hcf_16 port );
void	opw( hcf_16 port, hcf_16 value );
void	opb( hcf_16 port, hcf_8 value );

#define IN_PORT_WORD(port)			ipw( (hcf_io)(port) )
#define OUT_PORT_WORD(port, value)	opw( (hcf_io)(port), (hcf_16)(value) )
#else //LOG
#define IN_PORT_WORD(port)			((hcf_16)_inpw( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	((void)_outpw( (hcf_io)(port), value ))
#endif //LOG

#define	toch_maar_geen_asm
#if defined(toch_maar_asm)
#define IN_PORT_STRING( port, dest, len) __asm 		\
{													\
	__asm push di                               	\
	__asm push es                                 	\
	__asm mov cx,len                            	\
	__asm les di,dest                           	\
	__asm mov dx,port                           	\
	__asm rep insw                              	\
	__asm pop es	                            	\
	__asm pop di	                            	\
}

#define OUT_PORT_STRING( port, src, len) __asm		\
{                                               	\
	__asm push si                                 	\
	__asm push ds                                 	\
	__asm mov cx,len                              	\
	__asm lds si,src                             	\
	__asm mov dx,port                             	\
	__asm rep outsw	                            	\
	__asm pop ds                                  	\
	__asm pop si                                  	\
}

#else	//toch_maar_asm
#define IN_PORT_STRING( prt, dst, n)  while (n--) { *(hcf_16 FAR*)dst = IN_PORT_WORD( prt ); dst += 2/*1*/; }
#define OUT_PORT_STRING( prt, src, n) while (n--) { OUT_PORT_WORD( prt, *(hcf_16 FAR*)src ) ; src  += 2/*1*/; }
#endif	//toch_maar_asm 

#endif	/* WCITST */


/************************************************************************************************/
/********************************** S C O   U N I X  ********************************************/
/************************************************************************************************/

#if 0

#define	MSF_COMPONENT_ID

#define IN_PORT_WORD(port)			((hcf_16)inw( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	(outw( (hcf_io)(port), (hcf_16) (value) ))

#endif	/* SCO UNIX */

/************************************************************************************************/
/*******************************  Motorola Power PC 800 family  *********************************/
/************************************************************************************************/
/* known users: LH@I
 */



#if defined I_MPC8XX

#define	HCF_TYPE HCF_TYPE_AP //AccesPoint characteristics
#define MSF_COMPONENT_VAR       0
#define MSF_COMPONENT_ID        0
#define MSF_COMPONENT_MAJOR_VER 1
#define MSF_COMPONENT_MINOR_VER 0

#define HCF_HSI_VAR	1

#define HCF_BIG_ENDIAN
#define HCF_MEM_IO

#include "o_portbl.h"
#include "ipcmcia.h"
typedef o_uint8_t  hcf_8;
typedef o_uint16_t hcf_16;
typedef o_uint32_t hcf_32;

/***************************************************************************/


#if defined(_lint)
#else
asm hcf_16 IN_PORT_WORD(int port)
{
% reg port
    lhbrx r3,r0,port
    eieio
}
#endif


#if defined(_lint)
#else
asm void OUT_PORT_WORD(int port, hcf_16 value)
{
% reg port, value
    sthbrx value,r0,port
    eieio
}
#endif

/***************************************************************************/

#define IN_PORT_STRING(port, dest, len)               \
   {                                                  \
      unsigned l = (len);                             \
      hcf_16 *d = (volatile hcf_16 *)(dest);          \
      while (l--)                                     \
      {                                               \
         *d++ = *(volatile hcf_16 *)(port);           \
         EIEIO();                                     \
      }                                               \
   }

#define OUT_PORT_STRING(port, src, len)               \
   {                                                  \
      unsigned l = (len);                             \
      hcf_16 *s = (volatile hcf_16 *)(src);           \
      while (l--)                                     \
      {                                               \
         *(volatile hcf_16 *)(port) = *s++;           \
         EIEIO();                                     \
      }                                               \
   }

#endif	/* Diab */




/************************************************************************************************/
/**********************************   Diab or High C 29K   **************************************/
/************************************************************************************************/
/* known users: GK@C
 */

#if defined _AM29K

#define	HCF_TYPE HCF_TYPE_AP /*AccesPoint characteristics */
#define MSF_COMPONENT_VAR       0
#define MSF_COMPONENT_ID        COMP_ID_AP1
#define MSF_COMPONENT_MAJOR_VER 1
#define MSF_COMPONENT_MINOR_VER 0

#define HCF_BIG_ENDIAN
#define HCF_MEM_IO

#define SwapBytes(t)    /*lint -e572*/(((t) >> 8) + (((t) & 0xff) << 8))/*lint +e572*/

#if defined(__ppc)
    #ifndef __GNUC__
        #define __asm__     asm
    #endif

    #if !defined(_lint)
        #define EIEIO()     __asm__(" eieio")
    #else
        #define EIEIO()
    #endif

    static hcf_16 IN_PORT_WORD(int port) {
        hcf_16 value = *(volatile hcf_16 *)(port); EIEIO();
        value = SwapBytes(value);
        return value;
    }

    #define OUT_PORT_WORD(port, value)      \
            { *(volatile hcf_16 *)(port) = SwapBytes(value); EIEIO(); }
#else
    #define IN_PORT_WORD(port) (*(volatile hcf_16 *)(port))
    #define OUT_PORT_WORD(port, value) (*(volatile hcf_16 *)(port) = (value))
#endif

/***************************************************************************/

#define IN_PORT_STRING( port, dest, len)        {                       \
                        unsigned l = (len);                             \
                        hcf_16 t, *d = (volatile hcf_16 *)(dest);       \
                        while (l--) {                                   \
                            t = IN_PORT_WORD(port);                     \
                            *d++ = SwapBytes(t);                        \
                        }                                               \
                                                }

#define OUT_PORT_STRING( port, src, len)        {                       \
                        unsigned l = (len);                             \
                        hcf_16 t, *s = (volatile hcf_16 *)(src);        \
                        while (l--) {                                   \
                            t = *s++;                                   \
                            OUT_PORT_WORD(port, SwapBytes(t));          \
                        }                                               \
                                                }

#if PRODUCT == 9150
#define	HCF_TYPE HCF_TYPE_AP
    #define HCF_ASSERT
    #undef MSF_COMPONENT_ID
#endif

#endif	/* Diab or High C 29K */


/************************************************************************************************/
/*****************************************  MPC860 **********************************************/
/************************************************************************************************/
/* known users: RR
 */

//;? JohanB #if 0

#if defined CPU
#if CPU == PPC860

#define	HCF_TYPE HCF_TYPE_AP	//AccesPoint characteristics
#define MSF_COMPONENT_VAR       0
#define MSF_COMPONENT_ID        0
#define MSF_COMPONENT_MAJOR_VER 1
#define MSF_COMPONENT_MINOR_VER 0

#define HCF_BIG_ENDIAN
#define HCF_MEM_IO

#define SwapBytes(t)    /*lint -e572*/(((t) >> 8) + (((t) & 0xff) << 8))/*lint +e572*/

#ifndef __GNUC__
    #define __asm__     asm
#endif

#if !defined(_lint)
    #define EIEIO()     __asm__(" eieio")
#else
    #define EIEIO()
#endif

static hcf_16 IN_PORT_WORD(int port) {
    hcf_16 value = *(volatile hcf_16 *)(port); EIEIO();
    value = SwapBytes(value);
    return value;
    #ifdef __GNUC__
        /* the following serves to avoid the compiler warnings that
         * IN_PORT_WORD() is not used in some files */
        (void)IN_PORT_WORD;
    #endif
}

#define OUT_PORT_WORD(port, value)      \
        { *(volatile hcf_16 *)(port) = SwapBytes(value); EIEIO(); }

/***************************************************************************/

#define IN_PORT_STRING( port, dest, len)        {                       \
                        unsigned l = (len);                             \
                        hcf_16 t;                                       \
                        volatile hcf_16 *d = (volatile hcf_16 *)(dest); \
                        while (l--) {                                   \
                            t = IN_PORT_WORD(port);                     \
                            *d++ = SwapBytes(t);                        \
                        }                                               \
                                                }

#define OUT_PORT_STRING( port, src, len)        {                       \
                        unsigned l = (len);                             \
                        hcf_16 t;                                       \
                        volatile hcf_16 *s = (volatile hcf_16 *)(src);  \
                        while (l--) {                                   \
                            t = *s++;                                   \
                            OUT_PORT_WORD(port, SwapBytes(t));          \
                        }                                               \
                                                }

#if PRODUCT == 9150
//?    #define	HCF_TYPE HCF_TYPE_AP
    #define HCF_ASSERT
    #undef MSF_COMPONENT_ID
#endif

#endif	/* PPC860 */
#endif	/* CPU */
//;? JohanB #endif //0

/************************************************************************************************/
/****************************  Microtec Research 80X86 Compiler *********************************/
/************************************************************************************************/

#if 0

#define	HCF_TYPE HCF_TYPE_STA /*station characteristics*/

#define MSF_COMPONENT_VAR       0
#define MSF_COMPONENT_ID        0
#define MSF_COMPONENT_MAJOR_VER 1
#define MSF_COMPONENT_MINOR_VER 0

extern int far inp( int );
extern void far outp( int, int );
extern int far inpw( int );
extern void far outpw( int, int );

#define IN_PORT_WORD(port)		((hcf_16)inpw( (hcf_io)(port) ))
#define OUT_PORT_WORD(port, value)	((void)outpw( (hcf_io)(port), value ))

#define IN_PORT_STRING( port, dest, len)        {                       \
                        unsigned l = (len);                             \
                        hcf_16 *d = (hcf_16 *)(dest);                   \
                        while (l--) *d++ =  IN_PORT_WORD(port);         \
                                                }

#define OUT_PORT_STRING( port, src, len)        {                       \
                        unsigned l = (len);                             \
                        hcf_16 *s = (hcf_16 *)(src);                    \
                        while (l--) OUT_PORT_WORD(port, *s++);          \
                                                }
#endif	/* Microtec 80X86 C Compiler */



/************************************************************************************************/
/******************************  W A V E L A N  E C  ********************************************/
/************************************************************************************************/
/* known users: KM
 */

			   /*********/
#ifdef mc68302 /* LC302 */
			   /*********/

#define	MSF_COMPONENT_ID			COMP_ID_EC

#include <version.h>

#define	MSF_COMPONENT_VAR			1
#define	MSF_COMPONENT_MAJOR_VER		MAJOR_VERSION
#define	MSF_COMPONENT_MINOR_VER		MINOR_VERSION

#define HCF_BIG_ENDIAN
#define HCF_MEM_IO

#define SwapBytes(t)	/*lint -e572*/(((t) >> 8) + (((t) & 0xff) << 8))/*lint +e572*/

#define PCMCIA_ADDRESS 0xc80000UL

#define IN_PORT_2BYTES(port)			 (*(hcf_16 *)(port))
#if 0
static hcf_16 IN_PORT_WORD(hcf_32 port) // should be hcf_io, not hcf_32
{
  hcf_16 word = IN_PORT_2BYTES(port);
  return SwapBytes(word);
}
#else
static hcf_16 swap_var;
#define IN_PORT_WORD(port) \
  (((swap_var = IN_PORT_2BYTES(port)) >> 8) + (((swap_var) & 0xff) << 8))
#endif
#define OUT_PORT_2BYTES(port, value)	 (*(hcf_16 *)(port) = (hcf_16)(value))
#define OUT_PORT_WORD(port, value)		 OUT_PORT_2BYTES(port, SwapBytes(value))

//#define IN_PORT_STRING(port, dest, len)	  while ((len)--) {*(hcf_16 *)(dest) = IN_PORT_2BYTES(port); (dest) += 2; }
//#define OUT_PORT_STRING(port, src, len)	  while ((len)--) {OUT_PORT_2BYTES((port), *(hcf_16 *)(src)) ; (src)  += 2; }

#endif	/* mc68302 */

/* Vinay.B : Added for NGAP : Jan 12th, 2000 */
/************************************************************************************************/
/*********************************  NGAP   ***************************************/
/************************************************************************************************/

#if defined __VX_WORKS__	/* VxWorks */

#define	HCF_MAX_CONFIG	0
 
#if defined WLC_STATION
#define	HCF_TYPE HCF_TYPE_STA	/* Station characteristics */
#define MSF_COMPONENT_ID	COMP_ID_VX_WORKS_ENDSTA
#else	/* #if defined WLC_STATION */
#define	HCF_TYPE HCF_TYPE_AP /* Access point characteristics */
#define MSF_COMPONENT_ID	COMP_ID_VX_WORKS_ENDAP
#endif	/* #else defined WLC_STATION */

#define HCF_YIELD (taskDelay(0) == 0)

#define    MSF_COMPONENT_VAR              1
#define    MSF_COMPONENT_MAJOR_VER        1
#define    MSF_COMPONENT_MINOR_VER        0

/* #define HCF_ASSERT            0   debug build only */

#if defined PC486BSP

#define IN_PORT_WORD(port)            (sysInWord ((hcf_io)(port)))
#define OUT_PORT_WORD(port, value)        (sysOutWord ((hcf_io)(port), (hcf_16) (value)))
#define IN_PORT_STRING(port, dst, n)        (sysInWordString ((hcf_io)(port), dst, n))
#define OUT_PORT_STRING(port, src, n)        (sysOutWordString ((hcf_io)(port), src, n))

#elif defined AS2000BSP

#define HCF_MEM_IO

/* Define PCI stuff here. */
unsigned short sysRead16( unsigned short *port );
void sysWrite16( unsigned short *port, unsigned short value );

#define PCI_IN_BYTE( port ) \
	*(unsigned char *)( port )

#define PCI_IN_WORD( port ) \
	sysRead16( (unsigned short *)( port ) )

#define PCI_OUT_BYTE( port, value ) \
	*(unsigned char *)( port ) = (unsigned char)( value )

#define PCI_OUT_WORD( port, value ) \
	sysWrite16( (unsigned short *)( port ), (unsigned short)( value ) )

#define IN_PORT_WORD( port ) \
	PCI_IN_WORD( port )

#define OUT_PORT_WORD( port, value ) \
	PCI_OUT_WORD( port, value )

#define IN_PORT_STRING( port, buf, len ) \
	do { \
		hcf_16 *p; \
	 \
	 	for ( p = (hcf_16 *)(buf); p < &( (hcf_16 *)(buf) )[ (int)len ]; p++ ) { \
			*p = PCI_IN_WORD( port ); \
		} \
	} while ( 0 )

#define OUT_PORT_STRING( port, buf, len ) \
	do { \
		const hcf_16 *p; \
	 \
	 	for ( p = (const hcf_16 *)( buf ); p < &( (const hcf_16 *)(buf) )[ (int)len ]; p++ ) { \
			PCI_OUT_WORD( port, *p ); \
		} \
	} while ( 0 )

#elif defined FADS860BSP /* elif defined AS2000BSP */

#define HCF_BIG_ENDIAN

#define HCF_MEM_IO

#ifndef __GNUC__
    #define __asm__     asm
#endif

#if !defined(_lint)
    #define EIEIO()     __asm__(" eieio")
#else
    #define EIEIO()
#endif

static hcf_16 IN_PORT_WORD(int port) {
    hcf_16 value = *(volatile hcf_16 *)(port); EIEIO();
    value = ((value & 0xff00) >> 8) + ((value & 0x00ff) << 8);
/*  value = CNV_LITTLE_TO_INT(value); */
    return value;
    #ifdef __GNUC__
        /* the following serves to avoid the compiler warnings that
         * IN_PORT_WORD() is not used in some files */
        (void)IN_PORT_WORD;
    #endif
}

#define OUT_PORT_WORD(port, value)                                      \
        { *(volatile hcf_16 *)(port) = CNV_INT_TO_LITTLE(value); EIEIO(); }

/***********************************************************************/

#define IN_PORT_STRING( port, dest, len)        {                       \
                        unsigned l = (len);                             \
                        volatile hcf_16 *d = (volatile hcf_16 *)(dest); \
                        while (l--) {                                   \
                            *d++ = *(volatile hcf_16 *)(port);          \
                            EIEIO();                                    \
                        }                                               \
                                                }

#define OUT_PORT_STRING( port, src, len)        {                       \
                        unsigned l = (len);                             \
                        volatile hcf_16 *s = (volatile hcf_16 *)(src);  \
                        while (l--) {                                   \
                            *(volatile hcf_16 *)(port) = *s++;          \
                            EIEIO();                                    \
                        }                                               \
                                                }

#elif defined DAYTONABSP

#ifdef HCF_LITTLE_ENDIAN
#undef HCF_LITTLE_ENDIAN
#endif  /* ifdef HCF_LITTLE_ENDIAN */

#define HCF_BIG_ENDIAN

#ifdef HCF_PORT_IO
#undef HCF_PORT_IO
#endif  /* ifdef HCF_PORT_IO */

#define HCF_MEM_IO

#ifndef __GNUC__
    #define __asm__     asm
#endif

#define IN_PORT_BYTE(port)              (sysOrinocoInByte((unsigned long)(port)))
#define IN_PORT_WORD(port)              (sysOrinocoInWord((unsigned long)(port)))

#define OUT_PORT_BYTE(port,value)       (sysOrinocoOutByte((unsigned long)(port), (unsigned char)(value)))
#define OUT_PORT_WORD(port,value)       (sysOrinocoOutWord((unsigned long)(port), (unsigned short)(value)))

#define IN_PORT_STRING(port,dest,len)   (sysOrinocoInString((port), (dest), (len)))
#define OUT_PORT_STRING(port,src,len)   (sysOrinocoOutString((port), (src), (len)))

extern unsigned char    sysOrinocoInByte    (unsigned long port);
extern unsigned short   sysOrinocoInWord    (unsigned long port);
extern void             sysOrinocoInString  (unsigned long port, void *dest, unsigned short len);

extern void             sysOrinocoOutByte   (unsigned long port, unsigned char value);
extern void             sysOrinocoOutWord   (unsigned long port, unsigned short value);
extern void             sysOrinocoOutString (unsigned long port, void *src, unsigned short len);

#elif defined ALPHA_BSP

#ifdef HCF_LITTLE_ENDIAN
#undef HCF_LITTLE_ENDIAN
#endif  /* ifdef HCF_LITTLE_ENDIAN */

#define HCF_BIG_ENDIAN

#ifdef HCF_PORT_IO
#undef HCF_PORT_IO
#endif  /* ifdef HCF_PORT_IO */

#define HCF_MEM_IO

#ifndef __GNUC__
    #define __asm__     asm
#endif

#define IN_PORT_BYTE(port)              (sysOrinocoInByte((unsigned long)(port)))
#define IN_PORT_WORD(port)              (sysOrinocoInWord((unsigned long)(port)))

#define OUT_PORT_BYTE(port,value)       (sysOrinocoOutByte((unsigned long)(port), (unsigned char)(value)))
#define OUT_PORT_WORD(port,value)       (sysOrinocoOutWord((unsigned long)(port), (unsigned short)(value)))

#define IN_PORT_STRING(port,dest,len)   (sysOrinocoInString((port), (dest), (len)))
#define OUT_PORT_STRING(port,src,len)   (sysOrinocoOutString((port), (src), (len)))

extern unsigned char    sysOrinocoInByte    (unsigned long port);
extern unsigned short   sysOrinocoInWord    (unsigned long port);
extern void             sysOrinocoInString  (unsigned long port, void *dest, unsigned short len);

extern void             sysOrinocoOutByte   (unsigned long port, unsigned char value);
extern void             sysOrinocoOutWord   (unsigned long port, unsigned short value);
extern void             sysOrinocoOutString (unsigned long port, void *src, unsigned short len);

#else

error; /* commented here */ /*	"BSP is not defined..." */

#endif	/* else PC486BSP */

#endif	// __VX_WORKS__ 


/*  * * * * * * * * * * * * * * * * * * * * * *  IV  * * * * * * * * * * * * * * * * * * * * * * */

/***************************************Compiler specific ****************************************/

#if !defined EXTERN_C
#ifdef __cplusplus
#define EXTERN_C extern "C"
#else
#define EXTERN_C
#endif //__cplusplus
#endif //EXTERN_C

/************************************************************************************************/
/************************ N D I S   S P E C I F I C   M A C R O S  ******************************/
/************************************************************************************************/

#ifdef NDIS_MINIPORT_DRIVER
#if defined DEBUG || defined _DEBUG || (defined DBG && DBG != 0)
#ifdef _WIN32_WCE
#define DBGA2W(DBGSTR)	CeConvertAnsiToUnicodeLen(szDbgConvertBuffer, DBGSTR,  256)
#define OUTPUTDEBUGMSG(dprintf_exp)			        ce_debug_msg dprintf_exp // (void)(DEBUGMSG(ZONE_INIT, dprintf_exp)) //((void) (DbgPrint dprintf_exp))
#define ASSERTDEBUGMSG(cond, dprintf_exp)			cond ? 0:ce_debug_msg dprintf_exp 
#else
#define OUTPUTDEBUGMSG(dprintf_exp)					((void) (DbgPrint dprintf_exp))
// the assertdebugmsg macro will print filename, line followed by a caller-defined text, when cond == 0
#define ASSERTDEBUGMSG(cond, dprintf_exp)	((void)((cond) ? 0: (DbgPrint("%s:%d - ", __FILE__, __LINE__), DbgPrint dprintf_exp)))
#endif
#ifndef DBGA2W
#define DBGA2W
#endif
#define ASSERTDEBUGMSG(cond, dprintf_exp)
#endif // DEBUG
#endif // NDIS_MINIPORT_DRIVER


#if ! defined OUTPUTDEBUGMSG
//#define OUTPUTDEBUGMSG(dprintf_exp)
#endif //OUTPUTDEBUGMSG
#if ! defined ASSERTDEBUGMSG
#define ASSERTDEBUGMSG(cond, dprintf_exp)
#endif // ASSERTDEBUGMSG

/************************************************************************************************/
/********** M A C R O S derived of C O M P I L E R   S P E C I F I C   M A C R O S  *************/
/************************************************************************************************/

#if !defined FAR
#define FAR							// default to flat 32-bits code
#endif //!defined FAR

typedef hcf_8  FAR *wci_bufp;			 // segmented 16-bits or flat 32-bits pointer to 8 bits unit
typedef hcf_16 FAR *wci_recordp;		 // segmented 16-bits or flat 32-bits pointer to 16 bits unit

/*  * * * * * * * * * * * * * * * * * * * * * *  V  * * * * * * * * * * * * * * * * * * * * * * */


/*	I/O Address size
 *	Platforms which use port mapped I/O will (in general) have a 64k I/O space, conveniently expressed in
 *	a 16-bits quantity
 *	Platforms which use memory mapped I/O will (in general) have an I/O space much larger than 64k,
 *	and need a 32-bits quantity to express the I/O base
 *	To accommodate this the macro HCF_MEM_IO is available. If HCF_MEM_IO is not defined, the HCF uses an 
 *	hcf_16 to express I/O base and store in the IFB. If HCF_MEM_IO is defined, an hcf_32 is used.
 */
#if defined HCF_MEM_IO
typedef hcf_32 hcf_io;
#else
typedef hcf_16 hcf_io;
#endif //HCF_MEM_IO



/* MSF_COMPONENT_ID is used to define the CFG_IDENTITY_STRCT in HCF.C
 * CFG_IDENTITY_STRCT is defined in HCF.C purely based on convenience arguments
 * The HCF can not have the knowledge to determine the ComponentId field of the
 * Identity record (aka as Version Record), therefore the MSF part of the Drivers
 * must supply this value via the System Constant MSF_COMPONENT_ID
 * There is a set of values predefined in MDD.H (format COMP_ID_.....)
 *
 * Note that taking MSF_COMPONENT_ID as a default value for DUI_COMPAT_VAR is
 * purely an implementation convenience, the numerical values of these two
 * quantities have none functional relationship whatsoever.
 * Originally there was only a single DUI-variant with value 1. 
 * Then it was considered advantageous to have unique DUI-variant per driver and 
 * - as said before - out of convenience these variants where chosen to have 
 * the same numerical value as the component id of the driver.
 * Again later, it was decided that there would be two Miniport 3.1 drivers,
 * the old one continuing to have DUI-variant and component ID 41, the new 
 * one (the STAP or HomeLAN driver) having component ID 41 but DUI-variant 2 (since
 * 1 was already used in the past)
 */

#if defined	MSF_COMPONENT_ID
#if !defined DUI_COMPAT_VAR
#define	DUI_COMPAT_VAR				MSF_COMPONENT_ID
#endif //!defined DUI_COMPAT_VAR

#if ! defined DUI_COMPAT_BOT		//;?this way utilities can lower as well raise the bottom
#define	DUI_COMPAT_BOT              8
#endif // DUI_COMPAT_BOT

#if ! defined DUI_COMPAT_TOP		//;?this way utilities can lower as well raise the top
#define	DUI_COMPAT_TOP              8
#endif // DUI_COMPAT_TOP

#endif // MSF_COMPONENT_ID


#if (HCF_TYPE) & HCF_TYPE_HII
#if ! defined(HCF_HSI_VAR_4) 
#define HCF_HSI_VAR_4				//Hermes-II all types (for the time being!)
#endif // HCF_HSI_VAR_4
#if defined(HCF_HSI_VAR_1) || defined(HCF_HSI_VAR_2) || defined(HCF_HSI_VAR_3)
error, HSI variants 1, 2 and 3 correspond with H-I only;
#endif // HCF_HSI_VAR_1, HCF_HSI_VAR_2, HCF_HSI_VAR_3
#else // !HCF_TYPE_HII
#if ! defined(HCF_HSI_VAR_0) && ! defined(HCF_HSI_VAR_1) && ! defined(HCF_HSI_VAR_2) && ! defined(HCF_HSI_VAR_3)
#define HCF_HSI_VAR_1				//PCCard
#define HCF_HSI_VAR_2				//MiniPCI
#define HCF_HSI_VAR_3				//Personal PCCard
#endif // HCF_HSI_VAR_0/1/2/3
#if defined(HCF_HSI_VAR_4)
error, HSI variants 4 correspond with H-II only;
#endif // HCF_HSI_VAR_4
#endif // HCF_TYPE_HII


#if (HCF_TYPE) & HCF_TYPE_HII
#if ! defined(HCF_PRI_VAR_3)
#define HCF_PRI_VAR_3
#endif // HCF_PRI_VAR_3
#if defined(HCF_PRI_VAR_1) || defined(HCF_PRI_VAR_2)
error, primary variants 1 and 2 correspond with H-I only;
#endif // HCF_PRI_VAR_1, HCF_PRI_VAR_2
#else // !HCF_TYPE_HII
#if ! defined(HCF_PRI_VAR_1) && ! defined(HCF_PRI_VAR_2)
#define HCF_PRI_VAR_1
#define HCF_PRI_VAR_2
#endif //HCF_PRI_VAR_1/2
#if defined(HCF_PRI_VAR_3)
error, primary variant 3 correspond with H-II only;
#endif // HCF_PRI_VAR_3
#endif //HCF_TYPE_HII

#if (HCF_TYPE) & HCF_TYPE_HII
#if ! defined(HCF_APF_VAR_2)
#define HCF_APF_VAR_2
#endif // HCF_APF_VAR_2
#else // !HCF_TYPE_HII
#if ! defined(HCF_APF_VAR_1)
#define HCF_APF_VAR_1
#endif //HCF_APF_VAR_1
#endif //HCF_TYPE_HII

#if (HCF_TYPE) & HCF_TYPE_HII
#if ! defined(HCF_STA_VAR_2)
#define HCF_STA_VAR_2
#endif // HCF_STA_VAR_2
#else // !HCF_TYPE_HII
#if ! defined(HCF_STA_VAR_1)
#define HCF_STA_VAR_1
#endif //HCF_STA_VAR_1
#endif //HCF_TYPE_HII


/************************************************************************************************/
/******  M S F    S U P P O R T    F U N C T I O N S    P R O T O T Y P E S   *******************/
/************************************************************************************************/

//******************************************* A L I G N M E N T  **********************************************
#if !defined HCF_ALIGN
#define HCF_ALIGN 1			//default to no alignment
#endif // HCF_ALIGN

#define HCF_8P(p)						((hcf_8*)p)					
#define HCF_DEREF_WORDP(wp)			(hcf_16)( *HCF_8P(wp)  ) | (hcf_16) ((*(HCF_8P(wp)+1)) << 8)
#define HCF_DEREF_DWORDP(dwp)		(hcf_32)( *HCF_8P(dwp) ) | (hcf_32) ((*(HCF_8P(dwp)+1)) << 8)  | (hcf_32) ( (*(HCF_8P(dwp)+2)) << 16) | (hcf_32) ( (*(HCF_8P(dwp)+3)) << 24)


#if HCF_ALIGN != 1 && HCF_ALIGN != 2 && HCF_ALIGN != 4 && HCF_ALIGN != 8
	error;
#endif // HCF_ALIGN != 0 && HCF_ALIGN != 2 etc


#if !defined HCF_MAX_GROUP
#define HCF_MAX_GROUP		16		/* historical determined number of Multicast Addresses
									 * up to Station Supplier 4, Hermes supported a maximum of 16 addresses
									 * to prevent side effects on existing MSFs and to prevent the need
									 * for (messy) adaptation code, the HCF default is 16, making the
									 * HCF default compatible with all station vesions (as far as the
									 * Multicast aspect is concerned. It is suggested that MSFs which
									 * want 32 addresses, limit the Station Actor range to a bottom of
									 * at least 5														*/
#elif HCF_MAX_GROUP > 32
error;								// Hermes supports up to 32 Multicast Addresses
#endif

#if !defined HCF_MAX_CONFIG
#define HCF_MAX_CONFIG		256		/* maximum accumulated size in hcf_16 of LTV records used in hcf_put_info
									 * use of this feature is not recomanded and may be abondaned in the future
									 */
#endif

#if !defined HCF_MAX_MSG
#define HCF_MAX_MSG			1514	// WaveLAN Packet Size in bytes
#endif

#if !defined HCF_MAX_LTV
#define HCF_MAX_LTV			0x1001	// ;? requires some thought, this copes with "default" DownLoadBufferLenght
#endif

#if !defined HCF_PROT_TIME
#define HCF_PROT_TIME		256		// number of 10K microseconds protection timer against H/W malfunction
#elif HCF_PROT_TIME < 19 || HCF_PROT_TIME >	256
error;								// below the minimum .5 second required by Hermes or above the hcf_32 capacity
#endif


/*	Endianess
 *	Little Endian (a.k.a. Intel), least significant byte first
 *	Big Endian (a.k.a. Motorola), most significant byte first
 *
 * The following macros are supplied
 *  o CNV_LITTLE_TO_INT(w)			interprets the 16-bits input value as Little Endian, returns an hcf_16
 * 	o CNV_BIG_TO_INT(w)				interprets the 16-bits input value as Big Endian, returns an hcf_16
 *
 * At a number of places in the HCF code, the CNV_INT_TO_BIG_NP macro is used. While it does have the desired
 * effect on all platforms, it's naming is misleading, so revisit all places where these CNV macros are used
 * to assure the right name is used at the right place.
 *
 */

/* To increase portability, use unsigned char and unsigned char * when accessing parts of larger
 * types to convert their Endianess
 */

#define CNV_END(w)    ( ((hcf_16)(w) & 0x00FF) << 8 | ((hcf_16)(w) & 0xFF00) >> 8 )
#if defined HCF_BIG_ENDIAN
//******************************************** B I G   E N D I A N *******************************************
#define EOC						1			// endianess offset compenation
#define BE_PAR(x)				,x
#define CNV_LITTLE_TO_INT(w)    CNV_END(w)	//    endianess conversion needed
#define CNV_BIG_TO_INT(w)		(w)			// no endianess conversion needed
#else
//****************************************** L I T T L E   E N D I A N ****************************************
#define EOC						0			// endianess offset compenation
#define BE_PAR(x)
#define CNV_LITTLE_TO_INT(w) 	(w)			// no endianess conversion needed
#define CNV_BIG_TO_INT(w)       CNV_END(w)	//    endianess conversion needed
#endif // HCF_BIG_ENDIAN

// conversion macros which can be expressed in other macros
#define CNV_INT_TO_LITTLE(w)	CNV_LITTLE_TO_INT(w)
#define CNV_INT_TO_BIG(w)		CNV_BIG_TO_INT(w)



/*************************************************************************************************************/
/******************************************** . . . . . . . . .  *********************************************/
/*************************************************************************************************************/


/* The BASED customization macro is used to resolves the SS!=DS conflict for the Interrupt Service
 * logic in DOS Drivers. Due to the cumbersomeness of mixing C and assembler local BASED variables
 * still end up in the wrong segment. The workaround is that the HCF uses only global BASED
 * variables or IFB-based variables
 * The "BASED" construction (supposedly) only amounts to something in the small memory model.
 *
 * Note that the whole BASED rigmarole is needlessly complicated because both the Microsoft Compiler and
 * Linker are unnecessary restrictive in what far pointer manipulation they allow
 */

#if !defined BASED
#define BASED
#endif

#if !defined NULL
#define NULL ((void *) 0)
#endif

///*conflicts with ULTSDEMO
#if !defined TEXT
#define TEXT(x) x
#endif

#if !defined _TCHAR_DEFINED
#define TCHAR char
#endif
//conflicts with ULTSDEMO*/

/*************************************************************************************************************/
/************************************ M I G R A T I O N   A S P E C T S **************************************/
/*************************************************************************************************************/
#if !defined HCF_TALLIES
#define HCF_TALLIES 0x0001
#endif // HCF_TALLIES

#if !defined HCF_ENCAPSULATION
#define HCF_ENCAPSULATION 1
#endif // HCF_ENCAPSULATION

#if !defined HCF_MB_OFF
#define HCF_MB_ON
#endif // HCF_MB_OFF

#ifdef _WIN32_WCE
#if !defined HCF_TX_ERR_NOTIFY
#define HCF_TX_ERR_NOTIFY		0
#endif
#if HCF_TX_ERR_NOTIFY 
#undef HCF_MB_ON
#define HCF_MB_ON
#endif // HCF_TX_ERR_NOTIFY
#else // _WIN32_WCE
#ifdef HCF_TX_ERR_NOTIFY 
#undef HCF_MB_ON
#define HCF_MB_ON
#endif // HCF_TX_ERR_NOTIFY
#endif // _WIN32_WCE

#if (HCF_TYPE) & HCF_TYPE_HII
#define HCF_DLV 
//#define HCF_DLNV
#endif //HCF_TYPE_HII

#if !defined HCF_INT_OFF
#define HCF_INT_ON
#endif // HCF_INT_OFF

//#if !defined HCF_CARD_CHECK_OFF		/*obsolete under new WCI definition */
//#define	HCF_CARD_CHECK_ON
//#define	HCF_CARD_CHECK if ( ifbp->IFB_CardStat & CARD_STAT_PRESENT ) 
//#else
//#define HCF_CARD_CHECK
//#endif // HCF_CARD_CHECK_OFF

#define IFB_PIFRscInd		IFB_RscInd
#define IFB_DUIFRscInd		IFB_RscInd		
#define IFB_NotifyRscInd	IFB_RscInd		  
/*************************************************************************************************************/
/*********************** C O N F L I C T   D E T E C T I O N  &  R E S O L U T I O N *************************/
/*************************************************************************************************************/
#if defined _WVLAN_USB
#undef HCF_INT_ON
#if defined HCF_TYPE
#if ! ( (HCF_TYPE) & HCF_TYPE_USB ) 
there seems to be a conflict between HCF_TYPE and other macro definitions;
#endif // HCF_TYPE & HCF_TYPE_USB
#else
#define HCF_TYPE HCF_TYPE_USB		//default to: no SSN
#endif // HCF_TYPE
#endif // _WVLAN_USB

#if !defined HCF_TYPE
#define HCF_TYPE HCF_TYPE_HII		//default to Hermes-II
#endif 

#if (HCF_TYPE) & HCF_TYPE_HII
#undef HCF_IFB_SECURE
#undef HCF_MAX_CONFIG
#undef HCF_MAX_GROUP
#endif // HCF_TYPE

#if !( (HCF_TYPE) & HCF_TYPE_STA ) && !( (HCF_TYPE) & HCF_TYPE_AP )
you must define at least HCF_TYPE_STA or HCF_TYPE_AP;
//;?make sure this logic works on all relevant compilers;
/*#define HCF_TYPE__HCF_TYPE HCF_TYPE		//note that HCF_TYPE is garuanteed to be defined due to preceeding test
 *#undef HCF_TYPE
 *#define HCF_TYPE ( (HCF_TYPE__HCF_TYPE) | HCF_TYPE_STA )
 */
#endif

#if (HCF_TYPE) & (HCF_TYPE_STA|HCF_TYPE_AP) == 0
too bad, above logic does not seem to work;
#endif

#if defined HCF_ASSERT
#if HCF_ASSERT & 0x0002 && (HCF_TYPE) & HCF_TYPE_USB
err: conflict in assert which performs direct I/O in this case
#endif // HCF_ASSERT / HCF_TYPE_USB

#if HCF_ASSERT & 0x0004
//resolve potential conflict
#undef HCF_MB_OFF
#if !defined HCF_MB_ON
#define HCF_MB_ON
#endif // HCF_MB_ON
#endif // HCF_ASSERT
#endif // HCF_ASSERT

#if defined HCF_DEBUG && (HCF_TYPE) & HCF_TYPE_USB 
err: conflict in hcf_debug_trigger;
#endif // HCF_DEBUG / HCF_TYPE_USB
#endif //HCFCFG_H
