
option expr32
option casemap:none

; Begin of file hcf.h
;    vim:tw=110:ts=4:
HCF_H		EQU		1t
; ************************************************************************************************************
; *
; * FILE	 : hcf.h *************** 2.0 *************************************************************************
; *
; * DATE   : $Date: 2003/02/24 10:30:27 $   $Revision: 5.1.2.4 $
; *
; * AUTHOR : Nico Valster
; *
; * DESC   : Definitions and Prototypes for MSF as well as HCF sources
; *
; *			Customizable via HCFCFG.H
; *
; *
; **************************************************************************************************************
; Instructions to convert HCF.H to HCF.INC by means of H2INC
; 
; Use a command line which defines the specific macros and command line options
; needed to build the C-part, e.g. for the DOS ODI driver
; 		`h2inc /C /Ni /Zp /Zn hcf	 hcf.h`
; 
; 
; **************************************************************************************************************
; * COPYRIGHT (c) 1994 - 1995	by AT&T.	 			All Rights Reserved
; * COPYRIGHT (c) 1996 - 2000 by Lucent Technologies.	All Rights Reserved
; * COPYRIGHT (c) 2001 - 2002	by Agere Systems.		All Rights Reserved
; *************************************************************************************************************
;  System Constants to be defined by the MSF-programmer to tailor the HCF
; Begin of file hcfcfg.h
;    vim:tw=110:ts=4:
HCFCFG_H		EQU		1t
; *************************************************************************************************************
; *
; * FILE	 : hcfcfg.tpl // hcfcfg.h **************************** 2.0 ********************************************
; *
; * DATE   : $Date: 2003/02/24 10:30:27 $   $Revision: 5.1.2.4 $
; *
; * AUTHOR : Nico Valster
; *
; * DESC   : HCF Customization Macros
; *
; ***************************************************************************************************************
; * COPYRIGHT (c) 1994, 1995		 	by AT&T.	 			All Rights Reserved.
; * COPYRIGHT (c) 1996, 1997, 1998 	by Lucent Technologies.	All Rights Reserved.
; * COPYRIGHT (c) 2001, 2002			by Agere Systems.		All Rights Reserved.
; ***************************************************************************************************************
; *
; * hcfcfg.tpl list all #defines which must be specified to:
; *    I:	adjust the HCF functions defined in HCF.CPP to the characteristics of a specific environment
; * 		o maximum sizes for messages and notification frames, persistent configuration storage
; * 		o Endianess
; *
; *	II:	Compiler specific macros
; * 		o port I/O macros
; * 		o type definitions
; *
; *  III:	Environment specific ASSERT macro
; *
; *   IV: Compiler specific
; *
; *    V: ;? specific
; *
; *
; * By copying HCFCFG.TPL to HCFCFG.H and -if needed- modifying the #defines the WCI functionality can be
; * tailored
; *
; * Supported environments:
; WVLAN_41	Miniport                                NDIS 3.1
; WVLAN_42	Packet                                	Microsoft Visual C 1.5
; WVLAN_43	16 bits DOS ODI                      	Microsoft Visual C 1.5
; WVLAN_44	32 bits ODI (__NETWARE_386__)			WATCOM
; WVLAN_45	MAC_OS									MPW?, Symantec?
; WVLAN_46	Windows CE (_WIN32_WCE)					Microsoft ?
; WVLAN_47	LINUX  (__LINUX__)						GCC
; WVLAN_48	Miniport                                NDIS 5
; WVLAN_51	Miniport USB                            NDIS 5
; WVLAN_52	Miniport 		                        NDIS 4
; WVLAN_53	VxWorks END Station driver
; WVLAN_54	VxWorks END Access Point driver
; WVLAN_81	WavePoint								BORLAND C
; WCITST		Inhouse test tool						Microsoft Visual C 1.5
; WSU			WaveLAN Station Update					Microsoft Visual C ??
; SCO UNIX	not yet actually used ?					?
; __ppc		OEM supplied							?
; _AM29K		OEM supplied							?
; ?			OEM supplied							Microtec Research 80X86 Compiler
; 
; * T O   D O :  A D D   A   R E C I P E   H O W  T O   M O D I F Y  HCFCFG.H
; *
; *************************************************************************************************************
; ***************************************************************************
; *
; * CHANGE HISTORY
; *
; 
;   960702 - NV
; 	Original Entry - derived from HCF 2.12
; ************************************************************************************************
; ****************************    IN_PORT_STRING  S a m p l e s ***************************************************
; 
; 		// C implementation which let the processor handle the word-at-byte-boundary problem
; #define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { *(hcf_16 FAR*)dst = IN_PORT_WORD( prt ); dst += 2; }
; 
; 
; 		// C implementation which handles the word-at-byte-boundary problem 
; #define IN_PORT_STRING( prt, dst, n)	while ( n-- ) { int i = IN_PORT_WORD( prt ); *dst++ = (char)i; *dst++ = (char)(i >> 8); }
; 
; 
; 		// Assembler implementation
; #define IN_PORT_STRING( port, dest, len) __asm 		{														__asm push di                               		__asm push es                                 		__asm mov cx,len                            		__asm les di,dest                           		__asm mov dx,port                           		__asm rep insw                              		__asm pop es	                            		__asm pop di	                            	}
; 
;        
; *****************************************************************************************************************
; ****************************   OUT_PORT_STRING  S a m p l e s ***************************************************
;        
; 		// C implementation which let the processor handle the word-at-byte-boundary problem
; #define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *(hcf_16 FAR*)src ) ; src  += 2; }
; 
; 
; 		// C implementation which handles the word-at-byte-boundary problem 
; #define OUT_PORT_STRING( prt, src, n)	while ( n-- ) { OUT_PORT_WORD( prt, *src | *(src+1)<<8  ) ; src  += 2; }
; //;?  WHY hcf_16 FAR*)src and not unsigned char FAR*)src
; 
; 
; 												// Assembler implementation
; #define OUT_PORT_STRING( port, src, len) __asm		{                                               		__asm push si                                 		__asm push ds                                 		__asm mov cx,len                              		__asm lds si,src                             		__asm mov dx,port                             		__asm rep outsw	                            		__asm pop ds                                  		__asm pop si                                  	}
; 
; *****************************************************************************************************************
;   * * * * * * * * * * * * * * * * * * * * * *  I * * * * * * * * * * * * * * * * * * * * * * 
; 	Alignment
;  *	Some platforms can access words on odd boundaries (with possibly an performance impact), at other
;  *	platforms such an access may result in a memory access violation.
;  *	It is assumed that everywhere where the HCF casts a char pointer into a word pointer, the
;  *	alignment criteria are met. This put some restrictions on the MSF, which are assumed to be
;  *	"automatically" fulfilled at the applicable platforms
;  *	To assert this assumption, the macro HCF_ALIGN can be defined. The default value is 0, meaning no
;  *	alignment, a value of 2 means word alignment, other values are invalid
;  
;   * * * * * * * * * * * * * * * * * * * * * * II * * * * * * * * * * * * * * * * * * * * * * 
; **********************************************************************************************
; *****************  C O M P I L E R   S P E C I F I C   M A C R O S  **************************
; **********************************************************************************************
; ************************************************************************************************
; *
; * The platforms supported by this version are:
; *	- Microsoft Visual C 1.5 (16 bits platform)
; *	- Microsoft Visual C 2.0 (32 bits platform)
; *	- Watcom C/C++ 9.5
; *	- SCO UNIX
; *
; * In this version of hcfiocfg.tpl all macros except the MSVC 1.5 versions are either dependent on
; * compiler/environment supplied macros (e.g. _MSC_VER or "def-ed out"
; *
; * By selecting the appropriate Macro definitions by means of modifying the
; * "#ifdef 0/1" lines, the HCF can be adjusted for the I/O characteristics of
; * a specific compiler
; *
; * If needed the macros can be modified or replaced with definitions appropriate
; * for your personal platform
; * If you need to make such changes it is appreciated if you inform Lucent Technologies WCND Utrecht
; * That way the changes can become part of the next release of the WCI
; *
; *
; *	The prototypes and functional description of the macros are:
; *
; *	hcf_16	IN_PORT_WORD(  hcf_16 port)
; *			Reads a word (16 bits) from the specified port
; *
; *	void	OUT_PORT_WORD( hcf_16 port, hcf_16 value)
; *			Writes a word (16 bits) to the specified port
; *
; *	void	IN_PORT_STRING( port, dest, len)
; *			Reads len number of words from the specified port to the (FAR) address dest in PC-RAM
; *			Note that len specifies the number of words, NOT the number of bytes
; *			!!!NOTE, although len specifies the number of words, dest MUST be a char pointer NOTE!!!
; *			See also the common notes for IN_PORT_STRING and OUT_PORT_STRING
; *
; *	void	OUT_PORT_STRING( port, src, len)
; *			Writes len number of words from the (FAR) address src in PC-RAM to the specified port
; *			Note that len specifies the number of words, NOT the number of bytes.
; *			!!!NOTE, although len specifies the number of words, src MUST be a char pointer NOTE!!!
; *
; *			The peculiar combination of word-length and char pointers for IN_PORT_STRING as well as
; *			OUT_PORT_STRING is justified by the assumption that it offers a more optimal algorithm
; *
; *			Note to the HCF-implementor:
; *			Due to the passing of the parameters to compiler specific blabla.........
; *			do not use "expressions" as parameters, e.g. don't use "ifbp->IFB_IOBase + HREG_AUX_DATA" but
; *			assign this to a temporary variable.
; *
; *
; *  NOTE!!	For convenience of the MSF-programmer, all {IN|OUT}_PORT_{BYTE|WORD|STRING} macros are allowed to
; *			modify their parameters (although some might argue that this would constitute bad coding
; *			practice). This has its implications on the HCF, e.g. as a consequence these macros should not
; *			be called with parameters which have side effects, e.g auto-increment.
; *
; *  NOTE!!	in the Microsoft implementation of inline assembly it is O.K. to corrupt all flags except
; *			the direction flag and to corrupt all registers except the segment registers and EDI, ESI,
; *			ESP and EBP (or their 16 bits equivalents).
; *			Other environments may have other constraints
; *
; *  NOTE!!	in the Intel environment it is O.K to have a word (as a 16 bits quantity) at a byte boundary,
; *			hence IN_/OUT_PORT_STRING can move words between PC-memory and NIC-memory with as only
; *			constraint that the words are on a word boundary in NIC-memory. This does not hold true
; *			for all conceivable environments, e.g. an Motorola 68xxx does not allow this, in other
; *			words whenever there is a move from address in 2*n in one memory type to address 2*m+1 in the
; *			other type, the current templates for IN_/OUT_PORT_STRING are unsuitable. Probably the
; *			boundary conditions imposed by these type of platforms prevent this case from materializing
; *
; ************************************************************************************************
;  Note:
;  Visual C++ 1.5 : _MSC_VER ==  800
;  Visual C++ 4.0 : _MSC_VER == 1000
;  Visual C++ 4.2 : _MSC_VER == 1020
hcf_8		TYPEDEF		BYTE

hcf_16		TYPEDEF		WORD

hcf_32		TYPEDEF		DWORD

; ***************************** #define HCF_TYPE *****************************
; #define HCF_TYPE_HI_PRE_SSN	0x0000	// Hermes-I F/W without SSN support
;  SSN support
HCF_TYPE_SSN		EQU		000000001h
;  Host side for Internally developed USB Dongle driver support
HCF_TYPE_USB		EQU		000000002h
;  Hermes-II
HCF_TYPE_HII		EQU		000000004h
;  Access Point
HCF_TYPE_AP		EQU		000000010h
;  Station
HCF_TYPE_STA		EQU		000000020h
; **********************************************************************************************
; *****************************  M I N I P O R T    N D I S  3.1  ******************************
; **********************************************************************************************
; **********************************************************************************************
; ***************************  P A C K E T   D R I V E R  **************************************
; *********************************  D O S   O D I  ********************************************
; **********************************************************************************************
; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ To ease testing the different options ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;  Hermes-I F/W with SSN support
HCF_TYPE		EQU		000000021h
; #define HCF_TYPE (HCF_TYPE_STA | HCF_TYPE_USB	)		// Host side for Internally developed USB Dongle driver support
; #define HCF_TYPE (HCF_TYPE_STA | HCF_TYPE_HII )		// Hermes-II
; #define HCF_TYPE HCF_TYPE_STA							// Hermes-I F/W without SSN support
; //#define HCF_TYPE HCF_TYPE_HI_PRE_SSN	// Hermes-I F/W without SSN support
; /* alternatively */
; #undef  HCF_TYPE 						// Hermes-I F/W without SSN support
; #undef  HCF_ASSERT
; #define HCF_ASSERT    0x0002			//assert (also) via S/W Supp Register
; assert (also) in Mailbox
HCF_ASSERT		EQU		000000004h
; #define HCF_ASSERT	0x8000			//link msf_assert routine statically
; #define HCF_INT_OFF
; #define HCF_DOWNLOAD_OFF
; #define HCF_CARD_CHECK_OFF
; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ To ease testing the different options ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
MSF_COMPONENT_VAR		EQU		1t
MSF_COMPONENT_MAJOR_VER		EQU		6t
MSF_COMPONENT_MINOR_VER		EQU		10t
;  number of Multicast Addresses supported by ODI/Packet
HCF_MAX_GROUP		EQU		16t
;  segmented 16 bits mode
;  WVLAN_42, WVLAN_43, H2_LDR
; Begin of file /MSVC/INCLUDE\stdio.h
; **
; *stdio.h - definitions/declarations for standard I/O routines
; *
; *   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
; *
; *Purpose:
; *   This file defines the structures, values, macros, and functions
; *   used by the level 2 I/O ("standard I/O") routines.
; *   [ANSI/System V]
; *
; ***
size_t		TYPEDEF		WORD

va_list		TYPEDEF		PTR SBYTE

;  buffered I/O macros 
BUFSIZ		EQU		512t
_NFILE		EQU		20t
EOF		EQU		0ffffffffh
@t_msf430		TYPEDEF		PTR SBYTE
@t_msf431		TYPEDEF		PTR SBYTE
_iobuf		STRUCT 2t
_ptr		@t_msf430		?
_cnt		SWORD		?
_base		@t_msf431		?
_flag		SBYTE		?
_file		SBYTE		?
_iobuf		ENDS

FILE		TYPEDEF		_iobuf

;  _P_tmpnam: Directory where temporary files may be created.
;  * L_tmpnam size =  size of _P_tmpdir
;  *  + 1 (in case _P_tmpdir does not end in "")
;  *  + 6 (for the temp number string)
;  *  + 1 (for the null terminator)
;  
;  fseek constants 
SEEK_CUR		EQU		1t
SEEK_END		EQU		2t
SEEK_SET		EQU		0t
;  minimum guaranteed filename length, open file count, and unique
;  * tmpnam filenames.
;  
FILENAME_MAX		EQU		128t
FOPEN_MAX		EQU		18t
TMP_MAX		EQU		32767t
_SYS_OPEN		EQU		20t
;  define NULL pointer value 
;  declare _iob[] array 
EXTERNDEF		C _iob:FILE

;  define file position type 
fpos_t		TYPEDEF		SDWORD

;  standard file pointers 
_IOREAD		EQU		000000001h
_IOWRT		EQU		000000002h
_IOFBF		EQU		000000000h
_IOLBF		EQU		000000040h
_IONBF		EQU		000000004h
_IOMYBUF		EQU		000000008h
_IOEOF		EQU		000000010h
_IOERR		EQU		000000020h
_IOSTRG		EQU		000000040h
_IORW		EQU		000000080h
;  function prototypes 
@proto_msf430		TYPEDEF		PROTO C :PTR FILE
_filbuf		PROTO		@proto_msf430

@proto_msf431		TYPEDEF		PROTO C :SWORD, :PTR FILE
_flsbuf		PROTO		@proto_msf431

@proto_msf432		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :SWORD
_fsopen		PROTO		@proto_msf432

@proto_msf433		TYPEDEF		PROTO C :PTR FILE
clearerr		PROTO		@proto_msf433

@proto_msf434		TYPEDEF		PROTO C :PTR FILE
fclose		PROTO		@proto_msf434

@proto_msf435		TYPEDEF		PROTO C 
_fcloseall		PROTO		@proto_msf435

@proto_msf436		TYPEDEF		PROTO C :SWORD, :PTR SBYTE
_fdopen		PROTO		@proto_msf436

@proto_msf437		TYPEDEF		PROTO C :PTR FILE
feof		PROTO		@proto_msf437

@proto_msf438		TYPEDEF		PROTO C :PTR FILE
ferror		PROTO		@proto_msf438

@proto_msf439		TYPEDEF		PROTO C :PTR FILE
fflush		PROTO		@proto_msf439

@proto_msf4310		TYPEDEF		PROTO C :PTR FILE
fgetc		PROTO		@proto_msf4310

@proto_msf4311		TYPEDEF		PROTO C 
_fgetchar		PROTO		@proto_msf4311

@proto_msf4312		TYPEDEF		PROTO C :PTR FILE, :PTR fpos_t
fgetpos		PROTO		@proto_msf4312

@proto_msf4313		TYPEDEF		PROTO C :PTR SBYTE, :SWORD, :PTR FILE
fgets		PROTO		@proto_msf4313

@proto_msf4314		TYPEDEF		PROTO C :PTR FILE
_fileno		PROTO		@proto_msf4314

@proto_msf4315		TYPEDEF		PROTO C 
_flushall		PROTO		@proto_msf4315

@proto_msf4316		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE
fopen		PROTO		@proto_msf4316

@proto_msf4317		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE, :VARARG
fprintf		PROTO		@proto_msf4317

@proto_msf4318		TYPEDEF		PROTO C :SWORD, :PTR FILE
fputc		PROTO		@proto_msf4318

@proto_msf4319		TYPEDEF		PROTO C :SWORD
_fputchar		PROTO		@proto_msf4319

@proto_msf4320		TYPEDEF		PROTO C :PTR SBYTE, :PTR FILE
fputs		PROTO		@proto_msf4320

@proto_msf4321		TYPEDEF		PROTO C :PTR , :size_t, :size_t, :PTR FILE
fread		PROTO		@proto_msf4321

@proto_msf4322		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :PTR FILE
freopen		PROTO		@proto_msf4322

@proto_msf4323		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE, :VARARG
fscanf		PROTO		@proto_msf4323

@proto_msf4324		TYPEDEF		PROTO C :PTR FILE, :PTR SDWORD
fsetpos		PROTO		@proto_msf4324

@proto_msf4325		TYPEDEF		PROTO C :PTR FILE, :SDWORD, :SWORD
fseek		PROTO		@proto_msf4325

@proto_msf4326		TYPEDEF		PROTO C :PTR FILE
ftell		PROTO		@proto_msf4326

@proto_msf4327		TYPEDEF		PROTO C :PTR , :size_t, :size_t, :PTR FILE
fwrite		PROTO		@proto_msf4327

@proto_msf4328		TYPEDEF		PROTO C :PTR FILE
getc		PROTO		@proto_msf4328

@proto_msf4329		TYPEDEF		PROTO C 
getchar		PROTO		@proto_msf4329

@proto_msf4330		TYPEDEF		PROTO C :PTR SBYTE
gets		PROTO		@proto_msf4330

@proto_msf4331		TYPEDEF		PROTO C :PTR FILE
_getw		PROTO		@proto_msf4331

@proto_msf4332		TYPEDEF		PROTO C :PTR SBYTE
perror		PROTO		@proto_msf4332

@proto_msf4333		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
printf		PROTO		@proto_msf4333

@proto_msf4334		TYPEDEF		PROTO C :SWORD, :PTR FILE
putc		PROTO		@proto_msf4334

@proto_msf4335		TYPEDEF		PROTO C :SWORD
putchar		PROTO		@proto_msf4335

@proto_msf4336		TYPEDEF		PROTO C :PTR SBYTE
puts		PROTO		@proto_msf4336

@proto_msf4337		TYPEDEF		PROTO C :SWORD, :PTR FILE
_putw		PROTO		@proto_msf4337

@proto_msf4338		TYPEDEF		PROTO C :PTR SBYTE
remove		PROTO		@proto_msf4338

@proto_msf4339		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE
rename		PROTO		@proto_msf4339

@proto_msf4340		TYPEDEF		PROTO C :PTR FILE
rewind		PROTO		@proto_msf4340

@proto_msf4341		TYPEDEF		PROTO C 
_rmtmp		PROTO		@proto_msf4341

@proto_msf4342		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
scanf		PROTO		@proto_msf4342

@proto_msf4343		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE
setbuf		PROTO		@proto_msf4343

@proto_msf4344		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE, :SWORD, :size_t
setvbuf		PROTO		@proto_msf4344

@proto_msf4345		TYPEDEF		PROTO C :PTR SBYTE, :size_t, :PTR SBYTE, :VARARG
_snprintf		PROTO		@proto_msf4345

@proto_msf4346		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :VARARG
sprintf		PROTO		@proto_msf4346

@proto_msf4347		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :VARARG
sscanf		PROTO		@proto_msf4347

@proto_msf4348		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE
_tempnam		PROTO		@proto_msf4348

@proto_msf4349		TYPEDEF		PROTO C 
tmpfile		PROTO		@proto_msf4349

@proto_msf4350		TYPEDEF		PROTO C :PTR SBYTE
tmpnam		PROTO		@proto_msf4350

@proto_msf4351		TYPEDEF		PROTO C :SWORD, :PTR FILE
ungetc		PROTO		@proto_msf4351

@proto_msf4352		TYPEDEF		PROTO C :PTR SBYTE
_unlink		PROTO		@proto_msf4352

@proto_msf4353		TYPEDEF		PROTO C :PTR FILE, :PTR SBYTE, :va_list
vfprintf		PROTO		@proto_msf4353

@proto_msf4354		TYPEDEF		PROTO C :PTR SBYTE, :va_list
vprintf		PROTO		@proto_msf4354

@proto_msf4355		TYPEDEF		PROTO C :PTR SBYTE, :size_t, :PTR SBYTE, :va_list
_vsnprintf		PROTO		@proto_msf4355

@proto_msf4356		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE, :va_list
vsprintf		PROTO		@proto_msf4356

;  macro definitions 
;  Non-ANSI names for compatibility 
SYS_OPEN		EQU		000000014h
@proto_msf4357		TYPEDEF		PROTO C 
fcloseall		PROTO		@proto_msf4357

@proto_msf4358		TYPEDEF		PROTO C :SWORD, :PTR SBYTE
fdopen		PROTO		@proto_msf4358

@proto_msf4359		TYPEDEF		PROTO C 
fgetchar		PROTO		@proto_msf4359

@proto_msf4360		TYPEDEF		PROTO C :PTR FILE
fileno		PROTO		@proto_msf4360

@proto_msf4361		TYPEDEF		PROTO C 
flushall		PROTO		@proto_msf4361

@proto_msf4362		TYPEDEF		PROTO C :SWORD
fputchar		PROTO		@proto_msf4362

@proto_msf4363		TYPEDEF		PROTO C :PTR FILE
getw		PROTO		@proto_msf4363

@proto_msf4364		TYPEDEF		PROTO C :SWORD, :PTR FILE
putw		PROTO		@proto_msf4364

@proto_msf4365		TYPEDEF		PROTO C 
rmtmp		PROTO		@proto_msf4365

@proto_msf4366		TYPEDEF		PROTO C :PTR SBYTE, :PTR SBYTE
tempnam		PROTO		@proto_msf4366

@proto_msf4367		TYPEDEF		PROTO C :PTR SBYTE
unlink		PROTO		@proto_msf4367

; End of file /MSVC/INCLUDE\stdio.h
; Begin of file /MSVC/INCLUDE\conio.h
; **
; *conio.h - console and port I/O declarations
; *
; *   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
; *
; *Purpose:
; *   This include file contains the function declarations for
; *   the MS C V2.03 compatible console and port I/O routines.
; *
; ***
;  function prototypes 
@proto_msf4368		TYPEDEF		PROTO C :PTR SBYTE
_cgets		PROTO		@proto_msf4368

@proto_msf4369		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
_cprintf		PROTO		@proto_msf4369

@proto_msf4370		TYPEDEF		PROTO C :PTR SBYTE
_cputs		PROTO		@proto_msf4370

@proto_msf4371		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
_cscanf		PROTO		@proto_msf4371

@proto_msf4372		TYPEDEF		PROTO C 
_getch		PROTO		@proto_msf4372

@proto_msf4373		TYPEDEF		PROTO C 
_getche		PROTO		@proto_msf4373

@proto_msf4374		TYPEDEF		PROTO C :WORD
_inp		PROTO		@proto_msf4374

@proto_msf4375		TYPEDEF		PROTO C :WORD
_inpw		PROTO		@proto_msf4375

@proto_msf4376		TYPEDEF		PROTO C 
_kbhit		PROTO		@proto_msf4376

@proto_msf4377		TYPEDEF		PROTO C :WORD, :SWORD
_outp		PROTO		@proto_msf4377

@proto_msf4378		TYPEDEF		PROTO C :WORD, :WORD
_outpw		PROTO		@proto_msf4378

@proto_msf4379		TYPEDEF		PROTO C :SWORD
_putch		PROTO		@proto_msf4379

@proto_msf4380		TYPEDEF		PROTO C :SWORD
_ungetch		PROTO		@proto_msf4380

;  Non-ANSI names for compatibility 
@proto_msf4381		TYPEDEF		PROTO C :PTR SBYTE
cgets		PROTO		@proto_msf4381

@proto_msf4382		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
cprintf		PROTO		@proto_msf4382

@proto_msf4383		TYPEDEF		PROTO C :PTR SBYTE
cputs		PROTO		@proto_msf4383

@proto_msf4384		TYPEDEF		PROTO C :PTR SBYTE, :VARARG
cscanf		PROTO		@proto_msf4384

@proto_msf4385		TYPEDEF		PROTO C 
getch		PROTO		@proto_msf4385

@proto_msf4386		TYPEDEF		PROTO C 
getche		PROTO		@proto_msf4386

@proto_msf4387		TYPEDEF		PROTO C :WORD
inp		PROTO		@proto_msf4387

@proto_msf4388		TYPEDEF		PROTO C :WORD
inpw		PROTO		@proto_msf4388

@proto_msf4389		TYPEDEF		PROTO C 
kbhit		PROTO		@proto_msf4389

@proto_msf4390		TYPEDEF		PROTO C :WORD, :SWORD
outp		PROTO		@proto_msf4390

@proto_msf4391		TYPEDEF		PROTO C :WORD, :WORD
outpw		PROTO		@proto_msf4391

@proto_msf4392		TYPEDEF		PROTO C :SWORD
putch		PROTO		@proto_msf4392

@proto_msf4393		TYPEDEF		PROTO C :SWORD
ungetch		PROTO		@proto_msf4393

; End of file /MSVC/INCLUDE\conio.h
; #ifndef _DEBUG
; #endif // _DEBUG
;  C implementation which let the processor handle the word-at-byte-boundary problem
;  Asm or C implementation
;  H_2_INC 
;  WVLAN_43, WVLAN_42 (DOS ODI, Packet Driver) 
; **********************************************************************************************
; ***************************  N E T W A R E   3 8 6  ******************************************
; **********************************************************************************************
; **********************************************************************************************
; **********************************  M A C  O S   *********************************************
; **********************************************************************************************
; ********
; **********************************************************************************************
; **********************************  W I N C E ************************************************
; **********************************************************************************************
; *****************
;  WVLAN_46, WINCE 
; **********************************************************************************************
; *****************************************  L I N U X  ****************************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************  M I N I P O R T    N D I S  5.0 / 5.1 *************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************  M I N I P O R T    N D I S  4    ******************************
; **********************************************************************************************
; **********************************************************************************************
; ********************************************  Q N X  *****************************************
; **********************************************************************************************
; **********************************************************************************************
; ********************************************  B E O S  ***************************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************  M I N I P O R T  U S B   N D I S  5    ************************
; **********************************************************************************************
; **********************************************************************************************
; *******************************  U S B   D O N G L E  ****************************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************************  FreeBSD  ******************************************
; **********************************************************************************************
; **********************************************************************************************
; ********************************  W A V E P O I N T  *****************************************
; **********************************************************************************************
; **********************************************************************************************
; *******************************  W A V E L A U N C H  ****************************************
; **********************************************************************************************
; **********************************************************************************************
; ************************************  W C I T S T ********************************************
; **********************************************************************************************
; **********************************************************************************************
; ********************************* S C O   U N I X  *******************************************
; **********************************************************************************************
; **********************************************************************************************
; ******************************  Motorola Power PC 800 family  ********************************
; **********************************************************************************************
;  known users: LH@I
;  
; **********************************************************************************************
; *********************************   Diab or High C 29K   *************************************
; **********************************************************************************************
;  known users: GK@C
;  
; **********************************************************************************************
; ****************************************  MPC860 *********************************************
; **********************************************************************************************
;  known users: RR
;  
; ;? JohanB #if 0
; ;? JohanB #endif //0
; **********************************************************************************************
; ***************************  Microtec Research 80X86 Compiler ********************************
; **********************************************************************************************
; **********************************************************************************************
; *****************************  W A V E L A N  E C  *******************************************
; **********************************************************************************************
;  known users: KM
;  
; *******
;  LC302 
;  Vinay.B : Added for NGAP : Jan 12th, 2000 
; **********************************************************************************************
; ********************************  NGAP   **************************************
; **********************************************************************************************
;   * * * * * * * * * * * * * * * * * * * * * *  IV  * * * * * * * * * * * * * * * * * * * * * * 
; **************************************Compiler specific ***************************************
; __cplusplus
; EXTERN_C
; **********************************************************************************************
; ********* M A C R O S derived of C O M P I L E R   S P E C I F I C   M A C R O S  ************
; **********************************************************************************************
wci_bufp		TYPEDEF		FAR PTR hcf_8

;  segmented 16-bits or flat 32-bits pointer to 8 bits unit
wci_recordp		TYPEDEF		FAR PTR hcf_16

;  segmented 16-bits or flat 32-bits pointer to 16 bits unit
;   * * * * * * * * * * * * * * * * * * * * * *  V  * * * * * * * * * * * * * * * * * * * * * * 
; 	I/O Address size
;  *	Platforms which use port mapped I/O will (in general) have a 64k I/O space, conveniently expressed in
;  *	a 16-bits quantity
;  *	Platforms which use memory mapped I/O will (in general) have an I/O space much larger than 64k,
;  *	and need a 32-bits quantity to express the I/O base
;  *	To accommodate this the macro HCF_MEM_IO is available. If HCF_MEM_IO is not defined, the HCF uses an 
;  *	hcf_16 to express I/O base and store in the IFB. If HCF_MEM_IO is defined, an hcf_32 is used.
;  
hcf_io		TYPEDEF		hcf_16

; HCF_MEM_IO
;  MSF_COMPONENT_ID is used to define the CFG_IDENTITY_STRCT in HCF.C
;  * CFG_IDENTITY_STRCT is defined in HCF.C purely based on convenience arguments
;  * The HCF can not have the knowledge to determine the ComponentId field of the
;  * Identity record (aka as Version Record), therefore the MSF part of the Drivers
;  * must supply this value via the System Constant MSF_COMPONENT_ID
;  * There is a set of values predefined in MDD.H (format COMP_ID_.....)
;  *
;  * Note that taking MSF_COMPONENT_ID as a default value for DUI_COMPAT_VAR is
;  * purely an implementation convenience, the numerical values of these two
;  * quantities have none functional relationship whatsoever.
;  * Originally there was only a single DUI-variant with value 1. 
;  * Then it was considered advantageous to have unique DUI-variant per driver and 
;  * - as said before - out of convenience these variants where chosen to have 
;  * the same numerical value as the component id of the driver.
;  * Again later, it was decided that there would be two Miniport 3.1 drivers,
;  * the old one continuing to have DUI-variant and component ID 41, the new 
;  * one (the STAP or HomeLAN driver) having component ID 41 but DUI-variant 2 (since
;  * 1 was already used in the past)
;  
; !defined DUI_COMPAT_VAR
; ;?this way utilities can lower as well raise the bottom
DUI_COMPAT_BOT		EQU		7t
;  DUI_COMPAT_BOT
; ;?this way utilities can lower as well raise the top
DUI_COMPAT_TOP		EQU		7t
;  DUI_COMPAT_TOP
;  MSF_COMPONENT_ID
; PCCard
; MiniPCI
;  WaveLAN
; **********************************************************************************************
; *****  M S F    S U P P O R T    F U N C T I O N S    P R O T O T Y P E S   ******************
; **********************************************************************************************
; ******************************************* A L I G N M E N T  **********************************************
; default to no alignment
HCF_ALIGN		EQU		1t
;  HCF_ALIGN
;  maximum accumulated size in hcf_16 of LTV records used in hcf_put_info
; 									 * use of this feature is not recomanded and may be abondaned in the future
; 									 
HCF_MAX_CONFIG		EQU		256t
;  WaveLAN Packet Size in bytes
HCF_MAX_MSG		EQU		1514t
;  ;? requires some thought, this copes with "default" DownLoadBufferLenght
HCF_MAX_LTV		EQU		000001001h
;  number of 10K microseconds protection timer against H/W malfunction
HCF_PROT_TIME		EQU		256t
; 	Endianess
;  *	Little Endian (a.k.a. Intel), least significant byte first
;  *	Big Endian (a.k.a. Motorola), most significant byte first
;  *
;  * The following macros are supplied
;  *  o CNV_LITTLE_TO_INT(w)			interprets the 16-bits input value as Little Endian, returns an hcf_16
;  * 	o CNV_BIG_TO_INT(w)				interprets the 16-bits input value as Big Endian, returns an hcf_16
;  * 	o CNV_INT_TO_BIG_NP(addr)		converts in place the 16-bit value addressed by a near pointer from hcf_16
;  * 									to Big Endian
;  * 	o CNV_LITTLE_TO_INT_NP(addr)	converts in place the 16-bit value addressed by a near pointer from
;  *									Little endian to hcf_16
;  *
;  * At a number of places in the HCF code, the CNV_INT_TO_BIG_NP macro is used. While it does have the desired
;  * effect on all platforms, it's naming is misleading, so revisit all places where these CNV macros are used
;  * to assure the right name is used at the right place.
;  * Hint: introduce CNV_HOST_TO_NETWORK names if appropriate
;  *
;  
;  To increase portability, use unsigned char and unsigned char * when accessing parts of larger
;  * types to convert their Endianess
;  
; ****************************************** L I T T L E   E N D I A N ****************************************
;  no endianess conversion needed
;     endianess conversion needed
;  HCF_BIG_ENDIAN
;  conversion macros which can be expressed in other macros
; ***********************************************************************************************************
; ******************************************* . . . . . . . . .  ********************************************
; ***********************************************************************************************************
;  The BASED customization macro is used to resolves the SS!=DS conflict for the Interrupt Service
;  * logic in DOS Drivers. Due to the cumbersomeness of mixing C and assembler local BASED variables
;  * still end up in the wrong segment. The workaround is that the HCF uses only global BASED
;  * variables or IFB-based variables
;  * The "BASED" construction (supposedly) only amounts to something in the small memory model.
;  *
;  * Note that the whole BASED rigmarole is needlessly complicated because both the Microsoft Compiler and
;  * Linker are unnecessary restrictive in what far pointer manipulation they allow
;  
; /*conflicts with ULTSDEMO
; conflicts with ULTSDEMO*/
; to be deleted after testing (in favor of a more appropriate place)
; to be deleted after testing (in favor of a more appropriate place)
; #define HCF_TX_ERR_NOTIFY	//to be deleted after testing of MIC
; to be deleted after testing of MIC
; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!Do Not Forget to add HCF_DLV etc when appropriate
; ***********************************************************************************************************
; *********************************** M I G R A T I O N   A S P E C T S *************************************
; ***********************************************************************************************************
HCF_ENCAPSULATION		EQU		1t
;  HCF_ENCAPSULATION
;  HCF_MB_OFF
;  HCF_TX_ERR_NOTIFY
;  HCF_DOWNLOAD_OFF
;  HCF_INT_OFF
; ***********************************************************************************************************
; ********************** C O N F L I C T   D E T E C T I O N  &  R E S O L U T I O N ************************
; ***********************************************************************************************************
; resolve potential conflict
;  HCF_ASSERT
;  HCF_ASSERT
; HCFCFG_H
; End of file hcfcfg.h
;  Include file common for HCF, MSF, UIL, USF
; Begin of file mdd.h
CFG_PROG_STOP		EQU		000000000h
CFG_PROG_VOLATILE		EQU		000000100h
CFG_PROG_FLASH		EQU		000000300h
CFG_PROG_SEEPROM		EQU		000001300h
CFG_PROG_SEEPROM_READBACK		EQU		000000400h
MDD_H		EQU		1t
; ************************************************************************************************************
; *
; * FILE	  : mdd.h
; *
; * DATE    : $Date: 2003/02/24 10:30:27 $   $Revision: 5.1.2.4 $
; *
; * AUTHOR  : Nico Valster
; *
; * DESC   : Definitions and Prototypes for HCF, MSF, UIL as well as USF sources
; *
; ***************************************************************************************************************
; * COPYRIGHT (c) 1994 - 1995	by AT&T.	 			All Rights Reserved
; * COPYRIGHT (c) 1996 - 2000 by Lucent Technologies.	Rights Reserved
; * COPYRIGHT (c) 2001 - 2002	by Agere Systems.		All Rights Reserved
; *************************************************************************************************************
; *************************************************************************************************************
; *
; * Implementation Notes
; *
;  -	Typ rather than type is used as field names in structures like CFG_CIS_STRCT because type leads to
;  	conflicts with MASM when the H-file is converted to an INC-file
; *
; ***************************************************************************************************************
; Instructions to convert MDD.H to MDD.INC by means of H2INC
; 
; Use a command line which defines the specific macros and command line options
; needed to build the C-part, e.g. for the DOS ODI driver
; 		`h2inc /C  /DH_2_INC /Ni /Zp /Zn mdd	 mdd.h`
; 
; 
; 
; *
; * ToDo
; *
; 
; *************************************************************************************************************
; *************************************************************************************************************
; *
; * The macros Xn(...) and XXn(...) are used to define the LTV's (short for Length Type Value[ ]) ,
; * aka RIDs, processed by the Hermes.
; * The n in Xn and XXn reflects the number of "Value" fields in these RIDs.
; *
; * Xn(...) : Macros used for RIDs which use only type hcf_16 for the "V" fields of the LTV.
; * Xn takes as parameters a RID name and "n" name(s), one for each of the "V" fields of the LTV.
; *
; * XXn(...) : Macros used for RIDs which use at least one other type then hcf_16 for a "V" field
; * of the LTV.
; * XXn(..) takes as parameters a RID name and "n" pair(s) of type and name, one for each "V" field
; * of the LTV
; 
;  ******************************************  e x a m p l e s  **************************************************
; 
; * X1(RID_NAME, parameters...) : expands to :
; *    typedef struct RID_NAME_STRCT {
; *         hcf_16  len;
; *         hcf_16  typ;
; *         hcf_16  par1;
; *    } RID_NAME_STRCT;
; 
; * X2(RID_NAME, parameters...) : expands to :
; *    typedef struct RID_NAME_STRCT {
; *         hcf_16  len;
; *         hcf_16  typ;
; *         hcf_16  par1;
; *         hcf_16  par2;
; *    } RID_NAME_STRCT;
; 
; 
; * XX1(RID_NAME, par1type, par1name, ...) : expands to :
; *    typedef struct RID_NAME_STRCT {
; *       hcf_16    len;
; *       hcf_16    typ;
; *       par1type  par1name;
; *    } RID_NAME_STRCT;
; 
; **************************************************************************************************************
; ****************************** General define **************************************************************
MAC_ADDR_SIZE		EQU		6t
GROUP_ADDR_SIZE		EQU		0000000c0h
STAT_NAME_SIZE		EQU		32t
; channelset structure used in the CFG_CNF_COUNTRY LTV
CHANNEL_SET		STRUCT 1t
first_channel		hcf_16		?
number_of_channels		hcf_16		?
max_tx_output_level		hcf_16		?
CHANNEL_SET		ENDS

;  key structure used in the CFG_DEFAULT_KEYS LTV
; length of key
; encryption key
KEY_STRCT		STRUCT 1t
len		hcf_16		?
key		hcf_8		14t DUP (?)
KEY_STRCT		ENDS

;  Scan Result structure used in the CFG_SCAN LTV
SCAN_RS_STRCT		STRUCT 1t
channel_id		hcf_16		?
noise_level		hcf_16		?
signal_level		hcf_16		?
bssid		hcf_8		6t DUP (?)
beacon_interval_time		hcf_16		?
capability		hcf_16		?
ssid_len		hcf_16		?
ssid_val		hcf_8		32t DUP (?)
SCAN_RS_STRCT		ENDS

;  range specification structure used in CFG_RANGES, CFG_RANGE1 etc
CFG_RANGE_SPEC_STRCT		STRUCT 1t
number		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_RANGE_SPEC_STRCT		ENDS

;  byte oriented range specification structure used in CFG_RANGE_B LTV
CFG_RANGE_SPEC_BYTE_STRCT		STRUCT 1t
number		hcf_8		2t DUP (?)
bottom		hcf_8		2t DUP (?)
top		hcf_8		2t DUP (?)
CFG_RANGE_SPEC_BYTE_STRCT		ENDS

LTV_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
val		hcf_16		1t DUP (?)
LTV_STRCT		ENDS

; the LTV proto typ	
LTV_MAX_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
val		hcf_16		4097t DUP (?)
LTV_MAX_STRCT		ENDS

; the maximum LTV proto typ	
CFG_MB_ASSERT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
trace		hcf_16		?
qualifier		hcf_16		?
line		hcf_16		?
file_name		hcf_8		10t DUP (?)
CFG_MB_ASSERT_STRCT		ENDS

; MailBox InfoBlock containing assert (T:0x0831 (CFG_MB_ASSERT)) 
CFG_HCF_OPT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
val		hcf_16		20t DUP (?)
CFG_HCF_OPT_STRCT		ENDS

; the HCF (Compile time) option	
CFG_CMD_HCF_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
cmd		hcf_16		?
mode		hcf_16		?
add_info		hcf_16		?
CFG_CMD_HCF_STRCT		ENDS

; Program LTV	
CFG_PROG_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mode		hcf_16		?
low_addr		hcf_16		?
high_addr		hcf_16		?
dl_data		hcf_16		1t DUP (?)
CFG_PROG_STRCT		ENDS

; Program LTV	
CFG_RANGES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		1t DUP (<>)
CFG_RANGES_STRCT		ENDS

; CFG_DRV_SUP_RANGE (0x0827), CFG_DRV_ACT_RANGES_STA (0x0829) 
CFG_RANGE1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		1t DUP (<>)
CFG_RANGE1_STRCT		ENDS

; CFG_DRV_SUP_RANGE (0x0827), CFG_DRV_ACT_RANGES_STA (0x0829) 
CFG_RANGE2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		2t DUP (<>)
CFG_RANGE2_STRCT		ENDS

; CFG_DRV_ACT_RANGES_PRI (0x0828) 
CFG_RANGE3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		3t DUP (<>)
CFG_RANGE3_STRCT		ENDS

; CFG_DRV_ACT_RANGES_PRI (0x0828) 
CFG_RANGE4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		4t DUP (<>)
CFG_RANGE4_STRCT		ENDS

; CFG_DRV_ACT_RANGES_PRI (0x0828) 
CFG_RANGE5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		5t DUP (<>)
CFG_RANGE5_STRCT		ENDS

; CFG_DRV_ACT_RANGES_PRI (0x0828) 
CFG_RANGE6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		6t DUP (<>)
CFG_RANGE6_STRCT		ENDS

; CFG_DRV_ACT_RANGES_PRI (0x0828) 
CFG_RANGE7_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		7t DUP (<>)
CFG_RANGE7_STRCT		ENDS

; CFG_DRV_ACT_RANGES_PRI (0x0828) 
CFG_RANGE20_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_STRCT		20t DUP (<>)
CFG_RANGE20_STRCT		ENDS

; CFG_DRV_ACT_RANGES_PRI (0x0828) 
CFG_RANGE_B_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		CFG_RANGE_SPEC_BYTE_STRCT		20t DUP (<>)
CFG_RANGE_B_STRCT		ENDS

; CFG_DRV_ACT_RANGES_PRI (0x0828) 
; Static Configurations 
CFG_CNF_PORT_TYPE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
port_type		hcf_16		?
CFG_CNF_PORT_TYPE_STRCT		ENDS

; [STA] Connection control characteristics
CFG_MAC_ADDR_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_MAC_ADDR_STRCT		ENDS

; general: 0xFC01, 0xFC08, 0xFC11, 0xFC12, 0xFC13, 0xFC14, 0xFC15, 0xFC16 
CFG_CNF_OWN_MAC_ADDR_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_OWN_MAC_ADDR_STRCT		ENDS

CFG_ID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_ID_STRCT		ENDS

; 0xFC02, 0xFC04, 0xFC0E 
; 	X1( CFG_DESIRED_SSID,			ssid[17]			 )	see Dynamic Configurations 
CFG_CNF_OWN_CHANNEL_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
channel		hcf_16		?
CFG_CNF_OWN_CHANNEL_STRCT		ENDS

; Communication channel for BSS creation
CFG_CNF_OWN_SSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_CNF_OWN_SSID_STRCT		ENDS

CFG_CNF_OWN_ATIM_WINDOW_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
atim_window		hcf_16		?
CFG_CNF_OWN_ATIM_WINDOW_STRCT		ENDS

CFG_CNF_SYSTEM_SCALE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
system_scale		hcf_16		?
CFG_CNF_SYSTEM_SCALE_STRCT		ENDS

CFG_CNF_MAX_DATA_LEN_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
max_data_len		hcf_16		?
CFG_CNF_MAX_DATA_LEN_STRCT		ENDS

CFG_CNF_WDS_ADDR_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR_STRCT		ENDS

; [STA] MAC Address of corresponding WDS Link node
CFG_CNF_PM_ENABLED_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
pm_enabled		hcf_16		?
CFG_CNF_PM_ENABLED_STRCT		ENDS

; [STA] Switch for ESS Power Management (PM) On/Off
CFG_CNF_PM_EPS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
pm_eps		hcf_16		?
CFG_CNF_PM_EPS_STRCT		ENDS

; [STA] Switch for ESS PM EPS/PS Mode
CFG_CNF_MCAST_RX_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mcast_rx		hcf_16		?
CFG_CNF_MCAST_RX_STRCT		ENDS

; [STA] Switch for ESS PM Multicast reception On/Off
CFG_CNF_MAX_SLEEP_DURATION_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
duration		hcf_16		?
CFG_CNF_MAX_SLEEP_DURATION_STRCT		ENDS

; [STA] Maximum sleep time for ESS PM
CFG_CNF_PM_HOLDOVER_DURATION_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
duration		hcf_16		?
CFG_CNF_PM_HOLDOVER_DURATION_STRCT		ENDS

; [STA] Holdover time for ESS PM
CFG_CNF_OWN_NAME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_CNF_OWN_NAME_STRCT		ENDS

; Identification text for diagnostic purposes
CFG_CNF_OWN_DTIM_PERIOD_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
period		hcf_16		?
CFG_CNF_OWN_DTIM_PERIOD_STRCT		ENDS

; [AP] Beacon intervals between successive DTIMs
CFG_CNF_WDS_ADDR1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR1_STRCT		ENDS

; [AP] Port 1 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR2_STRCT		ENDS

; [AP] Port 2 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR3_STRCT		ENDS

; [AP] Port 3 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR4_STRCT		ENDS

; [AP] Port 4 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR5_STRCT		ENDS

; [AP] Port 5 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CNF_WDS_ADDR6_STRCT		ENDS

; [AP] Port 6 MAC Adrs of corresponding WDS Link node
CFG_CNF_MCAST_PM_BUF_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mcast_pm_buf		hcf_16		?
CFG_CNF_MCAST_PM_BUF_STRCT		ENDS

; [AP] Switch for PM buffereing of Multicast Messages
CFG_CNF_REJECT_ANY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
reject_any		hcf_16		?
CFG_CNF_REJECT_ANY_STRCT		ENDS

; [AP] Switch for PM buffereing of Multicast Messages
CFG_CNF_ENCRYPTION_ENABLED_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
encryption		hcf_16		?
CFG_CNF_ENCRYPTION_ENABLED_STRCT		ENDS

; specify encryption type of Tx/Rx messages
CFG_CNF_AUTHENTICATION_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
authentication		hcf_16		?
CFG_CNF_AUTHENTICATION_STRCT		ENDS

; selects Authentication algorithm
CFG_CNF_EXCL_UNENCRYPTED_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
exclude_unencrypted		hcf_16		?
CFG_CNF_EXCL_UNENCRYPTED_STRCT		ENDS

; [AP] Switch for 'clear-text' rx message acceptance
CFG_CNF_MCAST_RATE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mcast_rate		hcf_16		?
CFG_CNF_MCAST_RATE_STRCT		ENDS

; Transmit Data rate for Multicast frames
CFG_CNF_INTRA_BSS_RELAY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
intra_bss_relay		hcf_16		?
CFG_CNF_INTRA_BSS_RELAY_STRCT		ENDS

; [AP] Switch for IntraBBS relay
CFG_CNF_MICRO_WAVE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
micro_wave		hcf_16		?
CFG_CNF_MICRO_WAVE_STRCT		ENDS

; MicroWave (Robustness)
CFG_CNF_LOAD_BALANCING_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
load_balancing		hcf_16		?
CFG_CNF_LOAD_BALANCING_STRCT		ENDS

; Load Balancing	  (Boolean, 0=OFF, 1=ON, default=1)
CFG_CNF_MEDIUM_DISTRIBUTION_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
medium_distribution		hcf_16		?
CFG_CNF_MEDIUM_DISTRIBUTION_STRCT		ENDS

; Medium Distribution (Boolean, 0=OFF, 1=ON, default=1)
CFG_CNF_GROUP_ADDRESS_FILTER_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
group_addr_filter		hcf_16		?
CFG_CNF_GROUP_ADDRESS_FILTER_STRCT		ENDS

; Group Address Filter								   
CFG_CNF_COUNTRY_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
n_channel_sets		hcf_16		?
country_code		hcf_16		2t DUP (?)
environment		hcf_16		?
channel_set		CHANNEL_SET		1t DUP (<>)
CFG_CNF_COUNTRY_INFO_STRCT		ENDS

; Current Country Info  
CFG_CNF_COUNTRY_INFO_MAX_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
n_channel_sets		hcf_16		?
country_code		hcf_16		2t DUP (?)
environment		hcf_16		?
channel_set		CHANNEL_SET		14t DUP (<>)
CFG_CNF_COUNTRY_INFO_MAX_STRCT		ENDS

; Current Country Info  
; Dynamic Configurations 
CFG_DESIRED_SSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_DESIRED_SSID_STRCT		ENDS

; [STA] Service Set identification for connection
CFG_GROUP_ADDR_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		96t DUP (?)
CFG_GROUP_ADDR_STRCT		ENDS

; [STA] Multicast MAC Addresses for Rx-message
CFG_CREATE_IBSS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
create_ibss		hcf_16		?
CFG_CREATE_IBSS_STRCT		ENDS

; [STA] Switch for IBSS creation On/Off
CFG_RTS_THRH_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH_STRCT		ENDS

; [STA] Frame length used for RTS/CTS handshake
CFG_TX_RATE_CNTL_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tx_rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL_STRCT		ENDS

; [STA] Data rate control for message transmission
CFG_PROMISCUOUS_MODE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
promiscuous_mode		hcf_16		?
CFG_PROMISCUOUS_MODE_STRCT		ENDS

; [STA] Switch for Promiscuous mode reception On/Off
CFG_WAKE_ON_LAN_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
wake_on_lan		hcf_16		?
CFG_WAKE_ON_LAN_STRCT		ENDS

; [STA] Switch for Wake-On-LAN mode
CFG_RTS_THRH0_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH0_STRCT		ENDS

; [AP] Port 0 frame length for RTS/CTS handshake
CFG_RTS_THRH1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH1_STRCT		ENDS

; [AP] Port 1 frame length for RTS/CTS handshake
CFG_RTS_THRH2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH2_STRCT		ENDS

; [AP] Port 2 frame length for RTS/CTS handshake
CFG_RTS_THRH3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH3_STRCT		ENDS

; [AP] Port 3 frame length for RTS/CTS handshake
CFG_RTS_THRH4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH4_STRCT		ENDS

; [AP] Port 4 frame length for RTS/CTS handshake
CFG_RTS_THRH5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH5_STRCT		ENDS

; [AP] Port 5 frame length for RTS/CTS handshake
CFG_RTS_THRH6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rts_thrh		hcf_16		?
CFG_RTS_THRH6_STRCT		ENDS

; [AP] Port 6 frame length for RTS/CTS handshake
CFG_TX_RATE_CNTL0_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL0_STRCT		ENDS

; [AP] Port 0 data rate control for transmission
CFG_TX_RATE_CNTL1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL1_STRCT		ENDS

; [AP] Port 1 data rate control for transmission
CFG_TX_RATE_CNTL2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL2_STRCT		ENDS

; [AP] Port 2 data rate control for transmission
CFG_TX_RATE_CNTL3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL3_STRCT		ENDS

; [AP] Port 3 data rate control for transmission
CFG_TX_RATE_CNTL4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL4_STRCT		ENDS

; [AP] Port 4 data rate control for transmission
CFG_TX_RATE_CNTL5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL5_STRCT		ENDS

; [AP] Port 5 data rate control for transmission
CFG_TX_RATE_CNTL6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate_cntl		hcf_16		?
CFG_TX_RATE_CNTL6_STRCT		ENDS

; [AP] Port 6 data rate control for transmission
CFG_DEFAULT_KEYS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
key		KEY_STRCT		4t DUP (<>)
CFG_DEFAULT_KEYS_STRCT		ENDS

; defines set of encryption keys
CFG_TX_KEY_ID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tx_key_id		hcf_16		?
CFG_TX_KEY_ID_STRCT		ENDS

; select key for encryption of Tx messages
CFG_SCAN_SSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_SCAN_SSID_STRCT		ENDS

;                   identification for connection
CFG_ADD_TKIP_DEFAULT_KEY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tkip_key_id_info		hcf_16		?
tkip_key_iv_info		hcf_16		4t DUP (?)
tkip_key		hcf_16		8t DUP (?)
tx_mic_key		hcf_16		4t DUP (?)
rx_mic_key		hcf_16		4t DUP (?)
CFG_ADD_TKIP_DEFAULT_KEY_STRCT		ENDS

;        
CFG_SET_SSN_AUTHENTICATION_SUITE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssn_authentication_suite		hcf_16		?
CFG_SET_SSN_AUTHENTICATION_SUITE_STRCT		ENDS

;    
CFG_REMOVE_TKIP_DEFAULT_KEY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tkip_key_id		hcf_16		?
CFG_REMOVE_TKIP_DEFAULT_KEY_STRCT		ENDS

;    
CFG_TICK_TIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tick_time		hcf_16		?
CFG_TICK_TIME_STRCT		ENDS

; [PRI] Auxiliary Timer tick interval
; apparently not needed ;?XX4( CFG_CNF_COUNTRY,			hcf_16, num_sets, hcf_32, country_code, hcf_16, enviroment, CHANNEL_SET, channel_set[1] ) /*   */
;  NIC Information 
CFG_IDENTITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
comp_id		hcf_16		?
variant		hcf_16		?
version_major		hcf_16		?
version_minor		hcf_16		?
CFG_IDENTITY_STRCT		ENDS

; identification Prototype
CFG_RID_INF_MIN_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
y		hcf_16		?
CFG_RID_INF_MIN_STRCT		ENDS

; lowest value representing an Information RID
CFG_MAX_LOAD_TIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
max_load_time		hcf_16		?
CFG_MAX_LOAD_TIME_STRCT		ENDS

; [PRI] Maximum response time of the Download command.
CFG_DL_BUF_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
buf_page		hcf_16		?
buf_offset		hcf_16		?
buf_len		hcf_16		?
CFG_DL_BUF_STRCT		ENDS

; [PRI] Download buffer location and size.
CFG_PRI_IDENTITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
comp_id		hcf_16		?
variant		hcf_16		?
version_major		hcf_16		?
version_minor		hcf_16		?
CFG_PRI_IDENTITY_STRCT		ENDS

; [PRI] Primary Functions firmware identification.
CFG_PRI_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_PRI_SUP_RANGE_STRCT		ENDS

; [PRI] Primary Functions interface; Supplier compatibility range.
CFG_CFI_ACT_RANGES_PRI_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_CFI_ACT_RANGES_PRI_STRCT		ENDS

; [PRI] Controller interface; Actor compatibility ranges.
CFG_HSI_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_HSI_SUP_RANGE_STRCT		ENDS

; H/W - S/W I/F supplier range
CFG_NIC_SERIAL_NUMBER_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
serial_number		hcf_16		17t DUP (?)
CFG_NIC_SERIAL_NUMBER_STRCT		ENDS

; [PRI] Network Interface Card serial number.
CFG_NIC_IDENTITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
comp_id		hcf_16		?
variant		hcf_16		?
version_major		hcf_16		?
version_minor		hcf_16		?
CFG_NIC_IDENTITY_STRCT		ENDS

; [PRI] Network Interface Card identification.
CFG_MFI_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_MFI_SUP_RANGE_STRCT		ENDS

; [PRI] Modem interface, Supplier compatibility range.
CFG_CFI_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_CFI_SUP_RANGE_STRCT		ENDS

; [PRI] Controller interface; Supplier compatibility range.
CFG_CHANNEL_LIST_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
channel_list		hcf_16		?
CFG_CHANNEL_LIST_STRCT		ENDS

; Allowed communication channels.
CFG_REG_DOMAINS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
num_domain		hcf_16		?
reg_domains		hcf_8		10t DUP (?)
CFG_REG_DOMAINS_STRCT		ENDS

; List of intended regulatory domains.
CFG_TEMP_TYPE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
temp_type		hcf_16		?
CFG_TEMP_TYPE_STRCT		ENDS

; Hardware temperature range code.
CFG_CIS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
cis		hcf_16		240t DUP (?)
CFG_CIS_STRCT		ENDS

; PC Card Standard Card Information Structure
CFG_NIC_PROFILE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
profile_code		hcf_16		?
capability_options		hcf_16		?
allowed_data_rates		hcf_16		?
val4		hcf_16		?
val5		hcf_16		?
CFG_NIC_PROFILE_STRCT		ENDS

; Card Profile
CFG_FW_IDENTITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
comp_id		hcf_16		?
variant		hcf_16		?
version_major		hcf_16		?
version_minor		hcf_16		?
CFG_FW_IDENTITY_STRCT		ENDS

; [STA] Station Functions firmware identification.
CFG_FW_SUP_RANGE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_FW_SUP_RANGE_STRCT		ENDS

; [STA] Station Functions interface; Supplier compatibility range.
CFG_MFI_ACT_RANGES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_MFI_ACT_RANGES_STRCT		ENDS

; [STA] Modem interface; Actor compatibility ranges.
CFG_CFI_ACT_RANGES_STA_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
role		hcf_16		?
id		hcf_16		?
variant		hcf_16		?
bottom		hcf_16		?
top		hcf_16		?
CFG_CFI_ACT_RANGES_STA_STRCT		ENDS

; [STA] Controller interface; Actor compatibility ranges.
; 	MAC INFORMATION	
CFG_PORT_STAT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
port_stat		hcf_16		?
CFG_PORT_STAT_STRCT		ENDS

; [STA] Actual MAC Port connection control status
CFG_CURRENT_SSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssid		hcf_16		17t DUP (?)
CFG_CURRENT_SSID_STRCT		ENDS

; [STA] Identification of the actually connected SS
CFG_CURRENT_BSSID_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_CURRENT_BSSID_STRCT		ENDS

; [STA] Identification of the actually connected BSS
CFG_COMMS_QUALITY_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
coms_qual		hcf_16		?
signal_lvl		hcf_16		?
noise_lvl		hcf_16		?
CFG_COMMS_QUALITY_STRCT		ENDS

; [STA] Quality of the Basic Service Set connection
CFG_CURRENT_TX_RATE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE_STRCT		ENDS

; [STA] Actual transmit data rate
CFG_OWN_BEACON_INTERVAL_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
interval		hcf_16		?
CFG_OWN_BEACON_INTERVAL_STRCT		ENDS

; Beacon transmit interval time for BSS creation
CFG_CUR_SCALE_THRH_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
energy_detect_thrh		hcf_16		?
carrier_detect_thrh		hcf_16		?
defer_thrh		hcf_16		?
cell_search_thrh		hcf_16		?
out_of_range_thrh		hcf_16		?
delta_snr		hcf_16		?
CFG_CUR_SCALE_THRH_STRCT		ENDS

; Actual System Scale thresholds settings
CFG_PROTOCOL_RSP_TIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
time		hcf_16		?
CFG_PROTOCOL_RSP_TIME_STRCT		ENDS

; Max time to await a response to a request message
CFG_SHORT_RETRY_LIMIT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
limit		hcf_16		?
CFG_SHORT_RETRY_LIMIT_STRCT		ENDS

; Max number of transmit attempts for short frames
CFG_LONG_RETRY_LIMIT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
limit		hcf_16		?
CFG_LONG_RETRY_LIMIT_STRCT		ENDS

; Max number of transmit attempts for long frames
CFG_MAX_TX_LIFETIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
time		hcf_16		?
CFG_MAX_TX_LIFETIME_STRCT		ENDS

; Max transmit frame handling duration
CFG_MAX_RX_LIFETIME_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
time		hcf_16		?
CFG_MAX_RX_LIFETIME_STRCT		ENDS

; Max received frame handling duration
CFG_CF_POLLABLE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
cf_pollable		hcf_16		?
CFG_CF_POLLABLE_STRCT		ENDS

; [STA] Contention Free pollable capability indication
CFG_AUTHENTICATION_ALGORITHMS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
authentication_type		hcf_16		?
type_enabled		hcf_16		?
CFG_AUTHENTICATION_ALGORITHMS_STRCT		ENDS

; Authentication Algorithm
CFG_PRIVACY_OPT_IMPLEMENTED_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
privacy_opt_implemented		hcf_16		?
CFG_PRIVACY_OPT_IMPLEMENTED_STRCT		ENDS

; WEP Option availability indication
CFG_CURRENT_REMOTE_RATES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rates		hcf_16		?
CFG_CURRENT_REMOTE_RATES_STRCT		ENDS

; CurrentRemoteRates
CFG_CURRENT_USED_RATES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rates		hcf_16		?
CFG_CURRENT_USED_RATES_STRCT		ENDS

; CurrentUsedRates
CFG_CURRENT_SYSTEM_SCALE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
current_system_scale		hcf_16		?
CFG_CURRENT_SYSTEM_SCALE_STRCT		ENDS

; CurrentUsedRates
CFG_CURRENT_TX_RATE1_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE1_STRCT		ENDS

; 		// 	[AP] Actual Port 1 transmit data rate
CFG_CURRENT_TX_RATE2_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE2_STRCT		ENDS

; [AP] Actual Port 2 transmit data rate
CFG_CURRENT_TX_RATE3_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE3_STRCT		ENDS

; [AP] Actual Port 3 transmit data rate
CFG_CURRENT_TX_RATE4_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE4_STRCT		ENDS

; [AP] Actual Port 4 transmit data rate
CFG_CURRENT_TX_RATE5_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE5_STRCT		ENDS

; [AP] Actual Port 5 transmit data rate
CFG_CURRENT_TX_RATE6_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rate		hcf_16		?
CFG_CURRENT_TX_RATE6_STRCT		ENDS

; [AP] Actual Port 6 transmit data rate
CFG_OWN_MACADDRESS_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
mac_addr		hcf_16		3t DUP (?)
CFG_OWN_MACADDRESS_STRCT		ENDS

; [AP] Unique local node MAC Address
CFG_PCF_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
medium_occupancy_limit		hcf_16		?
cfp_period		hcf_16		?
cfp_max_duration		hcf_16		?
CFG_PCF_INFO_STRCT		ENDS

; [AP] Point Coordination Function capability info
; #@ ;? define CFG_CURRENT_COUNTRY_INFO		0xFD88		//
CFG_CURRENT_SSN_INFO_ELEMENT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
ssn_info_element		hcf_16		1t DUP (?)
CFG_CURRENT_SSN_INFO_ELEMENT_STRCT		ENDS

;     
;  X4( CFG_CURRENT_TKIP_IV_INFO, tkip_seq_cnt0, tkip_seq_cnt1, tkip_seq_cnt2, tkip_seq_cnt3, 0, 0 ) /*    */
CFG_CURRENT_TKIP_IV_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
tkip_seq_cnt0		hcf_16		4t DUP (?)
tkip_seq_cnt1		hcf_16		4t DUP (?)
tkip_seq_cnt2		hcf_16		4t DUP (?)
tkip_seq_cnt3		hcf_16		4t DUP (?)
CFG_CURRENT_TKIP_IV_INFO_STRCT		ENDS

;     
CFG_CURRENT_ASSOC_REQ_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
frame_type		hcf_16		?
frame_body		hcf_16		1t DUP (?)
CFG_CURRENT_ASSOC_REQ_INFO_STRCT		ENDS

; 	0xFD8C	
CFG_CURRENT_ASSOC_RESP_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
frame_type		hcf_16		?
frame_body		hcf_16		1t DUP (?)
CFG_CURRENT_ASSOC_RESP_INFO_STRCT		ENDS

; 	0xFD8D	
; 	Modem INFORMATION	
CFG_PHY_TYPE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
phy_type		hcf_16		?
CFG_PHY_TYPE_STRCT		ENDS

; 		// 	Physical layer type indication
CFG_CURRENT_CHANNEL_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
current_channel		hcf_16		?
CFG_CURRENT_CHANNEL_STRCT		ENDS

; Actual frequency channel used for transmission
CFG_CURRENT_POWER_STATE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
current_power_state		hcf_16		?
CFG_CURRENT_POWER_STATE_STRCT		ENDS

; Actual power consumption status
CFG_CCAMODE_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
cca_mode		hcf_16		?
CFG_CCAMODE_STRCT		ENDS

; Clear channel assessment mode indication
CFG_SUPPORTED_DATA_RATES_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
rates		hcf_16		5t DUP (?)
CFG_SUPPORTED_DATA_RATES_STRCT		ENDS

; Data rates capability information
;  FRAMES 
CFG_SCAN_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
scan_result		SCAN_RS_STRCT		32t DUP (<>)
CFG_SCAN_STRCT		ENDS

; Scan results
; -------------------------------------------------------------------------------------- 
;  UIL management function to be passed to WaveLAN/IEEE Drivers in DUI_STRCT field fun
; --------------------------------------------------------------------------------------
UIL_FUN_CONNECT		EQU		0t
;  Perform connect command
UIL_FUN_DISCONNECT		EQU		1t
;  Perform disconnect command
UIL_FUN_ACTION		EQU		2t
;  Perform UIL Action command.
UIL_FUN_SEND_DIAG_MSG		EQU		3t
;  Send a diagnostic message.
UIL_FUN_GET_INFO		EQU		4t
;  Retrieve information from NIC.
;  Put information on NIC.
UIL_FUN_PUT_INFO		EQU		5t

uil_fun		TYPEDEF		SWORD

;  UIL_ACT_DIAG	 		0x04		* obsolete, not supported by H-II
;    									* lack of support carried back to H-I
; 									
;  UIL_ACT_TALLIES		0x05		*;?this should not have been exported to the USF
; 									* it is solely intended as a strategic choice for the MSF to either
; 									* - use HCF_ACT_TALLIES and direct IFB access
; 									* - use CFG_TALLIES
; 									
UIL_ACT_SCAN		EQU		000000006h
;  only supported by AP F/W
UIL_ACT_ACS_SCAN		EQU		000000007h
UIL_ACT_BLOCK		EQU		00000000bh
UIL_ACT_UNBLOCK		EQU		00000000ch
UIL_ACT_RESET		EQU		000000080h
UIL_ACT_REBIND		EQU		000000081h
UIL_ACT_APPLY		EQU		000000082h
;  Note that UIL_ACT-codes must match HCF_ACT-codes accross a run-time bound I/F
;  * The initial matching is achieved by "#define HCF_ACT_xxx HCF_UIL_ACT_xxx" where appropriate  
;  * In other words, these codes should never, ever change to minimize migration problems between
;  * combinations of old drivers and new utilities nad vice versa
;  
;  ! UIL_ACT_TALLIES does not exist ! Hermes Inquire Tallies (F100) cmnd
HCF_ACT_TALLIES		EQU		000000005h
;  06 Hermes Inquire Scan (F101) command
HCF_ACT_SCAN		EQU		000000006h
;  07 Hermes ACS Scan (F102) command
HCF_ACT_ACS_SCAN		EQU		000000007h
;  USB look-a-like for hcf_initialize(xxxx) on the Dongle side
HCF_ACTION_INI		EQU		00000000ah
; 0B USB look-a-like for HCF_ACT_BLOCK on the Dongle side
HCF_ACTION_DISABLE		EQU		00000000bh
; 0C USB look-a-like for HCF_ACT_UNBLOCK on the Dongle side
HCF_ACTION_ENABLE		EQU		00000000ch
; 0D Disable Interrupt generation
HCF_ACT_INT_OFF		EQU		00000000dh
; 0E Enable Interrupt generation
HCF_ACT_INT_ON		EQU		00000000eh
; 0F Enforce Enable Interrupt generation
HCF_ACT_INT_FORCE_ON		EQU		00000000fh
; 10 HCF_CARD_CHECK_ON : MSF reported Card insertion
; 										 *   HCF_CARD_CHECK_OFF: Card initialization				
HCF_ACT_CARD_IN		EQU		000000010h
; 11 HCF_CARD_CHECK_ON : MSF reported Card removal
; 										 *   HCF_CARD_CHECK_OFF: place holder						
HCF_ACT_CARD_OUT		EQU		000000011h
; 12 freeze the F/W execution
HCF_ACT_FREEZE		EQU		000000012h
; 13 disable TimerTick interrupt
HCF_ACT_TICK_OFF		EQU		000000013h
; 14 enable TimerTick interrupt
HCF_ACT_TICK_ON		EQU		000000014h
; 17 Receiever ACK (optimization)
HCF_ACT_RX_ACK		EQU		000000015h
; 15
HCF_ACT_ASSERT_OFF		EQU		000000016h
; 16
HCF_ACT_ASSERT_ON		EQU		000000017h
; 	HCF_ACT_MAX							// xxxx: start value for UIL-range, NOT to be passed to HCF
;  *										Too bad, there was originally no spare room created to use
;  *										HCF_ACT_MAX as an equivalent of HCF_ERR_MAX. Since creating
;  *										this room in retrospect would create a backward incompatibilty
;  *										we will just have to live with the haphazard sequence of
;  *										UIL- and HCF specific codes. Theoretically this could be
;  *										corrected when and if there will ever be an overall
;  *										incompatibilty introduced for another reason
;  
; ============================================================= CONFIGURATION RECORDS	=====================
; ============================================================= mask 0xFCxx				=====================
; 	NETWORK PARAMETERS, STATIC CONFIGURATION ENTITIES
; FC05, FC0A, FC0B, FC0C, FC0D: SEE W2DN149
; lowest value representing a Configuration RID
CFG_RID_CFG_MIN		EQU		00000fc00h
; [STA] Connection control characteristics
CFG_CNF_PORT_TYPE		EQU		00000fc00h
; [STA] MAC Address of this node
CFG_CNF_OWN_MAC_ADDR		EQU		00000fc01h
; [STA] Service Set identification for connection
; 													 *originally known as static entity with name 
; 													 *	CFG_CNF_DESIRED_SSID
; 													 *when type changed to dynamic, name incorrectly changed to 
; 													 *	CNF_DESIRED_SSID
; 													 *finally name changed to (the "correct")
; 													 *	CFG_DESIRED_SSID
; 													 *CNF_DESIRED_SSID will be discarded some time in the future
; 													 
CNF_DESIRED_SSID		EQU		00000fc02h
; #define CFG_DESIRED_SSID	  CNF_DESIRED_SSID			
; Communication channel for BSS creation
CFG_CNF_OWN_CHANNEL		EQU		00000fc03h
; IBSS creation (STA) or ESS (AP) Service Set Ident
CFG_CNF_OWN_SSID		EQU		00000fc04h
; [STA] ATIM Window time for IBSS creation
CFG_CNF_OWN_ATIM_WINDOW		EQU		00000fc05h
; System Scale that specifies the AP density
CFG_CNF_SYSTEM_SCALE		EQU		00000fc06h
; Maximum length of MAC Frame Body data
CFG_CNF_MAX_DATA_LEN		EQU		00000fc07h
; [STA] MAC Address of corresponding WDS Link node
CFG_CNF_WDS_ADDR		EQU		00000fc08h
; legacy, to be deleted some time in the future
CFG_CNF_PM_ENABLED		EQU		00000fc09h
; [STA] Switch for ESS PM EPS/PS Mode
CFG_CNF_PM_EPS		EQU		00000fc0ah
; [STA] Switch for ESS PM Multicast reception On/Off
CFG_CNF_MCAST_RX		EQU		00000fc0bh
; [STA] Maximum sleep time for ESS PM
CFG_CNF_MAX_SLEEP_DURATION		EQU		00000fc0ch
; [STA] Holdover time for ESS PM
CFG_CNF_HOLDOVER_DURATION		EQU		00000fc0dh
; Identification text for diagnostic purposes
CFG_CNF_OWN_NAME		EQU		00000fc0eh
; [AP] Beacon intervals between successive DTIMs
CFG_CNF_OWN_DTIM_PERIOD		EQU		00000fc10h
; [AP] Port 1 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR1		EQU		00000fc11h
; [AP] Port 2 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR2		EQU		00000fc12h
; [AP] Port 3 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR3		EQU		00000fc13h
; [AP] Port 4 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR4		EQU		00000fc14h
; [AP] Port 5 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR5		EQU		00000fc15h
; [AP] Port 6 MAC Adrs of corresponding WDS Link node
CFG_CNF_WDS_ADDR6		EQU		00000fc16h
; [AP] Switch for PM buffereing of Multicast Messages
CFG_CNF_MCAST_PM_BUF		EQU		00000fc17h
; [AP] Switch for PM buffereing of Multicast Messages	
CFG_CNF_REJECT_ANY		EQU		00000fc18h
; select en/de-cryption of Tx/Rx messages
CFG_CNF_ENCRYPTION		EQU		00000fc20h
; selects Authentication algorithm						
CFG_CNF_AUTHENTICATION		EQU		00000fc21h
; [AP] Switch for 'clear-text' rx message acceptance	
CFG_CNF_EXCL_UNENCRYPTED		EQU		00000fc22h
; Transmit Data rate for Multicast frames				
CFG_CNF_MCAST_RATE		EQU		00000fc23h
; [AP] Switch for IntraBBS relay						
CFG_CNF_INTRA_BSS_RELAY		EQU		00000fc24h
; MicroWave (Robustness)
CFG_CNF_MICRO_WAVE		EQU		00000fc25h
; Load Balancing		 (Boolean, 0=OFF, 1=ON, default=1)
CFG_CNF_LOAD_BALANCING		EQU		00000fc26h
; Medium Distribution	 (Boolean, 0=OFF, 1=ON, default=1)
CFG_CNF_MEDIUM_DISTRIBUTION		EQU		00000fc27h
; Group Address Filter
CFG_CNF_GROUP_ADDRESS_FILTER		EQU		00000fc28h
; Country Info
CFG_CNF_COUNTRY_INFO		EQU		00000fc29h
; 	NETWORK PARAMETERS, DYNAMIC CONFIGURATION ENTITIES
; [STA] Service Set identification for connection
CFG_DESIRED_SSID		EQU		00000fc02h
; [STA] Multicast MAC Addresses for Rx-message
CFG_GROUP_ADDR		EQU		00000fc80h
; [STA] Switch for IBSS creation On/Off
CFG_CREATE_IBSS		EQU		00000fc81h
; [STA] Frame length used for RTS/CTS handshake
CFG_RTS_THRH		EQU		00000fc83h
; [STA] Data rate control for message transmission
CFG_TX_RATE_CNTL		EQU		00000fc84h
; [STA] Switch for Promiscuous mode reception On/Off
CFG_PROMISCUOUS_MODE		EQU		00000fc85h
; [STA] Switch for Wake-On-LAN mode
CFG_WAKE_ON_LAN		EQU		00000fc86h
; [AP] Port 0 frame length for RTS/CTS handshake
CFG_RTS_THRH0		EQU		00000fc97h
; [AP] Port 1 frame length for RTS/CTS handshake
CFG_RTS_THRH1		EQU		00000fc98h
; [AP] Port 2 frame length for RTS/CTS handshake
CFG_RTS_THRH2		EQU		00000fc99h
; [AP] Port 3 frame length for RTS/CTS handshake
CFG_RTS_THRH3		EQU		00000fc9ah
; [AP] Port 4 frame length for RTS/CTS handshake
CFG_RTS_THRH4		EQU		00000fc9bh
; [AP] Port 5 frame length for RTS/CTS handshake
CFG_RTS_THRH5		EQU		00000fc9ch
; [AP] Port 6 frame length for RTS/CTS handshake
CFG_RTS_THRH6		EQU		00000fc9dh
; [AP] Port 0 data rate control for transmission
CFG_TX_RATE_CNTL0		EQU		00000fc9eh
; [AP] Port 1 data rate control for transmission
CFG_TX_RATE_CNTL1		EQU		00000fc9fh
; [AP] Port 2 data rate control for transmission
CFG_TX_RATE_CNTL2		EQU		00000fca0h
; [AP] Port 3 data rate control for transmission
CFG_TX_RATE_CNTL3		EQU		00000fca1h
; [AP] Port 4 data rate control for transmission
CFG_TX_RATE_CNTL4		EQU		00000fca2h
; [AP] Port 5 data rate control for transmission
CFG_TX_RATE_CNTL5		EQU		00000fca3h
; [AP] Port 6 data rate control for transmission	
CFG_TX_RATE_CNTL6		EQU		00000fca4h
; defines set of encryption keys
CFG_DEFAULT_KEYS		EQU		00000fcb0h
; select key for encryption of Tx messages
CFG_TX_KEY_ID		EQU		00000fcb1h
; Scan SSID
CFG_SCAN_SSID		EQU		00000fcb2h
; 
CFG_ADD_TKIP_DEFAULT_KEY		EQU		00000fcb4h
; KeyID mask for tkip_key_id_info field
KEY_ID		EQU		000000003h
; Default Tx Key flag of tkip_key_id_info field
TX_KEY		EQU		000008000h
; 
CFG_SET_SSN_AUTHENTICATION_SUITE		EQU		00000fcb5h
; 
CFG_REMOVE_TKIP_DEFAULT_KEY		EQU		00000fcb6h
; 	BEHAVIOR PARAMETERS	
; [PRI] Auxiliary Timer tick interval
CFG_TICK_TIME		EQU		00000fce0h
; highest value representing an Configuration RID
CFG_RID_CFG_MAX		EQU		00000fcffh
; ============================================================= INFORMATION RECORDS 	=====================
; ============================================================= mask 0xFDxx				=====================
; 	NIC INFORMATION	
; lowest value representing an Information RID
CFG_RID_INF_MIN		EQU		00000fd00h
; [PRI] Maximum response time of the Download command.
CFG_MAX_LOAD_TIME		EQU		00000fd00h
; [PRI] Download buffer location and size.
CFG_DL_BUF		EQU		00000fd01h
; [PRI] Primary Functions firmware identification.
CFG_PRI_IDENTITY		EQU		00000fd02h
; [PRI] Primary Functions interface; Supplier compatibility range.
CFG_PRI_SUP_RANGE		EQU		00000fd03h
; [PRI] Controller interface; Actor compatibility ranges.
CFG_CFI_ACT_RANGES_PRI		EQU		00000fd04h
; H/W - S/W I/F supplier range
CFG_HSI_SUP_RANGE		EQU		00000fd09h
; [PRI] Network Interface Card serial number.
CFG_NIC_SERIAL_NUMBER		EQU		00000fd0ah
; [PRI] Network Interface Card identification.
CFG_NIC_IDENTITY		EQU		00000fd0bh
; [PRI] Modem interface, Supplier compatibility range.
CFG_MFI_SUP_RANGE		EQU		00000fd0ch
; [PRI] Controller interface; Supplier compatibility range.
CFG_CFI_SUP_RANGE		EQU		00000fd0dh
; Allowed communication channels.
CFG_CHANNEL_LIST		EQU		00000fd10h
; List of intended regulatory domains.
CFG_REG_DOMAINS		EQU		00000fd11h
; Hardware temperature range code.
CFG_TEMP_TYPE		EQU		00000fd12h
; PC Card Standard Card Information Structure
CFG_CIS		EQU		00000fd13h
; Obsolete H-I legacy 
; Card Profile
CFG_NIC_PROFILE		EQU		00000fd14h
; legacy	
; legacy
; firmware identification.
CFG_FW_IDENTITY		EQU		00000fd20h
; firmware Supplier compatibility range.
CFG_FW_SUP_RANGE		EQU		00000fd21h
; [STA] Modem interface; Actor compatibility ranges.
CFG_MFI_ACT_RANGES_STA		EQU		00000fd22h
; [STA] Controller interface; Actor compatibility ranges.
CFG_CFI_ACT_RANGES_STA		EQU		00000fd23h
; 	MAC INFORMATION
; [STA] Actual MAC Port connection control status
CFG_PORT_STAT		EQU		00000fd40h
; [STA] Identification of the actually connected SS
CFG_CURRENT_SSID		EQU		00000fd41h
; [STA] Identification of the actually connected BSS
CFG_CURRENT_BSSID		EQU		00000fd42h
; [STA] Quality of the Basic Service Set connection
CFG_COMMS_QUALITY		EQU		00000fd43h
; [STA] Actual transmit data rate
CFG_CURRENT_TX_RATE		EQU		00000fd44h
; Beacon transmit interval time for BSS creation
CFG_OWN_BEACON_INTERVAL		EQU		00000fd45h
; Actual System Scale thresholds settings
CFG_CUR_SCALE_THRH		EQU		00000fd46h
; Max time to await a response to a request message
CFG_PROTOCOL_RSP_TIME		EQU		00000fd47h
; Max number of transmit attempts for short frames
CFG_SHORT_RETRY_LIMIT		EQU		00000fd48h
; Max number of transmit attempts for long frames
CFG_LONG_RETRY_LIMIT		EQU		00000fd49h
; Max transmit frame handling duration
CFG_MAX_TX_LIFETIME		EQU		00000fd4ah
; Max received frame handling duration
CFG_MAX_RX_LIFETIME		EQU		00000fd4bh
; [STA] Contention Free pollable capability indication
CFG_CF_POLLABLE		EQU		00000fd4ch
; Available Authentication Algorithms indication
CFG_AUTHENTICATION_ALGORITHMS		EQU		00000fd4dh
; ?????????#define CFG_AUTHENTICATION				0xFD4D					//??????????????????????????????????????????
; ?????????#define CFG_AUTHENTICATION_TYPE			0xFD4E		//Available Authentication Types indication
; WEP Option availability indication
CFG_PRIVACY_OPT_IMPLEMENTED		EQU		00000fd4fh
; CurrentRemoteRates
CFG_CURRENT_REMOTE_RATES		EQU		00000fd50h
; CurrentUsedRates
CFG_CURRENT_USED_RATES		EQU		00000fd51h
; CurrentSystemScale
CFG_CURRENT_SYSTEM_SCALE		EQU		00000fd52h
; 		// 	[AP] Actual Port 1 transmit data rate
CFG_CURRENT_TX_RATE1		EQU		00000fd80h
; [AP] Actual Port 2 transmit data rate
CFG_CURRENT_TX_RATE2		EQU		00000fd81h
; [AP] Actual Port 3 transmit data rate
CFG_CURRENT_TX_RATE3		EQU		00000fd82h
; [AP] Actual Port 4 transmit data rate
CFG_CURRENT_TX_RATE4		EQU		00000fd83h
; [AP] Actual Port 5 transmit data rate
CFG_CURRENT_TX_RATE5		EQU		00000fd84h
; [AP] Actual Port 6 transmit data rate
CFG_CURRENT_TX_RATE6		EQU		00000fd85h
; [AP] Unique local node MAC Address
CFG_NIC_MAC_ADDR		EQU		00000fd86h
; [AP] Point Coordination Function capability info
CFG_PCF_INFO		EQU		00000fd87h
; 
CFG_CURRENT_COUNTRY_INFO		EQU		00000fd88h
; 
CFG_CURRENT_SSN_INFO_ELEMENT		EQU		00000fd8ah
; 
CFG_CURRENT_TKIP_IV_INFO		EQU		00000fd8bh
; 
CFG_CURRENT_ASSOC_REQ_INFO		EQU		00000fd8ch
; 
CFG_CURRENT_ASSOC_RESP_INFO		EQU		00000fd8dh
; 	MODEM INFORMATION	
; 		// 	Physical layer type indication
CFG_PHY_TYPE		EQU		00000fdc0h
; Actual frequency channel used for transmission
CFG_CURRENT_CHANNEL		EQU		00000fdc1h
; Actual power consumption status
CFG_CURRENT_POWER_STATE		EQU		00000fdc2h
; Clear channel assessment mode indication
CFG_CCAMODE		EQU		00000fdc3h
; MAC processing delay time
CFG_MAC_PROCESSING_DELAY		EQU		00000fdc5h
; Data rates capability information
CFG_SUPPORTED_DATA_RATES		EQU		00000fdc6h
; highest value representing an Information RID
CFG_RID_INF_MAX		EQU		00000fdffh
; #define CNF_DESIRED_SSID	CFG_DESIRED_SSID		/ * what a mess changing 0xFC02 from static to dynamic
; 													 * and trying to keep naming consistent
; 													 * as the X macros show, this was not a success
; 													 * to minimize the annoyance of the MSF programmers
; 													 * couple the "bad" historical name with the "right" name
; 													 */
; ***********************************************************************************************************
; *****************************      M A C R O S     *******************************************************
;  min and max macros 
; ***********************************************************************************************************
; ***************************** General define **************************************************************
; IFB field related
; 		IFB_CardStat
;  Debug Only !!
; 												 * MSF defines card as being present
; 												 * controls whether hcf-function is allowed to do I/O		
CARD_STAT_PRESENT		EQU		000008000h
; #define CARD_STAT_ENABLED				0x4000U	/* Debug Only !!
; 												 * one or more MAC Ports enabled							*/
;  hcf_disable did not detect compatible primary functions
CARD_STAT_INCOMP_PRI		EQU		000002000h
;  hcf_disable did not detect compatible station functions
CARD_STAT_INCOMP_STA		EQU		000001000h
;  Incompatible feature (prevents enable)
; 												 * !! NOTE !! this bit is only cleared as side effect of 
; 												   !! HCF_ACT_CARD_IN. Dynamically clearing it if a non-
; 												   !! violating feature is set, will not work properly if
; 												   !! - some time in the future -, a 2nd feature with this
; 												   !! characteristics is created. Since Utilities protect
; 												   !! "intelligent" against this problem and Driver Config
; 												   !! files can not change dynamically, this is not a serious
; 												   !! limitation
;                                                  
CARD_STAT_INCOMP_FEATURE		EQU		000000800h
;  No (functional) STA F/W in NV-RAM (allows download and AP mode)
CARD_STAT_STA_ABSENT		EQU		000000400h
;  Hermaphrodite in AP mode
CARD_STAT_AP		EQU		000000200h
;  HCF is in Defunct mode
CARD_STAT_DEFUNCT		EQU		000000100h
; 		IFB_RxStat
; Error mask
RX_STAT_ERR		EQU		000000003h
; Non-decryptable encrypted message
RX_STAT_UNDECR		EQU		000000002h
; FCS error
RX_STAT_FCS_ERR		EQU		000000001h
;  TxCntl parameter of hcf_put_data/hcf_send
; ;? get this defined at the correct place
HFS_TX_OK		EQU		000000002h
HFS_TX_EX		EQU		000000004h
; ;?15/10
;  SNAP header for E-II Encapsulation
ENC_NONE		EQU		0000000ffh
ENC_1042		EQU		000000000h
ENC_TUNNEL		EQU		0000000f8h
; ***************************** Xxxxxxxx ********************************************************************
;  HCF noticed an error after succesful diagnose command
; 												 * moved from enum to #define because it is never an 
; 												 * hcf_... function return code 
; 												 
HCF_ERR_DIAG_1		EQU		000000003h
; hcf_stat
; JMES: reactivated HCF_FAILURE and UIL_FAILURE
; 	HCF_FAILURE				= 0xFF,	/ * An (unspecified) failure, 0xFF is choosen to have a non-ubiquitous value
; 	                                 *	Note that HCF_xxxx errors which can end up in the CFG_DIAG LTV should
; 	                                 *	never exceed 0xFF, because the high order byte of VAL[0] is reserved
; 	                                 *	for Hermes errors
; 	                                 
HCF_SUCCESS		EQU		0t
;  0x00: OK
; 	HCF_ERR_DIAG_1			= 0x03,	// 	moved from enum to #define 
; 								// gap for ODI related status and obsolete 
HCF_ERR_TIME_OUT		EQU		4t
;  0x04: Expected Hermes event did not occure in expected time
HCF_ERR_NO_NIC		EQU		5t
;  0x05: card not found (usually yanked away during hcfio_in_string
; 											 Also: card is either absent or disabled while it should be neither		
HCF_ERR_BUSY		EQU		6t
;  0x06: hcf_send_diag_msg called while PIF_RscInd == 0
HCF_ERR_SEQ_BUG		EQU		7t
;  0x07: other cmd than the expected completed, probably HCF-bug
HCF_ERR_LEN		EQU		8t
;  0x08: buffer size insufficient
; 		  -	IFB_ConfigTable too small									
; 		  -	hcf_get_info buffer has a size of 0 or 1 or less than needed
; 			to accomodate all data
; 		  -	hcf_put_info: CFG_DLNV_DATA exceeds intermediate buffer size
HCF_ERR_INCOMP_PRI		EQU		9t
;  0x09: primary functions are not compatible
HCF_ERR_INCOMP_STA		EQU		10t
;  0x0A: primary functions are compatible, station functions are not
HCF_ERR_INCOMP_FEATURE		EQU		11t
;  0x0B: Incompatible feature (prevents enable)
HCF_ERR_DCWA		EQU		12t
;  0x0C DCWA (Data Corruption Work Around) catched (primarily in hcf_put_data process)
HCF_ERR_MIC		EQU		13t
;  0x0D: MIC check fails
HCF_ERR_INCOMP		EQU		16t
;  0x10: any incompatibilty (recall)
HCF_ERR_MAX		EQU		63t
;  end of HCF range, see UIL_ERR_MIN/MAX
; 									   *** ** *** *****  *** ***************  
HCF_ERR_DEFUNCT		EQU		128t
;  BIT, reflecting that the HCF is in defunct mode (bits 0x7F reflect cause)
HCF_ERR_DEFUNCT_LEGACY1		EQU		129t
;  0x081 Timeout on Busy bit drop before writing Hermes Initialize command
HCF_ERR_DEFUNCT_AUX		EQU		130t
;  0x082 Timeout on acknowledgement on en/disabling AUX registers
HCF_ERR_DEFUNCT_TIMER		EQU		131t
;  0x083 Timeout on timer calibration during initialization process
HCF_ERR_DEFUNCT_TIME_OUT		EQU		132t
;  0x084 Timeout on Busy bit drop during BAP setup
HCF_ERR_DEFUNCT_LEGACY2		EQU		133t
;  0x085 Allocation failed during initialization process
HCF_ERR_DEFUNCT_CMD_SEQ		EQU		134t
;  0x086 Hermes and HCF are out of sync in issuing/processing commands
HCF_ERR_DEFUNCT_LEGACY3		EQU		135t
;  0x087 DCWA during download did not succeed within retry limit
HCF_ERR_DEFUNCT_FREEZE		EQU		136t
;  0x088 freeze the F/W execution (intentionally via HCF_ACT_FREEZE)
HCF_ERR_CMD		EQU		256t
; "insignificant" error (see W2DN264)
; 	HCF_ERR_INQUIRE			= 0x0511,	// Inquiry failed due to lack of Hermes Buffer space
; enum /*uil_stat*/ {
UIL_FAILURE		EQU		255t
;  HCF_FAILURE,         //JMES/24022000: activated
; 												 * 20010705 nv this relick should be eridicated ot the UIL as well
; 												 
UIL_SUCCESS		EQU		0t
UIL_ERR_DIAG_1		EQU		3t
UIL_ERR_TIME_OUT		EQU		4t
UIL_ERR_NO_NIC		EQU		5t
UIL_ERR_BUSY		EQU		6t
UIL_ERR_SEQ_BUG		EQU		7t
UIL_ERR_LEN		EQU		8t
UIL_ERR_MIN		EQU		63t
; 0x3F,	end of HCF errors which are passed through to UIL
; 									   		  ****  *** ** *** ****** ***** *** ****** ******* ** ***  
UIL_ERR_PIF_CONFLICT		EQU		64t
; this is the lower boundary of UIL errors without HCF-pendant
UIL_ERR_INCOMP_DRV		EQU		65t
UIL_ERR_NO_DRV		EQU		66t
UIL_ERR_DOS_CALL		EQU		67t
UIL_ERR_IN_USE		EQU		68t
UIL_ERR_NSTL		EQU		69t
UIL_ERR_WRONG_IFB		EQU		70t
; upper boundary of UIL errors without HCF-pendant
; 											  ***** ******** ** *** ****** ******* *** *******  
; } /* uil_stat */
UIL_ERR_MAX		EQU		127t

;  (ODI initiated) return status of hcf_act( HCF_ACT_INT_OFF )
HCF_INT_PENDING		EQU		1t
HCF_PORT_DISABLE		EQU		000000000h
HCF_PORT_ENABLE		EQU		000000001h
;  Station supports only single MAC Port
HCF_PORT_0		EQU		000000000h
; HFS_TX_CNTL
HFS_TX_CNTL_TX_OK		EQU		000000002h
HFS_TX_CNTL_TX_EX		EQU		000000004h
; type subfield
HFS_TX_CNTL_TYPE		EQU		000000018h
; 802.3 format with TKIP
HFS_TX_CNTL_TYPE_TKIP		EQU		000000010h
; MIC Key ID subfield
HFS_TX_CNTL_MIC_KEY_ID		EQU		000001800h
; deprecated #define 	HFS_TX_CNTL_STRCT_TYPE	0x0018	//StrucType subfield of TxControl field of Transmit Frame Structure
; deprecated #define 	HFS_TX_CNTL_802_3	0x0000	//802.3 format
; TxPriority subfield of TxControl field of Transmit Frame Structure
HFS_TX_CNTL_PRIO		EQU		0000000e0h
HCF_TX_PRIO_HIGH		EQU		000000020h
HFS_TX_CNTL_NO_DCWA		EQU		000000040h
; replaces HCF_PUT_DATA_RESET
HFS_TX_CNTL_RESET		EQU		000000080h
; Station and HCF-light supports only a single MAC Port
HFS_TX_CNTL_PORT		EQU		000000000h
; HCF_TYPE_HI_PRE_SSN 
; ============================================================= HCF Defined RECORDS	=========================
; ??
; USB designator for Tx Frame
CFG_TX_FRAME		EQU		000000700h
; USB designator for Rx Frame
CFG_RX_FRAME		EQU		000000701h
; USB designator for Action Command Frame
CFG_ACTION		EQU		000000702h
; USB designator for "dummy response"
CFG_RESPONSE		EQU		000000710h
; Plug Data
CFG_PROD_DATA		EQU		000000800h
; Aux Data
CFG_AUX_DATA		EQU		000000801h
; 	803 through 806 reserved for "similar" actions
; Up/Download I2PROM for USB
CFG_DL_EEPROM		EQU		000000806h
; Download PDA
CFG_PDA		EQU		000000002h
; Up/Download EEPROM
CFG_MEM_I2PROM		EQU		000000004h
CFG_MEM_READ		EQU		000000000h
CFG_MEM_WRITE		EQU		000000001h
; range of the AUX_DATA family
CFG_AUX_DATA_MASK		EQU		000000807h
; Empty Mail Box Info Block
CFG_NULL		EQU		000000820h
; Mail Box Info Block
CFG_MB_INFO		EQU		000000820h
; Diagnose result
CFG_DIAG		EQU		000000821h
; WaveLAN Management Protocol
CFG_WMP		EQU		000000822h
; accumulated set of restraint bits detected by driver (HCF + MSF)
CFG_RESTRAINT_INFO		EQU		000000823h
; byte wise copy of IFB
CFG_IFB		EQU		000000824h
; Driver Information structure (see CFG_DRV_INFO_STRCT for details)
CFG_DRV_INFO		EQU		000000825h
; driver identity (see CFG_DRV_IDENTITY_STRCT for details)
CFG_DRV_IDENTITY		EQU		000000826h
; Supplier range of driver - utility I/F
CFG_DRV_SUP_RANGE		EQU		000000827h
; (Acceptable) Actor range for Primary Firmware - driver I/F
CFG_DRV_ACT_RANGES_PRI		EQU		000000828h
; (Acceptable) Actor range for Station Firmware - driver I/F
CFG_DRV_ACT_RANGES_STA		EQU		000000829h
; (Acceptable) Actor range for H/W - driver I/F
CFG_DRV_ACT_RANGES_HSI		EQU		00000082ah
; (Acceptable) Actor range for AP Firmware - driver I/F
CFG_DRV_ACT_RANGES_APF		EQU		00000082bh
; HCF (Compile time) options
CFG_HCF_OPT		EQU		00000082ch
; Unknown, used a.o. in "flows which should not occure"
CFG_UNK		EQU		00000082fh
; Register Mail Box
CFG_REG_MB		EQU		000000830h
; Assert information
CFG_MB_ASSERT		EQU		000000831h
; (de-)register MSF Assert Callback routine
CFG_REG_ASSERT_RTNP		EQU		000000832h
; Read and Clear Communications Tallies
CFG_TALLIES_VACATE		EQU		000000833h
; set/reset bits in MSF-controlled field of CFG_RESTRAINT_INFO
CFG_CNTL_RESTRAINT		EQU		000000834h
; control emergency escape IFB_MSFType		
CFG_CNTL_MSF_TYPE		EQU		000000835h
; control Engineering Flag settings			
CFG_CNTL_ENG_FLG		EQU		000000836h
; (de-)register MSF Log Callback routine
CFG_REG_LOG_RTNP		EQU		000000837h
; (de-)register Info frames to Log
CFG_REG_INFO_LOG		EQU		000000839h
; filter for use in TRACE/TRACE_VALUE macros set
CFG_REG_VALUE		EQU		00000083ah
; ;? 
CFG_TX_ERR_NOTIFY		EQU		000000840h
; R/W index + byte wise copy of Mail Box
CFG_MB_RAW		EQU		000000841h
; driver HCF activity log
CFG_DRV_LOG		EQU		000000842h
; Setup for Download to non-volatile RAM
CFG_DLNV_START		EQU		000000850h
; Download data
CFG_DLNV_DATA		EQU		000000851h
; Setup for Download to volatile RAM
CFG_DLV_START		EQU		000000852h
; Download RAM Addressing information
CFG_DLV_ADDR		EQU		000000853h
; Download RAM Data
CFG_DLV_DATA		EQU		000000854h
; Cleanup Download, non-volatile as well as volatile
CFG_DL_STOP		EQU		000000855h
; Download result
CFG_DL_STAT		EQU		000000856h
; Program NIC memory
CFG_PROG		EQU		000000857h
; Hermes Engineering command
; Hermes Engineering command
CFG_CMD_NIC		EQU		000000860h
; USB Engineering command
CFG_CMD_DONGLE		EQU		000000861h
; #define CFG_THESEUS_CMD					0x0862		//Theseus Test command
; HCF Engineering command
CFG_CMD_HCF		EQU		000000863h
; 0x088x											USB System Identification Range							
; USB Converter board Identity
CFG_UHW_IDENTITY		EQU		000000880h
; USB Converter board Supplier Range
CFG_UBI_SUP_RANGE		EQU		000000881h
; USB Bootloader Identity
CFG_UBL_IDENTITY		EQU		000000882h
; #define CFG_UDI_SUP_RANGE				0x0883		//USB Bootloader Supplier Range
; USB Bootloader Supplier Range
CFG_UBL_SUP_RANGE		EQU		000000883h
; Actor Hardware - USB Bootloader I/F
CFG_HW_ACT_RANGES_UDI		EQU		000000884h
; Actor Driver - USB Bootloader I/F
CFG_DRV_ACT_RANGES_UDI		EQU		000000885h
; Actor Driver - USB Converter board
CFG_DRV_ACT_RANGES_UBI		EQU		000000886h
; 0x089x											PCI System Identifiaction Range							
; ============================================================= MSF Defined RECORDS	=========================
; transfer encryption info from CPL to MSF 
CFG_ENCRYPT_STRING		EQU		000000900h
; control mode of STAP driver from CPL
CFG_AP_MODE		EQU		000000901h
; extend&export En-/Disable facility to Utility
CFG_DRIVER_ENABLE		EQU		000000902h
; PCI adapter (Ooievaar) structure
CFG_PCI_COMMAND		EQU		000000903h
; extend&export En-/Disable WOLAS facility to Utility
CFG_WOLAS_ENABLE		EQU		000000904h
; transfer CountryInfo info from CPL to MSF 
CFG_COUNTRY_STRING		EQU		000000905h
; ============================================================= INFORMATION FRRAMES		=====================
; lowest value representing an Informatio Frame
CFG_INFO_FRAME_MIN		EQU		00000f000h
; Handover Address						
CFG_NOTIFY		EQU		00000f000h
; Communications Tallies
CFG_TALLIES		EQU		00000f100h
; Scan results
CFG_SCAN		EQU		00000f101h
; ACS Scan results
CFG_ACS_SCAN		EQU		00000f102h
; Link Status
CFG_LINK_STAT		EQU		00000f200h
; Association Status		
CFG_ASSOC_STAT		EQU		00000f201h
; Security Status					
CFG_SECURITY_STAT		EQU		00000f202h
; ============================================================= CONFIGURATION RECORDS	=====================
; ***********************************************************************************************************
; ***************************** S T R U C T U R E   D E F I N I T I O N S ***********************************
; Quick&Dirty to get download for DOS ODI Hermes-II running typedef LTV_STRCT FAR *	LTVP;
; CFG_DRV_INFO (0x0825) driver information
; default length of RID
; RID identification as defined by Hermes
; Driver name, 8 bytes, right zero padded
; BCD 2 digit major and 2 digit minor driver version
; BCD 2 digit major and 2 digit minor HCF version
; 
; IOAddress used by NIC
; IORange used by NIC
; Interrupt used by NIC
; NIC status
; 									@*	0x8000	Card present
; 									@*	0x4000	Card Enabled
; 									@*	0x2000	Driver incompatible with NIC Primary Functions
; 									@*	0x1000	Driver incompatible with NIC Station Functions
; 									@*	0x007F	HCF Internal Flags (i.e. pseudo Asynchronous command code)  
; Frame type
; 									@*	0x000	802.3
; 									@*	0x008	802.11														
; driver specific info
; 									 * CE: virtual I/O base													
CFG_DRV_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
driver_name		hcf_8		8t DUP (?)
driver_version		hcf_16		?
HCF_version		hcf_16		?
driver_stat		hcf_16		?
IO_address		hcf_16		?
IO_range		hcf_16		?
IRQ_number		hcf_16		?
card_stat		hcf_16		?
frame_type		hcf_16		?
drv_info		hcf_32		?
CFG_DRV_INFO_STRCT		ENDS

; Primary Functions Firmware
COMP_ID_FW_PRI		EQU		21t
; Intermediate Functions Firmware
COMP_ID_FW_INTERMEDIATE		EQU		22t
; Station Functions Firmware
COMP_ID_FW_STA		EQU		31t
; AP Functions Firmware 
COMP_ID_FW_AP		EQU		32t
; Windows 9x/NT Miniport NDIS 3.1
COMP_ID_MINIPORT_NDIS_31		EQU		41t
; Packet
COMP_ID_PACKET		EQU		42t
; DOS ODI
COMP_ID_ODI_16		EQU		43t
; 32-bits ODI
COMP_ID_ODI_32		EQU		44t
; Macintosh OS
COMP_ID_MAC_OS		EQU		45t
; Windows CE Miniport
COMP_ID_WIN_CE		EQU		46t
; Linux, full source code in Public Domain, HCF-light based
; 										  		 *thanks to Andreas Neuhaus								
COMP_ID_LINUX_PD		EQU		47t
; Windows 9x/NT Miniport NDIS 5.0
COMP_ID_MINIPORT_NDIS_50		EQU		48t
; Linux, HCF-library based
COMP_ID_LINUX_LIB		EQU		49t
; QNX
COMP_ID_QNX		EQU		50t
; Windows 9x/NT Miniport NDIS 4.0
COMP_ID_MINIPORT_NDIS_50_USB		EQU		51t
; Windows 9x/NT Miniport NDIS 4.0
COMP_ID_MINIPORT_NDIS_40		EQU		52t
;  VxWorks END Station driver. 
COMP_ID_VX_WORKS_ENDSTA		EQU		53t
;  VxWorks END Access Point driver. 
COMP_ID_VX_WORKS_ENDAP		EQU		54t
; ;?#define COMP_ID_MAC_OS_????			55		//;?check with HM
; WaveLAN/IEEE AP
COMP_ID_AP1		EQU		81t
; WaveLAN/IEEE Ethernet Converter
COMP_ID_EC		EQU		83t
; USB Boot Loader
COMP_ID_UBL		EQU		87t
; supplier
COMP_ROLE_SUPL		EQU		000000000h
; actor
COMP_ROLE_ACT		EQU		000000001h
; Supplier			  - actor
; Modem		 		  - Firmware	I/F
COMP_ID_MFI		EQU		000000001h
; Controller		  - Firmware	I/F
COMP_ID_CFI		EQU		000000002h
; Primary Firmware	  - Driver		I/F
COMP_ID_PRI		EQU		000000003h
; Station Firmware	  - Driver		I/F
COMP_ID_STA		EQU		000000004h
; Driver			  - Utility		I/F
COMP_ID_DUI		EQU		000000005h
; H/W                 - Driver		I/F
COMP_ID_HSI		EQU		000000006h
; API                 - Driver		I/F
COMP_ID_DAI		EQU		000000007h
; H/W                 - Driver		I/F
COMP_ID_APF		EQU		000000008h
; USB Converter board - Host Driver	I/F
COMP_ID_UBI		EQU		000000019h
; 						USB Bootloader
; USB Bootloader	  - Host Driver	I/F
COMP_ID_UDI		EQU		00000001ah
; CFG_RESTRAINT_INFO (0x0823) accumulated set of warnings detected by driver
; default length of RID
; CFG_RESTRAINT_INFO (0x0823) identification
;  val[0]: First 16 warnings
; 									 *	0x0001: CFG_CNF_PM_ENABLED (0xFC09) while not supported by firmware	
; 									 *
; 									 * val[1]: Second 16 warnings
; 									 
CFG_RESTRAINT_INFO_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
val		hcf_16		2t DUP (?)
CFG_RESTRAINT_INFO_STRCT		ENDS

; CFG_CNTL_RESTRAINT (0x0834) accumulated set of warnings detected by driver
; default length of RID
; CFG_CNTL_RESTRAINT (0x0834) identification
;  set/rest command
;  individual restraint bits
; 									 * MSF_CRYPT_RESTRAINT_BIT	0x0001
; 									 
CFG_CNTL_RESTRAINT_STRCT		STRUCT 1t
len		hcf_16		?
typ		hcf_16		?
action		hcf_16		?
stat		hcf_16		1t DUP (?)
CFG_CNTL_RESTRAINT_STRCT		ENDS

@proto_msf4394		TYPEDEF		PROTO C :FAR PTR hcf_8, :WORD, :hcf_16, :SWORD
MSF_ASSERT_RTN		TYPEDEF		@proto_msf4394

