
#ifndef DHFPDA_H
#define DHFPDA_H


/*-----------------------------------------------------------------------------
 *
 * File: DHFPDA.H
 * $Date: 2003/05/30 11:40:20 $ $Revision: 1.1.1.1 $
 *
 * Abstract: Contains definitions etc. related to the PDA.
 *
 * Description:
 *
 * Author: John Meertens
 *
 * Started: 26-04-2000
 *
 * Changed:
 *
 * SOFTWARE LICENSE
 *
 * This software is provided subject to the following terms and conditions,
 * which you should read carefully before using the software.  Using this
 * software indicates your acceptance of these terms and conditions.  If you do
 * not agree with these terms and conditions, do not use the software.
 *
 * Copyright  2003 Agere Systems Inc.
 * All rights reserved.
 *
 * Redistribution and use in source or binary forms, with or without
 * modifications, are permitted provided that the following conditions are met:
 *
 * . Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following Disclaimer as comments in the code as
 *    well as in the documentation and/or other materials provided with the
 *    distribution.
 * 
 * . Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following Disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * . Neither the name of Agere Systems Inc. nor the names of the contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * Disclaimer
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, INFRINGEMENT AND THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  ANY
 * USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE IS SOLELY AT THE USERS OWN
 * RISK. IN NO EVENT SHALL AGERE SYSTEMS INC. OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, INCLUDING, BUT NOT LIMITED TO, CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 *----------------------------------------------------------------------------*/

#define LOF(x) (sizeof(x)/sizeof(hcf_16)-1)

#ifndef DSF_HERMESII


// PDR codes for PDA, names based on DS 010128 rev F
#define PDA_END             0x0000       // End record (contains CRC)
#define PDA_PART_NR         0x0001       // PartNrrecord (contains "signature" starting with 'A")
#define PDA_ADDRESS       0x390000       // Address of PDA on NIC


// In principle, the max. size of the PDA is is 4096 words. Currently, however, 
// only about 500 bytes of this area are currently used. To minimize the memory
// "burden" esp. for DOS-users we claim only 1024 words.
//HWi Must be tuned;????
//HWi Can't be bigger because of the limitation of USB which has a max of 2048 but
//also needs some header of 10 bytes.
// #define PDA_SIZE    1024
#define PDA_SIZE    1000

//#if UIL_DATBUF_SIZE < 512
//#error UIL_DATBUF_SIZE must be at least 512 for the DHF
//#endif

EXTERN_C int dhf_add_pda_record( LTVP rec );
EXTERN_C LTVP dhf_get_pda_record( hcf_16 code );
EXTERN_C int dhf_load_pda( void );                      // defined in this file
EXTERN_C int dhf_program_pda( void );
EXTERN_C int dhf_put_pda_record( hcf_16 code, LTVP rec );

#endif // #ifndef DSF_HERMESII

#endif  // DHFPDA_H
