
#ifndef DHFMSG_H
#define DHFMSG_H
/*-----------------------------------------------------------------------------
 * Filename : dhfmsg.h
 *
 * Started  : 01-Mar-20 2000 by John Meertens
 * Purpose  : Message texts for function dhf_get_res_msg
 * Description:
 *   This file contains messages that are returned by routine dhf_get_res_msg.
 *   File DHFMSG.H is the file that is actually included in the code.So if you
 *   want to edit some of the messages, then copy this TPL-file to file 
 *   DHFMSG.H and adjust texts there.
 *
 *   Note that #define DHF_GET_RES_MSG in DHFCFG.H must be defined for this
 *   file to be included.
 *  
 * Revision :
 *      : $Date: 2003/08/04 16:57:40 $  $Revision: 1.5 $
 *
 *
 *-----------------------------------------------------------------------------
 * COPYRIGHT (c) 1994, 1995 by AT&T.    All Rights Reserved.
 * COPYRIGHT (c) 1996, 1998 by Lucent Technologies. All Rights Reserved.
 *---------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
  Log:   V:/dev3dev/wl_dhf/code/dhfmsg.tpv 
 *---------------------------------------------------------------------------*/


#ifdef DHF_GET_RES_MSG

/*-----------------------------------------------------------------------------
 *
 * Messages and confirmation texts
 *
 *---------------------------------------------------------------------------*/

#define DHF_MSG_PRESSANYKEY             "\n\n\t<Press any key>"

#define DHF_MSG_DOWNLOAD_COMPLETED      "\nThe update was successful." \
                                        "\nYour WaveLAN card is now loaded with the new firmware version." \
                                        "\nPlease stop the card and reinsert it again to reinitialize the connection."

#define DHF_MSG_ABORTED                 "\nProgram aborted by user..."

#define DHF_MSG_NULL                    ""


/*-----------------------------------------------------------------------------
 *
 * Error messages
 *
 *---------------------------------------------------------------------------*/

#define DHF_ERROR_WEB_RESTRAINT         "\nYou have enabled WEB encryption for your Lucent wireless card which is" \
                                        "\ncurrently preventing your card from operating properly. Please verify whether:" \
                                        "\n. The inserted card supports WEB encryption, or" \
                                        "\nThe 'Station firmware' of the inserted card is v4.08 or higher." \
                                        "\nWEB encryption is supported by WaveLAN Silver cards only!" \
                                        "\n\nTo update the firmware on your card, disable WEB encryption in your" \
                                        "\ndriver configuration and restart this utility." \
                                        "\nWhen you want to run the WaveMANAGER/CLIENT program" \
                                        "\nto verify version info and card type, you must also disable WEB encryption first."

#define DHF_ERROR_UPDATE                "\nA problem occurred while updating your Lucent wireless card." \
                                        "\nPlease try again or revert to a previous version." \
                                        "\nIf the problem persists, contact the WaveLAN support organization."

#define DHF_ERROR_NOT_COMPATIBLE        "\nYour current Lucent wireless card is not updateable with this utility. " \
                                        "\nPlease check the WaveLAN website (www.wavelan.com) for information about" \
                                        "\navailability of special firmware updates. " \
                                        "\nYou'll need the Variant and Version information that is shown in the header."

#define DHF_ERROR_DUI_NOT_COMPATIBLE    "\nThe Lucent wireless card driver you have loaded is not compatible with this utility." \
                                        "\nPlease check the WaveLAN website (www.wavelan.com) for information about " \
                                        "\nthe latest available drivers and firmware updates."

#define DHF_ERROR_DIAGNOSE              "\nYour card is not properly operating." \
                                        "\nRun WaveMANAGER/CLIENT and do Card Diagnostics for more information."

#define DHF_ERROR_DOWNLOAD              "\nAn error occurred while updating the card."

#define DHF_ERROR_NO_CARD               "\nThere is no WaveLAN/IEEE card available in the PCMCIA slot. " \
                                        "\nPlease insert the WaveLAN/IEEE card and try again."

#define DHF_ERROR_NO_DRIVER             "\nThere is no WaveLAN/IEEE driver loaded." \
                                        "\nMake sure the right driver is installed, and the WaveLAN card is inserted."

#define DHF_ERROR_DUI_IN_USE            "\nThe Lucent wireless card driver currently installed on your computer is " \
                                        "already in use by another utility." \
                                        "\nPlease close all other Lucent wireless card utilities, then try again."

#define DHF_ERROR_CRD_APP_NOT_COMPATIBLE \
                                        "\nYour current Lucent wireless card is not updateable with this utility." \
                                        "\nPlease check the WaveLAN website (www.wavelan.com) for information on" \
                                        "\nfirmware updates that are compatible with your hardware."

#define DHF_ERROR_DRV_APP_NOT_COMPATIBLE \
                                        "\nThe Lucent wireless card driver currently installed on your computer" \
                                        "\nis not compatible with this utility." 

#define DHF_ERROR_CRD_PRI_NOT_COMPATIBLE \
                                        "\nYour current Lucent wireless card is not updateable with this utility."

#define DHF_ERROR_PRI_DRV_NOT_COMPATIBLE \
                                        "\nThe Lucent wireless card driver currently installed on your computer is" \
                                        "\nnot compatible with your wireless card."

#define DHF_ERROR_PRI_APP_NOT_COMPATIBLE \
                                         "\nThe Lucent wireless card you are using ia not updateable with this utility "

#define DHF_ERROR_CRD_STA_NOT_COMPATIBLE \
                                        "\nYour current Lucent wireless card is not updateable with this utility."


#endif  // DHF_GET_RES_MSG



#ifdef DSF_CONFIRM

/*-----------------------------------------------------------------------------
 *
 * Confirmation messages
 *
 *---------------------------------------------------------------------------*/

#define DHF_CONFIRM_UPDATE_CARD         "\nDo you want to update your card [Y/N] ?"

#define DHF_CONFIRM_DRV_STA_NOT_COMPATIBLE \
                                        "\nThe Lucent wireless card driver currently installed on your computer" \
                                        "\nis not compatible with the new firmware level and will not communicate" \
                                        "\nafter the firware update is complete." \
                                        "\nCheck the WaveLAN website (www.wavelan.com) for the latest driver information." \
                                        "\nContinue with this download? [Y/N] "

#define DHF_CONFIRM_DRIVER_NOT_COMPATIBLE \
                                        "\nThe current WaveLAN/IEEE driver is not compatible with the new firmware level " \
                                        "\nand will not communicate after the firmware update is completed. " \
                                        "\nMake sure you also update the driver after the firmware update. " \
                                        "\nCheck the WaveLAN website (www.wavelan.com) for the latest driver information." \
                                        "\nContinue with this download? [Y/N] "

#define DHF_CONFIRM_DRV_PRI_NOT_COMPATIBLE \
                                        "\nThe Lucent wireless card driver currently installed on your computer" \
                                        "\nis not compatible with the new primary firmware level and will not communicate" \
                                        "\nafter the firware update is complete." \
                                        "\nPlease update your driver first." \
                                        "\nCheck the WaveLAN website (www.wavelan.com) for the latest driver information."

#define DHF_CONFIRM_SAME_VERSION        "\nYour WaveLAN card already has the firmware level which this utility offers. " \
                                        "\nAre you sure you want to continue? [Y/N] "

#define DHF_CONFIRM_OLDER_VERSION       "\nYour WaveLAN card has a higher firmware level than this update utility offers." \
                                        "\nDo you want to downgrade? [Y/N] "

#define DHF_CONFIRM_CONTINUE_DOWNLOAD   "\nIf you continue make sure you also update the driver after the firmware update." \
                                        "\nContinue with this download?"
                                        
#endif  // DSF_CONFIRM








/*-----------------------------------------------------------------------------

TODO: delete these messages???
#define DHF_ERROR_GET_NIC_INFO          "\nAn error occurred when retrieving information from the card" \
                                        "\nContact the WaveLAN support organization."

#define DHF_ERROR_BUSY                  "\nA transient error occured, e.g. a conflict with a protocol stack initiated action"\
                                        "\nor no resorces available."\
                                        "\nPlease close your applications, then try again."

#define DHF_ERROR_ALLOC                 "\nAn memory allocation error occured"\
                                        "\nPlease close your applications, then try again."

#define DHF_ERROR_FAILURE               "\nA general (not specified) error occured."\
                                        "\nContact the WaveLAN support organization."

#define DHF_ERROR_NSTL                  "\nAn error occured in the (N)OS Transport Layer between this utility and the driver"\
                                        "\nContact the WaveLAN support organization."

#define DHF_ERROR_SEQBUG                "\nA general consistency (not specified) error occured."\
                                        "\nContact the WaveLAN support organization."

#define DHF_ERROR_LEN                   "\nA buffer size problem occured."\
                                        "\nContact the WaveLAN support organization."

//#define DHF_MSG_PROGRESS_DOWNLOADING  "\nDownloading..."
//
//#define DHF_MSG_PROGRESS_PLUGGING     "\nPreparing update..."
//
//#define DHF_MSG_NOCARD                    "\n- No card information available -"
//
//#define DHF_ERROR_CARDNOTCOMPATIBLE       "\nYour current WaveLAN card is not updateable with this utility." \
//                                      "\nPlease write down the hardware Variant and Version information that is shown " \
//                                      "\nin the header and check the WaveLAN website (www.wavelan.com) for information" \
//                                      "\nand firmware updates which are compatible with your hardware. "
//
//#define DHF_ERROR_DRIVERNOTREADY      "\nThe WaveLAN/IEEE driver is not able to access the card for download. " \
//                                      "\nPlease run WaveMANAGER/CLIENT to do Card Diagnostics."
//
////#define UIL_ERR_INCOMP_DRV              "\nThe current WaveLAN/IEEE driver is not compatible with this utility "
////                                        "\nCheck the WaveLAN website (www.wavelan.com) for the latest driver information."
//#define DHF_ERROR_DISCONNECTED            "\nA problem occurred while updating your WaveLAN/IEEE card." \
//                                      "\nPlease try again or revert to a previous version." \
//                                      "\nIf the problem persists, contact the WaveLAN support organization.  "
//
//#define DHF_WARNING_NOT_COMPATIBLE      "\nYour card was updated but not properly operating." \
//                                        "\nPlease run WaveMANAGER/CLIENT and do Card Diagnostics for more information."
//
*/



#endif	// DHFMSG_H
