
#ifndef DHFCFG_H
#define DHFCFG_H
/*-----------------------------------------------------------------------------
 * File DHFCFG.H
 *
 * Contents: #defines for the DHF module
 *
 * Comments:
 *   Some combinations of the #defines in this file are illegal (as noted below).
 *   If an illegal combinations of #defines is specified a compile error is
 *   generated. See document DHFUG.DOC for more information.
 *
 * Author: John Meertens
 * Date:   11-01-2000 
 *
 * Change history:
 *---------------------------------------------------------------------------*/


// Define DHF_WCI if you want to use the WCI to access the ORiNOCO card.
// Define DHF_UIL if you want to use the UIL to access the ORiNOCO card.
// You must define either DHF_WCI or DHF_UIL. If neither of the two is defined 
// or both a compile error is generated.
#define DHF_WCI
//!!!#define DHF_UIL

// Define DHF_BIG_ENDIAN if you are working on a big endian platform. 
// Define DHF_LITTLE_ENDIAN if you are working on a little endian platform. 
// You must define either DHF_BIG_ENDIAN or DHF_LITTLE_ENDIAN. If neither of 
// the two is defined or both a compile error is generated.
//!!!#define DHF_BIG_ENDIAN
#define DHF_LITTLE_ENDIAN
 
// Define if you want the DHF to users. Not defining DHF_GET_RES_MSG
// leads to a decrease in code size as message strings are not included.
//!!!#define DHF_GET_RES_MSG


//-----------------------------------------------------------------------------
// Define one or more of the following DSF #defines if you want to implement
// the related DSF-function. Function dsf_callback must allways be implemented.
// See file DHF.H for prototypes of the functions.

// Define DSF_CONFIRM if you want the DHF to ask the user for confirmation in a 
// number of situations. If DSF_CONFIRM is defined you must implement dsf_confirm.
// Not defining DSF_CONFIRM leads to a decrease in code size as confirmation
// strings are not included.
//!!!#define DSF_CONFIRM

// Define DSF_ALLOC if you want to manage memory allocation and de-allocation
// for the DHF. If DSF_ALLOC is defined you must implement dsf_alloc and dsf_free.
//!!!#define DSF_ALLOC


// Define DSF_DEBUG_MESSAGE if you want debug messages added to your output.
// If you define DSF_DEBUG_MESSAGE then you must implement function 
// dsf_debug_message.
//!!!#define DSF_DEBUG_MESSAGE

// Define DSF_ASSERT if you want asserts to be activated.
// If you define DSF_ASSERT then you must implement function dsf_assert.
//!!!#define DSF_ASSERT

// Define DSF_DBWIN if you want asserts and debug messages to be send to a debug 
// window like SOFTICE or DebugView from SysInternals.
//!!!#define DSF_DBWIN
//!!! Not implemented yet!

// Define DSF_VOLATILE_ONLY if you only wants to use valatile functions
// This is a typical setting for a AP and a driver.
//!!!#define DSF_VOLATILE_ONLY

// To use DHF for Hermes2 please add the define HERMES2 to the compile option defines
#ifdef HERMES2
#define DSF_HERMESII
#endif

// Define DSF_BINARY_FILE if you want to use the DHF in combination with
// reading the Firmware from a separate binary file.
//!!!#define DSF_BINARY_FILE

// Define DHF_WIN always
#define DHF_WIN

//#endif // DHFCFG_H
